#!/bin/sh
echo 'name: test-framework
version: 0.6
id: test-framework-0.6-52759c2638796759d46dfb66b7470fcd

license: BSD3
copyright:
maintainer: Max Bolingbroke <batterseapower@hotmail.com>
stability:
homepage: http://batterseapower.github.com/test-framework/
package-url:
synopsis: Framework for running and organising tests, with HUnit and QuickCheck support
description: Allows tests such as QuickCheck properties and HUnit test cases to be assembled into test groups, run in
             parallel (but reported in deterministic order, to aid diff interpretation) and filtered and controlled by
             command line options. All of this comes with colored test output, progress reporting and test statistics output.
category: Testing
author: Max Bolingbroke <batterseapower@hotmail.com>
pkgpath: devel/hs-test-framework
exposed: True
exposed-modules: Test.Framework Test.Framework.Options
                 Test.Framework.Providers.API Test.Framework.Runners.Console
                 Test.Framework.Runners.Options Test.Framework.Seed
hidden-modules: Test.Framework.Core Test.Framework.Improving
                Test.Framework.Runners.Console.Colors
                Test.Framework.Runners.Console.ProgressBar
                Test.Framework.Runners.Console.Run
                Test.Framework.Runners.Console.Statistics
                Test.Framework.Runners.Console.Table
                Test.Framework.Runners.Console.Utilities
                Test.Framework.Runners.Core Test.Framework.Runners.Processors
                Test.Framework.Runners.Statistics
                Test.Framework.Runners.TestPattern
                Test.Framework.Runners.ThreadPool
                Test.Framework.Runners.TimedConsumption
                Test.Framework.Runners.XML.JUnitWriter Test.Framework.Runners.XML
                Test.Framework.Utilities
trusted: False
import-dirs: /usr/local/lib/ghc/test-framework-0.6
library-dirs: /usr/local/lib/ghc/test-framework-0.6
hs-libraries: HStest-framework-0.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ansi-terminal-0.5.5-8801f5127d93c5faa91ff9c937224633
         ansi-wl-pprint-0.6.4-8e3413654b605e3af93fc0cb992abff4
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         extensible-exceptions-0.1.1.4-3d9bd197c43329612c640f24179a7f19
         hostname-1.0-53d19a1db667947ec9bde0d6f39966fb
         old-locale-1.0.0.4-5e45cabd3b4fdcad9e353ea3845f5ef7
         random-1.0.1.1-d8f82f84701874725b418c29860a58e0
         regex-posix-0.95.2-62c27af122347b4aae6289df5cd7f9ee
         time-1.4-d61e2caaa0486655b4e141dc277ed49f
         xml-1.3.7-e69d1456046baceda67d91ff22c9cc27
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-test-framework-0.6/html/test-framework.haddock
haddock-html: /usr/local/share/doc/hs-test-framework-0.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
