#!/bin/sh
echo 'name: haskell-src-exts
version: 1.13.3
id: haskell-src-exts-1.13.3-82aa5c9e8f66a01475bed22525f1f8b5

license: BSD3
copyright:
maintainer: Niklas Broberg <niklas.broberg@chalmers.se>
stability: Stable
homepage: http://code.haskell.org/haskell-src-exts
package-url:
synopsis: Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer
description: Haskell-Source with Extensions (HSE, haskell-src-exts)
             is an extension of the standard haskell-src package,
             and handles most registered syntactic extensions to Haskell, including:
             .
             * Multi-parameter type classes with functional dependencies
             .
             * Indexed type families (including associated types)
             .
             * Empty data declarations
             .
             * GADTs
             .
             * Implicit parameters
             .
             * Template Haskell
             .
             and a few more. All extensions implemented in GHC are supported.
             Apart from these standard extensions,
             it also handles regular patterns as per the HaRP extension
             as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
pkgpath: lang/hs-haskell-src-exts
exposed: True
exposed-modules: Language.Haskell.Exts Language.Haskell.Exts.Parser
                 Language.Haskell.Exts.Pretty Language.Haskell.Exts.Syntax
                 Language.Haskell.Exts.Extension Language.Haskell.Exts.Build
                 Language.Haskell.Exts.Fixity Language.Haskell.Exts.Comments
                 Language.Haskell.Exts.SrcLoc Language.Haskell.Exts.Annotated
                 Language.Haskell.Exts.Annotated.Syntax
                 Language.Haskell.Exts.Annotated.Fixity
                 Language.Haskell.Exts.Annotated.Build
                 Language.Haskell.Exts.Annotated.ExactPrint
                 Language.Haskell.Exts.Annotated.Simplify
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.Lexer Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
trusted: False
import-dirs: /usr/local/lib/ghc/haskell-src-exts-1.13.3
library-dirs: /usr/local/lib/ghc/haskell-src-exts-1.13.3
hs-libraries: HShaskell-src-exts-1.13.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         cpphs-1.13.3-837a98a4292a2c32528a5a6fd591555c
         pretty-1.1.1.0-91ed62f0481a81d292d550eec35ee75b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-haskell-src-exts-1.13.3/html/haskell-src-exts.haddock
haddock-html: /usr/local/share/doc/hs-haskell-src-exts-1.13.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
