#!/bin/sh
echo 'name: hackage-db
version: 1.4
id: hackage-db-1.4-5051a2bcd287dffb522e3492fbf95576

license: BSD3
copyright: Peter Simons
maintainer: Peter Simons <simons@cryp.to>
stability:
homepage: http://github.com/peti/hackage-db
package-url:
synopsis: provide access to the Hackage database via Data.Map
description: This module provides simple access to the Hackage database by means
             of @Data.Map@. Suppose you wanted to implement a utility that queries
             the set of available versions for a given package, the following
             program would do the trick:
             .
             > import qualified Distribution.Hackage.DB as DB
             > import Distribution.Text ( display )
             > import System.Environment ( getArgs )
             >
             > main :: IO ()
             > main = do
             >   pkgs <- getArgs
             >   db <- DB.readHackage
             >   let getVersions name = maybe [] DB.keys (DB.lookup name db)
             >   mapM_ (putStrLn . unwords . map display . getVersions) pkgs
             .
             When run, it would produce the following output:
             .
             > ./a.out containers deepseq cabal-install
             > 0.1.0.0 0.1.0.1 0.2.0.0 0.2.0.1 0.3.0.0 0.4.0.0
             > 1.0.0.0 1.1.0.0 1.1.0.1 1.1.0.2
             > 0.4.0 0.5.0 0.5.1 0.5.2 0.6.0 0.6.2 0.6.4 0.8.0 0.8.2 0.10.0 0.10.2
             .
             Note that once the database has been parsed, it can be accessed
             quickly, but the inital cost of reading @00-index.tar@ is fairly
             high.
category: Distribution
author: Peter Simons <simons@cryp.to>
pkgpath: databases/hs-hackage-db
exposed: True
exposed-modules: Distribution.Hackage.DB
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hackage-db-1.4
library-dirs: /usr/local/lib/ghc/hackage-db-1.4
hs-libraries: HShackage-db-1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: Cabal-1.14.0-90071ef9b434add24a18ee48575f67a1
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         directory-1.1.0.2-da0a8c62c2b42ae7a3b538f5fee58422
         filepath-1.3.0.0-f998e5510c76a98913f57b14b4f16c57
         tar-0.4.0.1-4475e920ec0efd391a270a8dc96d5562
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hackage-db-1.4/html/hackage-db.haddock
haddock-html: /usr/local/share/doc/hs-hackage-db-1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
