#!/bin/sh
echo 'name: dbus
version: 0.10.4
id: dbus-0.10.4-a529c151cf63d9942b543b8891d6ab34

license: GPL-3
copyright:
maintainer: John Millikin <jmillikin@gmail.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
package-url:
synopsis: A client library for the D-Bus IPC system.
description: D-Bus is a simple, message-based protocol for inter-process
             communication, which allows applications to interact with other parts of
             the machine and the user'\''s session using remote procedure calls.
             .
             D-Bus is a essential part of the modern Linux desktop, where it replaces
             earlier protocols such as CORBA and DCOP.
             .
             This library is an implementation of the D-Bus protocol in Haskell. It
             can be used to add D-Bus support to Haskell applications, without the
             awkward interfaces common to foreign bindings.
             .
             Example: connect to the session bus, and get a list of active names.
             .
             @
             &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
             .
             import Data.List (sort)
             import DBus
             import DBus.Client
             .
             main = do
             &#x20;   client <- connectSession
             &#x20;   //
             &#x20;   \-- Request a list of connected clients from the bus
             &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
             &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
             &#x20;       &#x7d;
             &#x20;   //
             &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
             &#x20;   \-- a list of names (here represented as [String])
             &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
             &#x20;   //
             &#x20;   \-- Print each name on a line, sorted so reserved names are below
             &#x20;   \-- temporary names.
             &#x20;   mapM_ putStrLn (sort names)
             @
             .
             >$ ghc --make list-names.hs
             >$ ./list-names
             >:1.0
             >:1.1
             >:1.10
             >:1.106
             >:1.109
             >:1.110
             >ca.desrt.dconf
             >org.freedesktop.DBus
             >org.freedesktop.Notifications
             >org.freedesktop.secrets
             >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <jmillikin@gmail.com>
pkgpath: x11/hs-dbus
exposed: True
exposed-modules: DBus DBus.Client DBus.Introspection DBus.Socket
                 DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.4
library-dirs: /usr/local/lib/ghc/dbus-0.10.4
hs-libraries: HSdbus-0.10.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         cereal-0.3.5.2-807bd944bfc86ac5df2f667be96ad9f0
         containers-0.4.2.1-75f143aa39a3e77a1ce2300025bdd8ce
         libxml-sax-0.7.3-57edfde11a90ef28a3828df72f0169a2
         network-2.3.1.0-abef231ef624b7502aa8b0353f2d5ca3
         parsec-3.1.3-07e54fceec3486ec01b4c366cf3d07fd
         random-1.0.1.1-d8f82f84701874725b418c29860a58e0
         text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f
         transformers-0.3.0.0-8e66ecc7d4dae2b07b2b5406908c70e4
         unix-2.5.1.1-0adea5be633a6b5a124519287d54626d
         vector-0.10.0.1-3450daae3d9f2092020075d05481123c
         xml-types-0.3.3-4caa1c4984f9d00ffbe46066cd57bee8
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.4/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
