#!/bin/sh
echo 'name: crypto-api
version: 0.10.2
id: crypto-api-0.10.2-b894ddbcbc6462caabf9766373a4cdd1

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
synopsis: A generic interface for cryptographic operations
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
trusted: False
import-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
library-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
hs-libraries: HScrypto-api-0.10.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         cereal-0.3.5.2-807bd944bfc86ac5df2f667be96ad9f0
         entropy-0.2.1-c84e6c51abcd6575cd8db3e7ab93fdf7
         largeword-1.0.0-6aec99e74a5a8681458c3824c86e0ea5
         tagged-0.4.4-886769b727dcf06f0418d254f5119104
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.10.2/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.10.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
