#!/bin/sh
echo 'name: cmdargs
version: 0.9.5
id: cmdargs-0.9.5-32e362a72b8eeff69c1181c8bbca4c8d

license: BSD3
copyright: Neil Mitchell 2009-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability: Beta
homepage: http://community.haskell.org/~ndm/cmdargs/
package-url:
synopsis: Command line argument processing
description: This library provides an easy way to define command line parsers. Most users
             will want to use the "System.Console.CmdArgs.Implicit" module, whose
             documentation contains an example.
             .
             * "System.Console.CmdArgs.Explicit" provides a way to write command line
             parsers for both single mode programs (most programs) and multiple
             mode programs (e.g. darcs or cabal). Parsers are defined by constructing
             a data structure.
             .
             * "System.Console.CmdArgs.Implicit" provides a way to concisely define
             command line parsers, up to three times shorter than getopt. These parsers
             are translated into the Explicit data type.
             .
             * "System.Console.CmdArgs.GetOpt" provides a wrapper allowing compatiblity
             with existing getopt parsers, mapping to the Explicit data type.
             .
             For a general reference on what command line flags are commonly used,
             see <http://www.faqs.org/docs/artu/ch10s05.html>.
category: Console
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-cmdargs
exposed: True
exposed-modules: System.Console.CmdArgs.Quote
                 System.Console.CmdArgs System.Console.CmdArgs.Annotate
                 System.Console.CmdArgs.Default System.Console.CmdArgs.Explicit
                 System.Console.CmdArgs.GetOpt System.Console.CmdArgs.Implicit
                 System.Console.CmdArgs.Text System.Console.CmdArgs.Helper
                 System.Console.CmdArgs.Verbosity
hidden-modules: Data.Generics.Any Data.Generics.Any.Prelude
                System.Console.CmdArgs.Explicit.Complete
                System.Console.CmdArgs.Explicit.ExpandArgsAt
                System.Console.CmdArgs.Explicit.Help
                System.Console.CmdArgs.Explicit.Process
                System.Console.CmdArgs.Explicit.SplitJoin
                System.Console.CmdArgs.Explicit.Type
                System.Console.CmdArgs.Implicit.Ann
                System.Console.CmdArgs.Implicit.Global
                System.Console.CmdArgs.Implicit.Local
                System.Console.CmdArgs.Implicit.Reader
                System.Console.CmdArgs.Implicit.Reform
                System.Console.CmdArgs.Implicit.Type
                System.Console.CmdArgs.Implicit.UI
trusted: False
import-dirs: /usr/local/lib/ghc/cmdargs-0.9.5
library-dirs: /usr/local/lib/ghc/cmdargs-0.9.5
hs-libraries: HScmdargs-0.9.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         filepath-1.3.0.0-f998e5510c76a98913f57b14b4f16c57
         process-1.1.0.1-608c248c1528f46eb960a08cead77291
         template-haskell-2.7.0.0-826c08e99d445bf7fa4a34d70f491207
         transformers-0.3.0.0-8e66ecc7d4dae2b07b2b5406908c70e4
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cmdargs-0.9.5/html/cmdargs.haddock
haddock-html: /usr/local/share/doc/hs-cmdargs-0.9.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
