#!/bin/sh
echo 'name: HTTP
version: 4000.2.5
id: HTTP-4000.2.5-ddff3f70ab49191ccfce5ecf4cbf611c

license: BSD3
copyright:
maintainer: Ganesh Sittampalam <http@projects.haskell.org>
stability:
homepage: https://github.com/haskell/HTTP
package-url:
synopsis: A library for client-side HTTP
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      (_, rsp)
             >         <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://www.haskell.org/"
             >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
pkgpath: net/hs-HTTP
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
trusted: False
import-dirs: /usr/local/lib/ghc/HTTP-4000.2.5
library-dirs: /usr/local/lib/ghc/HTTP-4000.2.5
hs-libraries: HSHTTP-4000.2.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         mtl-2.1.2-02e701f9b1590ee88a0b5b0bd5d93a29
         network-2.3.1.0-abef231ef624b7502aa8b0353f2d5ca3
         old-time-1.1.0.0-c11d19d5710541e7a9ae41c1582972eb
         parsec-3.1.3-07e54fceec3486ec01b4c366cf3d07fd
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.2.5/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.2.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
