/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Messager;
import com.sun.mirror.util.SourcePosition;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.apt.core.util.EclipseMessager;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class MessagerImpl
implements Messager,
EclipseMessager {
    private final AbstractCompilationEnv _env;

    MessagerImpl(AbstractCompilationEnv env) {
        this._env = env;
    }

    public void printError(SourcePosition pos, String msg, String[] arguments) {
        if (pos == null) {
            this.printError(msg);
        } else if (pos instanceof SourcePositionImpl) {
            this.print((SourcePositionImpl)pos, Severity.ERROR, msg, arguments);
        } else {
            this.print(pos, Severity.ERROR, msg, arguments);
        }
    }

    public void printError(ASTNode node, String msg) {
        if (node == null) {
            throw new IllegalArgumentException("'node' cannot be null");
        }
        int start = node.getStartPosition();
        int line = this._env.getAstCompilationUnit().getLineNumber(start);
        if (line < 1) {
            line = 1;
        }
        this._env.addMessage(this._env.getFile(), start, node.getLength() + start, Severity.ERROR, msg, line, null);
    }

    public void printError(String msg) {
        this.print(Severity.ERROR, msg, null);
    }

    public void printNotice(SourcePosition pos, String msg, String[] arguments) {
        if (pos instanceof SourcePositionImpl) {
            this.print((SourcePositionImpl)pos, Severity.INFO, msg, arguments);
        } else if (pos == null) {
            this.printNotice(msg);
        } else {
            this.print(pos, Severity.INFO, msg, arguments);
        }
    }

    public void printNotice(ASTNode node, String msg) {
        if (node == null) {
            throw new IllegalArgumentException("'node' cannot be null");
        }
        int start = node.getStartPosition();
        int line = this._env.getAstCompilationUnit().getLineNumber(start);
        if (line < 1) {
            line = 1;
        }
        this._env.addMessage(this._env.getFile(), start, node.getLength() + start, Severity.INFO, msg, line, null);
    }

    public void printNotice(String msg) {
        this.print(Severity.INFO, msg, null);
    }

    public void printWarning(SourcePosition pos, String msg, String[] arguments) {
        if (pos instanceof SourcePositionImpl) {
            this.print((SourcePositionImpl)pos, Severity.WARNING, msg, arguments);
        } else if (pos == null) {
            this.printWarning(msg);
        } else {
            this.print(pos, Severity.WARNING, msg, arguments);
        }
    }

    public void printWarning(ASTNode node, String msg) {
        if (node == null) {
            throw new IllegalArgumentException("'node' cannot be null");
        }
        int start = node.getStartPosition();
        int line = this._env.getAstCompilationUnit().getLineNumber(start);
        if (line < 1) {
            line = 1;
        }
        this._env.addMessage(this._env.getFile(), start, node.getLength() + start, Severity.WARNING, msg, line, null);
    }

    public void printWarning(String msg) {
        this.print(Severity.WARNING, msg, null);
    }

    public void printError(SourcePosition pos, String msg) {
        this.printError(pos, msg, null);
    }

    public void printWarning(SourcePosition pos, String msg) {
        this.printWarning(pos, msg, null);
    }

    public void printNotice(SourcePosition pos, String msg) {
        this.printNotice(pos, msg, null);
    }

    public void printFixableError(SourcePosition pos, String msg, String pluginId, String errorId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId cannot be null");
        }
        if (errorId == null) {
            throw new IllegalArgumentException("errorId cannot be null");
        }
        this.printError(pos, msg, new String[]{pluginId, errorId});
    }

    public void printFixableWarning(SourcePosition pos, String msg, String pluginId, String errorId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId cannot be null");
        }
        if (errorId == null) {
            throw new IllegalArgumentException("errorId cannot be null");
        }
        this.printWarning(pos, msg, new String[]{pluginId, errorId});
    }

    public void printFixableNotice(SourcePosition pos, String msg, String pluginId, String errorId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId cannot be null");
        }
        if (errorId == null) {
            throw new IllegalArgumentException("errorId cannot be null");
        }
        this.printNotice(pos, msg, new String[]{pluginId, errorId});
    }

    public void printFixableError(String msg, String pluginId, String errorId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId cannot be null");
        }
        if (errorId == null) {
            throw new IllegalArgumentException("errorId cannot be null");
        }
        this.print(Severity.ERROR, msg, new String[]{pluginId, errorId});
    }

    public void printFixableWarning(String msg, String pluginId, String errorId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId cannot be null");
        }
        if (errorId == null) {
            throw new IllegalArgumentException("errorId cannot be null");
        }
        this.print(Severity.WARNING, msg, new String[]{pluginId, errorId});
    }

    public void printFixableNotice(String msg, String pluginId, String errorId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId cannot be null");
        }
        if (errorId == null) {
            throw new IllegalArgumentException("errorId cannot be null");
        }
        this.print(Severity.INFO, msg, new String[]{pluginId, errorId});
    }

    private void print(SourcePositionImpl pos, Severity severity, String msg, String[] arguments) {
        IFile resource = pos.getResource();
        if (resource == null) {
            throw new IllegalStateException("missing resource");
        }
        this._env.addMessage(resource, pos.getStartingOffset(), pos.getEndingOffset(), severity, msg, pos.line(), arguments);
    }

    private void print(SourcePosition pos, Severity severity, String msg, String[] arguments) {
        CompilationUnit unit;
        File file = pos.file();
        IFile resource = null;
        if (file != null) {
            String projAbsPath = this._env.getProject().getLocation().toOSString();
            String fileAbsPath = file.getAbsolutePath();
            String fileRelPath = fileAbsPath.substring(projAbsPath.length());
            resource = this._env.getProject().getFile(fileRelPath);
            if (!resource.exists()) {
                resource = null;
            }
        } else {
            resource = null;
        }
        int offset = -1;
        if (resource != null && (unit = this._env.getASTFrom(resource)) != null) {
            offset = unit.getPosition(pos.line(), pos.column());
        }
        this._env.addMessage(resource, offset, -1, severity, msg, pos.line(), arguments);
    }

    private void print(Severity severity, String msg, String[] arguments) {
        this._env.addMessage(null, -1, -1, severity, msg, 1, arguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

