/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.osgi.framework.Bundle;

public class PluginVersionInfo
extends HelpProperties {
    private static final long serialVersionUID = 1L;
    protected static final String SEPARATOR = "\n";
    File dir;
    boolean doComparison = true;
    boolean hasChanged = false;
    boolean ignoreSavedVersions;
    Collection added = new ArrayList();
    Collection removed = new ArrayList();

    public PluginVersionInfo(String name, Collection docBundleIds, File dir, boolean ignoreSavedVersions) {
        super(name, dir);
        this.dir = dir;
        this.ignoreSavedVersions = ignoreSavedVersions;
        this.createTable(docBundleIds);
    }

    protected void createTable(Collection docBundleIds) {
        for (String bundleId : docBundleIds) {
            Bundle pluginBundle = Platform.getBundle((String)bundleId);
            if (pluginBundle == null) continue;
            StringBuffer pluginVersionAndFragments = new StringBuffer();
            this.appendBundleInformation(pluginVersionAndFragments, bundleId, (String)pluginBundle.getHeaders().get("Bundle-Version"));
            Bundle[] fragmentBundles = Platform.getFragments((Bundle)pluginBundle);
            if (fragmentBundles != null) {
                int f = 0;
                while (f < fragmentBundles.length) {
                    if (fragmentBundles[f].getState() != 2 && fragmentBundles[f].getState() != 1) {
                        this.appendBundleInformation(pluginVersionAndFragments, fragmentBundles[f].getSymbolicName(), (String)fragmentBundles[f].getHeaders().get("Bundle-Version"));
                    }
                    ++f;
                }
            }
            this.put(bundleId, pluginVersionAndFragments.toString());
        }
    }

    protected void appendBundleInformation(StringBuffer buffer, String id, String version) {
        if (buffer.length() > 0) {
            buffer.append(SEPARATOR);
        }
        buffer.append(id);
        buffer.append(SEPARATOR);
        buffer.append(version);
    }

    public boolean detectChange() {
        String oldVersions;
        String versions;
        String oneContr;
        if (!this.doComparison) {
            return this.hasChanged;
        }
        HelpProperties oldContrs = new HelpProperties(this.name, this.dir);
        if (!this.ignoreSavedVersions) {
            oldContrs.restore();
        }
        this.hasChanged = false;
        Enumeration<Object> keysEnum = this.keys();
        while (keysEnum.hasMoreElements()) {
            oneContr = (String)keysEnum.nextElement();
            if (!oldContrs.containsKey(oneContr)) {
                this.added.add(oneContr);
                continue;
            }
            versions = (String)this.get(oneContr);
            if (this.compare(versions, oldVersions = (String)oldContrs.get(oneContr))) continue;
            this.added.add(oneContr);
        }
        keysEnum = oldContrs.keys();
        while (keysEnum.hasMoreElements()) {
            oneContr = (String)keysEnum.nextElement();
            if (!this.containsKey(oneContr)) {
                this.removed.add(oneContr);
                continue;
            }
            versions = (String)this.get(oneContr);
            if (this.compare(versions, oldVersions = (String)oldContrs.get(oneContr))) continue;
            this.removed.add(oneContr);
        }
        this.hasChanged = this.added.size() > 0 || this.removed.size() > 0;
        this.doComparison = false;
        return this.hasChanged;
    }

    public Collection getAdded() {
        if (this.doComparison) {
            this.detectChange();
        }
        return this.added;
    }

    public Collection getRemoved() {
        if (this.doComparison) {
            this.detectChange();
        }
        return this.removed;
    }

    public boolean save() {
        if (super.save()) {
            this.doComparison = false;
            this.hasChanged = false;
            this.ignoreSavedVersions = false;
            this.added = new ArrayList();
            this.removed = new ArrayList();
            return true;
        }
        return false;
    }

    private boolean compare(String versions, String oldVersions) {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        StringTokenizer t = new StringTokenizer(versions, SEPARATOR, false);
        while (t.hasMoreTokens()) {
            String pluginOrFragment = t.nextToken();
            if (!t.hasMoreTokens()) continue;
            versionMap.put(pluginOrFragment, t.nextToken());
        }
        HashMap<String, String> oldVersionMap = new HashMap<String, String>();
        StringTokenizer t2 = new StringTokenizer(oldVersions, SEPARATOR, false);
        while (t2.hasMoreTokens()) {
            String pluginOrFragment = t2.nextToken();
            if (!t2.hasMoreTokens()) continue;
            oldVersionMap.put(pluginOrFragment, t2.nextToken());
        }
        return versionMap.equals(oldVersionMap);
    }
}

