/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.swt.graphics.Color;

public class TextAttribute {
    public static final int STRIKETHROUGH = 0x20000000;
    public static final int UNDERLINE = 0x40000000;
    private Color foreground;
    private Color background;
    private int style;

    public TextAttribute(Color foreground, Color background, int style) {
        this.foreground = foreground;
        this.background = background;
        this.style = style;
    }

    public TextAttribute(Color foreground) {
        this(foreground, null, 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextAttribute)) {
            return false;
        }
        TextAttribute a = (TextAttribute)object;
        return a.style == this.style && this.equals(a.foreground, this.foreground) && this.equals(a.background, this.background);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public int hashCode() {
        int foregroundHash = this.foreground == null ? 0 : this.foreground.hashCode();
        int backgroundHash = this.background == null ? 0 : this.background.hashCode();
        return foregroundHash << 24 | backgroundHash << 16 | this.style;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public int getStyle() {
        return this.style;
    }
}

