/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.AdaptableList;

public class DeleteAssociatedLaunchConfigurationsDialog
extends SelectionDialog {
    private static final String SETTINGS_ID = ".DELETE_ASSOCIATED_CONFIGS_DIALOG";
    private HashMap fMap = null;
    private Object fInput = null;
    private Button fPrefButton = null;
    private LCViewer fViewer = null;
    private Object[] fResult = null;

    public DeleteAssociatedLaunchConfigurationsDialog(Shell parentShell, Object input, String message, HashMap map) {
        super(parentShell);
        super.setMessage(message);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMap = map;
        this.fInput = input;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        SWTUtil.createLabel(comp, LaunchConfigurationsMessages.DeleteAssociatedLaunchConfigurationsDialog_0, 2);
        this.fViewer = new LCViewer(comp, 2048);
        Tree tree = this.fViewer.getTree();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tree.setLayoutData((Object)gd);
        this.fViewer.setContentProvider((IContentProvider)new DeleteContentProvider(this.fMap));
        this.fViewer.setInput(this.fInput);
        this.fViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fViewer.expandAll();
        Composite butcomp = new Composite(comp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        butcomp.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        butcomp.setLayoutData((Object)gd);
        Button sall = SWTUtil.createPushButton(butcomp, LaunchConfigurationsMessages.DeleteAssociatedLaunchConfigurationsDialog_1, null);
        sall.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DeleteAssociatedLaunchConfigurationsDialog.this.fViewer.setGrayedElements(new Object[0]);
                DeleteAssociatedLaunchConfigurationsDialog.this.fViewer.setAllChecked(true);
            }
        });
        Button dsall = SWTUtil.createPushButton(butcomp, LaunchConfigurationsMessages.DeleteAssociatedLaunchConfigurationsDialog_2, null);
        dsall.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DeleteAssociatedLaunchConfigurationsDialog.this.fViewer.setAllChecked(false);
            }
        });
        this.fPrefButton = new Button(comp, 32);
        this.fPrefButton.setText(LaunchConfigurationsMessages.DeleteAssociatedLaunchConfigurationsDialog_3);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    public Object[] getResult() {
        return this.fResult;
    }

    protected void okPressed() {
        this.fResult = this.fViewer.getCheckedElements();
        boolean pref = this.fPrefButton.getSelection();
        if (pref) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            store.setValue(IInternalDebugUIConstants.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE, "always");
        }
        super.okPressed();
    }

    class DeleteContentProvider
    implements ITreeContentProvider {
        private HashMap fInputMap = new HashMap();

        public DeleteContentProvider(HashMap map) {
            if (map != null) {
                this.fInputMap = map;
            }
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProject) {
                return ((ArrayList)this.fInputMap.get(parentElement)).toArray();
            }
            if (parentElement instanceof AdaptableList) {
                return this.fInputMap.keySet().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IProject;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.fInputMap.clear();
            this.fInputMap = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LCViewer
    extends CheckboxTreeViewer {
        public LCViewer(Composite parent, int style) {
            super(parent, style);
        }

        public Object[] getCheckedElements() {
            Object[] items = super.getCheckedElements();
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof ILaunchConfiguration) {
                    list.add(items[i]);
                }
                ++i;
            }
            return list.toArray();
        }

        protected void handleSelect(SelectionEvent event) {
            if (event.detail == 32) {
                this.updateCheckedState((TreeItem)event.item);
            }
        }

        public void updateCheckedState(TreeItem item) {
            Object element = item.getData();
            if (element instanceof ILaunchConfiguration) {
                TreeItem parent = item.getParentItem();
                TreeItem[] children = parent.getItems();
                int checked = 0;
                int i = 0;
                while (i < children.length) {
                    if (children[i].getChecked()) {
                        ++checked;
                    }
                    ++i;
                }
                if (checked == 0) {
                    this.setGrayChecked(parent.getData(), false);
                } else if (checked == children.length) {
                    parent.setGrayed(false);
                    parent.setChecked(true);
                } else {
                    this.setGrayChecked(parent.getData(), true);
                }
            } else if (element instanceof IProject) {
                item.setGrayed(false);
                TreeItem[] children = item.getItems();
                int i = 0;
                while (i < children.length) {
                    this.setChecked(children[i].getData(), item.getChecked());
                    ++i;
                }
            }
        }
    }
}

