/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;

public final class ActiveShellSourceProvider
extends AbstractSourceProvider {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeShell", "activeWorkbenchWindow", "activeWorkbenchWindowShell"};
    private final Display display;
    private Shell lastActiveShell = null;
    private Shell lastActiveWorkbenchWindowShell = null;
    private final Listener listener = new Listener(){

        public final void handleEvent(Event event) {
            boolean windowChanged;
            if (!(event.widget instanceof Shell)) {
                if (ActiveShellSourceProvider.access$0()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("ASSP: passOnEvent: " + event.widget);
                }
                return;
            }
            if (ActiveShellSourceProvider.access$0()) {
                ActiveShellSourceProvider.this.logDebuggingInfo("\tASSP:lastActiveShell: " + ActiveShellSourceProvider.this.lastActiveShell);
                ActiveShellSourceProvider.this.logDebuggingInfo("\tASSP:lastActiveWorkbenchWindowShell" + ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell);
            }
            Map currentState = ActiveShellSourceProvider.this.getCurrentState();
            Shell newActiveShell = (Shell)currentState.get("activeShell");
            IWorkbenchWindow newActiveWorkbenchWindow = (IWorkbenchWindow)currentState.get("activeWorkbenchWindow");
            Shell newActiveWorkbenchWindowShell = (Shell)currentState.get("activeWorkbenchWindowShell");
            boolean shellChanged = newActiveShell != ActiveShellSourceProvider.this.lastActiveShell;
            boolean bl = windowChanged = newActiveWorkbenchWindowShell != ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell;
            if (shellChanged && windowChanged) {
                HashMap<String, Object> sourceValuesByName = new HashMap<String, Object>(5);
                sourceValuesByName.put("activeShell", newActiveShell);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
                sourceValuesByName.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
                if (ActiveShellSourceProvider.access$0()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active shell changed to " + newActiveShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + newActiveWorkbenchWindow);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + newActiveWorkbenchWindowShell);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(17408, sourceValuesByName);
            } else if (shellChanged) {
                if (ActiveShellSourceProvider.access$0()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active shell changed to " + newActiveShell);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(1024, "activeShell", newActiveShell);
            } else if (windowChanged) {
                HashMap<String, IWorkbenchWindow> sourceValuesByName = new HashMap<String, IWorkbenchWindow>(4);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
                sourceValuesByName.put("activeWorkbenchWindowShell", (IWorkbenchWindow)newActiveWorkbenchWindowShell);
                if (ActiveShellSourceProvider.access$0()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + newActiveWorkbenchWindow);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + newActiveWorkbenchWindowShell);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(20480, sourceValuesByName);
            }
            ActiveShellSourceProvider.this.lastActiveShell = newActiveShell;
            ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell = newActiveWorkbenchWindowShell;
        }
    };
    private final IWorkbench workbench;

    public ActiveShellSourceProvider(IWorkbench workbench) {
        this.workbench = workbench;
        this.display = workbench.getDisplay();
        this.display.addFilter(26, this.listener);
    }

    public final void dispose() {
        this.display.removeFilter(26, this.listener);
    }

    public final Map getCurrentState() {
        HashMap<String, Object> currentState = new HashMap<String, Object>(4);
        Shell newActiveShell = this.display.getActiveShell();
        currentState.put("activeShell", newActiveShell);
        IContextService contextService = (IContextService)this.workbench.getService(IContextService.class);
        int shellType = contextService.getShellType(newActiveShell);
        if (shellType != 0) {
            IWorkbenchWindow newActiveWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            Shell newActiveWorkbenchWindowShell = newActiveWorkbenchWindow == null ? null : newActiveWorkbenchWindow.getShell();
            currentState.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
            currentState.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
        }
        return currentState;
    }

    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    static /* synthetic */ boolean access$0() {
        return AbstractSourceProvider.DEBUG;
    }
}

