/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class IndexAnchor
extends IndexedStoreObject {
    public static final int SIZE = 32;
    public static final int TYPE = 1;
    protected static final int RootNodeAddressOffset = 2;
    protected static final int RootNodeAddressLength = 4;
    protected static final int NumberOfEntriesOffset = 14;
    protected static final int NumberOfEntriesLength = 4;
    protected Field numberOfEntriesField;
    protected int numberOfEntries;
    protected Field rootNodeAddressField;
    protected ObjectAddress rootNodeAddress;

    public IndexAnchor() {
        this.numberOfEntries = 0;
        this.rootNodeAddress = ObjectAddress.Null;
    }

    public IndexAnchor(Field f, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        super(f, store, address);
    }

    private void setFields(Field f) {
        this.rootNodeAddressField = f.subfield(2, 4);
        this.numberOfEntriesField = f.subfield(14, 4);
    }

    protected void insertValues(Field f) {
        super.insertValues(f);
        this.setFields(f);
        this.numberOfEntriesField.put(this.numberOfEntries);
        this.rootNodeAddressField.put(this.rootNodeAddress);
    }

    protected void extractValues(Field f) throws ObjectStoreException {
        super.extractValues(f);
        this.setFields(f);
        this.numberOfEntries = this.numberOfEntriesField.getInt();
        this.rootNodeAddress = new ObjectAddress(this.rootNodeAddressField.get());
    }

    protected int getMinimumSize() {
        return 32;
    }

    protected int getRequiredType() {
        return 1;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Anchor(");
        b.append(this.numberOfEntries);
        b.append(",");
        b.append(this.rootNodeAddress);
        b.append(")");
        return b.toString();
    }

    void entryInserted(IndexNode node) {
        if (node.isLeaf()) {
            ++this.numberOfEntries;
            this.setChanged();
        }
    }

    void entryRemoved(IndexNode node) {
        if (node.isLeaf()) {
            --this.numberOfEntries;
            this.setChanged();
        }
    }

    void setRootNodeAddress(ObjectAddress rootNodeAddress) {
        this.rootNodeAddress = rootNodeAddress;
        this.setChanged();
    }

    void find(byte[] key, IndexCursor cursor) throws IndexedStoreException {
        if (this.rootNodeAddress.isNull()) {
            cursor.reset();
        } else {
            IndexNode rootNode = this.acquireNode(this.rootNodeAddress);
            rootNode.find(key, cursor);
            rootNode.release();
        }
    }

    void findFirstEntry(IndexCursor cursor) throws IndexedStoreException {
        if (this.rootNodeAddress.isNull()) {
            cursor.reset();
        } else {
            IndexNode rootNode = this.acquireNode(this.rootNodeAddress);
            rootNode.findFirstEntry(cursor);
            rootNode.release();
        }
    }

    void insert(byte[] key, byte[] value) throws IndexedStoreException {
        IndexNode rootNode;
        if (this.rootNodeAddress.isNull()) {
            rootNode = new IndexNode(this.address);
            try {
                this.store.insertObject(rootNode);
            }
            catch (ObjectStoreException e) {
                throw new IndexedStoreException(8, (Throwable)e);
            }
            this.rootNodeAddress = rootNode.getAddress();
        }
        rootNode = this.acquireNode(this.rootNodeAddress);
        rootNode.insertEntry(key, value);
        rootNode.release();
    }
}

