/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.SharingWizard;

public class DirectorySelectionPage
extends SVNWizardPage {
    Button useProjectNameButton;
    Button useSpecifiedNameButton;
    Text text;
    Button browseButton;
    Text urlText;
    String result;
    boolean useProjectName = true;

    public DirectorySelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.sharing_module_page_context");
        this.useProjectNameButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.moduleIsProject"), 3);
        this.useSpecifiedNameButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.specifyModule"), 1);
        this.useProjectNameButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectorySelectionPage.this.setUrlText();
                DirectorySelectionPage.this.useProjectName = DirectorySelectionPage.this.useProjectNameButton.getSelection();
                if (DirectorySelectionPage.this.useProjectName) {
                    DirectorySelectionPage.this.text.setEnabled(false);
                    DirectorySelectionPage.this.browseButton.setEnabled(false);
                    DirectorySelectionPage.this.result = null;
                    DirectorySelectionPage.this.setPageComplete(true);
                } else {
                    DirectorySelectionPage.this.text.setEnabled(true);
                    DirectorySelectionPage.this.browseButton.setEnabled(true);
                    DirectorySelectionPage.this.result = DirectorySelectionPage.this.text.getText();
                    if (DirectorySelectionPage.this.result.length() == 0) {
                        DirectorySelectionPage.this.result = null;
                        DirectorySelectionPage.this.setPageComplete(false);
                    } else {
                        DirectorySelectionPage.this.setPageComplete(true);
                    }
                }
            }
        });
        this.text = DirectorySelectionPage.createTextField(composite);
        this.text.setEnabled(false);
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DirectorySelectionPage.this.setUrlText();
                DirectorySelectionPage.this.result = DirectorySelectionPage.this.text.getText().trim();
                if (DirectorySelectionPage.this.result.length() == 0) {
                    DirectorySelectionPage.this.result = null;
                    DirectorySelectionPage.this.setPageComplete(false);
                } else {
                    DirectorySelectionPage.this.setPageComplete(true);
                }
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(Policy.bind("SharingWizard.browse"));
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                SharingWizard wizard = (SharingWizard)DirectorySelectionPage.this.getWizard();
                try {
                    ISVNRepositoryLocation repositoryLocation = wizard.getLocation();
                    ChooseUrlDialog dialog = new ChooseUrlDialog(DirectorySelectionPage.this.getShell(), (IResource)wizard.getProject());
                    dialog.setRepositoryLocation(repositoryLocation);
                    if (dialog.open() == 0 && dialog.getUrl() != null) {
                        DirectorySelectionPage.this.text.setText(String.valueOf(dialog.getUrl().toString().substring(repositoryLocation.getLocation().length() + 1)) + "/New Folder");
                        DirectorySelectionPage.this.text.setFocus();
                        DirectorySelectionPage.this.text.setSelection(DirectorySelectionPage.this.text.getText().indexOf("/New Folder") + 1, DirectorySelectionPage.this.text.getText().length());
                    }
                }
                catch (Exception exception) {}
            }
        });
        Group urlGroup = new Group(composite, 0);
        urlGroup.setText(Policy.bind("SharingWizard.url"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        urlGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        urlGroup.setLayoutData((Object)data);
        this.urlText = DirectorySelectionPage.createTextField((Composite)urlGroup);
        this.urlText.setEditable(false);
        Label warningLabel = new Label(composite, 0);
        warningLabel.setText(Policy.bind("SharingWizard.cannotExist"));
        data = new GridData();
        data.horizontalSpan = 3;
        warningLabel.setLayoutData((Object)data);
        this.useSpecifiedNameButton.setSelection(false);
        this.useProjectNameButton.setSelection(true);
        this.setUrlText();
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public String getDirectoryName() {
        return this.result;
    }

    public boolean useProjectName() {
        return this.useProjectName;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.useProjectNameButton.setFocus();
            this.setUrlText();
        }
    }

    private void setUrlText() {
        SharingWizard wizard = (SharingWizard)this.getWizard();
        try {
            if (this.useProjectNameButton.getSelection()) {
                this.urlText.setText(String.valueOf(wizard.getLocation().getLocation()) + "/" + wizard.getProject().getName());
            } else {
                this.urlText.setText(String.valueOf(wizard.getLocation().getLocation()) + "/" + this.text.getText().trim());
            }
        }
        catch (Exception exception) {}
    }
}

