/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DaySelectionCanvas
extends Canvas {
    private static final Color BLACK = Display.getCurrent().getSystemColor(2);
    private static final Color GRAY = Display.getCurrent().getSystemColor(15);
    private static final Color SELECTION_FOREGROUND = Display.getCurrent().getSystemColor(1);
    private static final Color WHITE = Display.getCurrent().getSystemColor(1);
    private Color selectionBackgroundColor = Display.getCurrent().getSystemColor(16);
    private final int WIDTH = 210;
    private final int HEIGHT = 140;
    private int[] days;
    private String[] header;
    private int selection = -1;

    public DaySelectionCanvas(Composite parent, int style) {
        super(parent, style);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.addPaintListener(new DaySelectPaintListener());
        this.addMouseListener((MouseListener)new DaySelectMouseListener());
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){});
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DaySelectionCanvas.this.selectionBackgroundColor.dispose();
                DaySelectionCanvas.this.selectionBackgroundColor = Display.getCurrent().getSystemColor(10);
                DaySelectionCanvas.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                DaySelectionCanvas.this.selectionBackgroundColor.dispose();
                DaySelectionCanvas.this.selectionBackgroundColor = Display.getCurrent().getSystemColor(16);
                DaySelectionCanvas.this.redraw();
            }
        });
    }

    public boolean setDays(int[] days) {
        if (days == null || days.length < 1) {
            days = null;
            return false;
        }
        int i = 0;
        while (i < days.length && days[i] > 1) {
            ++i;
        }
        if (i >= days.length || days[i] > 1) {
            days = null;
            return false;
        }
        this.days = days;
        this.selection = -1;
        this.redraw();
        return true;
    }

    public void setHeader(String[] header) {
        this.header = header;
        this.redraw();
    }

    public int getSelectedDay() {
        if (this.isValidSelection(this.selection)) {
            return this.days[this.selection];
        }
        return -1;
    }

    public void setSelectedDay(int day) {
        if (this.days == null) {
            this.selection = -1;
            return;
        }
        int i = 0;
        while (i < this.days.length) {
            if (this.days[i] == 1) {
                this.selection = i + day - 1;
                break;
            }
            ++i;
        }
    }

    public Point computeSize(int w, int h, boolean b) {
        int borderWidth = this.getBorderWidth();
        return new Point(210 + 2 * borderWidth, 140 + 2 * borderWidth);
    }

    public void dispose() {
        BLACK.dispose();
        GRAY.dispose();
        this.selectionBackgroundColor.dispose();
        SELECTION_FOREGROUND.dispose();
        WHITE.dispose();
        super.dispose();
    }

    private void setSelection(Point point, Point size) {
        int row = point.y / this.getRowHeight(size.y) - 1;
        int column = point.x / this.getColumnWidth(size.x);
        this.selection = row * 7 + column;
        this.redraw();
    }

    private boolean isValidSelection(int day) {
        if (this.days == null || day > this.days.length) {
            return false;
        }
        int i = 0;
        while (i < this.days.length && this.days[i] > 1) {
            if (i == day) {
                return false;
            }
            ++i;
        }
        if (i == day) {
            return true;
        }
        ++i;
        while (i < this.days.length && this.days[i] > 1) {
            if (i == day) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getColumnWidth(int width) {
        return width / 7;
    }

    private int getRowHeight(int height) {
        return height / 7;
    }

    private class DaySelectPaintListener
    implements PaintListener {
        private DaySelectPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            int i;
            Point controlSize = ((Control)e.getSource()).getSize();
            int height = controlSize.y;
            int rowHeight = DaySelectionCanvas.this.getRowHeight(height);
            int width = controlSize.x;
            int columnWidth = DaySelectionCanvas.this.getColumnWidth(width);
            GC gc = e.gc;
            gc.setBackground(WHITE);
            gc.fillRectangle(0, 0, width, height);
            gc.setForeground(BLACK);
            gc.setLineWidth(2);
            gc.drawLine(0, DaySelectionCanvas.this.getRowHeight(height), width, DaySelectionCanvas.this.getRowHeight(height));
            if (DaySelectionCanvas.this.header != null) {
                i = 0;
                while (i < DaySelectionCanvas.this.header.length) {
                    Point position = this.getHeaderPosition(gc, i, DaySelectionCanvas.this.header, columnWidth, rowHeight);
                    gc.drawText(DaySelectionCanvas.this.header[i], position.x, position.y);
                    ++i;
                }
            }
            gc.setForeground(GRAY);
            gc.setLineStyle(3);
            gc.setLineWidth(1);
            i = 1;
            while (i < 7) {
                gc.drawLine(i * columnWidth, DaySelectionCanvas.this.getRowHeight(height) + 1, i * columnWidth, height);
                ++i;
            }
            i = 2;
            while (i < 7) {
                gc.drawLine(0, i * rowHeight, width, i * rowHeight);
                ++i;
            }
            if (DaySelectionCanvas.this.days != null && DaySelectionCanvas.this.days.length > 0) {
                gc.setForeground(GRAY);
                i = 0;
                while (i < DaySelectionCanvas.this.days.length && DaySelectionCanvas.this.days[i] > 1) {
                    this.drawDay(gc, i, DaySelectionCanvas.this.days, columnWidth, rowHeight);
                    ++i;
                }
                gc.setForeground(BLACK);
                this.drawDay(gc, i, DaySelectionCanvas.this.days, columnWidth, rowHeight);
                ++i;
                while (i < DaySelectionCanvas.this.days.length && DaySelectionCanvas.this.days[i] > 1) {
                    this.drawDay(gc, i, DaySelectionCanvas.this.days, columnWidth, rowHeight);
                    ++i;
                }
                gc.setForeground(GRAY);
                while (i < DaySelectionCanvas.this.days.length) {
                    this.drawDay(gc, i, DaySelectionCanvas.this.days, columnWidth, rowHeight);
                    ++i;
                }
            }
            gc.dispose();
        }

        private void drawDay(GC gc, int item, int[] days, int columnWidth, int rowHeight) {
            Color tempBackground = null;
            Color tempForeground = null;
            boolean validSelection = DaySelectionCanvas.this.isValidSelection(item);
            if (validSelection && item == DaySelectionCanvas.this.selection) {
                tempBackground = gc.getBackground();
                tempForeground = gc.getForeground();
                gc.setBackground(DaySelectionCanvas.this.selectionBackgroundColor);
                gc.setForeground(SELECTION_FOREGROUND);
                int height = rowHeight;
                int width = columnWidth;
                int x = columnWidth * (item % 7);
                if (x > 0) {
                    ++x;
                    --width;
                }
                int y = rowHeight * (item / 7 + 1) + 1;
                --height;
                if (y == rowHeight) {
                    ++y;
                    --height;
                }
                gc.fillRectangle(x, y, width, height);
                gc.setBackground(tempBackground);
            }
            String dayString = String.valueOf(days[item]);
            Point position = this.getDayPosition(gc, item, days, columnWidth, rowHeight);
            gc.drawText(dayString, position.x, position.y, 1);
            if (validSelection && item == DaySelectionCanvas.this.selection) {
                gc.setForeground(tempForeground);
            }
        }

        private Point getHeaderPosition(GC gc, int item, String[] header, int columnWidth, int rowHeight) {
            int column = item % 7;
            Point size = gc.textExtent(String.valueOf(header[item]), 1);
            int x = column * columnWidth + columnWidth / 2 - size.x / 2;
            int y = rowHeight / 2 - size.y / 2;
            return new Point(x, y);
        }

        private Point getDayPosition(GC gc, int item, int[] days, int columnWidth, int rowHeight) {
            int row = item / 7 + 1;
            int column = item % 7;
            Point size = gc.textExtent(String.valueOf(days[item]), 1);
            int x = column * columnWidth + columnWidth / 2 - size.x / 2;
            int y = row * rowHeight + rowHeight / 2 - size.y / 2;
            return new Point(x, y);
        }
    }

    private class DaySelectMouseListener
    extends MouseAdapter {
        private DaySelectMouseListener() {
        }

        public void mouseDown(MouseEvent e) {
            Point size = ((Control)e.getSource()).getSize();
            DaySelectionCanvas.this.setSelection(new Point(e.x, e.y), size);
        }
    }
}

