/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class UpdateSynchronizeOperation
extends SVNSynchronizeOperation {
    private IResource[] resources;

    public UpdateSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IResource[] resources) {
        super(configuration, elements);
        this.resources = resources;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IResource[] resourceArray = this.trimResources(this.extractResources(this.resources, set));
        SVNRevision revision = null;
        SyncInfo[] syncInfos = set.getSyncInfos();
        boolean containsDeletes = false;
        int i = 0;
        while (i < syncInfos.length) {
            SVNStatusSyncInfo syncInfo = (SVNStatusSyncInfo)syncInfos[i];
            IResourceVariant remote = syncInfo.getRemote();
            if (remote != null && remote instanceof ISVNRemoteResource) {
                if (syncInfo.getRemoteResourceStatus() != null && syncInfo.getRemoteResourceStatus().getTextStatus() == SVNStatusKind.DELETED) {
                    containsDeletes = true;
                } else {
                    SVNRevision.Number rev = ((ISVNRemoteResource)remote).getLastChangedRevision();
                    if (rev instanceof SVNRevision.Number) {
                        long nbr = rev.getNumber();
                        if (revision == null) {
                            revision = rev;
                        } else {
                            long revisionNumber = ((SVNRevision.Number)revision).getNumber();
                            if (nbr > revisionNumber) {
                                revision = rev;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (revision == null || containsDeletes) {
            revision = SVNRevision.HEAD;
        }
        new UpdateOperation(this.getPart(), resourceArray, revision, true).run();
    }

    private IResource[] trimResources(IResource[] resourceArray) {
        ArrayList<IResource> folders = new ArrayList<IResource>();
        int i = 0;
        while (i < resourceArray.length) {
            if (resourceArray[i].getType() == 2 || resourceArray[i].getType() == 4) {
                folders.add(resourceArray[i]);
            }
            ++i;
        }
        ArrayList<IResource> trimmedList = new ArrayList<IResource>();
        int i2 = 0;
        while (i2 < resourceArray.length) {
            if (!this.parentIncluded(resourceArray[i2], folders)) {
                trimmedList.add(resourceArray[i2]);
            }
            ++i2;
        }
        IResource[] trimmedArray = new IResource[trimmedList.size()];
        trimmedList.toArray(trimmedArray);
        return trimmedArray;
    }

    private boolean parentIncluded(IResource resource, List folders) {
        IContainer parent = resource.getParent();
        if (parent == null) {
            return false;
        }
        if (folders.contains(parent)) {
            return true;
        }
        return this.parentIncluded((IResource)parent, folders);
    }
}

