/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public abstract class CompareWithRemoteAction
extends WorkspaceAction {
    private final SVNRevision revision;

    public CompareWithRemoteAction(SVNRevision revision) {
        this.revision = revision;
    }

    public void execute(IAction action) {
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return;
        }
        try {
            final ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0]);
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNLocalCompareInput(localResource, CompareWithRemoteAction.this.revision), (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
                    }
                    catch (SVNException e) {
                        CompareWithRemoteAction.this.handle((Exception)((Object)e), null, null);
                    }
                }
            }, false, 2);
        }
        catch (Exception e) {
            this.handle(e, null, null);
        }
    }

    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) throws SVNException {
        return super.isEnabledForSVNResource(svnResource) || svnResource.getParent().isManaged();
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForInaccessibleResources() {
        return true;
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }
}

