/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class UnlockResourcesCommand
implements ISVNCommand {
    private IResource[] resources;
    private boolean force;
    private SVNWorkspaceRoot root;

    public UnlockResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, boolean force) {
        this.resources = resources;
        this.force = force;
        this.root = root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        File[] resourceFiles = new File[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            resourceFiles[i] = this.resources[i].getLocation().toFile();
            ++i;
        }
        try {
            try {
                monitor.beginTask(null, 100);
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.unlock(resourceFiles, this.force);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
            Object var5_8 = null;
            OperationManager.getInstance().endOperation();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }
}

