/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.util;

import de.tobject.findbugs.FindbugsPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionDialog
extends ElementTreeSelectionDialog {
    public FileSelectionDialog(Shell parent, String title, final String extension) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        this.setTitle(title);
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IContainer) {
                    try {
                        IResource[] resources = ((IContainer)element).members();
                        for (int i = 0; i < resources.length; ++i) {
                            if (!this.select(viewer, element, resources[i])) continue;
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Error looking up children.");
                    }
                }
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return file.getName().endsWith(extension);
                }
                return false;
            }
        });
    }
}

