/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.epic.core.util.FileUtilities;
import org.epic.debug.PerlDebugPlugin;
import org.epic.perleditor.editors.PerlEditor;

public class PerlConsoleHyperlink
implements IHyperlink {
    private final String path;
    private final int lineNumber;

    public PerlConsoleHyperlink(String path, int line) {
        this.path = path;
        this.lineNumber = line - 1;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            PerlEditor editor = (PerlEditor)IDE.openEditor((IWorkbenchPage)this.activeWorkbenchPage(), (IFile)this.getEditorInput().getFile(), (boolean)true, (boolean)true);
            IDocument doc = editor.getViewer().getDocument();
            IRegion line = doc.getLineInformation(this.lineNumber);
            editor.selectAndReveal(line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            PerlDebugPlugin.log(e);
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
    }

    private IWorkbenchPage activeWorkbenchPage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private IFileEditorInput getEditorInput() {
        Path path = new Path(this.path);
        IFile fileInWorkspace = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        return fileInWorkspace != null ? new FileEditorInput(fileInWorkspace) : FileUtilities.getFileEditorInput((IPath)path);
    }
}

