###############################################################################
#
# EagleCmdlets.ps1 --
#
# Extensible Adaptable Generalized Logic Engine (Eagle)
# PowerShell Cmdlet Installation Script
#
# Copyright (c) 2007-2012 by Joe Mistachkin.  All rights reserved.
#
# See the file "license.terms" for information on usage and redistribution of
# this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: $
#
###############################################################################

param([String]$mode)

Set-Alias installutil `
    "$env:windir\Microsoft.NET\Framework\v2.0.50727\InstallUtil.exe"

$path = Split-Path $myInvocation.myCommand.path

if ($path -eq $null) {
  $path = "."
}

$fileName = Join-Path $path EagleCmdlets.dll

switch ($mode)
{
  "install" {
    installutil /LogFile= $fileName

    if ($lastExitCode -eq 0) {
      Add-PSSnapin EagleCmdlets
    } else {
      Write-Error "Installation of cmdlet failed."
    }
  }
  "uninstall" {
    installutil /u /LogFile= $fileName

    if ($lastExitCode -ne 0) {
      Write-Error "Uninstallation of cmdlet failed."
    }
  }
  default {
    Write-Error "Unknown mode."
  }
}
