/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import javax.net.ssl.SSLContext;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.transport.SocketConnectorFactory;
import org.apache.activemq.transport.https.Krb5AndCertsSslSocketConnector;
import org.apache.activemq.util.IntrospectionSupport;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SecureSocketConnectorFactory
extends SocketConnectorFactory {
    private String keyPassword = System.getProperty("javax.net.ssl.keyPassword");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String keyStore = System.getProperty("javax.net.ssl.keyStore");
    private String keyStoreType;
    private String secureRandomCertficateAlgorithm;
    private String trustCertificateAlgorithm;
    private String keyCertificateAlgorithm;
    private String protocol;
    private String auth;
    private SslContext context;

    public SecureSocketConnectorFactory(SslContext context) {
        this.context = context;
    }

    @Override
    public Connector createConnector() throws Exception {
        Krb5AndCertsSslSocketConnector sslConnector;
        IntrospectionSupport.setProperties((Object)this, this.getTransportOptions());
        if (Krb5AndCertsSslSocketConnector.isKrb(this.auth)) {
            sslConnector = new Krb5AndCertsSslSocketConnector();
            sslConnector.setMode(this.auth);
        } else {
            sslConnector = new SslSelectChannelConnector();
        }
        SSLContext sslContext = this.context == null ? null : this.context.getSSLContext();
        SslContextFactory factory = sslConnector.getSslContextFactory();
        if (this.context != null) {
            factory.setSslContext(sslContext);
        } else {
            if (this.keyStore != null) {
                factory.setKeyStorePath(this.keyStore);
            }
            if (this.keyStorePassword != null) {
                factory.setKeyStorePassword(this.keyStorePassword);
            }
            if (this.keyPassword == null && this.keyStorePassword != null) {
                factory.setKeyStorePassword(this.keyStorePassword);
            }
            if (this.keyStoreType != null) {
                factory.setKeyStoreType(this.keyStoreType);
            }
            if (this.secureRandomCertficateAlgorithm != null) {
                factory.setSecureRandomAlgorithm(this.secureRandomCertficateAlgorithm);
            }
            if (this.keyCertificateAlgorithm != null) {
                factory.setSslKeyManagerFactoryAlgorithm(this.keyCertificateAlgorithm);
            }
            if (this.trustCertificateAlgorithm != null) {
                factory.setTrustManagerFactoryAlgorithm(this.trustCertificateAlgorithm);
            }
            if (this.protocol != null) {
                factory.setProtocol(this.protocol);
            }
        }
        return sslConnector;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSecureRandomCertficateAlgorithm() {
        return this.secureRandomCertficateAlgorithm;
    }

    public void setSecureRandomCertficateAlgorithm(String secureRandomCertficateAlgorithm) {
        this.secureRandomCertficateAlgorithm = secureRandomCertficateAlgorithm;
    }

    public String getKeyCertificateAlgorithm() {
        return this.keyCertificateAlgorithm;
    }

    public void setKeyCertificateAlgorithm(String keyCertificateAlgorithm) {
        this.keyCertificateAlgorithm = keyCertificateAlgorithm;
    }

    public String getTrustCertificateAlgorithm() {
        return this.trustCertificateAlgorithm;
    }

    public void setTrustCertificateAlgorithm(String trustCertificateAlgorithm) {
        this.trustCertificateAlgorithm = trustCertificateAlgorithm;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }
}

