/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.LoopProcessor;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="loop")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoopDefinition
extends ExpressionNode {
    @XmlAttribute
    private Boolean copy;

    public LoopDefinition() {
    }

    public LoopDefinition(Expression expression) {
        super(expression);
    }

    public LoopDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public LoopDefinition copy() {
        this.setCopy(true);
        return this;
    }

    public void setExpression(Expression expr) {
        this.setExpression(new ExpressionDefinition(expr));
    }

    public Boolean getCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }

    public boolean isCopy() {
        return this.copy != null ? this.copy : false;
    }

    public String toString() {
        return "Loop[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return "loop[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "loop";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor output = this.createChildProcessor(routeContext, true);
        return new LoopProcessor(output, this.getExpression().createExpression(routeContext), this.isCopy());
    }
}

