/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.leveldbjni.internal;

import org.fusesource.leveldbjni.internal.JniDBIterator;
import org.fusesource.leveldbjni.internal.JniSnapshot;
import org.fusesource.leveldbjni.internal.JniWriteBatch;
import org.fusesource.leveldbjni.internal.NativeCache;
import org.fusesource.leveldbjni.internal.NativeComparator;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.fusesource.leveldbjni.internal.NativeLogger;
import org.fusesource.leveldbjni.internal.NativeRange;
import org.fusesource.leveldbjni.internal.NativeReadOptions;
import org.fusesource.leveldbjni.internal.NativeWriteBatch;
import org.fusesource.leveldbjni.internal.NativeWriteOptions;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;

public class JniDB
implements DB {
    private final NativeDB db;
    private final NativeCache cache;
    private final NativeComparator comparator;
    private final NativeLogger logger;

    public JniDB(NativeDB db, NativeCache cache, NativeComparator comparator, NativeLogger logger) {
        this.db = db;
        this.cache = cache;
        this.comparator = comparator;
        this.logger = logger;
    }

    public void close() {
        this.db.delete();
        if (this.cache != null) {
            this.cache.delete();
        }
        if (this.comparator != null) {
            this.comparator.delete();
        }
        if (this.logger != null) {
            this.logger.delete();
        }
    }

    public byte[] get(byte[] key) throws DBException {
        return this.get(key, new ReadOptions());
    }

    public byte[] get(byte[] key, ReadOptions options) throws DBException {
        try {
            return this.db.get(this.convert(options), key);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw new DBException(e.getMessage(), (Throwable)e);
        }
    }

    public DBIterator iterator() {
        return this.iterator(new ReadOptions());
    }

    public DBIterator iterator(ReadOptions options) {
        return new JniDBIterator(this.db.iterator(this.convert(options)));
    }

    public void put(byte[] key, byte[] value) throws DBException {
        this.put(key, value, new WriteOptions());
    }

    public void delete(byte[] key) throws DBException {
        this.delete(key, new WriteOptions());
    }

    public void write(WriteBatch updates) throws DBException {
        this.write(updates, new WriteOptions());
    }

    public WriteBatch createWriteBatch() {
        return new JniWriteBatch(new NativeWriteBatch());
    }

    public Snapshot put(byte[] key, byte[] value, WriteOptions options) throws DBException {
        try {
            this.db.put(this.convert(options), key, value);
            return null;
        }
        catch (NativeDB.DBException e) {
            throw new DBException(e.getMessage(), (Throwable)e);
        }
    }

    public Snapshot delete(byte[] key, WriteOptions options) throws DBException {
        try {
            this.db.delete(this.convert(options), key);
            return null;
        }
        catch (NativeDB.DBException e) {
            throw new DBException(e.getMessage(), (Throwable)e);
        }
    }

    public Snapshot write(WriteBatch updates, WriteOptions options) throws DBException {
        try {
            this.db.write(this.convert(options), ((JniWriteBatch)updates).writeBatch());
            return null;
        }
        catch (NativeDB.DBException e) {
            throw new DBException(e.getMessage(), (Throwable)e);
        }
    }

    public Snapshot getSnapshot() {
        return new JniSnapshot(this.db, this.db.getSnapshot());
    }

    public long[] getApproximateSizes(Range ... ranges) {
        NativeRange[] args = new NativeRange[ranges.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = new NativeRange(ranges[i].start(), ranges[i].limit());
        }
        return this.db.getApproximateSizes(args);
    }

    public String getProperty(String name) {
        return this.db.getProperty(name);
    }

    private NativeReadOptions convert(ReadOptions options) {
        if (options == null) {
            return null;
        }
        NativeReadOptions rc = new NativeReadOptions();
        rc.fillCache(options.fillCache());
        rc.verifyChecksums(options.verifyChecksums());
        if (options.snapshot() != null) {
            rc.snapshot(((JniSnapshot)options.snapshot()).snapshot());
        }
        return rc;
    }

    private NativeWriteOptions convert(WriteOptions options) {
        if (options == null) {
            return null;
        }
        NativeWriteOptions rc = new NativeWriteOptions();
        rc.sync(options.sync());
        if (options.snapshot()) {
            throw new UnsupportedOperationException("WriteOptions snapshot not supported");
        }
        return rc;
    }

    public void compactRange(byte[] begin, byte[] end) throws DBException {
        this.db.compactRange(begin, end);
    }
}

