/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.http.HTTPProxyAdapterControl;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigMap;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.HTTPMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.SOAPMessage;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.http.ExternalProxySettings;
import flex.messaging.services.http.HTTPConnectionManagerSettings;
import flex.messaging.services.http.HTTPProxyDestination;
import flex.messaging.services.http.HostConfigurationSettings;
import flex.messaging.services.http.ProtocolFactory;
import flex.messaging.services.http.proxy.AccessFilter;
import flex.messaging.services.http.proxy.ErrorFilter;
import flex.messaging.services.http.proxy.ProxyContext;
import flex.messaging.services.http.proxy.ProxyContextFilter;
import flex.messaging.services.http.proxy.ProxyFilter;
import flex.messaging.services.http.proxy.RequestFilter;
import flex.messaging.services.http.proxy.ResponseFilter;
import flex.messaging.services.http.proxy.SecurityFilter;
import flex.messaging.services.http.proxy.Target;
import flex.messaging.util.ClassUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;

public class HTTPProxyAdapter
extends ServiceAdapter {
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final int DEFAULT_COOKIE_LIMIT = 200;
    private static final String COOKIE_LIMIT = "cookie-limit";
    private static final String ALLOW_LAX_SSL = "allow-lax-ssl";
    private static final String CONTENT_CHUNKED = "content-chunked";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String PROPERTIES = "properties";
    protected boolean allowLaxSSL = false;
    protected boolean contentChunked = false;
    protected int cookieLimit = 200;
    protected ExternalProxySettings externalProxy;
    protected HTTPConnectionManagerSettings connectionManagerSettings;
    protected HttpConnectionManager connectionManager;
    protected HttpConnectionManagerParams connectionParams;
    protected ProxyFilter filterChain;
    protected UsernamePasswordCredentials proxyCredentials;
    private HTTPProxyAdapterControl controller;
    static /* synthetic */ Class class$flex$messaging$services$http$ProtocolFactory;

    public HTTPProxyAdapter() {
        this(false);
    }

    public HTTPProxyAdapter(boolean enableManagement) {
        super(enableManagement);
        this.createFilterChain();
        this.externalProxy = new ExternalProxySettings();
        this.connectionManagerSettings = new HTTPConnectionManagerSettings();
    }

    public void initialize(String id, ConfigMap properties) {
        ConfigMap extern;
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        ConfigMap conn = properties.getPropertyAsMap("connection-manager", null);
        if (conn != null) {
            List hosts;
            int bufferSize;
            int timeout;
            int defaultMaxConnsPerHost = 2;
            if (conn.getProperty("max-total-connections") != null) {
                int maxTotal = conn.getPropertyAsInt("max-total-connections", 20);
                this.connectionManagerSettings.setMaxTotalConnections(maxTotal);
            }
            if (conn.getProperty("default-max-connections-per-host") != null) {
                defaultMaxConnsPerHost = conn.getPropertyAsInt("default-max-connections-per-host", 2);
                this.connectionManagerSettings.setDefaultMaxConnectionsPerHost(defaultMaxConnsPerHost);
            }
            if (conn.getProperty("connection-timeout") != null && (timeout = conn.getPropertyAsInt("connection-timeout", 0)) >= 0) {
                this.connectionManagerSettings.setConnectionTimeout(timeout);
            }
            if (conn.getProperty("socket-timeout") != null && (timeout = conn.getPropertyAsInt("socket-timeout", 0)) >= 0) {
                this.connectionManagerSettings.setSocketTimeout(timeout);
            }
            if (conn.getProperty("stale-checking-enabled") != null) {
                boolean staleCheck = conn.getPropertyAsBoolean("stale-checking-enabled", true);
                this.connectionManagerSettings.setStaleCheckingEnabled(staleCheck);
            }
            if (conn.getProperty("send-buffer-size") != null && (bufferSize = conn.getPropertyAsInt("send-buffer-size", 0)) > 0) {
                this.connectionManagerSettings.setSendBufferSize(bufferSize);
            }
            if (conn.getProperty("receive-buffer-size") != null && (bufferSize = conn.getPropertyAsInt("receive-buffer-size", 0)) > 0) {
                this.connectionManagerSettings.setReceiveBufferSize(bufferSize);
            }
            if (conn.getProperty("tcp-no-delay") != null) {
                boolean noNagel = conn.getPropertyAsBoolean("tcp-no-delay", true);
                this.connectionManagerSettings.setTcpNoDelay(noNagel);
            }
            if (conn.getProperty("linger") != null) {
                int linger = conn.getPropertyAsInt("linger", -1);
                this.connectionManagerSettings.setLinger(linger);
            }
            if ((hosts = conn.getPropertyAsList("max-per-host", null)) != null) {
                ArrayList<HostConfigurationSettings> hostSettings = new ArrayList<HostConfigurationSettings>();
                Iterator it = hosts.iterator();
                while (it.hasNext()) {
                    ConfigMap proxy;
                    ConfigMap maxPerHost = (ConfigMap)it.next();
                    HostConfigurationSettings hostConfig = new HostConfigurationSettings();
                    int maxConn = defaultMaxConnsPerHost;
                    if (maxPerHost.getProperty("max-connections") != null) {
                        maxConn = maxPerHost.getPropertyAsInt("max-connections", 2);
                        hostConfig.setMaximumConnections(maxConn);
                    }
                    if (maxPerHost.getProperty("host") != null) {
                        String host = maxPerHost.getPropertyAsString("host", null);
                        hostConfig.setHost(host);
                        if (host != null) {
                            int port = maxPerHost.getPropertyAsInt("port", 0);
                            hostConfig.setPort(port);
                            ConfigMap factoryMap = maxPerHost.getPropertyAsMap("protocol-factory", null);
                            if (factoryMap != null) {
                                String className = factoryMap.getPropertyAsString(CLASS, null);
                                if (className != null) {
                                    Class factoryClass = ClassUtil.createClass((String)className);
                                    ProtocolFactory protocolFactory = (ProtocolFactory)ClassUtil.createDefaultInstance((Class)factoryClass, (Class)(class$flex$messaging$services$http$ProtocolFactory == null ? HTTPProxyAdapter.class$("flex.messaging.services.http.ProtocolFactory") : class$flex$messaging$services$http$ProtocolFactory));
                                    String factoryId = factoryMap.getPropertyAsString(ID, host + "_protocol_factory");
                                    ConfigMap protocolProperties = factoryMap.getPropertyAsMap(PROPERTIES, null);
                                    protocolFactory.initialize(factoryId, protocolProperties);
                                }
                            } else {
                                String protocol = maxPerHost.getPropertyAsString("protocol", null);
                                hostConfig.setProtocol(protocol);
                            }
                        }
                    }
                    if (maxPerHost.getProperty("proxy") != null && (proxy = maxPerHost.getPropertyAsMap("proxy", null)) != null) {
                        String proxyHost = proxy.getPropertyAsString("host", null);
                        hostConfig.setProxyHost(proxyHost);
                        if (proxyHost != null) {
                            int port = proxy.getPropertyAsInt("port", 0);
                            hostConfig.setProxyPort(port);
                        }
                    }
                    if (maxPerHost.getProperty("local-address") != null) {
                        String localAddress = maxPerHost.getPropertyAsString("local-address", null);
                        hostConfig.setLocalAddress(localAddress);
                    }
                    hostSettings.add(hostConfig);
                }
                if (hostSettings.size() > 0) {
                    this.connectionManagerSettings.setMaxConnectionsPerHost(hostSettings);
                }
            }
            this.setConnectionManagerSettings(this.connectionManagerSettings);
        }
        if (properties.getProperty(COOKIE_LIMIT) != null) {
            int cl = properties.getPropertyAsInt(COOKIE_LIMIT, 200);
            this.setCookieLimit(cl);
        }
        if (properties.getProperty(ALLOW_LAX_SSL) != null) {
            boolean lax = properties.getPropertyAsBoolean(ALLOW_LAX_SSL, false);
            this.setAllowLaxSSL(lax);
        }
        if (properties.getProperty(CONTENT_CHUNKED) != null) {
            boolean ch = properties.getPropertyAsBoolean(CONTENT_CHUNKED, false);
            this.setContentChunked(ch);
        }
        if ((extern = properties.getPropertyAsMap("external-proxy", null)) != null) {
            ExternalProxySettings proxy = new ExternalProxySettings();
            String proxyServer = extern.getPropertyAsString("server", null);
            proxy.setProxyServer(proxyServer);
            int proxyPort = extern.getPropertyAsInt("port", 80);
            proxy.setProxyPort(proxyPort);
            String ntdomain = extern.getPropertyAsString("nt-domain", null);
            proxy.setNTDomain(ntdomain);
            String username = extern.getPropertyAsString("username", null);
            proxy.setUsername(username);
            String password = extern.getPropertyAsString("password", null);
            proxy.setPassword(password);
            this.setExternalProxySettings(proxy);
        }
    }

    public boolean isAllowLaxSSL() {
        return this.allowLaxSSL;
    }

    public void setAllowLaxSSL(boolean allowLaxSSL) {
        this.allowLaxSSL = allowLaxSSL;
    }

    public boolean isContentChunked() {
        return this.contentChunked;
    }

    public void setContentChunked(boolean contentChunked) {
        this.contentChunked = contentChunked;
    }

    public int getCookieLimit() {
        return this.cookieLimit;
    }

    public void setCookieLimit(int cookieLimit) {
        this.cookieLimit = cookieLimit;
    }

    public void setDestination(Destination destination) {
        HTTPProxyDestination dest = (HTTPProxyDestination)destination;
        super.setDestination((Destination)dest);
    }

    public ExternalProxySettings getExternalProxySettings() {
        return this.externalProxy;
    }

    public void setExternalProxySettings(ExternalProxySettings externalProxy) {
        this.externalProxy = externalProxy;
        this.initExternalProxy(externalProxy);
    }

    public HTTPConnectionManagerSettings getConnectionManagerSettings() {
        return this.connectionManagerSettings;
    }

    public void setConnectionManagerSettings(HTTPConnectionManagerSettings connectionManagerSettings) {
        this.connectionManagerSettings = connectionManagerSettings;
        this.initHttpConnectionManagerParams(connectionManagerSettings);
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.setParams(this.connectionParams);
    }

    public Object invoke(Message msg) {
        HTTPMessage message = (HTTPMessage)msg;
        ProxyContext context = new ProxyContext();
        if (message instanceof SOAPMessage) {
            context.setSoapRequest(true);
        } else {
            context.setSoapRequest(false);
        }
        this.setupContext(context, message);
        try {
            this.filterChain.invoke(context);
            Object response = context.getResponse();
            if (context.getRecordHeaders()) {
                AcknowledgeMessage ack = new AcknowledgeMessage();
                ack.setBody(response);
                ack.setHeader("requestHeaders", (Object)context.getRequestHeaders());
                ack.setHeader("responseHeaders", (Object)context.getResponseHeaders());
                return ack;
            }
            return response;
        }
        catch (MessageException ex) {
            throw ex;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new MessageException(t.toString());
        }
    }

    protected void setupContext(ProxyContext context, HTTPMessage message) {
        Target target = new Target();
        context.setTarget(target);
        context.setExternalProxySettings(this.externalProxy);
        context.setProxyCredentials(this.proxyCredentials);
        context.setConnectionManager(this.connectionManager);
        context.setAllowLaxSSL(this.allowLaxSSL);
        context.setContentChunked(this.contentChunked);
        context.setRecordHeaders(message.getRecordHeaders());
        context.setCookieLimit(this.cookieLimit);
        context.setHttpRequest(FlexContext.getHttpRequest() != null);
        String url = message.getUrl();
        context.setUrl(url);
        Map httpHeaders = message.getHttpHeaders();
        context.setHeaders(httpHeaders);
        String method = message.getMethod();
        context.setMethod(method);
        String contentType = message.getContentType();
        context.setContentType(contentType);
        Object body = message.getBody();
        context.setBody(body);
        target.setRemoteUsername(message.getRemoteUsername());
        target.setRemotePassword(message.getRemotePassword());
        HTTPProxyDestination destination = (HTTPProxyDestination)this.getDestination();
        target.setUseCustomAuthentication(destination.isUseCustomAuthentication());
        if (destination.getProtocolFactory() != null) {
            ProtocolFactory protocolFactory = destination.getProtocolFactory();
            context.setProtocol(protocolFactory.getProtocol());
        }
    }

    protected void setupAdapterControl(Destination destination) {
        this.controller = new HTTPProxyAdapterControl(this, destination.getControl());
        this.controller.register();
        this.setControl((BaseControl)this.controller);
    }

    private ProxyFilter createFilterChain() {
        if (this.filterChain == null) {
            ErrorFilter errorFilter = new ErrorFilter();
            AccessFilter accessFilter = new AccessFilter();
            ProxyContextFilter contextFilter = new ProxyContextFilter();
            ResponseFilter responseFilter = new ResponseFilter();
            SecurityFilter securityFilter = new SecurityFilter();
            RequestFilter requestFilter = new RequestFilter();
            errorFilter.setNext(accessFilter);
            accessFilter.setNext(contextFilter);
            contextFilter.setNext(responseFilter);
            responseFilter.setNext(securityFilter);
            securityFilter.setNext(requestFilter);
            this.filterChain = errorFilter;
        }
        return this.filterChain;
    }

    private void initExternalProxy(ExternalProxySettings ep) {
        if (this.externalProxy != null) {
            String proxyServer = this.externalProxy.getProxyServer();
            String proxyUsername = this.externalProxy.getUsername();
            if (proxyUsername != null) {
                String proxyPassword = this.externalProxy.getPassword();
                String proxyDomain = this.externalProxy.getNTDomain();
                this.proxyCredentials = proxyDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyServer, proxyDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
            }
        }
    }

    private void initHttpConnectionManagerParams(HTTPConnectionManagerSettings settings) {
        this.connectionParams = new HttpConnectionManagerParams();
        this.connectionParams.setMaxTotalConnections(settings.getMaxTotalConnections());
        this.connectionParams.setDefaultMaxConnectionsPerHost(settings.getDefaultMaxConnectionsPerHost());
        if (settings.getConnectionTimeout() >= 0) {
            this.connectionParams.setConnectionTimeout(settings.getConnectionTimeout());
        }
        if (settings.getSocketTimeout() >= 0) {
            this.connectionParams.setSoTimeout(settings.getSocketTimeout());
        }
        this.connectionParams.setStaleCheckingEnabled(settings.isStaleCheckingEnabled());
        if (settings.getSendBufferSize() > 0) {
            this.connectionParams.setSendBufferSize(settings.getSendBufferSize());
        }
        if (settings.getReceiveBufferSize() > 0) {
            this.connectionParams.setReceiveBufferSize(settings.getReceiveBufferSize());
        }
        this.connectionParams.setTcpNoDelay(settings.isTcpNoDelay());
        this.connectionParams.setLinger(settings.getLinger());
        if (settings.getMaxConnectionsPerHost() != null) {
            Iterator it = settings.getMaxConnectionsPerHost().iterator();
            while (it.hasNext()) {
                HostParams params;
                Protocol protocol;
                HostConfigurationSettings hcs = (HostConfigurationSettings)it.next();
                HostConfiguration hostConfig = new HostConfiguration();
                if (hcs.getProtocol() != null) {
                    protocol = Protocol.getProtocol((String)hcs.getProtocol());
                    hostConfig.setHost(hcs.getHost(), hcs.getPort(), protocol);
                } else if (hcs.getProtocolFactory() != null) {
                    protocol = hcs.getProtocolFactory().getProtocol();
                    if (hcs.getPort() > 0) {
                        hostConfig.setHost(hcs.getHost(), hcs.getPort(), protocol);
                    } else {
                        hostConfig.setHost(hcs.getHost(), protocol.getDefaultPort(), protocol);
                    }
                } else if (hcs.getPort() > 0) {
                    hostConfig.setHost(hcs.getHost(), hcs.getPort());
                } else {
                    hostConfig.setHost(hcs.getHost());
                }
                if (hcs.getVirtualHost() != null && (params = hostConfig.getParams()) != null) {
                    params.setVirtualHost(hcs.getVirtualHost());
                }
                if (hcs.getProxyHost() != null) {
                    hostConfig.setProxy(hcs.getProxyHost(), hcs.getProxyPort());
                }
                try {
                    InetAddress addr = InetAddress.getByName(hcs.getLocalAddress());
                    hostConfig.setLocalAddress(addr);
                }
                catch (UnknownHostException ex) {
                    // empty catch block
                }
                this.connectionParams.setMaxConnectionsPerHost(hostConfig, hcs.getMaximumConnections());
            }
        }
    }
}

