/*
 * Decompiled with CFR 0.152.
 */
package org.safehaus.uuid;

import java.io.Serializable;

public class UUID
implements Serializable,
Cloneable,
Comparable {
    private static final String kHexChars = "0123456789abcdefABCDEF";
    public static final byte INDEX_CLOCK_HI = 6;
    public static final byte INDEX_CLOCK_MID = 4;
    public static final byte INDEX_CLOCK_LO = 0;
    public static final byte INDEX_TYPE = 6;
    public static final byte INDEX_CLOCK_SEQUENCE = 8;
    public static final byte INDEX_VARIATION = 8;
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_TIME_BASED = 1;
    public static final byte TYPE_DCE = 2;
    public static final byte TYPE_NAME_BASED = 3;
    public static final byte TYPE_RANDOM_BASED = 4;
    public static final String NAMESPACE_DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_URL = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_OID = "6ba7b812-9dad-11d1-80b4-00c04fd430c8";
    public static final String NAMESPACE_X500 = "6ba7b814-9dad-11d1-80b4-00c04fd430c8";
    private static boolean sDescCaching = true;
    private static final UUID sNullUUID = new UUID();
    private final byte[] mId = new byte[16];
    private transient String mDesc = null;
    private transient int mHashCode = 0;
    private static final int[] kShifts = new int[]{3, 7, 17, 21, 29, 4, 9};
    private static final int[] sTimeCompare = new int[]{6, 7, 4, 5, 0, 1, 2, 3};

    public UUID() {
    }

    public UUID(byte[] byArray) {
        for (int i = 0; i < 16; ++i) {
            this.mId[i] = byArray[i];
        }
    }

    public UUID(byte[] byArray, int n) {
        for (int i = 0; i < 16; ++i) {
            this.mId[i] = byArray[n + i];
        }
    }

    UUID(int n, byte[] byArray) {
        for (int i = 0; i < 16; ++i) {
            this.mId[i] = byArray[i];
        }
        this.mId[6] = (byte)(this.mId[6] & 0xF);
        this.mId[6] = (byte)(this.mId[6] | (byte)(n << 4));
        this.mId[8] = (byte)(this.mId[8] & 0x3F);
        this.mId[8] = (byte)(this.mId[8] | 0xFFFFFF80);
    }

    public UUID(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 36) {
            throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
        }
        int n = 0;
        int n2 = 0;
        while (n < 36) {
            switch (n) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (string.charAt(n) != '-') {
                        throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
                    }
                    ++n;
                }
            }
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                this.mId[n2] = (byte)(c - 48 << 4);
            } else if (c >= 'a' && c <= 'f') {
                this.mId[n2] = (byte)(c - 97 + 10 << 4);
            } else if (c >= 'A' && c <= 'F') {
                this.mId[n2] = (byte)(c - 65 + 10 << 4);
            } else {
                throw new NumberFormatException("Non-hex character '" + c + "'");
            }
            c = string.charAt(++n);
            if (c >= '0' && c <= '9') {
                int n3 = n2;
                this.mId[n3] = (byte)(this.mId[n3] | (byte)(c - 48));
            } else if (c >= 'a' && c <= 'f') {
                int n4 = n2;
                this.mId[n4] = (byte)(this.mId[n4] | (byte)(c - 97 + 10));
            } else if (c >= 'A' && c <= 'F') {
                int n5 = n2;
                this.mId[n5] = (byte)(this.mId[n5] | (byte)(c - 65 + 10));
            } else {
                throw new NumberFormatException("Non-hex character '" + c + "'");
            }
            ++n;
            ++n2;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static void setDescCaching(boolean bl) {
        sDescCaching = bl;
    }

    public static UUID getNullUUID() {
        return sNullUUID;
    }

    public boolean isNullUUID() {
        if (this == sNullUUID) {
            return true;
        }
        byte[] byArray = this.mId;
        int n = this.mId.length;
        byte by = 0;
        while (--n >= 0) {
            if (byArray[n] == by) continue;
            return false;
        }
        return true;
    }

    public int getType() {
        return (this.mId[6] & 0xFF) >> 4;
    }

    public byte[] asByteArray() {
        byte[] byArray = new byte[16];
        this.toByteArray(byArray);
        return byArray;
    }

    public void toByteArray(byte[] byArray, int n) {
        byte[] byArray2 = this.mId;
        for (int i = 0; i < 16; ++i) {
            byArray[n + i] = byArray2[i];
        }
    }

    public void toByteArray(byte[] byArray) {
        this.toByteArray(byArray, 0);
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            int n;
            int n2 = this.mId[0] & 0xFF;
            n2 |= n2 << 16;
            n2 |= n2 << 8;
            for (n = 1; n < 15; n += 2) {
                int n3 = (this.mId[n] & 0xFF) << 8 | this.mId[n + 1] & 0xFF;
                int n4 = kShifts[n >> 1];
                if (n4 > 16) {
                    n2 ^= n3 << n4 | n3 >>> 32 - n4;
                    continue;
                }
                n2 ^= n3 << n4;
            }
            n = this.mId[15] & 0xFF;
            n2 ^= n << 3;
            n2 ^= n << 13;
            this.mHashCode = (n2 ^= n << 27) == 0 ? -1 : n2;
        }
        return this.mHashCode;
    }

    public String toString() {
        if (this.mDesc == null) {
            StringBuffer stringBuffer = new StringBuffer(36);
            for (int i = 0; i < 16; ++i) {
                switch (i) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: {
                        stringBuffer.append('-');
                    }
                }
                int n = this.mId[i] & 0xFF;
                stringBuffer.append(kHexChars.charAt(n >> 4));
                stringBuffer.append(kHexChars.charAt(n & 0xF));
            }
            if (!sDescCaching) {
                return stringBuffer.toString();
            }
            this.mDesc = stringBuffer.toString();
        }
        return this.mDesc;
    }

    public int compareTo(Object object) {
        int n;
        int n2;
        int n3;
        UUID uUID = (UUID)object;
        int n4 = this.getType();
        if (n4 > (n3 = uUID.getType())) {
            return 1;
        }
        if (n4 < n3) {
            return -1;
        }
        byte[] byArray = this.mId;
        byte[] byArray2 = uUID.mId;
        if (n4 == 1) {
            for (n2 = 0; n2 < 8; ++n2) {
                n = sTimeCompare[n2];
                int n5 = (byArray[n] & 0xFF) - (byArray2[n] & 0xFF);
                if (n5 == 0) continue;
                return n5;
            }
        }
        while (n2 < 16) {
            n = (byArray[n2] & 0xFF) - (byArray2[n2] & 0xFF);
            if (n != 0) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UUID)) {
            return false;
        }
        byte[] byArray = ((UUID)object).mId;
        byte[] byArray2 = this.mId;
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static UUID valueOf(String string) throws NumberFormatException {
        return new UUID(string);
    }

    public static UUID valueOf(byte[] byArray, int n) {
        return new UUID(byArray, n);
    }

    public static UUID valueOf(byte[] byArray) {
        return new UUID(byArray);
    }

    private void copyFrom(UUID uUID) {
        byte[] byArray = uUID.mId;
        byte[] byArray2 = this.mId;
        for (int i = 0; i < 16; ++i) {
            byArray2[i] = byArray[i];
        }
        this.mDesc = sDescCaching ? uUID.mDesc : null;
    }

    public static void main(String[] stringArray) {
    }
}

