'''OpenGL extension ARB.texture_compression

Overview (from the spec)
	
	    Compressing texture images can reduce texture memory utilization and
	    improve performance when rendering textured primitives.  This extension
	    allows OpenGL applications to use compressed texture images by providing:
	
		(1) A framework upon which extensions providing specific compressed
		    image formats can be built.
	
		(2) A set of generic compressed internal formats that allow
		    applications to specify that texture images should be stored in
		    compressed form without needing to code for specific compression
		    formats.
	
	    An application can define compressed texture images by providing a texture
	    image stored in a specific compressed image format.  This extension does
	    not define any specific compressed image formats, but it does provide the
	    mechanisms necessary to enable other extensions that do.
	
	    An application can also define compressed texture images by providing an
	    uncompressed texture image but specifying a compressed internal format.
	    In this case, the GL will automatically compress the texture image using
	    the appropriate image format.  Compressed internal formats can either be
	    specific (as above) or generic.  Generic compressed internal formats are
	    not actual image formats, but are instead mapped into one of the specific
	    compressed formats provided by the GL (or to an uncompressed base internal
	    format if no appropriate compressed format is available).  Generic
	    compressed internal formats allow applications to use texture compression
	    without needing to code to any particular compression algorithm.  Generic
	    compressed formats allow the use of texture compression across a wide
	    range of platforms with differing compression algorithms and also allow
	    future GL implementations to substitute improved compression methods
	    transparently.
	
	    Compressed texture images can be obtained from the GL in uncompressed form
	    by calling GetTexImage and in compressed form by calling
	    GetCompressedTexImageARB.  Queried compressed images can be saved and
	    later reused by calling CompressedTexImage[123]DARB.  Pre-compressed
	    texture images do not need to be processed by the GL and should
	    significantly improve texture loading performance relative to uncompressed
	    images.
	
	    This extension does not define specific compressed image formats (e.g.,
	    S3TC, FXT1), nor does it provide means to encode or decode such images.
	    To support images in a specific compressed format, a hardware vendor
	    would:
	
	      (1) Provide a new extension defininig specific compressed
		  <internalformat> and <format> tokens for TexImage[123]D,
		  TexSubImage[123]D, CopyTexImage[12]D, CompressedTexImage[123]DARB,
	          CompressedTexSubImage[123]DARB, and GetCompressedTexImageARB calls.
	
	      (2) Specify the encoding of compressed images of that specific format.
	
	      (3) Specify a method for deriving the size of compressed images of that
		  specific format, using the <internalformat>, <width>, <height>,
		  <depth> parameters, and (if necessary) the compressed image itself.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/ARB/texture_compression.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_texture_compression'
GL_COMPRESSED_ALPHA_ARB = constant.Constant( 'GL_COMPRESSED_ALPHA_ARB', 0x84E9 )
GL_COMPRESSED_LUMINANCE_ARB = constant.Constant( 'GL_COMPRESSED_LUMINANCE_ARB', 0x84EA )
GL_COMPRESSED_LUMINANCE_ALPHA_ARB = constant.Constant( 'GL_COMPRESSED_LUMINANCE_ALPHA_ARB', 0x84EB )
GL_COMPRESSED_INTENSITY_ARB = constant.Constant( 'GL_COMPRESSED_INTENSITY_ARB', 0x84EC )
GL_COMPRESSED_RGB_ARB = constant.Constant( 'GL_COMPRESSED_RGB_ARB', 0x84ED )
GL_COMPRESSED_RGBA_ARB = constant.Constant( 'GL_COMPRESSED_RGBA_ARB', 0x84EE )
GL_TEXTURE_COMPRESSION_HINT_ARB = constant.Constant( 'GL_TEXTURE_COMPRESSION_HINT_ARB', 0x84EF )
glget.addGLGetConstant( GL_TEXTURE_COMPRESSION_HINT_ARB, (1,) )
GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = constant.Constant( 'GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB', 0x86A0 )
GL_TEXTURE_COMPRESSED_ARB = constant.Constant( 'GL_TEXTURE_COMPRESSED_ARB', 0x86A1 )
GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = constant.Constant( 'GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB', 0x86A2 )
glget.addGLGetConstant( GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB, (1,) )
GL_COMPRESSED_TEXTURE_FORMATS_ARB = constant.Constant( 'GL_COMPRESSED_TEXTURE_FORMATS_ARB', 0x86A3 )
glget.addGLGetConstant( GL_COMPRESSED_TEXTURE_FORMATS_ARB, (1,) )
glCompressedTexImage3DARB = platform.createExtensionFunction( 
	'glCompressedTexImage3DARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLsizei, constants.GLint, constants.GLsizei, ctypes.c_void_p,),
	doc = 'glCompressedTexImage3DARB( GLenum(target), GLint(level), GLenum(internalformat), GLsizei(width), GLsizei(height), GLsizei(depth), GLint(border), GLsizei(imageSize), c_void_p(data) ) -> None',
	argNames = ('target', 'level', 'internalformat', 'width', 'height', 'depth', 'border', 'imageSize', 'data',),
)

glCompressedTexImage2DARB = platform.createExtensionFunction( 
	'glCompressedTexImage2DARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLint, constants.GLsizei, ctypes.c_void_p,),
	doc = 'glCompressedTexImage2DARB( GLenum(target), GLint(level), GLenum(internalformat), GLsizei(width), GLsizei(height), GLint(border), GLsizei(imageSize), c_void_p(data) ) -> None',
	argNames = ('target', 'level', 'internalformat', 'width', 'height', 'border', 'imageSize', 'data',),
)

glCompressedTexImage1DARB = platform.createExtensionFunction( 
	'glCompressedTexImage1DARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLenum, constants.GLsizei, constants.GLint, constants.GLsizei, ctypes.c_void_p,),
	doc = 'glCompressedTexImage1DARB( GLenum(target), GLint(level), GLenum(internalformat), GLsizei(width), GLint(border), GLsizei(imageSize), c_void_p(data) ) -> None',
	argNames = ('target', 'level', 'internalformat', 'width', 'border', 'imageSize', 'data',),
)

glCompressedTexSubImage3DARB = platform.createExtensionFunction( 
	'glCompressedTexSubImage3DARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLint, constants.GLint, constants.GLint, constants.GLsizei, constants.GLsizei, constants.GLsizei, constants.GLenum, constants.GLsizei, ctypes.c_void_p,),
	doc = 'glCompressedTexSubImage3DARB( GLenum(target), GLint(level), GLint(xoffset), GLint(yoffset), GLint(zoffset), GLsizei(width), GLsizei(height), GLsizei(depth), GLenum(format), GLsizei(imageSize), c_void_p(data) ) -> None',
	argNames = ('target', 'level', 'xoffset', 'yoffset', 'zoffset', 'width', 'height', 'depth', 'format', 'imageSize', 'data',),
)

glCompressedTexSubImage2DARB = platform.createExtensionFunction( 
	'glCompressedTexSubImage2DARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLint, constants.GLint, constants.GLsizei, constants.GLsizei, constants.GLenum, constants.GLsizei, ctypes.c_void_p,),
	doc = 'glCompressedTexSubImage2DARB( GLenum(target), GLint(level), GLint(xoffset), GLint(yoffset), GLsizei(width), GLsizei(height), GLenum(format), GLsizei(imageSize), c_void_p(data) ) -> None',
	argNames = ('target', 'level', 'xoffset', 'yoffset', 'width', 'height', 'format', 'imageSize', 'data',),
)

glCompressedTexSubImage1DARB = platform.createExtensionFunction( 
	'glCompressedTexSubImage1DARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, constants.GLint, constants.GLsizei, constants.GLenum, constants.GLsizei, ctypes.c_void_p,),
	doc = 'glCompressedTexSubImage1DARB( GLenum(target), GLint(level), GLint(xoffset), GLsizei(width), GLenum(format), GLsizei(imageSize), c_void_p(data) ) -> None',
	argNames = ('target', 'level', 'xoffset', 'width', 'format', 'imageSize', 'data',),
)

glGetCompressedTexImageARB = platform.createExtensionFunction( 
	'glGetCompressedTexImageARB', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint, ctypes.c_void_p,),
	doc = 'glGetCompressedTexImageARB( GLenum(target), GLint(level), c_void_p(img) ) -> None',
	argNames = ('target', 'level', 'img',),
)


def glInitTextureCompressionARB():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
