<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Authentification, autorisation et contrle d'accs - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Recettes / Tutoriels</a></div><div id="page-content"><div id="preamble"><h1>Authentification, autorisation et contrle d'accs</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/howto/auth.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/auth.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/auth.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/auth.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/howto/auth.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Vrifiez la version
            anglaise pour les changements rcents.</div>

    <p>L'authentification est un processus qui vous permet de vrifier
    qu'une personne est bien celle qu'elle prtend tre. L'autorisation
    est un processus qui permet  une personne d'aller l o elle veut
    aller, ou d'obtenir les informations qu'elle dsire.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#related">Modules et directives concerns</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#theprerequisites">Les prrequis</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#gettingitworking">Mise en oeuvre</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#satisfy">Satisfy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#lettingmorethanonepersonin">Autorisation d'accs 
plusieurs personnes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#possibleproblems">Problmes possibles</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbmdbd">Autre mthode de stockage des mots de
passe</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#moreinformation">Pour aller plus loin . . .</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Modules et directives concerns</a></h2>

<p>Trois groupes de modules sont concerns par le processus
d'authentification et d'autorisation. Vous devrez utiliser au moins un
module de chaque groupe.</p>

<ul>
  <li>Type d'authentification (voir la directive <code class="directive"><a href="../mod/core.html#authtype">AuthType</a></code>)
    <ul>
      <li><code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code></li>
      <li><code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code></li>
    </ul>
  </li>
  <li>Fournisseur d'authentification
    <ul>
      <li><code class="module"><a href="../mod/mod_authn_alias.html">mod_authn_alias</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_anon.html">mod_authn_anon</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_default.html">mod_authn_default</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code></li>
      <li><code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code></li>
    </ul>
  </li>
  <li>Autorisation (voir la directive <code class="directive"><a href="../mod/core.html#require">Require</a></code>)
    <ul>
      <li><code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_default.html">mod_authz_default</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_owner.html">mod_authz_owner</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code></li>
    </ul>
  </li>
</ul>

    <p>Le module <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> est un fournisseur
  d'authentification et d'autorisation. Le module
  <code class="module"><a href="../mod/mod_authn_alias.html">mod_authn_alias</a></code> n'est pas un fournisseur
  d'authentification lui-mme, mais permet une configuration plus souple
  des autres fournisseurs d'authentification.</p>

  <p>Le module <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> fournit une autorisation
  et un contrle d'accs bass sur le nom du serveur,  l'adresse IP ou
  certaines caractristiques de la requte, mais ne fait pas partie du
  systme fournisseur d'authentification.</p>

  <p>Vous devriez aussi jeter un coup d'oeil au manuel de recettes <a href="access.html">Contrle d'accs</a>, qui dcrit les diffrentes
  mthodes de contrle d'accs  votre serveur.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
    <p>Si votre site web contient des informations sensibles ou
    destines seulement  un groupe de personnes restreint, les
    techniques exposes dans cet article vont vous aider  vous assurer
    que les personnes qui ont accs  ces pages sont bien celles
    auxquelles vous avez donn l'autorisation d'accs.</p>

    <p>Cet article dcrit les mthodes "standards" de protection de
    parties de votre site web que la plupart d'entre vous sont appels 
    utiliser.</p>

    <div class="note"><h3>Note :</h3>
    <p>Si vos donnes ont un rel besoin de scurisation, prvoyez
    l'utilisation de <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> en plus de toute mthode
    d'authentification.</p>
    </div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="theprerequisites" id="theprerequisites">Les prrequis</a></h2>
    <p>Les directives dcrites dans cet article devront tre insres
    soit au niveau de la configuration de votre serveur principal (en
    gnral dans une section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>), soit au niveau de la
    configuration des rpertoires (fichiers <code>.htaccess</code>)</p>

    <p>Si vous envisagez l'utilisation de fichiers
    <code>.htaccess</code>, la configuration de votre serveur devra
    permettre l'ajout de directives d'authentification dans ces
    fichiers. Pour ce faire, on utilise la directive <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>, qui spcifie quelles
    directives pourront ventuellement contenir les fichiers de
    configuration de niveau rpertoire.</p>

    <p>Comme il est ici question d'authentification, vous aurez besoin
    d'une directive <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>
    du style :</p>

    <div class="example"><p><code>
      AllowOverride AuthConfig
    </code></p></div>

    <p>Or, si vous avez l'intention d'ajouter les directives directement
    dans le fichier de configuration principal, vous devrez bien entendu
    possder les droits en criture sur ce fichier.</p>

    <p>Vous devrez aussi connatre un tant soit peu la structure des
    rpertoires de votre serveur, ne serait-ce que pour savoir o se
    trouvent certains fichiers. Cela ne devrait pas prsenter de grandes
    difficults, et j'essaierai de clarifier tout a lorsque le besoin
    s'en fera sentir.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="gettingitworking" id="gettingitworking">Mise en oeuvre</a></h2>
    <p>Nous dcrivons ici les bases de la protection par mot de passe
    d'un rpertoire de votre serveur.</p>

    <p>Vous devez en premier lieu crer un fichier de mots de passe. La
    mthode exacte selon laquelle vous allez crer ce fichier va varier
    en fonction du fournisseur d'authentification choisi. Mais nous
    entrerons dans les dtails plus loin, et pour le moment, nous nous
    contenterons d'un fichier de mots de passe en mode texte.</p>

    <p>Ce fichier doit tre enregistr  un endroit non accessible
    depuis le web, de faon  ce que les clients ne puissent pas le
    tlcharger. Par exemple, si vos documents sont servis  partir de
    <code>/usr/local/apache/htdocs</code>, vous pouvez enregistrer le
    fichier des mots de passe dans
    <code>/usr/local/apache/passwd</code>.</p>

    <p>L'utilitaire <code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code> fourni avec Apache
    permet de crer ce fichier. Vous le trouverez dans le rpertoire
    <code>bin</code> de votre installation d'Apache. Si vous avez
    install Apache  partir d'un paquetage tiers, il sera probablement
    dans le chemin par dfaut de vos excutables.</p>

    <p>Pour crer le fichier, tapez :</p>

    <div class="example"><p><code>
      htpasswd -c /usr/local/apache/passwd/passwords rbowen
    </code></p></div>

    <p><code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code> vous demandera d'entrer le mot de
    passe, et de le retaper pour confirmation :</p>

    <div class="example"><p><code>
      # htpasswd -c /usr/local/apache/passwd/passwords rbowen<br />
      New password: mot-de-passe<br />
      Re-type new password: mot-de-passe<br />
      Adding password for user rbowen
    </code></p></div>

    <p>Si <code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code> n'est pas dans le chemin par
    dfaut de vos excutables, vous devrez bien entendu entrer le chemin
    complet du fichier. Dans le cas d'une installation par dfaut, il se
    trouve  <code>/usr/local/apache2/bin/htpasswd</code>.</p>

    <p>Ensuite, vous allez devoir configurer le serveur de faon  ce
    qu'il demande un mot de passe et lui prciser quels utilisateurs disposent
    de droits d'accs. Pour ce faire, vous pouvez soit diter le
    fichier <code>httpd.conf</code>, soit utiliser un fichier
    <code>.htaccess</code>. Par exemple, si vous voulez protger le
    rpertoire <code>/usr/local/apache/htdocs/secret</code>, vous pouvez
    utiliser les directives suivantes, soit dans le fichier
    <code>/usr/local/apache/htdocs/secret/.htaccess</code>, soit dans le
    fichier <code>httpd.conf</code>  l'intrieur d'une section &lt;Directory
    /usr/local/apache/apache/htdocs/secret&gt; :</p>

    <div class="example"><p><code>
      AuthType Basic<br />
      AuthName "Fichiers rservs"<br />
      # (La ligne suivante est facultative)<br />
      AuthBasicProvider file<br />
      AuthUserFile /usr/local/apache/passwd/passwords<br />
      Require user rbowen
    </code></p></div>

    <p>Examinons ces directives une  une. La directive <code class="directive"><a href="../mod/core.html#authtype">AuthType</a></code> dfinit la mthode
    utilise pour authentifier l'utilisateur. La mthode la plus
    courante est <code>Basic</code>, et elle est implmente par
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>. Il faut cependant garder  l'esprit
    que l'authentification Basic transmet le mot de passe en clair depuis le
    client vers le serveur. Cette mthode ne devra donc pas
    tre utilise pour la transmission de donnes hautement sensibles si
    elle n'est pas associe au module <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>. Apache
    supporte une autre mthode d'authentification : <code>AuthType
    Digest</code>. Cette mthode est implmente par le module <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code> et est beaucoup plus scurise. La plupart
    des navigateurs rcents supportent l'authentification Digest.</p>

    <p>La directive <code class="directive"><a href="../mod/core.html#authname">AuthName</a></code> dfinit
    l'<dfn>Identificateur</dfn> (Realm)  utiliser avec
    l'authentification. L'identificateur possde deux fonctions. Tout
    d'abord, le client prsente en gnral cette information 
    l'utilisateur dans le cadre de la bote de dialogue de mot de passe.
    Ensuite, le client l'utilise pour dterminer quel mot de passe
    envoyer pour une zone authentifie donne.</p>

    <p>Ainsi par exemple, une fois un client authentifi dans la zone
    <code>"Fichiers rservs"</code>, il soumettra  nouveau
    automatiquement le mme mot de passe pour toute zone du mme serveur
    marque de l'identificateur <code>"Fichiers rservs"</code>. De
    cette faon, vous pouvez viter  un utilisateur d'avoir  saisir
    plusieurs fois le mme mot de passe en faisant partager le mme
    identificateur entre plusieurs zones rserves. Bien entendu et pour
    des raisons de scurit, le client devra redemander le mot
    de passe chaque fois que le nom d'hte du serveur sera modifi.</p>

    <p>La directive <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> est, dans ce
    cas, facultative, car <code>file</code> est la valeur par dfaut
    pour cette directive. Par contre, cette directive sera obligatoire
    si vous utilisez une autre source d'authentification comme
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> ou
    <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.</p>

    <p>La directive <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code> dfinit le chemin
    du fichier de mots de passe que nous venons de crer avec
    <code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code>. Si vous possdez un grand nombre
    d'utilisateurs, la dure de la recherche dans un fichier texte pour
    authentifier un utilisateur  chaque requte va augmenter
    rapidement, et pour pallier cet inconvnient, Apache peut aussi
    stocker les donnes relatives aux
    utilisateurs dans des bases de donnes rapides. Le module
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> fournit la directive <code class="directive"><a href="../mod/mod_authn_dbm.html#authdbmuserfile">AuthDBMUserFile</a></code>. Le programme <code class="program"><a href="../programs/dbmmanage.html">dbmmanage</a></code> permet de crer et manipuler ces fichiers. Vous
    trouverez de nombreuses options d'autres types d'authentification
    fournies par des modules tiers dans la <a href="http://modules.apache.org/">Base de donnes des modules
    d'Apache</a>.</p>

    <p>Enfin, la directive <code class="directive"><a href="../mod/core.html#require">Require</a></code>
    implmente la partie
    autorisation du processus en dfinissant l'utilisateur autoris 
    accder  cette zone du serveur. Dans la section suivante, nous
    dcrirons les diffrentes mthodes d'utilisation de la directive
    <code class="directive"><a href="../mod/core.html#require">Require</a></code> directive.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="satisfy" id="satisfy">Satisfy</a></h2>

<p>La directive <code class="directive"><a href="../mod/core.html#satisfy">Satisfy</a></code> permet de
spcifier que plusieurs critres peuvent tre considrs pour dcider si
l'on peut accorder l'accs  un utilisateur particulier. Satisfy accepte
comme argument une des deux options - <code>all</code> ou
<code>any</code>. La valeur par dfaut est <code>all</code>, ce qui
signifie que dans le cas o plusieurs critres sont spcifis,
l'ensemble de ces derniers doit tre satisfait pour que l'accs soit
accord. Par contre, si la valeur est <code>any</code>, si plusieurs
critres sont spcifis et si l'utilisateur satisfait  au moins un
d'entre eux, l'accs lui sera accord.</p>

<p>Un exemple d'utilisation de cette directive est un contrle d'accs
afin de s'assurer que, bien qu'une ressource soit protge par mot de
passe depuis l'extrieur de votre rseau, tous les htes de votre rseau
pourront y accder sans authentification. Voici comment y parvenir en
utilisant la directive Satisfy :</p>

<div class="example"><p><code>
&lt;Directory /usr/local/apache/htdocs/sekrit&gt;<br />
  AuthType Basic<br />
  AuthName intranet<br />
  AuthUserFile /www/passwd/users<br />
  AuthGroupFile /www/passwd/groups<br />
  Require group customers<br />
  Order allow,deny<br />
  Allow from internal.com<br />
  Satisfy any<br />
&lt;/Directory&gt;
</code></p></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="lettingmorethanonepersonin" id="lettingmorethanonepersonin">Autorisation d'accs 
plusieurs personnes</a></h2>
    <p>Les directives ci-dessus n'autorisent qu'une personne (quelqu'un
    possdant le nom d'utilisateur <code>rbowen</code>)  accder au
    rpertoire. Dans la plupart des cas, vous devrez autoriser
    l'accs  plusieurs personnes. C'est ici
    qu'intervient la directive <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code>.</p>

    <p>Si vous voulez autoriser l'accs  plusieurs personnes, vous
    devez crer un fichier de groupes qui associe des noms de groupes
    avec une liste d'utilisateurs de ce groupe. Le format de ce fichier
    est trs simple, et vous pouvez le crer avec votre diteur de texte favori.
    Son contenu se prsente comme suit :</p>

   <div class="example"><p><code>
     Nom-de-groupe: rbowen dpitts sungo rshersey
   </code></p></div>

    <p>Il s'agit simplement d'une liste des membres du groupe sous la
    forme d'une ligne spare par des espaces.</p>

    <p>Pour ajouter un utilisateur  votre fichier de mots de passe
    prexistant, entrez :</p>

    <div class="example"><p><code>
      htpasswd /usr/local/apache/passwd/passwords dpitts
    </code></p></div>

    <p>Vous obtiendrez le mme effet qu'auparavant, mais le mot de passe
    sera ajout au fichier, plutt que d'en crer un nouveau (C'est le
    drapeau <code>-c</code> qui permet de crer un nouveau fichier de
    mots de passe)..</p>

    <p>Maintenant, vous devez modifier votre fichier
    <code>.htaccess</code> comme suit :</p>

    <div class="example"><p><code>
      AuthType Basic<br />
      AuthName "By Invitation Only"<br />
      # Ligne facultative :<br />
      AuthBasicProvider file<br />
      AuthUserFile /usr/local/apache/passwd/passwords<br />
      AuthGroupFile /usr/local/apache/passwd/groups<br />
      Require group Nom-de-groupe
    </code></p></div>

    <p>Maintenant, quiconque appartient au groupe
    <code>Nom-de-groupe</code>, et possde une entre dans le fichier
    <code>password</code> pourra accder au rpertoire s'il tape le bon
    mot de passe.</p>

    <p>Il existe une autre mthode moins contraignante pour autoriser
    l'accs  plusieurs personnes. Plutt que de crer un fichier de
    groupes, il vous suffit d'ajouter la directive suivante :</p>

    <div class="example"><p><code>
      Require valid-user
    </code></p></div>

    <p>Le remplacement de la ligne <code>Require user rbowen</code> par
    la ligne <code>Require valid-user</code> autorisera l'accs 
    quiconque possdant une entre dans le fichier password, et ayant
    tap le bon mot de passe. Vous pouvez mme simuler le comportement
    des groupes en associant un fichier de mots de passe diffrent pour
    chaque groupe. L'avantage de cette approche rside dans le fait
    qu'Apache ne doit consulter qu'un fichier au lieu de deux. Par
    contre, vous devez maintenir un nombre plus ou moins important de
    fichiers de mots de passe, et vous assurer de faire rfrence au bon
    fichier dans la directive <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="possibleproblems" id="possibleproblems">Problmes possibles</a></h2>
    <p>L'authentification Basic est spcifie d'une telle manire que
    vos nom d'utilisateur et mot de passe doivent tre vrifis chaque
    fois que vous demandez un document au serveur, et ceci mme si vous
    rechargez la mme page, et pour chaque image contenue dans la page
    (si elles sont situes dans un rpertoire protg). Comme vous
    pouvez l'imaginer, ceci ralentit un peu le fonctionnement. La mesure
    dans laquelle le fonctionnement est ralenti est proportionnelle  la
    taille du fichier des mots de passe, car ce dernier doit tre ouvert
    et la liste des utilisateurs parcourue jusqu' ce que votre nom soit
    trouv, et ceci chaque fois qu'une page est charge.</p>

    <p>En consquence, ce ralentissement impose une limite pratique au
    nombre d'utilisateurs que vous pouvez enregistrer dans un fichier de
    mots de passe. Cette limite va varier en fonction des performances
    de votre serveur, mais vous commencerez  remarquer un
    ralentissement lorsque vous atteindrez quelques centaines
    d'utilisateurs, et serez alors appel  utiliser une mthode
    d'authentification diffrente.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dbmdbd" id="dbmdbd">Autre mthode de stockage des mots de
passe</a></h2>

    <p>Suite au problme voqu prcdemment et induit par le stockage
    des mots de passe dans un fichier texte, vous pouvez tre appel 
    stocker vos mots de passe d'une autre manire, par exemple dans une
    base de donnes.</p>

    <p>Pour y parvenir, on peut utiliser les modules
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> ou <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.
    Vous pouvez choisir comme format de stockage <code>dbm</code> ou
    <code>dbd</code>  la place de <code>file</code> pour la directive
    <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>.</p>

    <p>Par exemple, pour slectionner un fichier dbm  la place d'un
    fichier texte :</p>

    <div class="example"><p><code>
    &lt;Directory /www/docs/private&gt;<br />
    AuthName "Private"<br />
    AuthType Basic<br />
    AuthBasicProvider dbm<br />
    AuthDBMUserFile /www/passwords/passwd.dbm<br />
    Require valid-user<br />
    &lt;/Directory&gt;
    </code></p></div>

    <p>D'autres options sont disponibles. Consultez la documentation de
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> pour plus de dtails.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="moreinformation" id="moreinformation">Pour aller plus loin . . .</a></h2>
    <p>Vous pouvez aussi lire la documentation de
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> et <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>
    qui contient des informations supplmentaires  propos du
    fonctionnement de tout ceci.
    Certaines configurations d'authentification peuvent aussi tre
    simplifies  l'aide du module <code class="module"><a href="../mod/mod_authn_alias.html">mod_authn_alias</a></code>.</p>

    <p>Les diffrents algorithmes de chiffrement supports par Apache
    pour authentifier les donnes sont expliqus dans <a href="../misc/password_encryptions.html">PasswordEncryptions</a>.</p>

    <p>Enfin vous pouvez consulter la recette <a href="access.html">Access
    Control</a>, qui dcrit un certain nombre de situations en relation
    avec le sujet.</p>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/howto/auth.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/auth.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/auth.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/auth.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/howto/auth.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.2/howto/auth.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>