require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M88K_CMMU_H_)) {
    eval 'sub _M88K_CMMU_H_ () {1;}' unless defined(&_M88K_CMMU_H_);
    if(defined(&_KERNEL)  && !defined(&_LOCORE)) {
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CMMU_LOCK () { &__cpu_simple_lock( &cmmu_cpu_lock);}' unless defined(&CMMU_LOCK);
	    eval 'sub CMMU_UNLOCK () { &__cpu_simple_unlock( &cmmu_cpu_lock);}' unless defined(&CMMU_UNLOCK);
	} else {
	    eval 'sub CMMU_LOCK () { &do { }  &while (0);}' unless defined(&CMMU_LOCK);
	    eval 'sub CMMU_UNLOCK () { &do { }  &while (0);}' unless defined(&CMMU_UNLOCK);
	}
	eval 'sub cmmu_init () {( ($cmmu->{init}));}' unless defined(&cmmu_init);
	eval 'sub setup_board_config () {( ($cmmu->{setup_board_config}));}' unless defined(&setup_board_config);
	eval 'sub cpu_configuration_print {
	    my($cpu) = @_;
    	    eval q(( ($cmmu->{cpu_configuration_print}))($cpu));
	}' unless defined(&cpu_configuration_print);
	eval 'sub cmmu_shutdown () {( ($cmmu->{shutdown}));}' unless defined(&cmmu_shutdown);
	eval 'sub cmmu_cpu_number () {( ($cmmu->{cpu_number}));}' unless defined(&cmmu_cpu_number);
	eval 'sub cmmu_kapr_cmode () {( ($cmmu->{kapr_cmode}));}' unless defined(&cmmu_kapr_cmode);
	eval 'sub cmmu_set_sapr {
	    my($apr) = @_;
    	    eval q(( ($cmmu->{set_sapr}))($apr));
	}' unless defined(&cmmu_set_sapr);
	eval 'sub cmmu_set_uapr {
	    my($apr) = @_;
    	    eval q(( ($cmmu->{set_uapr}))($apr));
	}' unless defined(&cmmu_set_uapr);
	eval 'sub cmmu_tlbis {
	    my($cpu, $va, $pte) = @_;
    	    eval q(( ($cmmu->{tlb_inv_s}))($cpu, $va, $pte));
	}' unless defined(&cmmu_tlbis);
	eval 'sub cmmu_tlbiu {
	    my($cpu, $va, $pte) = @_;
    	    eval q(( ($cmmu->{tlb_inv_u}))($cpu, $va, $pte));
	}' unless defined(&cmmu_tlbiu);
	eval 'sub cmmu_tlbia {
	    my($cpu) = @_;
    	    eval q(( ($cmmu->{tlb_inv_all}))($cpu));
	}' unless defined(&cmmu_tlbia);
	eval 'sub cmmu_cache_wbinv {
	    my($cpu, $pa, $s) = @_;
    	    eval q(( ($cmmu->{cache_wbinv}))($cpu, $pa, $s));
	}' unless defined(&cmmu_cache_wbinv);
	eval 'sub cmmu_dcache_wb {
	    my($cpu, $pa, $s) = @_;
    	    eval q(( ($cmmu->{dcache_wb}))($cpu, $pa, $s));
	}' unless defined(&cmmu_dcache_wb);
	eval 'sub cmmu_icache_inv {
	    my($cpu,$pa,$s) = @_;
    	    eval q(( ($cmmu->{icache_inv}))($cpu, $pa, $s));
	}' unless defined(&cmmu_icache_inv);
	eval 'sub dma_cachectl {
	    my($pa, $s, $op) = @_;
    	    eval q(( ($cmmu->{dma_cachectl}))($pa, $s, $op));
	}' unless defined(&dma_cachectl);
	eval 'sub dma_cachectl_local {
	    my($pa, $s, $op) = @_;
    	    eval q(( ($cmmu->{dma_cachectl_local}))($pa, $s, $op));
	}' unless defined(&dma_cachectl_local);
	eval 'sub cmmu_initialize_cpu {
	    my($cpu) = @_;
    	    eval q(( ($cmmu->{initialize_cpu}))($cpu));
	}' unless defined(&cmmu_initialize_cpu);
	eval 'sub DMA_CACHE_INV () {0x;}' unless defined(&DMA_CACHE_INV);
	eval 'sub DMA_CACHE_SYNC_INVAL () {0x1;}' unless defined(&DMA_CACHE_SYNC_INVAL);
	eval 'sub DMA_CACHE_SYNC () {0x2;}' unless defined(&DMA_CACHE_SYNC);
    }
}
1;
