require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS64_CPUREGS_H_)) {
    eval 'sub _MIPS64_CPUREGS_H_ () {1;}' unless defined(&_MIPS64_CPUREGS_H_);
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	eval 'sub SR_COP_USABILITY () {0x30000000;}' unless defined(&SR_COP_USABILITY);
	eval 'sub SR_COP_0_BIT () {0x10000000;}' unless defined(&SR_COP_0_BIT);
	eval 'sub SR_COP_1_BIT () {0x20000000;}' unless defined(&SR_COP_1_BIT);
	eval 'sub SR_RP () {0x8000000;}' unless defined(&SR_RP);
	eval 'sub SR_FR_32 () {0x4000000;}' unless defined(&SR_FR_32);
	eval 'sub SR_RE () {0x2000000;}' unless defined(&SR_RE);
	eval 'sub SR_DSD () {0x1000000;}' unless defined(&SR_DSD);
	eval 'sub SR_BOOT_EXC_VEC () {0x400000;}' unless defined(&SR_BOOT_EXC_VEC);
	eval 'sub SR_TLB_SHUTDOWN () {0x200000;}' unless defined(&SR_TLB_SHUTDOWN);
	eval 'sub SR_SOFT_RESET () {0x100000;}' unless defined(&SR_SOFT_RESET);
	eval 'sub SR_DIAG_CH () {0x40000;}' unless defined(&SR_DIAG_CH);
	eval 'sub SR_DIAG_CE () {0x20000;}' unless defined(&SR_DIAG_CE);
	eval 'sub SR_DIAG_DE () {0x10000;}' unless defined(&SR_DIAG_DE);
	eval 'sub SR_KX () {0x80;}' unless defined(&SR_KX);
	eval 'sub SR_SX () {0x40;}' unless defined(&SR_SX);
	eval 'sub SR_UX () {0x20;}' unless defined(&SR_UX);
	eval 'sub SR_ERL () {0x4;}' unless defined(&SR_ERL);
	eval 'sub SR_EXL () {0x2;}' unless defined(&SR_EXL);
	eval 'sub SR_INT_ENAB () {0x1;}' unless defined(&SR_INT_ENAB);
	eval 'sub SOFT_INT_MASK_0 () {0x100;}' unless defined(&SOFT_INT_MASK_0);
	eval 'sub SOFT_INT_MASK_1 () {0x200;}' unless defined(&SOFT_INT_MASK_1);
	eval 'sub SR_INT_MASK_0 () {0x400;}' unless defined(&SR_INT_MASK_0);
	eval 'sub SR_INT_MASK_1 () {0x800;}' unless defined(&SR_INT_MASK_1);
	eval 'sub SR_INT_MASK_2 () {0x1000;}' unless defined(&SR_INT_MASK_2);
	eval 'sub SR_INT_MASK_3 () {0x2000;}' unless defined(&SR_INT_MASK_3);
	eval 'sub SR_INT_MASK_4 () {0x4000;}' unless defined(&SR_INT_MASK_4);
	eval 'sub SR_INT_MASK_5 () {0x8000;}' unless defined(&SR_INT_MASK_5);
	eval 'sub SR_SERIALIZE_FPU () {0x10000000000;}' unless defined(&SR_SERIALIZE_FPU);
	eval 'sub SR_KPGSZ_SHIFT () {36;}' unless defined(&SR_KPGSZ_SHIFT);
	eval 'sub SR_UPGSZ_SHIFT () {32;}' unless defined(&SR_UPGSZ_SHIFT);
	eval 'sub SR_PGSZ_4K () {0;}' unless defined(&SR_PGSZ_4K);
	eval 'sub SR_PGSZ_8K () {1;}' unless defined(&SR_PGSZ_8K);
	eval 'sub SR_PGSZ_16K () {2;}' unless defined(&SR_PGSZ_16K);
	eval 'sub SR_PGSZ_64K () {3;}' unless defined(&SR_PGSZ_64K);
	eval 'sub SR_PGSZ_1M () {4;}' unless defined(&SR_PGSZ_1M);
	eval 'sub SR_PGSZ_4M () {5;}' unless defined(&SR_PGSZ_4M);
	eval 'sub SR_PGSZ_16M () {6;}' unless defined(&SR_PGSZ_16M);
	eval 'sub SR_PGSZ_MASK () {0xf;}' unless defined(&SR_PGSZ_MASK);
	eval 'sub SR_INT_MASK_6 () {0x10000;}' unless defined(&SR_INT_MASK_6);
	eval 'sub SR_INT_MASK_7 () {0x20000;}' unless defined(&SR_INT_MASK_7);
	eval 'sub SR_INT_MASK_8 () {0x40000;}' unless defined(&SR_INT_MASK_8);
	if(defined(&CPU_R8000)) {
	    eval 'sub SR_XX () {0x40;}' unless defined(&SR_XX);
	    eval 'sub SR_KSU_MASK () {0x10;}' unless defined(&SR_KSU_MASK);
	    eval 'sub SR_KSU_KERNEL () {0x;}' unless defined(&SR_KSU_KERNEL);
	    eval 'sub SR_INT_MASK () {0x7ff00;}' unless defined(&SR_INT_MASK);
	} else {
	    eval 'sub SR_XX () {0x80000000;}' unless defined(&SR_XX);
	    eval 'sub SR_KSU_MASK () {0x18;}' unless defined(&SR_KSU_MASK);
	    eval 'sub SR_KSU_SUPER () {0x8;}' unless defined(&SR_KSU_SUPER);
	    eval 'sub SR_KSU_KERNEL () {0x;}' unless defined(&SR_KSU_KERNEL);
	    eval 'sub SR_INT_MASK () {0xff00;}' unless defined(&SR_INT_MASK);
	}
	unless(defined(&SR_KSU_USER)) {
	    eval 'sub SR_KSU_USER () {0x10;}' unless defined(&SR_KSU_USER);
	}
	eval 'sub IC_INT_MASK () {0x3f00;}' unless defined(&IC_INT_MASK);
	eval 'sub IC_INT_MASK_6 () {0x100;}' unless defined(&IC_INT_MASK_6);
	eval 'sub IC_INT_MASK_7 () {0x200;}' unless defined(&IC_INT_MASK_7);
	eval 'sub IC_INT_MASK_8 () {0x400;}' unless defined(&IC_INT_MASK_8);
	eval 'sub IC_INT_MASK_9 () {0x800;}' unless defined(&IC_INT_MASK_9);
	eval 'sub IC_INT_TIMR () {0x1000;}' unless defined(&IC_INT_TIMR);
	eval 'sub IC_INT_PERF () {0x2000;}' unless defined(&IC_INT_PERF);
	eval 'sub IC_INT_TE () {0x80;}' unless defined(&IC_INT_TE);
	eval 'sub SOFT_INT_MASK () {( &SOFT_INT_MASK_0 |  &SOFT_INT_MASK_1);}' unless defined(&SOFT_INT_MASK);
	if(defined(&CPU_R8000)) {
	    eval 'sub CR_BR_DELAY () {0x8000000000000000;}' unless defined(&CR_BR_DELAY);
	    eval 'sub CR_EXC_CODE () {0xf8;}' unless defined(&CR_EXC_CODE);
	    eval 'sub CR_EXC_CODE_SHIFT () {3;}' unless defined(&CR_EXC_CODE_SHIFT);
	    eval 'sub CR_COP_ERR () {0x10000000;}' unless defined(&CR_COP_ERR);
	} else {
	    eval 'sub CR_BR_DELAY () {0x80000000;}' unless defined(&CR_BR_DELAY);
	    eval 'sub CR_EXC_CODE () {0x7c;}' unless defined(&CR_EXC_CODE);
	    eval 'sub CR_EXC_CODE_SHIFT () {2;}' unless defined(&CR_EXC_CODE_SHIFT);
	    eval 'sub CR_COP_ERR () {0x30000000;}' unless defined(&CR_COP_ERR);
	}
	eval 'sub CR_COP1_ERR () {0x10000000;}' unless defined(&CR_COP1_ERR);
	eval 'sub CR_COP2_ERR () {0x20000000;}' unless defined(&CR_COP2_ERR);
	eval 'sub CR_COP3_ERR () {0x20000000;}' unless defined(&CR_COP3_ERR);
	eval 'sub CR_INT_SOFT0 () {0x100;}' unless defined(&CR_INT_SOFT0);
	eval 'sub CR_INT_SOFT1 () {0x200;}' unless defined(&CR_INT_SOFT1);
	eval 'sub CR_INT_0 () {0x400;}' unless defined(&CR_INT_0);
	eval 'sub CR_INT_1 () {0x800;}' unless defined(&CR_INT_1);
	eval 'sub CR_INT_2 () {0x1000;}' unless defined(&CR_INT_2);
	eval 'sub CR_INT_3 () {0x2000;}' unless defined(&CR_INT_3);
	eval 'sub CR_INT_4 () {0x4000;}' unless defined(&CR_INT_4);
	eval 'sub CR_INT_5 () {0x8000;}' unless defined(&CR_INT_5);
	eval 'sub CR_INT_6 () {0x10000;}' unless defined(&CR_INT_6);
	eval 'sub CR_INT_7 () {0x20000;}' unless defined(&CR_INT_7);
	eval 'sub CR_INT_8 () {0x40000;}' unless defined(&CR_INT_8);
	eval 'sub CR_INT_9 () {0x80000;}' unless defined(&CR_INT_9);
	eval 'sub CR_INT_HARD () {0xffc00;}' unless defined(&CR_INT_HARD);
	eval 'sub CR_INT_TIMR () {0x100000;}' unless defined(&CR_INT_TIMR);
	eval 'sub CR_INT_PERF () {0x200000;}' unless defined(&CR_INT_PERF);
	eval 'sub CR_FPE () {0x1000000;}' unless defined(&CR_FPE);
	eval 'sub CR_VCE () {0x2000000;}' unless defined(&CR_VCE);
	eval 'sub CR_BERR () {0x4000000;}' unless defined(&CR_BERR);
	eval 'sub CR_NMI () {0x8000000;}' unless defined(&CR_NMI);
	if(defined(&CPU_R8000)) {
	    eval 'sub CR_INT_MASK () {0x407ff00;}' unless defined(&CR_INT_MASK);
	} else {
	    eval 'sub CR_INT_MASK () {0x3fff00;}' unless defined(&CR_INT_MASK);
	}
	eval 'sub CFGR_CCA_MASK () {0x7;}' unless defined(&CFGR_CCA_MASK);
	eval 'sub CFGR_CU () {0x8;}' unless defined(&CFGR_CU);
	eval 'sub CFGR_ICE () {0x200000000;}' unless defined(&CFGR_ICE);
	eval 'sub CFGR_SMM () {0x400000000;}' unless defined(&CFGR_SMM);
	if(defined(&CPU_R8000)) {
	    eval 'sub RESET_EXC_VEC () { &PHYS_TO_XKPHYS(0x1fc00000,  &CCA_NC);}' unless defined(&RESET_EXC_VEC);
	} else {
	    eval 'sub RESET_EXC_VEC () {( &CKSEG1_BASE + 0x1fc00000);}' unless defined(&RESET_EXC_VEC);
	    eval 'sub TLB_MISS_EXC_VEC () {( &CKSEG1_BASE + 0x);}' unless defined(&TLB_MISS_EXC_VEC);
	    eval 'sub XTLB_MISS_EXC_VEC () {( &CKSEG1_BASE + 0x80);}' unless defined(&XTLB_MISS_EXC_VEC);
	    eval 'sub CACHE_ERR_EXC_VEC () {( &CKSEG1_BASE + 0x100);}' unless defined(&CACHE_ERR_EXC_VEC);
	    eval 'sub GEN_EXC_VEC () {( &CKSEG1_BASE + 0x180);}' unless defined(&GEN_EXC_VEC);
	}
	eval 'sub COP_0_COUNT () {$9;}' unless defined(&COP_0_COUNT);
	eval 'sub COP_0_TLB_HI () {$10;}' unless defined(&COP_0_TLB_HI);
	eval 'sub COP_0_STATUS_REG () {$12;}' unless defined(&COP_0_STATUS_REG);
	eval 'sub COP_0_CAUSE_REG () {$13;}' unless defined(&COP_0_CAUSE_REG);
	eval 'sub COP_0_EXC_PC () {$14;}' unless defined(&COP_0_EXC_PC);
	eval 'sub COP_0_PRID () {$15;}' unless defined(&COP_0_PRID);
	eval 'sub COP_0_CONFIG () {$16;}' unless defined(&COP_0_CONFIG);
	eval 'sub COP_0_TLB_INDEX () {$0;}' unless defined(&COP_0_TLB_INDEX);
	eval 'sub COP_0_TLB_RANDOM () {$1;}' unless defined(&COP_0_TLB_RANDOM);
	eval 'sub COP_0_TLB_LO0 () {$2;}' unless defined(&COP_0_TLB_LO0);
	eval 'sub COP_0_TLB_LO1 () {$3;}' unless defined(&COP_0_TLB_LO1);
	eval 'sub COP_0_TLB_CONTEXT () {$4;}' unless defined(&COP_0_TLB_CONTEXT);
	eval 'sub COP_0_TLB_PG_MASK () {$5;}' unless defined(&COP_0_TLB_PG_MASK);
	eval 'sub COP_0_TLB_WIRED () {$6;}' unless defined(&COP_0_TLB_WIRED);
	eval 'sub COP_0_BAD_VADDR () {$8;}' unless defined(&COP_0_BAD_VADDR);
	eval 'sub COP_0_COMPARE () {$11;}' unless defined(&COP_0_COMPARE);
	eval 'sub COP_0_LLADDR () {$17;}' unless defined(&COP_0_LLADDR);
	eval 'sub COP_0_WATCH_LO () {$18;}' unless defined(&COP_0_WATCH_LO);
	eval 'sub COP_0_WATCH_HI () {$19;}' unless defined(&COP_0_WATCH_HI);
	eval 'sub COP_0_TLB_XCONTEXT () {$20;}' unless defined(&COP_0_TLB_XCONTEXT);
	eval 'sub COP_0_ECC () {$26;}' unless defined(&COP_0_ECC);
	eval 'sub COP_0_CACHE_ERR () {$27;}' unless defined(&COP_0_CACHE_ERR);
	eval 'sub COP_0_TAG_LO () {$28;}' unless defined(&COP_0_TAG_LO);
	eval 'sub COP_0_TAG_HI () {$29;}' unless defined(&COP_0_TAG_HI);
	eval 'sub COP_0_ERROR_PC () {$30;}' unless defined(&COP_0_ERROR_PC);
	eval 'sub COP_0_TLB_SET () {$0;}' unless defined(&COP_0_TLB_SET);
	eval 'sub COP_0_TLB_LO () {$2;}' unless defined(&COP_0_TLB_LO);
	eval 'sub COP_0_UBASE () {$4;}' unless defined(&COP_0_UBASE);
	eval 'sub COP_0_SHIFTAMT () {$5;}' unless defined(&COP_0_SHIFTAMT);
	eval 'sub COP_0_TRAPBASE () {$6;}' unless defined(&COP_0_TRAPBASE);
	eval 'sub COP_0_BAD_PADDR () {$7;}' unless defined(&COP_0_BAD_PADDR);
	eval 'sub COP_0_VADDR () {$8;}' unless defined(&COP_0_VADDR);
	eval 'sub COP_0_WORK0 () {$18;}' unless defined(&COP_0_WORK0);
	eval 'sub COP_0_WORK1 () {$19;}' unless defined(&COP_0_WORK1);
	eval 'sub COP_0_PBASE () {$20;}' unless defined(&COP_0_PBASE);
	eval 'sub COP_0_GBASE () {$21;}' unless defined(&COP_0_GBASE);
	eval 'sub COP_0_TFP_TLB_WIRED () {$24;}' unless defined(&COP_0_TFP_TLB_WIRED);
	eval 'sub COP_0_DCACHE () {$28;}' unless defined(&COP_0_DCACHE);
	eval 'sub COP_0_ICACHE () {$29;}' unless defined(&COP_0_ICACHE);
	eval 'sub COP_0_WATCH_1 () {$18;}' unless defined(&COP_0_WATCH_1);
	eval 'sub COP_0_WATCH_2 () {$19;}' unless defined(&COP_0_WATCH_2);
	eval 'sub COP_0_WATCH_M () {$24;}' unless defined(&COP_0_WATCH_M);
	eval 'sub COP_0_PC_COUNT () {$25;}' unless defined(&COP_0_PC_COUNT);
	eval 'sub COP_0_PC_CTRL () {$22;}' unless defined(&COP_0_PC_CTRL);
	eval 'sub COP_0_ICR () {$20;}' unless defined(&COP_0_ICR);
	eval 'sub COP_0_TLB_FR_MASK () {$21;}' unless defined(&COP_0_TLB_FR_MASK);
	eval 'sub COP_0_DIAG () {$22;}' unless defined(&COP_0_DIAG);
	eval 'sub COP_0_TLB_PG_GRAIN () {$5, 1;}' unless defined(&COP_0_TLB_PG_GRAIN);
	eval 'sub COP_0_CVMCTL () {$9, 7;}' unless defined(&COP_0_CVMCTL);
	eval 'sub COP_0_CVMMEMCTL () {$11, 7;}' unless defined(&COP_0_CVMMEMCTL);
	eval 'sub COP_0_EBASE () {$15, 1;}' unless defined(&COP_0_EBASE);
	if(defined(&CPU_OCTEON) || defined(&CPU_R8000)) {
	    eval 'sub CP0_CYCLE_DIVIDER () {1;}' unless defined(&CP0_CYCLE_DIVIDER);
	} else {
	    eval 'sub CP0_CYCLE_DIVIDER () {2;}' unless defined(&CP0_CYCLE_DIVIDER);
	}
	eval 'sub FPC_ID () {$0;}' unless defined(&FPC_ID);
	eval 'sub FPC_CSR () {$31;}' unless defined(&FPC_CSR);
    }
}
1;
