require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&PAGE_SHIFT_4M)) {
    sub PAGE_SHIFT_4M () {	22;}
}
unless(defined(&PAGE_MASK_4M)) {
    sub PAGE_MASK_4M () {	( &NBPD - 1);}
}
unless(defined(&PMAP_PA_MASK_4M)) {
    sub PMAP_PA_MASK_4M () {	~(( &paddr_t) &PAGE_MASK_4M);}
}
unless(defined(&PIGLET_PAGE_MASK)) {
    sub PIGLET_PAGE_MASK () {	~(( &paddr_t) &PAGE_MASK_4M);}
}
unless(defined(&HIBERNATE_PD_PAGE)) {
    sub HIBERNATE_PD_PAGE () {	( &PAGE_SIZE * 5);}
}
unless(defined(&HIBERNATE_PT_PAGE)) {
    sub HIBERNATE_PT_PAGE () {	( &PAGE_SIZE * 6);}
}
unless(defined(&HIBERNATE_STACK_PAGE)) {
    sub HIBERNATE_STACK_PAGE () {	( &PAGE_SIZE * 8);}
}
unless(defined(&HIBERNATE_INFLATE_PAGE)) {
    sub HIBERNATE_INFLATE_PAGE () {	( &PAGE_SIZE * 9);}
}
unless(defined(&HIBERNATE_COPY_PAGE)) {
    sub HIBERNATE_COPY_PAGE () {	( &PAGE_SIZE * 10);}
}
unless(defined(&HIBERNATE_HIBALLOC_PAGE)) {
    sub HIBERNATE_HIBALLOC_PAGE () {	( &PAGE_SIZE * 11);}
}
unless(defined(&HIBERNATE_CHUNK_SIZE)) {
    sub HIBERNATE_CHUNK_SIZE () {	0x400000;}
}
unless(defined(&HIBERNATE_CHUNK_TABLE_SIZE)) {
    sub HIBERNATE_CHUNK_TABLE_SIZE () {	0x100000;}
}
unless(defined(&HIBERNATE_STACK_OFFSET)) {
    sub HIBERNATE_STACK_OFFSET () {	0xf00;}
}
unless(defined(&atop_4m)) {
    sub atop_4m {
	my($x) = @_;
	eval q((($x) >>  &PAGE_SHIFT_4M));
    }
}
unless(defined(&atop_4k)) {
    sub atop_4k {
	my($x) = @_;
	eval q((($x) >>  &PAGE_SHIFT));
    }
}
unless(defined(&s4pde_4m)) {
    sub s4pde_4m {
	my($va) = @_;
	eval q((( &pt_entry_t *) &HIBERNATE_PD_PAGE +  &atop_4m($va)));
    }
}
unless(defined(&s4pde_4k)) {
    sub s4pde_4k {
	my($va) = @_;
	eval q((( &pt_entry_t *) &HIBERNATE_PD_PAGE +  &atop_4k($va)));
    }
}
unless(defined(&s4pte_4k)) {
    sub s4pte_4k {
	my($va) = @_;
	eval q((( &pt_entry_t *) &HIBERNATE_PT_PAGE +  &atop_4k($va)));
    }
}
1;
