require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&UDL_CMD_MAX_XFER_SIZE)) {
    sub UDL_CMD_MAX_XFER_SIZE () {	1048576;}
}
unless(defined(&UDL_CMD_MAX_DATA_SIZE)) {
    sub UDL_CMD_MAX_DATA_SIZE () {	512;}
}
unless(defined(&UDL_CMD_MAX_PIXEL_COUNT)) {
    sub UDL_CMD_MAX_PIXEL_COUNT () {	( &UDL_CMD_MAX_DATA_SIZE / 2);}
}
unless(defined(&UDL_CMD_WRITE_HEAD_SIZE)) {
    sub UDL_CMD_WRITE_HEAD_SIZE () {	6;}
}
unless(defined(&UDL_CMD_COPY_HEAD_SIZE)) {
    sub UDL_CMD_COPY_HEAD_SIZE () {	9;}
}
unless(defined(&UDL_CMD_WRITE_MAX_SIZE)) {
    sub UDL_CMD_WRITE_MAX_SIZE () {	( &UDL_CMD_WRITE_HEAD_SIZE +  &UDL_CMD_MAX_DATA_SIZE + 2);}
}
unless(defined(&UDL_CMD_COPY_MAX_SIZE)) {
    sub UDL_CMD_COPY_MAX_SIZE () {	( &UDL_CMD_COPY_HEAD_SIZE + 2);}
}
unless(defined(&UDL_CMD_XFER_SYNC)) {
    sub UDL_CMD_XFER_SYNC () {	0;}
}
unless(defined(&UDL_CMD_XFER_ASYNC)) {
    sub UDL_CMD_XFER_ASYNC () {	1;}
}
unless(defined(&UDL_CMD_XFER_COUNT)) {
    sub UDL_CMD_XFER_COUNT () {	8;}
}
unless(defined(&DLALL)) {
    sub DLALL () {	0x;}
}
unless(defined(&DL125)) {
    sub DL125 () {	0x;}
}
unless(defined(&DL120)) {
    sub DL120 () {	0x1;}
}
unless(defined(&DL160)) {
    sub DL160 () {	0x2;}
}
unless(defined(&DL165)) {
    sub DL165 () {	0x3;}
}
unless(defined(&DL195)) {
    sub DL195 () {	0x4;}
}
unless(defined(&DLMAX)) {
    sub DLMAX () {	0x4;}
}
unless(defined(&DLUNK)) {
    sub DLUNK () {	0xff;}
}
unless(defined(&UDL_CTRL_CMD_READ_EDID)) {
    sub UDL_CTRL_CMD_READ_EDID () {	0x2;}
}
unless(defined(&UDL_CTRL_CMD_WRITE_1)) {
    sub UDL_CTRL_CMD_WRITE_1 () {	0x3;}
}
unless(defined(&UDL_CTRL_CMD_READ_1)) {
    sub UDL_CTRL_CMD_READ_1 () {	0x4;}
}
unless(defined(&UDL_CTRL_CMD_POLL)) {
    sub UDL_CTRL_CMD_POLL () {	0x6;}
}
unless(defined(&UDL_CTRL_CMD_SET_KEY)) {
    sub UDL_CTRL_CMD_SET_KEY () {	0x12;}
}
unless(defined(&UDL_BULK_SOC)) {
    sub UDL_BULK_SOC () {	0xaf;}
}
unless(defined(&UDL_BULK_CMD_REG_WRITE_1)) {
    sub UDL_BULK_CMD_REG_WRITE_1 () {	0x20;}
}
unless(defined(&UDL_BULK_CMD_EOC)) {
    sub UDL_BULK_CMD_EOC () {	0xa0;}
}
unless(defined(&UDL_BULK_CMD_DECOMP)) {
    sub UDL_BULK_CMD_DECOMP () {	0xe0;}
}
unless(defined(&UDL_BULK_CMD_FB_BASE)) {
    sub UDL_BULK_CMD_FB_BASE () {	0x60;}
}
unless(defined(&UDL_BULK_CMD_FB_WORD)) {
    sub UDL_BULK_CMD_FB_WORD () {	0x8;}
}
unless(defined(&UDL_BULK_CMD_FB_COMP)) {
    sub UDL_BULK_CMD_FB_COMP () {	0x10;}
}
unless(defined(&UDL_BULK_CMD_FB_WRITE)) {
    sub UDL_BULK_CMD_FB_WRITE () {	( &UDL_BULK_CMD_FB_BASE | 0x);}
}
unless(defined(&UDL_BULK_CMD_FB_COPY)) {
    sub UDL_BULK_CMD_FB_COPY () {	( &UDL_BULK_CMD_FB_BASE | 0x2);}
}
unless(defined(&UDL_REG_ADDR_START16)) {
    sub UDL_REG_ADDR_START16 () {	0x20;}
}
unless(defined(&UDL_REG_ADDR_STRIDE16)) {
    sub UDL_REG_ADDR_STRIDE16 () {	0x23;}
}
unless(defined(&UDL_REG_ADDR_START8)) {
    sub UDL_REG_ADDR_START8 () {	0x26;}
}
unless(defined(&UDL_REG_ADDR_STRIDE8)) {
    sub UDL_REG_ADDR_STRIDE8 () {	0x29;}
}
unless(defined(&UDL_REG_SCREEN)) {
    sub UDL_REG_SCREEN () {	0x1f;}
}
unless(defined(&UDL_REG_SCREEN_ON)) {
    sub UDL_REG_SCREEN_ON () {	0x;}
}
unless(defined(&UDL_REG_SCREEN_OFF)) {
    sub UDL_REG_SCREEN_OFF () {	0x1;}
}
unless(defined(&UDL_REG_SYNC)) {
    sub UDL_REG_SYNC () {	0xff;}
}
unless(defined(&UDL_MODE_SIZE)) {
    sub UDL_MODE_SIZE () {	29;}
}
unless(defined(&MAX_DL_MODES)) {
    sub MAX_DL_MODES () {	 &nitems( &udl_modes);}
}
unless(defined(&UDL_HUFFMAN_RECORD_SIZE)) {
    sub UDL_HUFFMAN_RECORD_SIZE () {	$sizeof{'struct udl_huffman'};}
}
unless(defined(&UDL_HUFFMAN_RECORDS)) {
    sub UDL_HUFFMAN_RECORDS () {	(65536+ 1);}
}
unless(defined(&UDL_HUFFMAN_BASE)) {
    sub UDL_HUFFMAN_BASE () {	((( &UDL_HUFFMAN_RECORDS - 1) / 2) *  &UDL_HUFFMAN_RECORD_SIZE);}
}
unless(defined(&UDL_CB_TOTAL_SIZE)) {
    sub UDL_CB_TOTAL_SIZE () {	512;}
}
unless(defined(&UDL_CB_TAIL_SIZE)) {
    sub UDL_CB_TAIL_SIZE () {	4;}
}
unless(defined(&UDL_CB_BODY_SIZE)) {
    sub UDL_CB_BODY_SIZE () {	( &UDL_CB_TOTAL_SIZE -  &UDL_CB_TAIL_SIZE);}
}
unless(defined(&UDL_CB_RESTART_SIZE)) {
    sub UDL_CB_RESTART_SIZE () {	( &UDL_CB_BODY_SIZE -  &UDL_CB_TAIL_SIZE);}
}
1;
