require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_I915_REG_H_)) {
    eval 'sub _I915_REG_H_ () {1;}' unless defined(&_I915_REG_H_);
    eval 'sub _PIPE {
        my($pipe, $a, $b) = @_;
	    eval q((($a) + ($pipe)*(($b)-($a))));
    }' unless defined(&_PIPE);
    eval 'sub INTEL_GMCH_CTRL () {0x52;}' unless defined(&INTEL_GMCH_CTRL);
    eval 'sub INTEL_GMCH_VGA_DISABLE () {(1<< 1);}' unless defined(&INTEL_GMCH_VGA_DISABLE);
    eval 'sub HPLLCC () {0xc0;}' unless defined(&HPLLCC);
    eval 'sub GC_CLOCK_CONTROL_MASK () {(0xf << 0);}' unless defined(&GC_CLOCK_CONTROL_MASK);
    eval 'sub GC_CLOCK_133_200 () {(0<< 0);}' unless defined(&GC_CLOCK_133_200);
    eval 'sub GC_CLOCK_100_200 () {(1<< 0);}' unless defined(&GC_CLOCK_100_200);
    eval 'sub GC_CLOCK_100_133 () {(2<< 0);}' unless defined(&GC_CLOCK_100_133);
    eval 'sub GC_CLOCK_166_250 () {(3<< 0);}' unless defined(&GC_CLOCK_166_250);
    eval 'sub GCFGC2 () {0xda;}' unless defined(&GCFGC2);
    eval 'sub GCFGC () {0xf0;}' unless defined(&GCFGC);
    eval 'sub GC_LOW_FREQUENCY_ENABLE () {(1<< 7);}' unless defined(&GC_LOW_FREQUENCY_ENABLE);
    eval 'sub GC_DISPLAY_CLOCK_190_200_MHZ () {(0<< 4);}' unless defined(&GC_DISPLAY_CLOCK_190_200_MHZ);
    eval 'sub GC_DISPLAY_CLOCK_333_MHZ () {(4<< 4);}' unless defined(&GC_DISPLAY_CLOCK_333_MHZ);
    eval 'sub GC_DISPLAY_CLOCK_MASK () {(7<< 4);}' unless defined(&GC_DISPLAY_CLOCK_MASK);
    eval 'sub GM45_GC_RENDER_CLOCK_MASK () {(0xf << 0);}' unless defined(&GM45_GC_RENDER_CLOCK_MASK);
    eval 'sub GM45_GC_RENDER_CLOCK_266_MHZ () {(8<< 0);}' unless defined(&GM45_GC_RENDER_CLOCK_266_MHZ);
    eval 'sub GM45_GC_RENDER_CLOCK_320_MHZ () {(9<< 0);}' unless defined(&GM45_GC_RENDER_CLOCK_320_MHZ);
    eval 'sub GM45_GC_RENDER_CLOCK_400_MHZ () {(0xb << 0);}' unless defined(&GM45_GC_RENDER_CLOCK_400_MHZ);
    eval 'sub GM45_GC_RENDER_CLOCK_533_MHZ () {(0xc << 0);}' unless defined(&GM45_GC_RENDER_CLOCK_533_MHZ);
    eval 'sub I965_GC_RENDER_CLOCK_MASK () {(0xf << 0);}' unless defined(&I965_GC_RENDER_CLOCK_MASK);
    eval 'sub I965_GC_RENDER_CLOCK_267_MHZ () {(2<< 0);}' unless defined(&I965_GC_RENDER_CLOCK_267_MHZ);
    eval 'sub I965_GC_RENDER_CLOCK_333_MHZ () {(3<< 0);}' unless defined(&I965_GC_RENDER_CLOCK_333_MHZ);
    eval 'sub I965_GC_RENDER_CLOCK_444_MHZ () {(4<< 0);}' unless defined(&I965_GC_RENDER_CLOCK_444_MHZ);
    eval 'sub I965_GC_RENDER_CLOCK_533_MHZ () {(5<< 0);}' unless defined(&I965_GC_RENDER_CLOCK_533_MHZ);
    eval 'sub I945_GC_RENDER_CLOCK_MASK () {(7<< 0);}' unless defined(&I945_GC_RENDER_CLOCK_MASK);
    eval 'sub I945_GC_RENDER_CLOCK_166_MHZ () {(0<< 0);}' unless defined(&I945_GC_RENDER_CLOCK_166_MHZ);
    eval 'sub I945_GC_RENDER_CLOCK_200_MHZ () {(1<< 0);}' unless defined(&I945_GC_RENDER_CLOCK_200_MHZ);
    eval 'sub I945_GC_RENDER_CLOCK_250_MHZ () {(3<< 0);}' unless defined(&I945_GC_RENDER_CLOCK_250_MHZ);
    eval 'sub I945_GC_RENDER_CLOCK_400_MHZ () {(5<< 0);}' unless defined(&I945_GC_RENDER_CLOCK_400_MHZ);
    eval 'sub I915_GC_RENDER_CLOCK_MASK () {(7<< 0);}' unless defined(&I915_GC_RENDER_CLOCK_MASK);
    eval 'sub I915_GC_RENDER_CLOCK_166_MHZ () {(0<< 0);}' unless defined(&I915_GC_RENDER_CLOCK_166_MHZ);
    eval 'sub I915_GC_RENDER_CLOCK_200_MHZ () {(1<< 0);}' unless defined(&I915_GC_RENDER_CLOCK_200_MHZ);
    eval 'sub I915_GC_RENDER_CLOCK_333_MHZ () {(4<< 0);}' unless defined(&I915_GC_RENDER_CLOCK_333_MHZ);
    eval 'sub LBB () {0xf4;}' unless defined(&LBB);
    eval 'sub I965_GDRST () {0xc0;}' unless defined(&I965_GDRST);
    eval 'sub ILK_GDSR () {0x2ca4;}' unless defined(&ILK_GDSR);
    eval 'sub GRDOM_FULL () {(0<<2);}' unless defined(&GRDOM_FULL);
    eval 'sub GRDOM_RENDER () {(1<<2);}' unless defined(&GRDOM_RENDER);
    eval 'sub GRDOM_MEDIA () {(3<<2);}' unless defined(&GRDOM_MEDIA);
    eval 'sub GEN6_MBCUNIT_SNPCR () {0x900c;}' unless defined(&GEN6_MBCUNIT_SNPCR);
    eval 'sub GEN6_MBC_SNPCR_SHIFT () {21;}' unless defined(&GEN6_MBC_SNPCR_SHIFT);
    eval 'sub GEN6_MBC_SNPCR_MASK () {(3<<21);}' unless defined(&GEN6_MBC_SNPCR_MASK);
    eval 'sub GEN6_MBC_SNPCR_MAX () {(0<<21);}' unless defined(&GEN6_MBC_SNPCR_MAX);
    eval 'sub GEN6_MBC_SNPCR_MED () {(1<<21);}' unless defined(&GEN6_MBC_SNPCR_MED);
    eval 'sub GEN6_MBC_SNPCR_LOW () {(2<<21);}' unless defined(&GEN6_MBC_SNPCR_LOW);
    eval 'sub GEN6_MBC_SNPCR_MIN () {(3<<21);}' unless defined(&GEN6_MBC_SNPCR_MIN);
    eval 'sub GEN6_MBCTL () {0x907c;}' unless defined(&GEN6_MBCTL);
    eval 'sub GEN6_MBCTL_ENABLE_BOOT_FETCH () {(1<< 4);}' unless defined(&GEN6_MBCTL_ENABLE_BOOT_FETCH);
    eval 'sub GEN6_MBCTL_CTX_FETCH_NEEDED () {(1<< 3);}' unless defined(&GEN6_MBCTL_CTX_FETCH_NEEDED);
    eval 'sub GEN6_MBCTL_BME_UPDATE_ENABLE () {(1<< 2);}' unless defined(&GEN6_MBCTL_BME_UPDATE_ENABLE);
    eval 'sub GEN6_MBCTL_MAE_UPDATE_ENABLE () {(1<< 1);}' unless defined(&GEN6_MBCTL_MAE_UPDATE_ENABLE);
    eval 'sub GEN6_MBCTL_BOOT_FETCH_MECH () {(1<< 0);}' unless defined(&GEN6_MBCTL_BOOT_FETCH_MECH);
    eval 'sub GEN6_GDRST () {0x941c;}' unless defined(&GEN6_GDRST);
    eval 'sub GEN6_GRDOM_FULL () {(1<< 0);}' unless defined(&GEN6_GRDOM_FULL);
    eval 'sub GEN6_GRDOM_RENDER () {(1<< 1);}' unless defined(&GEN6_GRDOM_RENDER);
    eval 'sub GEN6_GRDOM_MEDIA () {(1<< 2);}' unless defined(&GEN6_GRDOM_MEDIA);
    eval 'sub GEN6_GRDOM_BLT () {(1<< 3);}' unless defined(&GEN6_GRDOM_BLT);
    eval 'sub GEN6_GTT_ADDR_ENCODE {
        my($addr) = @_;
	    eval q((($addr) | ((($addr) >> 28) & 0xff0)));
    }' unless defined(&GEN6_GTT_ADDR_ENCODE);
    eval 'sub GEN6_PDE_VALID () {(1<< 0);}' unless defined(&GEN6_PDE_VALID);
    eval 'sub GEN6_PDE_LARGE_PAGE () {(2<< 0);}' unless defined(&GEN6_PDE_LARGE_PAGE);
    eval 'sub GEN6_PDE_ADDR_ENCODE {
        my($addr) = @_;
	    eval q( &GEN6_GTT_ADDR_ENCODE($addr));
    }' unless defined(&GEN6_PDE_ADDR_ENCODE);
    eval 'sub GEN6_PTE_VALID () {(1<< 0);}' unless defined(&GEN6_PTE_VALID);
    eval 'sub GEN6_PTE_UNCACHED () {(1<< 1);}' unless defined(&GEN6_PTE_UNCACHED);
    eval 'sub GEN6_PTE_CACHE_LLC () {(2<< 1);}' unless defined(&GEN6_PTE_CACHE_LLC);
    eval 'sub GEN6_PTE_CACHE_LLC_MLC () {(3<< 1);}' unless defined(&GEN6_PTE_CACHE_LLC_MLC);
    eval 'sub GEN6_PTE_CACHE_BITS () {(3<< 1);}' unless defined(&GEN6_PTE_CACHE_BITS);
    eval 'sub GEN6_PTE_GFDT () {(1<< 3);}' unless defined(&GEN6_PTE_GFDT);
    eval 'sub GEN6_PTE_ADDR_ENCODE {
        my($addr) = @_;
	    eval q( &GEN6_GTT_ADDR_ENCODE($addr));
    }' unless defined(&GEN6_PTE_ADDR_ENCODE);
    eval 'sub RING_PP_DIR_BASE {
        my($ring) = @_;
	    eval q((($ring)-> &mmio_base+0x228));
    }' unless defined(&RING_PP_DIR_BASE);
    eval 'sub RING_PP_DIR_BASE_READ {
        my($ring) = @_;
	    eval q((($ring)-> &mmio_base+0x518));
    }' unless defined(&RING_PP_DIR_BASE_READ);
    eval 'sub RING_PP_DIR_DCLV {
        my($ring) = @_;
	    eval q((($ring)-> &mmio_base+0x220));
    }' unless defined(&RING_PP_DIR_DCLV);
    eval 'sub PP_DIR_DCLV_2G () {0xffffffff;}' unless defined(&PP_DIR_DCLV_2G);
    eval 'sub GAM_ECOCHK () {0x4090;}' unless defined(&GAM_ECOCHK);
    eval 'sub ECOCHK_SNB_BIT () {(1<<10);}' unless defined(&ECOCHK_SNB_BIT);
    eval 'sub ECOCHK_PPGTT_CACHE64B () {(0x3<<3);}' unless defined(&ECOCHK_PPGTT_CACHE64B);
    eval 'sub ECOCHK_PPGTT_CACHE4B () {(0x<<3);}' unless defined(&ECOCHK_PPGTT_CACHE4B);
    eval 'sub VGA_ST01_MDA () {0x3ba;}' unless defined(&VGA_ST01_MDA);
    eval 'sub VGA_ST01_CGA () {0x3da;}' unless defined(&VGA_ST01_CGA);
    eval 'sub VGA_MSR_WRITE () {0x3c2;}' unless defined(&VGA_MSR_WRITE);
    eval 'sub VGA_MSR_READ () {0x3cc;}' unless defined(&VGA_MSR_READ);
    eval 'sub VGA_MSR_MEM_EN () {(1<<1);}' unless defined(&VGA_MSR_MEM_EN);
    eval 'sub VGA_MSR_CGA_MODE () {(1<<0);}' unless defined(&VGA_MSR_CGA_MODE);
    eval 'sub VGA_SR_INDEX () {0x3c4;}' unless defined(&VGA_SR_INDEX);
    eval 'sub VGA_SR_DATA () {0x3c5;}' unless defined(&VGA_SR_DATA);
    eval 'sub VGA_AR_INDEX () {0x3c0;}' unless defined(&VGA_AR_INDEX);
    eval 'sub VGA_AR_VID_EN () {(1<<5);}' unless defined(&VGA_AR_VID_EN);
    eval 'sub VGA_AR_DATA_WRITE () {0x3c0;}' unless defined(&VGA_AR_DATA_WRITE);
    eval 'sub VGA_AR_DATA_READ () {0x3c1;}' unless defined(&VGA_AR_DATA_READ);
    eval 'sub VGA_GR_INDEX () {0x3ce;}' unless defined(&VGA_GR_INDEX);
    eval 'sub VGA_GR_DATA () {0x3cf;}' unless defined(&VGA_GR_DATA);
    eval 'sub VGA_GR_MEM_READ_MODE_SHIFT () {3;}' unless defined(&VGA_GR_MEM_READ_MODE_SHIFT);
    eval 'sub VGA_GR_MEM_READ_MODE_PLANE () {1;}' unless defined(&VGA_GR_MEM_READ_MODE_PLANE);
    eval 'sub VGA_GR_MEM_MODE_MASK () {0xc;}' unless defined(&VGA_GR_MEM_MODE_MASK);
    eval 'sub VGA_GR_MEM_MODE_SHIFT () {2;}' unless defined(&VGA_GR_MEM_MODE_SHIFT);
    eval 'sub VGA_GR_MEM_A0000_AFFFF () {0;}' unless defined(&VGA_GR_MEM_A0000_AFFFF);
    eval 'sub VGA_GR_MEM_A0000_BFFFF () {1;}' unless defined(&VGA_GR_MEM_A0000_BFFFF);
    eval 'sub VGA_GR_MEM_B0000_B7FFF () {2;}' unless defined(&VGA_GR_MEM_B0000_B7FFF);
    eval 'sub VGA_GR_MEM_B0000_BFFFF () {3;}' unless defined(&VGA_GR_MEM_B0000_BFFFF);
    eval 'sub VGA_DACMASK () {0x3c6;}' unless defined(&VGA_DACMASK);
    eval 'sub VGA_DACRX () {0x3c7;}' unless defined(&VGA_DACRX);
    eval 'sub VGA_DACWX () {0x3c8;}' unless defined(&VGA_DACWX);
    eval 'sub VGA_DACDATA () {0x3c9;}' unless defined(&VGA_DACDATA);
    eval 'sub VGA_CR_INDEX_MDA () {0x3b4;}' unless defined(&VGA_CR_INDEX_MDA);
    eval 'sub VGA_CR_DATA_MDA () {0x3b5;}' unless defined(&VGA_CR_DATA_MDA);
    eval 'sub VGA_CR_INDEX_CGA () {0x3d4;}' unless defined(&VGA_CR_INDEX_CGA);
    eval 'sub VGA_CR_DATA_CGA () {0x3d5;}' unless defined(&VGA_CR_DATA_CGA);
    eval 'sub MI_INSTR {
        my($opcode, $flags) = @_;
	    eval q(((($opcode) << 23) | ($flags)));
    }' unless defined(&MI_INSTR);
    eval 'sub MI_NOOP () { &MI_INSTR(0, 0);}' unless defined(&MI_NOOP);
    eval 'sub MI_USER_INTERRUPT () { &MI_INSTR(0x2, 0);}' unless defined(&MI_USER_INTERRUPT);
    eval 'sub MI_WAIT_FOR_EVENT () { &MI_INSTR(0x3, 0);}' unless defined(&MI_WAIT_FOR_EVENT);
    eval 'sub MI_WAIT_FOR_OVERLAY_FLIP () {(1<<16);}' unless defined(&MI_WAIT_FOR_OVERLAY_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_B_FLIP () {(1<<6);}' unless defined(&MI_WAIT_FOR_PLANE_B_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_A_FLIP () {(1<<2);}' unless defined(&MI_WAIT_FOR_PLANE_A_FLIP);
    eval 'sub MI_WAIT_FOR_PLANE_A_SCANLINES () {(1<<1);}' unless defined(&MI_WAIT_FOR_PLANE_A_SCANLINES);
    eval 'sub MI_FLUSH () { &MI_INSTR(0x4, 0);}' unless defined(&MI_FLUSH);
    eval 'sub MI_READ_FLUSH () {(1<< 0);}' unless defined(&MI_READ_FLUSH);
    eval 'sub MI_EXE_FLUSH () {(1<< 1);}' unless defined(&MI_EXE_FLUSH);
    eval 'sub MI_NO_WRITE_FLUSH () {(1<< 2);}' unless defined(&MI_NO_WRITE_FLUSH);
    eval 'sub MI_SCENE_COUNT () {(1<< 3);}' unless defined(&MI_SCENE_COUNT);
    eval 'sub MI_END_SCENE () {(1<< 4);}' unless defined(&MI_END_SCENE);
    eval 'sub MI_INVALIDATE_ISP () {(1<< 5);}' unless defined(&MI_INVALIDATE_ISP);
    eval 'sub MI_BATCH_BUFFER_END () { &MI_INSTR(0xa, 0);}' unless defined(&MI_BATCH_BUFFER_END);
    eval 'sub MI_SUSPEND_FLUSH () { &MI_INSTR(0xb, 0);}' unless defined(&MI_SUSPEND_FLUSH);
    eval 'sub MI_SUSPEND_FLUSH_EN () {(1<<0);}' unless defined(&MI_SUSPEND_FLUSH_EN);
    eval 'sub MI_REPORT_HEAD () { &MI_INSTR(0x7, 0);}' unless defined(&MI_REPORT_HEAD);
    eval 'sub MI_OVERLAY_FLIP () { &MI_INSTR(0x11, 0);}' unless defined(&MI_OVERLAY_FLIP);
    eval 'sub MI_OVERLAY_CONTINUE () {(0x<<21);}' unless defined(&MI_OVERLAY_CONTINUE);
    eval 'sub MI_OVERLAY_ON () {(0x1<<21);}' unless defined(&MI_OVERLAY_ON);
    eval 'sub MI_OVERLAY_OFF () {(0x2<<21);}' unless defined(&MI_OVERLAY_OFF);
    eval 'sub MI_LOAD_SCAN_LINES_INCL () { &MI_INSTR(0x12, 0);}' unless defined(&MI_LOAD_SCAN_LINES_INCL);
    eval 'sub MI_DISPLAY_FLIP () { &MI_INSTR(0x14, 2);}' unless defined(&MI_DISPLAY_FLIP);
    eval 'sub MI_DISPLAY_FLIP_I915 () { &MI_INSTR(0x14, 1);}' unless defined(&MI_DISPLAY_FLIP_I915);
    eval 'sub MI_DISPLAY_FLIP_PLANE {
        my($n) = @_;
	    eval q((($n) << 20));
    }' unless defined(&MI_DISPLAY_FLIP_PLANE);
    eval 'sub MI_SET_CONTEXT () { &MI_INSTR(0x18, 0);}' unless defined(&MI_SET_CONTEXT);
    eval 'sub MI_MM_SPACE_GTT () {(1<<8);}' unless defined(&MI_MM_SPACE_GTT);
    eval 'sub MI_MM_SPACE_PHYSICAL () {(0<<8);}' unless defined(&MI_MM_SPACE_PHYSICAL);
    eval 'sub MI_SAVE_EXT_STATE_EN () {(1<<3);}' unless defined(&MI_SAVE_EXT_STATE_EN);
    eval 'sub MI_RESTORE_EXT_STATE_EN () {(1<<2);}' unless defined(&MI_RESTORE_EXT_STATE_EN);
    eval 'sub MI_FORCE_RESTORE () {(1<<1);}' unless defined(&MI_FORCE_RESTORE);
    eval 'sub MI_RESTORE_INHIBIT () {(1<<0);}' unless defined(&MI_RESTORE_INHIBIT);
    eval 'sub MI_STORE_DWORD_IMM () { &MI_INSTR(0x20, 1);}' unless defined(&MI_STORE_DWORD_IMM);
    eval 'sub MI_MEM_VIRTUAL () {(1<< 22);}' unless defined(&MI_MEM_VIRTUAL);
    eval 'sub MI_STORE_DWORD_INDEX () { &MI_INSTR(0x21, 1);}' unless defined(&MI_STORE_DWORD_INDEX);
    eval 'sub MI_STORE_DWORD_INDEX_SHIFT () {2;}' unless defined(&MI_STORE_DWORD_INDEX_SHIFT);
    eval 'sub MI_LOAD_REGISTER_IMM {
        my($x) = @_;
	    eval q( &MI_INSTR(0x22, 2*$x-1));
    }' unless defined(&MI_LOAD_REGISTER_IMM);
    eval 'sub MI_FLUSH_DW () { &MI_INSTR(0x26, 1);}' unless defined(&MI_FLUSH_DW);
    eval 'sub MI_INVALIDATE_TLB () {(1<<18);}' unless defined(&MI_INVALIDATE_TLB);
    eval 'sub MI_INVALIDATE_BSD () {(1<<7);}' unless defined(&MI_INVALIDATE_BSD);
    eval 'sub MI_BATCH_BUFFER () { &MI_INSTR(0x30, 1);}' unless defined(&MI_BATCH_BUFFER);
    eval 'sub MI_BATCH_NON_SECURE () {(1);}' unless defined(&MI_BATCH_NON_SECURE);
    eval 'sub MI_BATCH_NON_SECURE_I965 () {(1<<8);}' unless defined(&MI_BATCH_NON_SECURE_I965);
    eval 'sub MI_BATCH_BUFFER_START () { &MI_INSTR(0x31, 0);}' unless defined(&MI_BATCH_BUFFER_START);
    eval 'sub MI_SEMAPHORE_MBOX () { &MI_INSTR(0x16, 1);}' unless defined(&MI_SEMAPHORE_MBOX);
    eval 'sub MI_SEMAPHORE_GLOBAL_GTT () {(1<<22);}' unless defined(&MI_SEMAPHORE_GLOBAL_GTT);
    eval 'sub MI_SEMAPHORE_UPDATE () {(1<<21);}' unless defined(&MI_SEMAPHORE_UPDATE);
    eval 'sub MI_SEMAPHORE_COMPARE () {(1<<20);}' unless defined(&MI_SEMAPHORE_COMPARE);
    eval 'sub MI_SEMAPHORE_REGISTER () {(1<<18);}' unless defined(&MI_SEMAPHORE_REGISTER);
    eval 'sub MI_SEMAPHORE_SYNC_RV () {(2<<16);}' unless defined(&MI_SEMAPHORE_SYNC_RV);
    eval 'sub MI_SEMAPHORE_SYNC_RB () {(0<<16);}' unless defined(&MI_SEMAPHORE_SYNC_RB);
    eval 'sub MI_SEMAPHORE_SYNC_VR () {(0<<16);}' unless defined(&MI_SEMAPHORE_SYNC_VR);
    eval 'sub MI_SEMAPHORE_SYNC_VB () {(2<<16);}' unless defined(&MI_SEMAPHORE_SYNC_VB);
    eval 'sub MI_SEMAPHORE_SYNC_BR () {(2<<16);}' unless defined(&MI_SEMAPHORE_SYNC_BR);
    eval 'sub MI_SEMAPHORE_SYNC_BV () {(0<<16);}' unless defined(&MI_SEMAPHORE_SYNC_BV);
    eval 'sub MI_SEMAPHORE_SYNC_INVALID () {(1<<0);}' unless defined(&MI_SEMAPHORE_SYNC_INVALID);
    eval 'sub GFX_INSTR {
        my($opcode, $flags) = @_;
	    eval q(((0x3 << 29) | (($opcode) << 24) | ($flags)));
    }' unless defined(&GFX_INSTR);
    eval 'sub GFX_OP_RASTER_RULES () {((0x3<<29)|(0x7<<24));}' unless defined(&GFX_OP_RASTER_RULES);
    eval 'sub GFX_OP_SCISSOR () {((0x3<<29)|(0x1c<<24)|(0x10<<19));}' unless defined(&GFX_OP_SCISSOR);
    eval 'sub SC_UPDATE_SCISSOR () {(0x1<<1);}' unless defined(&SC_UPDATE_SCISSOR);
    eval 'sub SC_ENABLE_MASK () {(0x1<<0);}' unless defined(&SC_ENABLE_MASK);
    eval 'sub SC_ENABLE () {(0x1<<0);}' unless defined(&SC_ENABLE);
    eval 'sub GFX_OP_LOAD_INDIRECT () {((0x3<<29)|(0x1d<<24)|(0x7<<16));}' unless defined(&GFX_OP_LOAD_INDIRECT);
    eval 'sub GFX_OP_SCISSOR_INFO () {((0x3<<29)|(0x1d<<24)|(0x81<<16)|(0x1));}' unless defined(&GFX_OP_SCISSOR_INFO);
    eval 'sub SCI_YMIN_MASK () {(0xffff<<16);}' unless defined(&SCI_YMIN_MASK);
    eval 'sub SCI_XMIN_MASK () {(0xffff<<0);}' unless defined(&SCI_XMIN_MASK);
    eval 'sub SCI_YMAX_MASK () {(0xffff<<16);}' unless defined(&SCI_YMAX_MASK);
    eval 'sub SCI_XMAX_MASK () {(0xffff<<0);}' unless defined(&SCI_XMAX_MASK);
    eval 'sub GFX_OP_SCISSOR_ENABLE () {((0x3<<29)|(0x1c<<24)|(0x10<<19));}' unless defined(&GFX_OP_SCISSOR_ENABLE);
    eval 'sub GFX_OP_SCISSOR_RECT () {((0x3<<29)|(0x1d<<24)|(0x81<<16)|1);}' unless defined(&GFX_OP_SCISSOR_RECT);
    eval 'sub GFX_OP_COLOR_FACTOR () {((0x3<<29)|(0x1d<<24)|(0x1<<16)|0x);}' unless defined(&GFX_OP_COLOR_FACTOR);
    eval 'sub GFX_OP_STIPPLE () {((0x3<<29)|(0x1d<<24)|(0x83<<16));}' unless defined(&GFX_OP_STIPPLE);
    eval 'sub GFX_OP_MAP_INFO () {((0x3<<29)|(0x1d<<24)|0x4);}' unless defined(&GFX_OP_MAP_INFO);
    eval 'sub GFX_OP_DESTBUFFER_VARS () {((0x3<<29)|(0x1d<<24)|(0x85<<16)|0x);}' unless defined(&GFX_OP_DESTBUFFER_VARS);
    eval 'sub GFX_OP_DESTBUFFER_INFO () {((0x3<<29)|(0x1d<<24)|(0x8e<<16)|1);}' unless defined(&GFX_OP_DESTBUFFER_INFO);
    eval 'sub GFX_OP_DRAWRECT_INFO () {((0x3<<29)|(0x1d<<24)|(0x80<<16)|(0x3));}' unless defined(&GFX_OP_DRAWRECT_INFO);
    eval 'sub GFX_OP_DRAWRECT_INFO_I965 () {((0x7900<<16)|0x2);}' unless defined(&GFX_OP_DRAWRECT_INFO_I965);
    eval 'sub SRC_COPY_BLT_CMD () {((2<<29)|(0x43<<22)|4);}' unless defined(&SRC_COPY_BLT_CMD);
    eval 'sub XY_SRC_COPY_BLT_CMD () {((2<<29)|(0x53<<22)|6);}' unless defined(&XY_SRC_COPY_BLT_CMD);
    eval 'sub XY_MONO_SRC_COPY_IMM_BLT () {((2<<29)|(0x71<<22)|5);}' unless defined(&XY_MONO_SRC_COPY_IMM_BLT);
    eval 'sub XY_SRC_COPY_BLT_WRITE_ALPHA () {(1<<21);}' unless defined(&XY_SRC_COPY_BLT_WRITE_ALPHA);
    eval 'sub XY_SRC_COPY_BLT_WRITE_RGB () {(1<<20);}' unless defined(&XY_SRC_COPY_BLT_WRITE_RGB);
    eval 'sub BLT_DEPTH_8 () {(0<<24);}' unless defined(&BLT_DEPTH_8);
    eval 'sub BLT_DEPTH_16_565 () {(1<<24);}' unless defined(&BLT_DEPTH_16_565);
    eval 'sub BLT_DEPTH_16_1555 () {(2<<24);}' unless defined(&BLT_DEPTH_16_1555);
    eval 'sub BLT_DEPTH_32 () {(3<<24);}' unless defined(&BLT_DEPTH_32);
    eval 'sub BLT_ROP_GXCOPY () {(0xcc<<16);}' unless defined(&BLT_ROP_GXCOPY);
    eval 'sub XY_SRC_COPY_BLT_SRC_TILED () {(1<<15);}' unless defined(&XY_SRC_COPY_BLT_SRC_TILED);
    eval 'sub XY_SRC_COPY_BLT_DST_TILED () {(1<<11);}' unless defined(&XY_SRC_COPY_BLT_DST_TILED);
    eval 'sub CMD_OP_DISPLAYBUFFER_INFO () {((0x<<29)|(0x14<<23)|2);}' unless defined(&CMD_OP_DISPLAYBUFFER_INFO);
    eval 'sub ASYNC_FLIP () {(1<<22);}' unless defined(&ASYNC_FLIP);
    eval 'sub DISPLAY_PLANE_A () {(0<<20);}' unless defined(&DISPLAY_PLANE_A);
    eval 'sub DISPLAY_PLANE_B () {(1<<20);}' unless defined(&DISPLAY_PLANE_B);
    eval 'sub GFX_OP_PIPE_CONTROL {
        my($len) = @_;
	    eval q(((0x3<<29)|(0x3<<27)|(0x2<<24)|($len-2)));
    }' unless defined(&GFX_OP_PIPE_CONTROL);
    eval 'sub PIPE_CONTROL_CS_STALL () {(1<<20);}' unless defined(&PIPE_CONTROL_CS_STALL);
    eval 'sub PIPE_CONTROL_QW_WRITE () {(1<<14);}' unless defined(&PIPE_CONTROL_QW_WRITE);
    eval 'sub PIPE_CONTROL_DEPTH_STALL () {(1<<13);}' unless defined(&PIPE_CONTROL_DEPTH_STALL);
    eval 'sub PIPE_CONTROL_WRITE_FLUSH () {(1<<12);}' unless defined(&PIPE_CONTROL_WRITE_FLUSH);
    eval 'sub PIPE_CONTROL_RENDER_TARGET_CACHE_FLUSH () {(1<<12);}' unless defined(&PIPE_CONTROL_RENDER_TARGET_CACHE_FLUSH);
    eval 'sub PIPE_CONTROL_INSTRUCTION_CACHE_INVALIDATE () {(1<<11);}' unless defined(&PIPE_CONTROL_INSTRUCTION_CACHE_INVALIDATE);
    eval 'sub PIPE_CONTROL_TEXTURE_CACHE_INVALIDATE () {(1<<10);}' unless defined(&PIPE_CONTROL_TEXTURE_CACHE_INVALIDATE);
    eval 'sub PIPE_CONTROL_INDIRECT_STATE_DISABLE () {(1<<9);}' unless defined(&PIPE_CONTROL_INDIRECT_STATE_DISABLE);
    eval 'sub PIPE_CONTROL_NOTIFY () {(1<<8);}' unless defined(&PIPE_CONTROL_NOTIFY);
    eval 'sub PIPE_CONTROL_VF_CACHE_INVALIDATE () {(1<<4);}' unless defined(&PIPE_CONTROL_VF_CACHE_INVALIDATE);
    eval 'sub PIPE_CONTROL_CONST_CACHE_INVALIDATE () {(1<<3);}' unless defined(&PIPE_CONTROL_CONST_CACHE_INVALIDATE);
    eval 'sub PIPE_CONTROL_STATE_CACHE_INVALIDATE () {(1<<2);}' unless defined(&PIPE_CONTROL_STATE_CACHE_INVALIDATE);
    eval 'sub PIPE_CONTROL_STALL_AT_SCOREBOARD () {(1<<1);}' unless defined(&PIPE_CONTROL_STALL_AT_SCOREBOARD);
    eval 'sub PIPE_CONTROL_DEPTH_CACHE_FLUSH () {(1<<0);}' unless defined(&PIPE_CONTROL_DEPTH_CACHE_FLUSH);
    eval 'sub PIPE_CONTROL_GLOBAL_GTT () {(1<<2);}' unless defined(&PIPE_CONTROL_GLOBAL_GTT);
    eval 'sub DEBUG_RESET_I830 () {0x6070;}' unless defined(&DEBUG_RESET_I830);
    eval 'sub DEBUG_RESET_FULL () {(1<<7);}' unless defined(&DEBUG_RESET_FULL);
    eval 'sub DEBUG_RESET_RENDER () {(1<<8);}' unless defined(&DEBUG_RESET_RENDER);
    eval 'sub DEBUG_RESET_DISPLAY () {(1<<9);}' unless defined(&DEBUG_RESET_DISPLAY);
    eval 'sub FENCE_REG_830_0 () {0x2000;}' unless defined(&FENCE_REG_830_0);
    eval 'sub FENCE_REG_945_8 () {0x3000;}' unless defined(&FENCE_REG_945_8);
    eval 'sub I830_FENCE_START_MASK () {0x7f80000;}' unless defined(&I830_FENCE_START_MASK);
    eval 'sub I830_FENCE_TILING_Y_SHIFT () {12;}' unless defined(&I830_FENCE_TILING_Y_SHIFT);
    eval 'sub I830_FENCE_SIZE_BITS {
        my($size) = @_;
	    eval q((( &ffs(($size) >> 19) - 1) << 8));
    }' unless defined(&I830_FENCE_SIZE_BITS);
    eval 'sub I830_FENCE_PITCH_SHIFT () {4;}' unless defined(&I830_FENCE_PITCH_SHIFT);
    eval 'sub I830_FENCE_REG_VALID () {(1<<0);}' unless defined(&I830_FENCE_REG_VALID);
    eval 'sub I915_FENCE_MAX_PITCH_VAL () {4;}' unless defined(&I915_FENCE_MAX_PITCH_VAL);
    eval 'sub I830_FENCE_MAX_PITCH_VAL () {6;}' unless defined(&I830_FENCE_MAX_PITCH_VAL);
    eval 'sub I830_FENCE_MAX_SIZE_VAL () {(1<<8);}' unless defined(&I830_FENCE_MAX_SIZE_VAL);
    eval 'sub I915_FENCE_START_MASK () {0xff00000;}' unless defined(&I915_FENCE_START_MASK);
    eval 'sub I915_FENCE_SIZE_BITS {
        my($size) = @_;
	    eval q((( &ffs(($size) >> 20) - 1) << 8));
    }' unless defined(&I915_FENCE_SIZE_BITS);
    eval 'sub FENCE_REG_965_0 () {0x3000;}' unless defined(&FENCE_REG_965_0);
    eval 'sub I965_FENCE_PITCH_SHIFT () {2;}' unless defined(&I965_FENCE_PITCH_SHIFT);
    eval 'sub I965_FENCE_TILING_Y_SHIFT () {1;}' unless defined(&I965_FENCE_TILING_Y_SHIFT);
    eval 'sub I965_FENCE_REG_VALID () {(1<<0);}' unless defined(&I965_FENCE_REG_VALID);
    eval 'sub I965_FENCE_MAX_PITCH_VAL () {0x400;}' unless defined(&I965_FENCE_MAX_PITCH_VAL);
    eval 'sub FENCE_REG_SANDYBRIDGE_0 () {0x100000;}' unless defined(&FENCE_REG_SANDYBRIDGE_0);
    eval 'sub SANDYBRIDGE_FENCE_PITCH_SHIFT () {32;}' unless defined(&SANDYBRIDGE_FENCE_PITCH_SHIFT);
    eval 'sub TILECTL () {0x101000;}' unless defined(&TILECTL);
    eval 'sub TILECTL_SWZCTL () {(1<< 0);}' unless defined(&TILECTL_SWZCTL);
    eval 'sub TILECTL_TLB_PREFETCH_DIS () {(1<< 2);}' unless defined(&TILECTL_TLB_PREFETCH_DIS);
    eval 'sub TILECTL_BACKSNOOP_DIS () {(1<< 3);}' unless defined(&TILECTL_BACKSNOOP_DIS);
    eval 'sub PGTBL_ER () {0x2024;}' unless defined(&PGTBL_ER);
    eval 'sub RENDER_RING_BASE () {0x2000;}' unless defined(&RENDER_RING_BASE);
    eval 'sub BSD_RING_BASE () {0x4000;}' unless defined(&BSD_RING_BASE);
    eval 'sub GEN6_BSD_RING_BASE () {0x12000;}' unless defined(&GEN6_BSD_RING_BASE);
    eval 'sub BLT_RING_BASE () {0x22000;}' unless defined(&BLT_RING_BASE);
    eval 'sub RING_TAIL {
        my($base) = @_;
	    eval q((($base)+0x30));
    }' unless defined(&RING_TAIL);
    eval 'sub RING_HEAD {
        my($base) = @_;
	    eval q((($base)+0x34));
    }' unless defined(&RING_HEAD);
    eval 'sub RING_START {
        my($base) = @_;
	    eval q((($base)+0x38));
    }' unless defined(&RING_START);
    eval 'sub RING_CTL {
        my($base) = @_;
	    eval q((($base)+0x3c));
    }' unless defined(&RING_CTL);
    eval 'sub RING_SYNC_0 {
        my($base) = @_;
	    eval q((($base)+0x40));
    }' unless defined(&RING_SYNC_0);
    eval 'sub RING_SYNC_1 {
        my($base) = @_;
	    eval q((($base)+0x44));
    }' unless defined(&RING_SYNC_1);
    eval 'sub GEN6_RVSYNC () {( &RING_SYNC_0( &RENDER_RING_BASE));}' unless defined(&GEN6_RVSYNC);
    eval 'sub GEN6_RBSYNC () {( &RING_SYNC_1( &RENDER_RING_BASE));}' unless defined(&GEN6_RBSYNC);
    eval 'sub GEN6_VRSYNC () {( &RING_SYNC_1( &GEN6_BSD_RING_BASE));}' unless defined(&GEN6_VRSYNC);
    eval 'sub GEN6_VBSYNC () {( &RING_SYNC_0( &GEN6_BSD_RING_BASE));}' unless defined(&GEN6_VBSYNC);
    eval 'sub GEN6_BRSYNC () {( &RING_SYNC_0( &BLT_RING_BASE));}' unless defined(&GEN6_BRSYNC);
    eval 'sub GEN6_BVSYNC () {( &RING_SYNC_1( &BLT_RING_BASE));}' unless defined(&GEN6_BVSYNC);
    eval 'sub RING_MAX_IDLE {
        my($base) = @_;
	    eval q((($base)+0x54));
    }' unless defined(&RING_MAX_IDLE);
    eval 'sub RING_HWS_PGA {
        my($base) = @_;
	    eval q((($base)+0x80));
    }' unless defined(&RING_HWS_PGA);
    eval 'sub RING_HWS_PGA_GEN6 {
        my($base) = @_;
	    eval q((($base)+0x2080));
    }' unless defined(&RING_HWS_PGA_GEN6);
    eval 'sub ARB_MODE () {0x4030;}' unless defined(&ARB_MODE);
    eval 'sub ARB_MODE_SWIZZLE_SNB () {(1<<4);}' unless defined(&ARB_MODE_SWIZZLE_SNB);
    eval 'sub ARB_MODE_SWIZZLE_IVB () {(1<<5);}' unless defined(&ARB_MODE_SWIZZLE_IVB);
    eval 'sub ARB_MODE_ENABLE {
        my($x) = @_;
	    eval q( &GFX_MODE_ENABLE($x));
    }' unless defined(&ARB_MODE_ENABLE);
    eval 'sub ARB_MODE_DISABLE {
        my($x) = @_;
	    eval q( &GFX_MODE_DISABLE($x));
    }' unless defined(&ARB_MODE_DISABLE);
    eval 'sub RENDER_HWS_PGA_GEN7 () {(0x4080);}' unless defined(&RENDER_HWS_PGA_GEN7);
    eval 'sub RING_FAULT_REG {
        my($ring) = @_;
	    eval q((0x4094 + 0x100*($ring)-> &id));
    }' unless defined(&RING_FAULT_REG);
    eval 'sub DONE_REG () {0x40b0;}' unless defined(&DONE_REG);
    eval 'sub BSD_HWS_PGA_GEN7 () {(0x4180);}' unless defined(&BSD_HWS_PGA_GEN7);
    eval 'sub BLT_HWS_PGA_GEN7 () {(0x4280);}' unless defined(&BLT_HWS_PGA_GEN7);
    eval 'sub RING_ACTHD {
        my($base) = @_;
	    eval q((($base)+0x74));
    }' unless defined(&RING_ACTHD);
    eval 'sub RING_NOPID {
        my($base) = @_;
	    eval q((($base)+0x94));
    }' unless defined(&RING_NOPID);
    eval 'sub RING_IMR {
        my($base) = @_;
	    eval q((($base)+0xa8));
    }' unless defined(&RING_IMR);
    eval 'sub TAIL_ADDR () {0x1ffff8;}' unless defined(&TAIL_ADDR);
    eval 'sub HEAD_WRAP_COUNT () {0xffe00000;}' unless defined(&HEAD_WRAP_COUNT);
    eval 'sub HEAD_WRAP_ONE () {0x200000;}' unless defined(&HEAD_WRAP_ONE);
    eval 'sub HEAD_ADDR () {0x1ffffc;}' unless defined(&HEAD_ADDR);
    eval 'sub RING_NR_PAGES () {0x1ff000;}' unless defined(&RING_NR_PAGES);
    eval 'sub RING_REPORT_MASK () {0x6;}' unless defined(&RING_REPORT_MASK);
    eval 'sub RING_REPORT_64K () {0x2;}' unless defined(&RING_REPORT_64K);
    eval 'sub RING_REPORT_128K () {0x4;}' unless defined(&RING_REPORT_128K);
    eval 'sub RING_NO_REPORT () {0x;}' unless defined(&RING_NO_REPORT);
    eval 'sub RING_VALID_MASK () {0x1;}' unless defined(&RING_VALID_MASK);
    eval 'sub RING_VALID () {0x1;}' unless defined(&RING_VALID);
    eval 'sub RING_INVALID () {0x;}' unless defined(&RING_INVALID);
    eval 'sub RING_WAIT_I8XX () {(1<<0);}' unless defined(&RING_WAIT_I8XX);
    eval 'sub RING_WAIT () {(1<<11);}' unless defined(&RING_WAIT);
    eval 'sub RING_WAIT_SEMAPHORE () {(1<<10);}' unless defined(&RING_WAIT_SEMAPHORE);
    if(1) {
	eval 'sub PRB0_TAIL () {0x2030;}' unless defined(&PRB0_TAIL);
	eval 'sub PRB0_HEAD () {0x2034;}' unless defined(&PRB0_HEAD);
	eval 'sub PRB0_START () {0x2038;}' unless defined(&PRB0_START);
	eval 'sub PRB0_CTL () {0x203c;}' unless defined(&PRB0_CTL);
	eval 'sub PRB1_TAIL () {0x2040;}' unless defined(&PRB1_TAIL);
	eval 'sub PRB1_HEAD () {0x2044;}' unless defined(&PRB1_HEAD);
	eval 'sub PRB1_START () {0x2048;}' unless defined(&PRB1_START);
	eval 'sub PRB1_CTL () {0x204c;}' unless defined(&PRB1_CTL);
    }
    eval 'sub IPEIR_I965 () {0x2064;}' unless defined(&IPEIR_I965);
    eval 'sub IPEHR_I965 () {0x2068;}' unless defined(&IPEHR_I965);
    eval 'sub INSTDONE_I965 () {0x206c;}' unless defined(&INSTDONE_I965);
    eval 'sub RING_IPEIR {
        my($base) = @_;
	    eval q((($base)+0x64));
    }' unless defined(&RING_IPEIR);
    eval 'sub RING_IPEHR {
        my($base) = @_;
	    eval q((($base)+0x68));
    }' unless defined(&RING_IPEHR);
    eval 'sub RING_INSTDONE {
        my($base) = @_;
	    eval q((($base)+0x6c));
    }' unless defined(&RING_INSTDONE);
    eval 'sub RING_INSTPS {
        my($base) = @_;
	    eval q((($base)+0x70));
    }' unless defined(&RING_INSTPS);
    eval 'sub RING_DMA_FADD {
        my($base) = @_;
	    eval q((($base)+0x78));
    }' unless defined(&RING_DMA_FADD);
    eval 'sub RING_INSTPM {
        my($base) = @_;
	    eval q((($base)+0xc0));
    }' unless defined(&RING_INSTPM);
    eval 'sub INSTPS () {0x2070;}' unless defined(&INSTPS);
    eval 'sub INSTDONE1 () {0x207c;}' unless defined(&INSTDONE1);
    eval 'sub ACTHD_I965 () {0x2074;}' unless defined(&ACTHD_I965);
    eval 'sub HWS_PGA () {0x2080;}' unless defined(&HWS_PGA);
    eval 'sub HWS_ADDRESS_MASK () {0xfffff000;}' unless defined(&HWS_ADDRESS_MASK);
    eval 'sub HWS_START_ADDRESS_SHIFT () {4;}' unless defined(&HWS_START_ADDRESS_SHIFT);
    eval 'sub PWRCTXA () {0x2088;}' unless defined(&PWRCTXA);
    eval 'sub PWRCTX_EN () {(1<<0);}' unless defined(&PWRCTX_EN);
    eval 'sub IPEIR () {0x2088;}' unless defined(&IPEIR);
    eval 'sub IPEHR () {0x208c;}' unless defined(&IPEHR);
    eval 'sub INSTDONE () {0x2090;}' unless defined(&INSTDONE);
    eval 'sub NOPID () {0x2094;}' unless defined(&NOPID);
    eval 'sub HWSTAM () {0x2098;}' unless defined(&HWSTAM);
    eval 'sub ERROR_GEN6 () {0x40a0;}' unless defined(&ERROR_GEN6);
    eval 'sub _3D_CHICKEN () {0x2084;}' unless defined(&_3D_CHICKEN);
    eval 'sub _3D_CHICKEN2 () {0x208c;}' unless defined(&_3D_CHICKEN2);
    eval 'sub _3D_CHICKEN2_WM_READ_PIPELINED () {(1<< 14);}' unless defined(&_3D_CHICKEN2_WM_READ_PIPELINED);
    eval 'sub _3D_CHICKEN3 () {0x2090;}' unless defined(&_3D_CHICKEN3);
    eval 'sub MI_MODE () {0x209c;}' unless defined(&MI_MODE);
    eval 'sub VS_TIMER_DISPATCH () {(1<< 6);}' unless defined(&VS_TIMER_DISPATCH);
    eval 'sub MI_FLUSH_ENABLE () {(1<< 12);}' unless defined(&MI_FLUSH_ENABLE);
    eval 'sub GFX_MODE () {0x2520;}' unless defined(&GFX_MODE);
    eval 'sub GFX_MODE_GEN7 () {0x229c;}' unless defined(&GFX_MODE_GEN7);
    eval 'sub RING_MODE_GEN7 {
        my($ring) = @_;
	    eval q((($ring)-> &mmio_base+0x29c));
    }' unless defined(&RING_MODE_GEN7);
    eval 'sub GFX_RUN_LIST_ENABLE () {(1<<15);}' unless defined(&GFX_RUN_LIST_ENABLE);
    eval 'sub GFX_TLB_INVALIDATE_ALWAYS () {(1<<13);}' unless defined(&GFX_TLB_INVALIDATE_ALWAYS);
    eval 'sub GFX_SURFACE_FAULT_ENABLE () {(1<<12);}' unless defined(&GFX_SURFACE_FAULT_ENABLE);
    eval 'sub GFX_REPLAY_MODE () {(1<<11);}' unless defined(&GFX_REPLAY_MODE);
    eval 'sub GFX_PSMI_GRANULARITY () {(1<<10);}' unless defined(&GFX_PSMI_GRANULARITY);
    eval 'sub GFX_PPGTT_ENABLE () {(1<<9);}' unless defined(&GFX_PPGTT_ENABLE);
    eval 'sub GFX_MODE_ENABLE {
        my($bit) = @_;
	    eval q(((($bit) << 16) | ($bit)));
    }' unless defined(&GFX_MODE_ENABLE);
    eval 'sub GFX_MODE_DISABLE {
        my($bit) = @_;
	    eval q(((($bit) << 16) | (0)));
    }' unless defined(&GFX_MODE_DISABLE);
    eval 'sub SCPD0 () {0x209c;}' unless defined(&SCPD0);
    eval 'sub IER () {0x20a0;}' unless defined(&IER);
    eval 'sub IIR () {0x20a4;}' unless defined(&IIR);
    eval 'sub IMR () {0x20a8;}' unless defined(&IMR);
    eval 'sub ISR () {0x20ac;}' unless defined(&ISR);
    eval 'sub I915_PIPE_CONTROL_NOTIFY_INTERRUPT () {(1<<18);}' unless defined(&I915_PIPE_CONTROL_NOTIFY_INTERRUPT);
    eval 'sub I915_DISPLAY_PORT_INTERRUPT () {(1<<17);}' unless defined(&I915_DISPLAY_PORT_INTERRUPT);
    eval 'sub I915_RENDER_COMMAND_PARSER_ERROR_INTERRUPT () {(1<<15);}' unless defined(&I915_RENDER_COMMAND_PARSER_ERROR_INTERRUPT);
    eval 'sub I915_GMCH_THERMAL_SENSOR_EVENT_INTERRUPT () {(1<<14);}' unless defined(&I915_GMCH_THERMAL_SENSOR_EVENT_INTERRUPT);
    eval 'sub I915_HWB_OOM_INTERRUPT () {(1<<13);}' unless defined(&I915_HWB_OOM_INTERRUPT);
    eval 'sub I915_SYNC_STATUS_INTERRUPT () {(1<<12);}' unless defined(&I915_SYNC_STATUS_INTERRUPT);
    eval 'sub I915_DISPLAY_PLANE_A_FLIP_PENDING_INTERRUPT () {(1<<11);}' unless defined(&I915_DISPLAY_PLANE_A_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_DISPLAY_PLANE_B_FLIP_PENDING_INTERRUPT () {(1<<10);}' unless defined(&I915_DISPLAY_PLANE_B_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_OVERLAY_PLANE_FLIP_PENDING_INTERRUPT () {(1<<9);}' unless defined(&I915_OVERLAY_PLANE_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_DISPLAY_PLANE_C_FLIP_PENDING_INTERRUPT () {(1<<8);}' unless defined(&I915_DISPLAY_PLANE_C_FLIP_PENDING_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_A_VBLANK_INTERRUPT () {(1<<7);}' unless defined(&I915_DISPLAY_PIPE_A_VBLANK_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_A_EVENT_INTERRUPT () {(1<<6);}' unless defined(&I915_DISPLAY_PIPE_A_EVENT_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_B_VBLANK_INTERRUPT () {(1<<5);}' unless defined(&I915_DISPLAY_PIPE_B_VBLANK_INTERRUPT);
    eval 'sub I915_DISPLAY_PIPE_B_EVENT_INTERRUPT () {(1<<4);}' unless defined(&I915_DISPLAY_PIPE_B_EVENT_INTERRUPT);
    eval 'sub I915_DEBUG_INTERRUPT () {(1<<2);}' unless defined(&I915_DEBUG_INTERRUPT);
    eval 'sub I915_USER_INTERRUPT () {(1<<1);}' unless defined(&I915_USER_INTERRUPT);
    eval 'sub I915_ASLE_INTERRUPT () {(1<<0);}' unless defined(&I915_ASLE_INTERRUPT);
    eval 'sub I915_BSD_USER_INTERRUPT () {(1<<25);}' unless defined(&I915_BSD_USER_INTERRUPT);
    eval 'sub EIR () {0x20b0;}' unless defined(&EIR);
    eval 'sub EMR () {0x20b4;}' unless defined(&EMR);
    eval 'sub ESR () {0x20b8;}' unless defined(&ESR);
    eval 'sub GM45_ERROR_PAGE_TABLE () {(1<<5);}' unless defined(&GM45_ERROR_PAGE_TABLE);
    eval 'sub GM45_ERROR_MEM_PRIV () {(1<<4);}' unless defined(&GM45_ERROR_MEM_PRIV);
    eval 'sub I915_ERROR_PAGE_TABLE () {(1<<4);}' unless defined(&I915_ERROR_PAGE_TABLE);
    eval 'sub GM45_ERROR_CP_PRIV () {(1<<3);}' unless defined(&GM45_ERROR_CP_PRIV);
    eval 'sub I915_ERROR_MEMORY_REFRESH () {(1<<1);}' unless defined(&I915_ERROR_MEMORY_REFRESH);
    eval 'sub I915_ERROR_INSTRUCTION () {(1<<0);}' unless defined(&I915_ERROR_INSTRUCTION);
    eval 'sub INSTPM () {0x20c0;}' unless defined(&INSTPM);
    eval 'sub INSTPM_SELF_EN () {(1<<12);}' unless defined(&INSTPM_SELF_EN);
    eval 'sub INSTPM_AGPBUSY_DIS () {(1<<11);}' unless defined(&INSTPM_AGPBUSY_DIS);
    eval 'sub INSTPM_FORCE_ORDERING () {(1<<7);}' unless defined(&INSTPM_FORCE_ORDERING);
    eval 'sub ACTHD () {0x20c8;}' unless defined(&ACTHD);
    eval 'sub FW_BLC () {0x20d8;}' unless defined(&FW_BLC);
    eval 'sub FW_BLC2 () {0x20dc;}' unless defined(&FW_BLC2);
    eval 'sub FW_BLC_SELF () {0x20e0;}' unless defined(&FW_BLC_SELF);
    eval 'sub FW_BLC_SELF_EN_MASK () {(1<<31);}' unless defined(&FW_BLC_SELF_EN_MASK);
    eval 'sub FW_BLC_SELF_FIFO_MASK () {(1<<16);}' unless defined(&FW_BLC_SELF_FIFO_MASK);
    eval 'sub FW_BLC_SELF_EN () {(1<<15);}' unless defined(&FW_BLC_SELF_EN);
    eval 'sub MM_BURST_LENGTH () {0x700000;}' unless defined(&MM_BURST_LENGTH);
    eval 'sub MM_FIFO_WATERMARK () {0x1f000;}' unless defined(&MM_FIFO_WATERMARK);
    eval 'sub LM_BURST_LENGTH () {0x700;}' unless defined(&LM_BURST_LENGTH);
    eval 'sub LM_FIFO_WATERMARK () {0x1f;}' unless defined(&LM_FIFO_WATERMARK);
    eval 'sub MI_ARB_STATE () {0x20e4;}' unless defined(&MI_ARB_STATE);
    eval 'sub MI_ARB_MASK_SHIFT () {16;}' unless defined(&MI_ARB_MASK_SHIFT);
    eval 'sub MI_ARB_RENDER_TLB_LOW_PRIORITY () {(1<< 15);}' unless defined(&MI_ARB_RENDER_TLB_LOW_PRIORITY);
    eval 'sub MI_ARB_ISOCH_WAIT_GTT () {(1<< 14);}' unless defined(&MI_ARB_ISOCH_WAIT_GTT);
    eval 'sub MI_ARB_BLOCK_GRANT_MASK () {(3<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_MASK);
    eval 'sub MI_ARB_BLOCK_GRANT_8 () {(0<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_8);
    eval 'sub MI_ARB_BLOCK_GRANT_4 () {(1<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_4);
    eval 'sub MI_ARB_BLOCK_GRANT_2 () {(2<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_2);
    eval 'sub MI_ARB_BLOCK_GRANT_0 () {(3<< 12);}' unless defined(&MI_ARB_BLOCK_GRANT_0);
    eval 'sub MI_ARB_C3_LP_WRITE_ENABLE () {(1<< 11);}' unless defined(&MI_ARB_C3_LP_WRITE_ENABLE);
    eval 'sub MI_ARB_ASYNC_FLIP_ACK_IMMEDIATE () {(1<< 10);}' unless defined(&MI_ARB_ASYNC_FLIP_ACK_IMMEDIATE);
    eval 'sub MI_ARB_DUAL_DATA_PHASE_DISABLE () {(1<< 9);}' unless defined(&MI_ARB_DUAL_DATA_PHASE_DISABLE);
    eval 'sub MI_ARB_CACHE_SNOOP_DISABLE () {(1<< 8);}' unless defined(&MI_ARB_CACHE_SNOOP_DISABLE);
    eval 'sub MI_ARB_TIME_SLICE_MASK () {(7<< 5);}' unless defined(&MI_ARB_TIME_SLICE_MASK);
    eval 'sub MI_ARB_TIME_SLICE_1 () {(0<< 5);}' unless defined(&MI_ARB_TIME_SLICE_1);
    eval 'sub MI_ARB_TIME_SLICE_2 () {(1<< 5);}' unless defined(&MI_ARB_TIME_SLICE_2);
    eval 'sub MI_ARB_TIME_SLICE_4 () {(2<< 5);}' unless defined(&MI_ARB_TIME_SLICE_4);
    eval 'sub MI_ARB_TIME_SLICE_6 () {(3<< 5);}' unless defined(&MI_ARB_TIME_SLICE_6);
    eval 'sub MI_ARB_TIME_SLICE_8 () {(4<< 5);}' unless defined(&MI_ARB_TIME_SLICE_8);
    eval 'sub MI_ARB_TIME_SLICE_10 () {(5<< 5);}' unless defined(&MI_ARB_TIME_SLICE_10);
    eval 'sub MI_ARB_TIME_SLICE_14 () {(6<< 5);}' unless defined(&MI_ARB_TIME_SLICE_14);
    eval 'sub MI_ARB_TIME_SLICE_16 () {(7<< 5);}' unless defined(&MI_ARB_TIME_SLICE_16);
    eval 'sub MI_ARB_LOW_PRIORITY_GRACE_4KB () {(0<< 4);}' unless defined(&MI_ARB_LOW_PRIORITY_GRACE_4KB);
    eval 'sub MI_ARB_LOW_PRIORITY_GRACE_8KB () {(1<< 4);}' unless defined(&MI_ARB_LOW_PRIORITY_GRACE_8KB);
    eval 'sub MI_ARB_DISPLAY_TRICKLE_FEED_DISABLE () {(1<< 2);}' unless defined(&MI_ARB_DISPLAY_TRICKLE_FEED_DISABLE);
    eval 'sub MI_ARB_DISPLAY_PRIORITY_A_B () {(0<< 0);}' unless defined(&MI_ARB_DISPLAY_PRIORITY_A_B);
    eval 'sub MI_ARB_DISPLAY_PRIORITY_B_A () {(1<< 0);}' unless defined(&MI_ARB_DISPLAY_PRIORITY_B_A);
    eval 'sub CACHE_MODE_0 () {0x2120;}' unless defined(&CACHE_MODE_0);
    eval 'sub CM0_MASK_SHIFT () {16;}' unless defined(&CM0_MASK_SHIFT);
    eval 'sub CM0_IZ_OPT_DISABLE () {(1<<6);}' unless defined(&CM0_IZ_OPT_DISABLE);
    eval 'sub CM0_ZR_OPT_DISABLE () {(1<<5);}' unless defined(&CM0_ZR_OPT_DISABLE);
    eval 'sub CM0_STC_EVICT_DISABLE_LRA_SNB () {(1<<5);}' unless defined(&CM0_STC_EVICT_DISABLE_LRA_SNB);
    eval 'sub CM0_DEPTH_EVICT_DISABLE () {(1<<4);}' unless defined(&CM0_DEPTH_EVICT_DISABLE);
    eval 'sub CM0_COLOR_EVICT_DISABLE () {(1<<3);}' unless defined(&CM0_COLOR_EVICT_DISABLE);
    eval 'sub CM0_DEPTH_WRITE_DISABLE () {(1<<1);}' unless defined(&CM0_DEPTH_WRITE_DISABLE);
    eval 'sub CM0_RC_OP_FLUSH_DISABLE () {(1<<0);}' unless defined(&CM0_RC_OP_FLUSH_DISABLE);
    eval 'sub BB_ADDR () {0x2140;}' unless defined(&BB_ADDR);
    eval 'sub GFX_FLSH_CNTL () {0x2170;}' unless defined(&GFX_FLSH_CNTL);
    eval 'sub ECOSKPD () {0x21d0;}' unless defined(&ECOSKPD);
    eval 'sub ECO_GATING_CX_ONLY () {(1<<3);}' unless defined(&ECO_GATING_CX_ONLY);
    eval 'sub ECO_FLIP_DONE () {(1<<0);}' unless defined(&ECO_FLIP_DONE);
    eval 'sub GEN6_RENDER_HWSTAM () {0x2098;}' unless defined(&GEN6_RENDER_HWSTAM);
    eval 'sub GEN6_RENDER_IMR () {0x20a8;}' unless defined(&GEN6_RENDER_IMR);
    eval 'sub GEN6_RENDER_CONTEXT_SWITCH_INTERRUPT () {(1<< 8);}' unless defined(&GEN6_RENDER_CONTEXT_SWITCH_INTERRUPT);
    eval 'sub GEN6_RENDER_PPGTT_PAGE_FAULT () {(1<< 7);}' unless defined(&GEN6_RENDER_PPGTT_PAGE_FAULT);
    eval 'sub GEN6_RENDER_TIMEOUT_COUNTER_EXPIRED () {(1<< 6);}' unless defined(&GEN6_RENDER_TIMEOUT_COUNTER_EXPIRED);
    eval 'sub GEN6_RENDER_L3_PARITY_ERROR () {(1<< 5);}' unless defined(&GEN6_RENDER_L3_PARITY_ERROR);
    eval 'sub GEN6_RENDER_PIPE_CONTROL_NOTIFY_INTERRUPT () {(1<< 4);}' unless defined(&GEN6_RENDER_PIPE_CONTROL_NOTIFY_INTERRUPT);
    eval 'sub GEN6_RENDER_COMMAND_PARSER_MASTER_ERROR () {(1<< 3);}' unless defined(&GEN6_RENDER_COMMAND_PARSER_MASTER_ERROR);
    eval 'sub GEN6_RENDER_SYNC_STATUS () {(1<< 2);}' unless defined(&GEN6_RENDER_SYNC_STATUS);
    eval 'sub GEN6_RENDER_DEBUG_INTERRUPT () {(1<< 1);}' unless defined(&GEN6_RENDER_DEBUG_INTERRUPT);
    eval 'sub GEN6_RENDER_USER_INTERRUPT () {(1<< 0);}' unless defined(&GEN6_RENDER_USER_INTERRUPT);
    eval 'sub GEN6_BLITTER_HWSTAM () {0x22098;}' unless defined(&GEN6_BLITTER_HWSTAM);
    eval 'sub GEN6_BLITTER_IMR () {0x220a8;}' unless defined(&GEN6_BLITTER_IMR);
    eval 'sub GEN6_BLITTER_MI_FLUSH_DW_NOTIFY_INTERRUPT () {(1<< 26);}' unless defined(&GEN6_BLITTER_MI_FLUSH_DW_NOTIFY_INTERRUPT);
    eval 'sub GEN6_BLITTER_COMMAND_PARSER_MASTER_ERROR () {(1<< 25);}' unless defined(&GEN6_BLITTER_COMMAND_PARSER_MASTER_ERROR);
    eval 'sub GEN6_BLITTER_SYNC_STATUS () {(1<< 24);}' unless defined(&GEN6_BLITTER_SYNC_STATUS);
    eval 'sub GEN6_BLITTER_USER_INTERRUPT () {(1<< 22);}' unless defined(&GEN6_BLITTER_USER_INTERRUPT);
    eval 'sub GEN6_BLITTER_ECOSKPD () {0x221d0;}' unless defined(&GEN6_BLITTER_ECOSKPD);
    eval 'sub GEN6_BLITTER_LOCK_SHIFT () {16;}' unless defined(&GEN6_BLITTER_LOCK_SHIFT);
    eval 'sub GEN6_BLITTER_FBC_NOTIFY () {(1<<3);}' unless defined(&GEN6_BLITTER_FBC_NOTIFY);
    eval 'sub GEN6_BSD_SLEEP_PSMI_CONTROL () {0x12050;}' unless defined(&GEN6_BSD_SLEEP_PSMI_CONTROL);
    eval 'sub GEN6_BSD_SLEEP_PSMI_CONTROL_RC_ILDL_MESSAGE_MODIFY_MASK () {(1<< 16);}' unless defined(&GEN6_BSD_SLEEP_PSMI_CONTROL_RC_ILDL_MESSAGE_MODIFY_MASK);
    eval 'sub GEN6_BSD_SLEEP_PSMI_CONTROL_RC_ILDL_MESSAGE_DISABLE () {(1<< 0);}' unless defined(&GEN6_BSD_SLEEP_PSMI_CONTROL_RC_ILDL_MESSAGE_DISABLE);
    eval 'sub GEN6_BSD_SLEEP_PSMI_CONTROL_RC_ILDL_MESSAGE_ENABLE () {0;}' unless defined(&GEN6_BSD_SLEEP_PSMI_CONTROL_RC_ILDL_MESSAGE_ENABLE);
    eval 'sub GEN6_BSD_SLEEP_PSMI_CONTROL_IDLE_INDICATOR () {(1<< 3);}' unless defined(&GEN6_BSD_SLEEP_PSMI_CONTROL_IDLE_INDICATOR);
    eval 'sub GEN6_BSD_HWSTAM () {0x12098;}' unless defined(&GEN6_BSD_HWSTAM);
    eval 'sub GEN6_BSD_IMR () {0x120a8;}' unless defined(&GEN6_BSD_IMR);
    eval 'sub GEN6_BSD_USER_INTERRUPT () {(1<< 12);}' unless defined(&GEN6_BSD_USER_INTERRUPT);
    eval 'sub GEN6_BSD_RNCID () {0x12198;}' unless defined(&GEN6_BSD_RNCID);
    eval 'sub FBC_CFB_BASE () {0x3200;}' unless defined(&FBC_CFB_BASE);
    eval 'sub FBC_LL_BASE () {0x3204;}' unless defined(&FBC_LL_BASE);
    eval 'sub FBC_CONTROL () {0x3208;}' unless defined(&FBC_CONTROL);
    eval 'sub FBC_CTL_EN () {(1<<31);}' unless defined(&FBC_CTL_EN);
    eval 'sub FBC_CTL_PERIODIC () {(1<<30);}' unless defined(&FBC_CTL_PERIODIC);
    eval 'sub FBC_CTL_INTERVAL_SHIFT () {(16);}' unless defined(&FBC_CTL_INTERVAL_SHIFT);
    eval 'sub FBC_CTL_UNCOMPRESSIBLE () {(1<<14);}' unless defined(&FBC_CTL_UNCOMPRESSIBLE);
    eval 'sub FBC_CTL_C3_IDLE () {(1<<13);}' unless defined(&FBC_CTL_C3_IDLE);
    eval 'sub FBC_CTL_STRIDE_SHIFT () {(5);}' unless defined(&FBC_CTL_STRIDE_SHIFT);
    eval 'sub FBC_CTL_FENCENO () {(1<<0);}' unless defined(&FBC_CTL_FENCENO);
    eval 'sub FBC_COMMAND () {0x320c;}' unless defined(&FBC_COMMAND);
    eval 'sub FBC_CMD_COMPRESS () {(1<<0);}' unless defined(&FBC_CMD_COMPRESS);
    eval 'sub FBC_STATUS () {0x3210;}' unless defined(&FBC_STATUS);
    eval 'sub FBC_STAT_COMPRESSING () {(1<<31);}' unless defined(&FBC_STAT_COMPRESSING);
    eval 'sub FBC_STAT_COMPRESSED () {(1<<30);}' unless defined(&FBC_STAT_COMPRESSED);
    eval 'sub FBC_STAT_MODIFIED () {(1<<29);}' unless defined(&FBC_STAT_MODIFIED);
    eval 'sub FBC_STAT_CURRENT_LINE () {(1<<0);}' unless defined(&FBC_STAT_CURRENT_LINE);
    eval 'sub FBC_CONTROL2 () {0x3214;}' unless defined(&FBC_CONTROL2);
    eval 'sub FBC_CTL_FENCE_DBL () {(0<<4);}' unless defined(&FBC_CTL_FENCE_DBL);
    eval 'sub FBC_CTL_IDLE_IMM () {(0<<2);}' unless defined(&FBC_CTL_IDLE_IMM);
    eval 'sub FBC_CTL_IDLE_FULL () {(1<<2);}' unless defined(&FBC_CTL_IDLE_FULL);
    eval 'sub FBC_CTL_IDLE_LINE () {(2<<2);}' unless defined(&FBC_CTL_IDLE_LINE);
    eval 'sub FBC_CTL_IDLE_DEBUG () {(3<<2);}' unless defined(&FBC_CTL_IDLE_DEBUG);
    eval 'sub FBC_CTL_CPU_FENCE () {(1<<1);}' unless defined(&FBC_CTL_CPU_FENCE);
    eval 'sub FBC_CTL_PLANEA () {(0<<0);}' unless defined(&FBC_CTL_PLANEA);
    eval 'sub FBC_CTL_PLANEB () {(1<<0);}' unless defined(&FBC_CTL_PLANEB);
    eval 'sub FBC_FENCE_OFF () {0x321b;}' unless defined(&FBC_FENCE_OFF);
    eval 'sub FBC_TAG () {0x3300;}' unless defined(&FBC_TAG);
    eval 'sub FBC_LL_SIZE () {(1536);}' unless defined(&FBC_LL_SIZE);
    eval 'sub DPFC_CB_BASE () {0x3200;}' unless defined(&DPFC_CB_BASE);
    eval 'sub DPFC_CONTROL () {0x3208;}' unless defined(&DPFC_CONTROL);
    eval 'sub DPFC_CTL_EN () {(1<<31);}' unless defined(&DPFC_CTL_EN);
    eval 'sub DPFC_CTL_PLANEA () {(0<<30);}' unless defined(&DPFC_CTL_PLANEA);
    eval 'sub DPFC_CTL_PLANEB () {(1<<30);}' unless defined(&DPFC_CTL_PLANEB);
    eval 'sub DPFC_CTL_FENCE_EN () {(1<<29);}' unless defined(&DPFC_CTL_FENCE_EN);
    eval 'sub DPFC_CTL_PERSISTENT_MODE () {(1<<25);}' unless defined(&DPFC_CTL_PERSISTENT_MODE);
    eval 'sub DPFC_SR_EN () {(1<<10);}' unless defined(&DPFC_SR_EN);
    eval 'sub DPFC_CTL_LIMIT_1X () {(0<<6);}' unless defined(&DPFC_CTL_LIMIT_1X);
    eval 'sub DPFC_CTL_LIMIT_2X () {(1<<6);}' unless defined(&DPFC_CTL_LIMIT_2X);
    eval 'sub DPFC_CTL_LIMIT_4X () {(2<<6);}' unless defined(&DPFC_CTL_LIMIT_4X);
    eval 'sub DPFC_RECOMP_CTL () {0x320c;}' unless defined(&DPFC_RECOMP_CTL);
    eval 'sub DPFC_RECOMP_STALL_EN () {(1<<27);}' unless defined(&DPFC_RECOMP_STALL_EN);
    eval 'sub DPFC_RECOMP_STALL_WM_SHIFT () {(16);}' unless defined(&DPFC_RECOMP_STALL_WM_SHIFT);
    eval 'sub DPFC_RECOMP_STALL_WM_MASK () {(0x7ff0000);}' unless defined(&DPFC_RECOMP_STALL_WM_MASK);
    eval 'sub DPFC_RECOMP_TIMER_COUNT_SHIFT () {(0);}' unless defined(&DPFC_RECOMP_TIMER_COUNT_SHIFT);
    eval 'sub DPFC_RECOMP_TIMER_COUNT_MASK () {(0x3f);}' unless defined(&DPFC_RECOMP_TIMER_COUNT_MASK);
    eval 'sub DPFC_STATUS () {0x3210;}' unless defined(&DPFC_STATUS);
    eval 'sub DPFC_INVAL_SEG_SHIFT () {(16);}' unless defined(&DPFC_INVAL_SEG_SHIFT);
    eval 'sub DPFC_INVAL_SEG_MASK () {(0x7ff0000);}' unless defined(&DPFC_INVAL_SEG_MASK);
    eval 'sub DPFC_COMP_SEG_SHIFT () {(0);}' unless defined(&DPFC_COMP_SEG_SHIFT);
    eval 'sub DPFC_COMP_SEG_MASK () {(0x3ff);}' unless defined(&DPFC_COMP_SEG_MASK);
    eval 'sub DPFC_STATUS2 () {0x3214;}' unless defined(&DPFC_STATUS2);
    eval 'sub DPFC_FENCE_YOFF () {0x3218;}' unless defined(&DPFC_FENCE_YOFF);
    eval 'sub DPFC_CHICKEN () {0x3224;}' unless defined(&DPFC_CHICKEN);
    eval 'sub DPFC_HT_MODIFY () {(1<<31);}' unless defined(&DPFC_HT_MODIFY);
    eval 'sub ILK_DPFC_CB_BASE () {0x43200;}' unless defined(&ILK_DPFC_CB_BASE);
    eval 'sub ILK_DPFC_CONTROL () {0x43208;}' unless defined(&ILK_DPFC_CONTROL);
    eval 'sub DPFC_RESERVED () {(0x1fffff00);}' unless defined(&DPFC_RESERVED);
    eval 'sub ILK_DPFC_RECOMP_CTL () {0x4320c;}' unless defined(&ILK_DPFC_RECOMP_CTL);
    eval 'sub ILK_DPFC_STATUS () {0x43210;}' unless defined(&ILK_DPFC_STATUS);
    eval 'sub ILK_DPFC_FENCE_YOFF () {0x43218;}' unless defined(&ILK_DPFC_FENCE_YOFF);
    eval 'sub ILK_DPFC_CHICKEN () {0x43224;}' unless defined(&ILK_DPFC_CHICKEN);
    eval 'sub ILK_FBC_RT_BASE () {0x2128;}' unless defined(&ILK_FBC_RT_BASE);
    eval 'sub ILK_FBC_RT_VALID () {(1<<0);}' unless defined(&ILK_FBC_RT_VALID);
    eval 'sub ILK_DISPLAY_CHICKEN1 () {0x42000;}' unless defined(&ILK_DISPLAY_CHICKEN1);
    eval 'sub ILK_FBCQ_DIS () {(1<<22);}' unless defined(&ILK_FBCQ_DIS);
    eval 'sub ILK_PABSTRETCH_DIS () {(1<<21);}' unless defined(&ILK_PABSTRETCH_DIS);
    eval 'sub SNB_DPFC_CTL_SA () {0x100100;}' unless defined(&SNB_DPFC_CTL_SA);
    eval 'sub SNB_CPU_FENCE_ENABLE () {(1<<29);}' unless defined(&SNB_CPU_FENCE_ENABLE);
    eval 'sub DPFC_CPU_FENCE_OFFSET () {0x100104;}' unless defined(&DPFC_CPU_FENCE_OFFSET);
    eval 'sub GPIOA () {0x5010;}' unless defined(&GPIOA);
    eval 'sub GPIOB () {0x5014;}' unless defined(&GPIOB);
    eval 'sub GPIOC () {0x5018;}' unless defined(&GPIOC);
    eval 'sub GPIOD () {0x501c;}' unless defined(&GPIOD);
    eval 'sub GPIOE () {0x5020;}' unless defined(&GPIOE);
    eval 'sub GPIOF () {0x5024;}' unless defined(&GPIOF);
    eval 'sub GPIOG () {0x5028;}' unless defined(&GPIOG);
    eval 'sub GPIOH () {0x502c;}' unless defined(&GPIOH);
    eval 'sub GPIO_CLOCK_DIR_MASK () {(1<< 0);}' unless defined(&GPIO_CLOCK_DIR_MASK);
    eval 'sub GPIO_CLOCK_DIR_IN () {(0<< 1);}' unless defined(&GPIO_CLOCK_DIR_IN);
    eval 'sub GPIO_CLOCK_DIR_OUT () {(1<< 1);}' unless defined(&GPIO_CLOCK_DIR_OUT);
    eval 'sub GPIO_CLOCK_VAL_MASK () {(1<< 2);}' unless defined(&GPIO_CLOCK_VAL_MASK);
    eval 'sub GPIO_CLOCK_VAL_OUT () {(1<< 3);}' unless defined(&GPIO_CLOCK_VAL_OUT);
    eval 'sub GPIO_CLOCK_VAL_IN () {(1<< 4);}' unless defined(&GPIO_CLOCK_VAL_IN);
    eval 'sub GPIO_CLOCK_PULLUP_DISABLE () {(1<< 5);}' unless defined(&GPIO_CLOCK_PULLUP_DISABLE);
    eval 'sub GPIO_DATA_DIR_MASK () {(1<< 8);}' unless defined(&GPIO_DATA_DIR_MASK);
    eval 'sub GPIO_DATA_DIR_IN () {(0<< 9);}' unless defined(&GPIO_DATA_DIR_IN);
    eval 'sub GPIO_DATA_DIR_OUT () {(1<< 9);}' unless defined(&GPIO_DATA_DIR_OUT);
    eval 'sub GPIO_DATA_VAL_MASK () {(1<< 10);}' unless defined(&GPIO_DATA_VAL_MASK);
    eval 'sub GPIO_DATA_VAL_OUT () {(1<< 11);}' unless defined(&GPIO_DATA_VAL_OUT);
    eval 'sub GPIO_DATA_VAL_IN () {(1<< 12);}' unless defined(&GPIO_DATA_VAL_IN);
    eval 'sub GPIO_DATA_PULLUP_DISABLE () {(1<< 13);}' unless defined(&GPIO_DATA_PULLUP_DISABLE);
    eval 'sub GMBUS0 () {0x5100;}' unless defined(&GMBUS0);
    eval 'sub GMBUS_RATE_100KHZ () {(0<<8);}' unless defined(&GMBUS_RATE_100KHZ);
    eval 'sub GMBUS_RATE_50KHZ () {(1<<8);}' unless defined(&GMBUS_RATE_50KHZ);
    eval 'sub GMBUS_RATE_400KHZ () {(2<<8);}' unless defined(&GMBUS_RATE_400KHZ);
    eval 'sub GMBUS_RATE_1MHZ () {(3<<8);}' unless defined(&GMBUS_RATE_1MHZ);
    eval 'sub GMBUS_HOLD_EXT () {(1<<7);}' unless defined(&GMBUS_HOLD_EXT);
    eval 'sub GMBUS_PORT_DISABLED () {0;}' unless defined(&GMBUS_PORT_DISABLED);
    eval 'sub GMBUS_PORT_SSC () {1;}' unless defined(&GMBUS_PORT_SSC);
    eval 'sub GMBUS_PORT_VGADDC () {2;}' unless defined(&GMBUS_PORT_VGADDC);
    eval 'sub GMBUS_PORT_PANEL () {3;}' unless defined(&GMBUS_PORT_PANEL);
    eval 'sub GMBUS_PORT_DPC () {4;}' unless defined(&GMBUS_PORT_DPC);
    eval 'sub GMBUS_PORT_DPB () {5;}' unless defined(&GMBUS_PORT_DPB);
    eval 'sub GMBUS_PORT_DPD () {7;}' unless defined(&GMBUS_PORT_DPD);
    eval 'sub GMBUS_NUM_PORTS () {8;}' unless defined(&GMBUS_NUM_PORTS);
    eval 'sub GMBUS1 () {0x5104;}' unless defined(&GMBUS1);
    eval 'sub GMBUS_SW_CLR_INT () {(1<<31);}' unless defined(&GMBUS_SW_CLR_INT);
    eval 'sub GMBUS_SW_RDY () {(1<<30);}' unless defined(&GMBUS_SW_RDY);
    eval 'sub GMBUS_ENT () {(1<<29);}' unless defined(&GMBUS_ENT);
    eval 'sub GMBUS_CYCLE_NONE () {(0<<25);}' unless defined(&GMBUS_CYCLE_NONE);
    eval 'sub GMBUS_CYCLE_WAIT () {(1<<25);}' unless defined(&GMBUS_CYCLE_WAIT);
    eval 'sub GMBUS_CYCLE_INDEX () {(2<<25);}' unless defined(&GMBUS_CYCLE_INDEX);
    eval 'sub GMBUS_CYCLE_STOP () {(4<<25);}' unless defined(&GMBUS_CYCLE_STOP);
    eval 'sub GMBUS_BYTE_COUNT_SHIFT () {16;}' unless defined(&GMBUS_BYTE_COUNT_SHIFT);
    eval 'sub GMBUS_SLAVE_INDEX_SHIFT () {8;}' unless defined(&GMBUS_SLAVE_INDEX_SHIFT);
    eval 'sub GMBUS_SLAVE_ADDR_SHIFT () {1;}' unless defined(&GMBUS_SLAVE_ADDR_SHIFT);
    eval 'sub GMBUS_SLAVE_READ () {(1<<0);}' unless defined(&GMBUS_SLAVE_READ);
    eval 'sub GMBUS_SLAVE_WRITE () {(0<<0);}' unless defined(&GMBUS_SLAVE_WRITE);
    eval 'sub GMBUS2 () {0x5108;}' unless defined(&GMBUS2);
    eval 'sub GMBUS_INUSE () {(1<<15);}' unless defined(&GMBUS_INUSE);
    eval 'sub GMBUS_HW_WAIT_PHASE () {(1<<14);}' unless defined(&GMBUS_HW_WAIT_PHASE);
    eval 'sub GMBUS_STALL_TIMEOUT () {(1<<13);}' unless defined(&GMBUS_STALL_TIMEOUT);
    eval 'sub GMBUS_INT () {(1<<12);}' unless defined(&GMBUS_INT);
    eval 'sub GMBUS_HW_RDY () {(1<<11);}' unless defined(&GMBUS_HW_RDY);
    eval 'sub GMBUS_SATOER () {(1<<10);}' unless defined(&GMBUS_SATOER);
    eval 'sub GMBUS_ACTIVE () {(1<<9);}' unless defined(&GMBUS_ACTIVE);
    eval 'sub GMBUS3 () {0x510c;}' unless defined(&GMBUS3);
    eval 'sub GMBUS4 () {0x5110;}' unless defined(&GMBUS4);
    eval 'sub GMBUS_SLAVE_TIMEOUT_EN () {(1<<4);}' unless defined(&GMBUS_SLAVE_TIMEOUT_EN);
    eval 'sub GMBUS_NAK_EN () {(1<<3);}' unless defined(&GMBUS_NAK_EN);
    eval 'sub GMBUS_IDLE_EN () {(1<<2);}' unless defined(&GMBUS_IDLE_EN);
    eval 'sub GMBUS_HW_WAIT_EN () {(1<<1);}' unless defined(&GMBUS_HW_WAIT_EN);
    eval 'sub GMBUS_HW_RDY_EN () {(1<<0);}' unless defined(&GMBUS_HW_RDY_EN);
    eval 'sub GMBUS5 () {0x5120;}' unless defined(&GMBUS5);
    eval 'sub GMBUS_2BYTE_INDEX_EN () {(1<<31);}' unless defined(&GMBUS_2BYTE_INDEX_EN);
    eval 'sub VGA0 () {0x6000;}' unless defined(&VGA0);
    eval 'sub VGA1 () {0x6004;}' unless defined(&VGA1);
    eval 'sub VGA_PD () {0x6010;}' unless defined(&VGA_PD);
    eval 'sub VGA0_PD_P2_DIV_4 () {(1<< 7);}' unless defined(&VGA0_PD_P2_DIV_4);
    eval 'sub VGA0_PD_P1_DIV_2 () {(1<< 5);}' unless defined(&VGA0_PD_P1_DIV_2);
    eval 'sub VGA0_PD_P1_SHIFT () {0;}' unless defined(&VGA0_PD_P1_SHIFT);
    eval 'sub VGA0_PD_P1_MASK () {(0x1f << 0);}' unless defined(&VGA0_PD_P1_MASK);
    eval 'sub VGA1_PD_P2_DIV_4 () {(1<< 15);}' unless defined(&VGA1_PD_P2_DIV_4);
    eval 'sub VGA1_PD_P1_DIV_2 () {(1<< 13);}' unless defined(&VGA1_PD_P1_DIV_2);
    eval 'sub VGA1_PD_P1_SHIFT () {8;}' unless defined(&VGA1_PD_P1_SHIFT);
    eval 'sub VGA1_PD_P1_MASK () {(0x1f << 8);}' unless defined(&VGA1_PD_P1_MASK);
    eval 'sub _DPLL_A () {0x6014;}' unless defined(&_DPLL_A);
    eval 'sub _DPLL_B () {0x6018;}' unless defined(&_DPLL_B);
    eval 'sub DPLL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DPLL_A,  &_DPLL_B));
    }' unless defined(&DPLL);
    eval 'sub DPLL_VCO_ENABLE () {(1<< 31);}' unless defined(&DPLL_VCO_ENABLE);
    eval 'sub DPLL_DVO_HIGH_SPEED () {(1<< 30);}' unless defined(&DPLL_DVO_HIGH_SPEED);
    eval 'sub DPLL_SYNCLOCK_ENABLE () {(1<< 29);}' unless defined(&DPLL_SYNCLOCK_ENABLE);
    eval 'sub DPLL_VGA_MODE_DIS () {(1<< 28);}' unless defined(&DPLL_VGA_MODE_DIS);
    eval 'sub DPLLB_MODE_DAC_SERIAL () {(1<< 26);}' unless defined(&DPLLB_MODE_DAC_SERIAL);
    eval 'sub DPLLB_MODE_LVDS () {(2<< 26);}' unless defined(&DPLLB_MODE_LVDS);
    eval 'sub DPLL_MODE_MASK () {(3<< 26);}' unless defined(&DPLL_MODE_MASK);
    eval 'sub DPLL_DAC_SERIAL_P2_CLOCK_DIV_10 () {(0<< 24);}' unless defined(&DPLL_DAC_SERIAL_P2_CLOCK_DIV_10);
    eval 'sub DPLL_DAC_SERIAL_P2_CLOCK_DIV_5 () {(1<< 24);}' unless defined(&DPLL_DAC_SERIAL_P2_CLOCK_DIV_5);
    eval 'sub DPLLB_LVDS_P2_CLOCK_DIV_14 () {(0<< 24);}' unless defined(&DPLLB_LVDS_P2_CLOCK_DIV_14);
    eval 'sub DPLLB_LVDS_P2_CLOCK_DIV_7 () {(1<< 24);}' unless defined(&DPLLB_LVDS_P2_CLOCK_DIV_7);
    eval 'sub DPLL_P2_CLOCK_DIV_MASK () {0x3000000;}' unless defined(&DPLL_P2_CLOCK_DIV_MASK);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK () {0xff0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_PINEVIEW () {0xff8000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_PINEVIEW);
    eval 'sub SRX_INDEX () {0x3c4;}' unless defined(&SRX_INDEX);
    eval 'sub SRX_DATA () {0x3c5;}' unless defined(&SRX_DATA);
    eval 'sub SR01 () {1;}' unless defined(&SR01);
    eval 'sub SR01_SCREEN_OFF () {(1<<5);}' unless defined(&SR01_SCREEN_OFF);
    eval 'sub PPCR () {0x61204;}' unless defined(&PPCR);
    eval 'sub PPCR_ON () {(1<<0);}' unless defined(&PPCR_ON);
    eval 'sub DVOB () {0x61140;}' unless defined(&DVOB);
    eval 'sub DVOB_ON () {(1<<31);}' unless defined(&DVOB_ON);
    eval 'sub DVOC () {0x61160;}' unless defined(&DVOC);
    eval 'sub DVOC_ON () {(1<<31);}' unless defined(&DVOC_ON);
    eval 'sub LVDS () {0x61180;}' unless defined(&LVDS);
    eval 'sub LVDS_ON () {(1<<31);}' unless defined(&LVDS_ON);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_I830 () {0x1f0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_I830);
    eval 'sub DPLL_FPA01_P1_POST_DIV_MASK_I830_LVDS () {0x3f0000;}' unless defined(&DPLL_FPA01_P1_POST_DIV_MASK_I830_LVDS);
    eval 'sub DPLL_FPA01_P1_POST_DIV_SHIFT () {16;}' unless defined(&DPLL_FPA01_P1_POST_DIV_SHIFT);
    eval 'sub DPLL_FPA01_P1_POST_DIV_SHIFT_PINEVIEW () {15;}' unless defined(&DPLL_FPA01_P1_POST_DIV_SHIFT_PINEVIEW);
    eval 'sub PLL_P2_DIVIDE_BY_4 () {(1<< 23);}' unless defined(&PLL_P2_DIVIDE_BY_4);
    eval 'sub PLL_P1_DIVIDE_BY_TWO () {(1<< 21);}' unless defined(&PLL_P1_DIVIDE_BY_TWO);
    eval 'sub PLL_REF_INPUT_DREFCLK () {(0<< 13);}' unless defined(&PLL_REF_INPUT_DREFCLK);
    eval 'sub PLL_REF_INPUT_TVCLKINA () {(1<< 13);}' unless defined(&PLL_REF_INPUT_TVCLKINA);
    eval 'sub PLL_REF_INPUT_TVCLKINBC () {(2<< 13);}' unless defined(&PLL_REF_INPUT_TVCLKINBC);
    eval 'sub PLLB_REF_INPUT_SPREADSPECTRUMIN () {(3<< 13);}' unless defined(&PLLB_REF_INPUT_SPREADSPECTRUMIN);
    eval 'sub PLL_REF_INPUT_MASK () {(3<< 13);}' unless defined(&PLL_REF_INPUT_MASK);
    eval 'sub PLL_LOAD_PULSE_PHASE_SHIFT () {9;}' unless defined(&PLL_LOAD_PULSE_PHASE_SHIFT);
    eval 'sub PLL_REF_SDVO_HDMI_MULTIPLIER_SHIFT () {9;}' unless defined(&PLL_REF_SDVO_HDMI_MULTIPLIER_SHIFT);
    eval 'sub PLL_REF_SDVO_HDMI_MULTIPLIER_MASK () {(7<< 9);}' unless defined(&PLL_REF_SDVO_HDMI_MULTIPLIER_MASK);
    eval 'sub PLL_REF_SDVO_HDMI_MULTIPLIER {
        my($x) = @_;
	    eval q(((($x)-1) << 9));
    }' unless defined(&PLL_REF_SDVO_HDMI_MULTIPLIER);
    eval 'sub DPLL_FPA1_P1_POST_DIV_SHIFT () {0;}' unless defined(&DPLL_FPA1_P1_POST_DIV_SHIFT);
    eval 'sub DPLL_FPA1_P1_POST_DIV_MASK () {0xff;}' unless defined(&DPLL_FPA1_P1_POST_DIV_MASK);
    eval 'sub PLL_LOAD_PULSE_PHASE_MASK () {(0xf <<  &PLL_LOAD_PULSE_PHASE_SHIFT);}' unless defined(&PLL_LOAD_PULSE_PHASE_MASK);
    eval 'sub DISPLAY_RATE_SELECT_FPA1 () {(1<< 8);}' unless defined(&DISPLAY_RATE_SELECT_FPA1);
    eval 'sub SDVO_MULTIPLIER_MASK () {0xff;}' unless defined(&SDVO_MULTIPLIER_MASK);
    eval 'sub SDVO_MULTIPLIER_SHIFT_HIRES () {4;}' unless defined(&SDVO_MULTIPLIER_SHIFT_HIRES);
    eval 'sub SDVO_MULTIPLIER_SHIFT_VGA () {0;}' unless defined(&SDVO_MULTIPLIER_SHIFT_VGA);
    eval 'sub _DPLL_A_MD () {0x601c;}' unless defined(&_DPLL_A_MD);
    eval 'sub DPLL_MD_UDI_DIVIDER_MASK () {0x3f000000;}' unless defined(&DPLL_MD_UDI_DIVIDER_MASK);
    eval 'sub DPLL_MD_UDI_DIVIDER_SHIFT () {24;}' unless defined(&DPLL_MD_UDI_DIVIDER_SHIFT);
    eval 'sub DPLL_MD_VGA_UDI_DIVIDER_MASK () {0x3f0000;}' unless defined(&DPLL_MD_VGA_UDI_DIVIDER_MASK);
    eval 'sub DPLL_MD_VGA_UDI_DIVIDER_SHIFT () {16;}' unless defined(&DPLL_MD_VGA_UDI_DIVIDER_SHIFT);
    eval 'sub DPLL_MD_UDI_MULTIPLIER_MASK () {0x3f00;}' unless defined(&DPLL_MD_UDI_MULTIPLIER_MASK);
    eval 'sub DPLL_MD_UDI_MULTIPLIER_SHIFT () {8;}' unless defined(&DPLL_MD_UDI_MULTIPLIER_SHIFT);
    eval 'sub DPLL_MD_VGA_UDI_MULTIPLIER_MASK () {0x3f;}' unless defined(&DPLL_MD_VGA_UDI_MULTIPLIER_MASK);
    eval 'sub DPLL_MD_VGA_UDI_MULTIPLIER_SHIFT () {0;}' unless defined(&DPLL_MD_VGA_UDI_MULTIPLIER_SHIFT);
    eval 'sub _DPLL_B_MD () {0x6020;}' unless defined(&_DPLL_B_MD);
    eval 'sub DPLL_MD {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DPLL_A_MD,  &_DPLL_B_MD));
    }' unless defined(&DPLL_MD);
    eval 'sub _FPA0 () {0x6040;}' unless defined(&_FPA0);
    eval 'sub _FPA1 () {0x6044;}' unless defined(&_FPA1);
    eval 'sub _FPB0 () {0x6048;}' unless defined(&_FPB0);
    eval 'sub _FPB1 () {0x604c;}' unless defined(&_FPB1);
    eval 'sub FP0 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FPA0,  &_FPB0));
    }' unless defined(&FP0);
    eval 'sub FP1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FPA1,  &_FPB1));
    }' unless defined(&FP1);
    eval 'sub FP_N_DIV_MASK () {0x3f0000;}' unless defined(&FP_N_DIV_MASK);
    eval 'sub FP_N_PINEVIEW_DIV_MASK () {0xff0000;}' unless defined(&FP_N_PINEVIEW_DIV_MASK);
    eval 'sub FP_N_DIV_SHIFT () {16;}' unless defined(&FP_N_DIV_SHIFT);
    eval 'sub FP_M1_DIV_MASK () {0x3f00;}' unless defined(&FP_M1_DIV_MASK);
    eval 'sub FP_M1_DIV_SHIFT () {8;}' unless defined(&FP_M1_DIV_SHIFT);
    eval 'sub FP_M2_DIV_MASK () {0x3f;}' unless defined(&FP_M2_DIV_MASK);
    eval 'sub FP_M2_PINEVIEW_DIV_MASK () {0xff;}' unless defined(&FP_M2_PINEVIEW_DIV_MASK);
    eval 'sub FP_M2_DIV_SHIFT () {0;}' unless defined(&FP_M2_DIV_SHIFT);
    eval 'sub DPLL_TEST () {0x606c;}' unless defined(&DPLL_TEST);
    eval 'sub DPLLB_TEST_SDVO_DIV_1 () {(0<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_1);
    eval 'sub DPLLB_TEST_SDVO_DIV_2 () {(1<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_2);
    eval 'sub DPLLB_TEST_SDVO_DIV_4 () {(2<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_4);
    eval 'sub DPLLB_TEST_SDVO_DIV_MASK () {(3<< 22);}' unless defined(&DPLLB_TEST_SDVO_DIV_MASK);
    eval 'sub DPLLB_TEST_N_BYPASS () {(1<< 19);}' unless defined(&DPLLB_TEST_N_BYPASS);
    eval 'sub DPLLB_TEST_M_BYPASS () {(1<< 18);}' unless defined(&DPLLB_TEST_M_BYPASS);
    eval 'sub DPLLB_INPUT_BUFFER_ENABLE () {(1<< 16);}' unless defined(&DPLLB_INPUT_BUFFER_ENABLE);
    eval 'sub DPLLA_TEST_N_BYPASS () {(1<< 3);}' unless defined(&DPLLA_TEST_N_BYPASS);
    eval 'sub DPLLA_TEST_M_BYPASS () {(1<< 2);}' unless defined(&DPLLA_TEST_M_BYPASS);
    eval 'sub DPLLA_INPUT_BUFFER_ENABLE () {(1<< 0);}' unless defined(&DPLLA_INPUT_BUFFER_ENABLE);
    eval 'sub D_STATE () {0x6104;}' unless defined(&D_STATE);
    eval 'sub DSTATE_GFX_RESET_I830 () {(1<<6);}' unless defined(&DSTATE_GFX_RESET_I830);
    eval 'sub DSTATE_PLL_D3_OFF () {(1<<3);}' unless defined(&DSTATE_PLL_D3_OFF);
    eval 'sub DSTATE_GFX_CLOCK_GATING () {(1<<1);}' unless defined(&DSTATE_GFX_CLOCK_GATING);
    eval 'sub DSTATE_DOT_CLOCK_GATING () {(1<<0);}' unless defined(&DSTATE_DOT_CLOCK_GATING);
    eval 'sub DSPCLK_GATE_D () {0x6200;}' unless defined(&DSPCLK_GATE_D);
    eval 'sub DPUNIT_B_CLOCK_GATE_DISABLE () {(1<< 30);}' unless defined(&DPUNIT_B_CLOCK_GATE_DISABLE);
    eval 'sub VSUNIT_CLOCK_GATE_DISABLE () {(1<< 29);}' unless defined(&VSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub VRHUNIT_CLOCK_GATE_DISABLE () {(1<< 28);}' unless defined(&VRHUNIT_CLOCK_GATE_DISABLE);
    eval 'sub VRDUNIT_CLOCK_GATE_DISABLE () {(1<< 27);}' unless defined(&VRDUNIT_CLOCK_GATE_DISABLE);
    eval 'sub AUDUNIT_CLOCK_GATE_DISABLE () {(1<< 26);}' unless defined(&AUDUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPUNIT_A_CLOCK_GATE_DISABLE () {(1<< 25);}' unless defined(&DPUNIT_A_CLOCK_GATE_DISABLE);
    eval 'sub DPCUNIT_CLOCK_GATE_DISABLE () {(1<< 24);}' unless defined(&DPCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVRUNIT_CLOCK_GATE_DISABLE () {(1<< 23);}' unless defined(&TVRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVCUNIT_CLOCK_GATE_DISABLE () {(1<< 22);}' unless defined(&TVCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVFUNIT_CLOCK_GATE_DISABLE () {(1<< 21);}' unless defined(&TVFUNIT_CLOCK_GATE_DISABLE);
    eval 'sub TVEUNIT_CLOCK_GATE_DISABLE () {(1<< 20);}' unless defined(&TVEUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DVSUNIT_CLOCK_GATE_DISABLE () {(1<< 19);}' unless defined(&DVSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DSSUNIT_CLOCK_GATE_DISABLE () {(1<< 18);}' unless defined(&DSSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DDBUNIT_CLOCK_GATE_DISABLE () {(1<< 17);}' unless defined(&DDBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPRUNIT_CLOCK_GATE_DISABLE () {(1<< 16);}' unless defined(&DPRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPFUNIT_CLOCK_GATE_DISABLE () {(1<< 15);}' unless defined(&DPFUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPBMUNIT_CLOCK_GATE_DISABLE () {(1<< 14);}' unless defined(&DPBMUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPLSUNIT_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&DPLSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPLUNIT_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&DPLUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPOUNIT_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&DPOUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPBUNIT_CLOCK_GATE_DISABLE () {(1<< 10);}' unless defined(&DPBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DCUNIT_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&DCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPUNIT_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&DPUNIT_CLOCK_GATE_DISABLE);
    eval 'sub VRUNIT_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&VRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVHUNIT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&OVHUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPIOUNIT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&DPIOUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVFUNIT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&OVFUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVBUNIT_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&OVBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVRUNIT_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&OVRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVCUNIT_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&OVCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVUUNIT_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&OVUUNIT_CLOCK_GATE_DISABLE);
    eval 'sub ZVUNIT_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&ZVUNIT_CLOCK_GATE_DISABLE);
    eval 'sub OVLUNIT_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&OVLUNIT_CLOCK_GATE_DISABLE);
    eval 'sub RENCLK_GATE_D1 () {0x6204;}' unless defined(&RENCLK_GATE_D1);
    eval 'sub BLITTER_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&BLITTER_CLOCK_GATE_DISABLE);
    eval 'sub MPEG_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&MPEG_CLOCK_GATE_DISABLE);
    eval 'sub PC_FE_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&PC_FE_CLOCK_GATE_DISABLE);
    eval 'sub PC_BE_CLOCK_GATE_DISABLE () {(1<< 10);}' unless defined(&PC_BE_CLOCK_GATE_DISABLE);
    eval 'sub WINDOWER_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&WINDOWER_CLOCK_GATE_DISABLE);
    eval 'sub INTERPOLATOR_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&INTERPOLATOR_CLOCK_GATE_DISABLE);
    eval 'sub COLOR_CALCULATOR_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&COLOR_CALCULATOR_CLOCK_GATE_DISABLE);
    eval 'sub MOTION_COMP_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&MOTION_COMP_CLOCK_GATE_DISABLE);
    eval 'sub MAG_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&MAG_CLOCK_GATE_DISABLE);
    eval 'sub MECI_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&MECI_CLOCK_GATE_DISABLE);
    eval 'sub DCMP_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&DCMP_CLOCK_GATE_DISABLE);
    eval 'sub MEC_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&MEC_CLOCK_GATE_DISABLE);
    eval 'sub MECO_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&MECO_CLOCK_GATE_DISABLE);
    eval 'sub SV_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&SV_CLOCK_GATE_DISABLE);
    eval 'sub I915_MPEG_CLOCK_GATE_DISABLE () {(1<< 16);}' unless defined(&I915_MPEG_CLOCK_GATE_DISABLE);
    eval 'sub I915_VLD_IP_PR_CLOCK_GATE_DISABLE () {(1<< 15);}' unless defined(&I915_VLD_IP_PR_CLOCK_GATE_DISABLE);
    eval 'sub I915_MOTION_COMP_CLOCK_GATE_DISABLE () {(1<< 14);}' unless defined(&I915_MOTION_COMP_CLOCK_GATE_DISABLE);
    eval 'sub I915_BD_BF_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&I915_BD_BF_CLOCK_GATE_DISABLE);
    eval 'sub I915_SF_SE_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&I915_SF_SE_CLOCK_GATE_DISABLE);
    eval 'sub I915_WM_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&I915_WM_CLOCK_GATE_DISABLE);
    eval 'sub I915_IZ_CLOCK_GATE_DISABLE () {(1<< 10);}' unless defined(&I915_IZ_CLOCK_GATE_DISABLE);
    eval 'sub I915_PI_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&I915_PI_CLOCK_GATE_DISABLE);
    eval 'sub I915_DI_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&I915_DI_CLOCK_GATE_DISABLE);
    eval 'sub I915_SH_SV_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&I915_SH_SV_CLOCK_GATE_DISABLE);
    eval 'sub I915_PL_DG_QC_FT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&I915_PL_DG_QC_FT_CLOCK_GATE_DISABLE);
    eval 'sub I915_SC_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&I915_SC_CLOCK_GATE_DISABLE);
    eval 'sub I915_FL_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&I915_FL_CLOCK_GATE_DISABLE);
    eval 'sub I915_DM_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&I915_DM_CLOCK_GATE_DISABLE);
    eval 'sub I915_PS_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&I915_PS_CLOCK_GATE_DISABLE);
    eval 'sub I915_CC_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&I915_CC_CLOCK_GATE_DISABLE);
    eval 'sub I915_BY_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&I915_BY_CLOCK_GATE_DISABLE);
    eval 'sub I965_RCZ_CLOCK_GATE_DISABLE () {(1<< 30);}' unless defined(&I965_RCZ_CLOCK_GATE_DISABLE);
    eval 'sub I965_RCC_CLOCK_GATE_DISABLE () {(1<< 29);}' unless defined(&I965_RCC_CLOCK_GATE_DISABLE);
    eval 'sub I965_RCPB_CLOCK_GATE_DISABLE () {(1<< 28);}' unless defined(&I965_RCPB_CLOCK_GATE_DISABLE);
    eval 'sub I965_DAP_CLOCK_GATE_DISABLE () {(1<< 27);}' unless defined(&I965_DAP_CLOCK_GATE_DISABLE);
    eval 'sub I965_ROC_CLOCK_GATE_DISABLE () {(1<< 26);}' unless defined(&I965_ROC_CLOCK_GATE_DISABLE);
    eval 'sub I965_GW_CLOCK_GATE_DISABLE () {(1<< 25);}' unless defined(&I965_GW_CLOCK_GATE_DISABLE);
    eval 'sub I965_TD_CLOCK_GATE_DISABLE () {(1<< 24);}' unless defined(&I965_TD_CLOCK_GATE_DISABLE);
    eval 'sub I965_ISC_CLOCK_GATE_DISABLE () {(1<< 23);}' unless defined(&I965_ISC_CLOCK_GATE_DISABLE);
    eval 'sub I965_IC_CLOCK_GATE_DISABLE () {(1<< 22);}' unless defined(&I965_IC_CLOCK_GATE_DISABLE);
    eval 'sub I965_EU_CLOCK_GATE_DISABLE () {(1<< 21);}' unless defined(&I965_EU_CLOCK_GATE_DISABLE);
    eval 'sub I965_IF_CLOCK_GATE_DISABLE () {(1<< 20);}' unless defined(&I965_IF_CLOCK_GATE_DISABLE);
    eval 'sub I965_TC_CLOCK_GATE_DISABLE () {(1<< 19);}' unless defined(&I965_TC_CLOCK_GATE_DISABLE);
    eval 'sub I965_SO_CLOCK_GATE_DISABLE () {(1<< 17);}' unless defined(&I965_SO_CLOCK_GATE_DISABLE);
    eval 'sub I965_FBC_CLOCK_GATE_DISABLE () {(1<< 16);}' unless defined(&I965_FBC_CLOCK_GATE_DISABLE);
    eval 'sub I965_MARI_CLOCK_GATE_DISABLE () {(1<< 15);}' unless defined(&I965_MARI_CLOCK_GATE_DISABLE);
    eval 'sub I965_MASF_CLOCK_GATE_DISABLE () {(1<< 14);}' unless defined(&I965_MASF_CLOCK_GATE_DISABLE);
    eval 'sub I965_MAWB_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&I965_MAWB_CLOCK_GATE_DISABLE);
    eval 'sub I965_EM_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&I965_EM_CLOCK_GATE_DISABLE);
    eval 'sub I965_UC_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&I965_UC_CLOCK_GATE_DISABLE);
    eval 'sub I965_SI_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&I965_SI_CLOCK_GATE_DISABLE);
    eval 'sub I965_MT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&I965_MT_CLOCK_GATE_DISABLE);
    eval 'sub I965_PL_CLOCK_GATE_DISABLE () {(1<< 4);}' unless defined(&I965_PL_CLOCK_GATE_DISABLE);
    eval 'sub I965_DG_CLOCK_GATE_DISABLE () {(1<< 3);}' unless defined(&I965_DG_CLOCK_GATE_DISABLE);
    eval 'sub I965_QC_CLOCK_GATE_DISABLE () {(1<< 2);}' unless defined(&I965_QC_CLOCK_GATE_DISABLE);
    eval 'sub I965_FT_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&I965_FT_CLOCK_GATE_DISABLE);
    eval 'sub I965_DM_CLOCK_GATE_DISABLE () {(1<< 0);}' unless defined(&I965_DM_CLOCK_GATE_DISABLE);
    eval 'sub RENCLK_GATE_D2 () {0x6208;}' unless defined(&RENCLK_GATE_D2);
    eval 'sub VF_UNIT_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&VF_UNIT_CLOCK_GATE_DISABLE);
    eval 'sub GS_UNIT_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&GS_UNIT_CLOCK_GATE_DISABLE);
    eval 'sub CL_UNIT_CLOCK_GATE_DISABLE () {(1<< 6);}' unless defined(&CL_UNIT_CLOCK_GATE_DISABLE);
    eval 'sub RAMCLK_GATE_D () {0x6210;}' unless defined(&RAMCLK_GATE_D);
    eval 'sub DEUC () {0x6214;}' unless defined(&DEUC);
    eval 'sub _PALETTE_A () {0xa000;}' unless defined(&_PALETTE_A);
    eval 'sub _PALETTE_B () {0xa800;}' unless defined(&_PALETTE_B);
    eval 'sub PALETTE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PALETTE_A,  &_PALETTE_B));
    }' unless defined(&PALETTE);
    eval 'sub MCHBAR_MIRROR_BASE () {0x10000;}' unless defined(&MCHBAR_MIRROR_BASE);
    eval 'sub MCHBAR_MIRROR_BASE_SNB () {0x140000;}' unless defined(&MCHBAR_MIRROR_BASE_SNB);
    eval 'sub DCC () {0x10200;}' unless defined(&DCC);
    eval 'sub DCC_ADDRESSING_MODE_SINGLE_CHANNEL () {(0<< 0);}' unless defined(&DCC_ADDRESSING_MODE_SINGLE_CHANNEL);
    eval 'sub DCC_ADDRESSING_MODE_DUAL_CHANNEL_ASYMMETRIC () {(1<< 0);}' unless defined(&DCC_ADDRESSING_MODE_DUAL_CHANNEL_ASYMMETRIC);
    eval 'sub DCC_ADDRESSING_MODE_DUAL_CHANNEL_INTERLEAVED () {(2<< 0);}' unless defined(&DCC_ADDRESSING_MODE_DUAL_CHANNEL_INTERLEAVED);
    eval 'sub DCC_ADDRESSING_MODE_MASK () {(3<< 0);}' unless defined(&DCC_ADDRESSING_MODE_MASK);
    eval 'sub DCC_CHANNEL_XOR_DISABLE () {(1<< 10);}' unless defined(&DCC_CHANNEL_XOR_DISABLE);
    eval 'sub DCC_CHANNEL_XOR_BIT_17 () {(1<< 9);}' unless defined(&DCC_CHANNEL_XOR_BIT_17);
    eval 'sub CSHRDDR3CTL () {0x101a8;}' unless defined(&CSHRDDR3CTL);
    eval 'sub CSHRDDR3CTL_DDR3 () {(1<< 2);}' unless defined(&CSHRDDR3CTL_DDR3);
    eval 'sub C0DRB3 () {0x10206;}' unless defined(&C0DRB3);
    eval 'sub C1DRB3 () {0x10606;}' unless defined(&C1DRB3);
    eval 'sub MAD_DIMM_C0 () {( &MCHBAR_MIRROR_BASE_SNB + 0x5004);}' unless defined(&MAD_DIMM_C0);
    eval 'sub MAD_DIMM_C1 () {( &MCHBAR_MIRROR_BASE_SNB + 0x5008);}' unless defined(&MAD_DIMM_C1);
    eval 'sub MAD_DIMM_C2 () {( &MCHBAR_MIRROR_BASE_SNB + 0x500c);}' unless defined(&MAD_DIMM_C2);
    eval 'sub MAD_DIMM_ECC_MASK () {(0x3 << 24);}' unless defined(&MAD_DIMM_ECC_MASK);
    eval 'sub MAD_DIMM_ECC_OFF () {(0x << 24);}' unless defined(&MAD_DIMM_ECC_OFF);
    eval 'sub MAD_DIMM_ECC_IO_ON_LOGIC_OFF () {(0x1 << 24);}' unless defined(&MAD_DIMM_ECC_IO_ON_LOGIC_OFF);
    eval 'sub MAD_DIMM_ECC_IO_OFF_LOGIC_ON () {(0x2 << 24);}' unless defined(&MAD_DIMM_ECC_IO_OFF_LOGIC_ON);
    eval 'sub MAD_DIMM_ECC_ON () {(0x3 << 24);}' unless defined(&MAD_DIMM_ECC_ON);
    eval 'sub MAD_DIMM_ENH_INTERLEAVE () {(0x1 << 22);}' unless defined(&MAD_DIMM_ENH_INTERLEAVE);
    eval 'sub MAD_DIMM_RANK_INTERLEAVE () {(0x1 << 21);}' unless defined(&MAD_DIMM_RANK_INTERLEAVE);
    eval 'sub MAD_DIMM_B_WIDTH_X16 () {(0x1 << 20);}' unless defined(&MAD_DIMM_B_WIDTH_X16);
    eval 'sub MAD_DIMM_A_WIDTH_X16 () {(0x1 << 19);}' unless defined(&MAD_DIMM_A_WIDTH_X16);
    eval 'sub MAD_DIMM_B_DUAL_RANK () {(0x1 << 18);}' unless defined(&MAD_DIMM_B_DUAL_RANK);
    eval 'sub MAD_DIMM_A_DUAL_RANK () {(0x1 << 17);}' unless defined(&MAD_DIMM_A_DUAL_RANK);
    eval 'sub MAD_DIMM_A_SELECT () {(0x1 << 16);}' unless defined(&MAD_DIMM_A_SELECT);
    eval 'sub MAD_DIMM_B_SIZE_SHIFT () {8;}' unless defined(&MAD_DIMM_B_SIZE_SHIFT);
    eval 'sub MAD_DIMM_B_SIZE_MASK () {(0xff <<  &MAD_DIMM_B_SIZE_SHIFT);}' unless defined(&MAD_DIMM_B_SIZE_MASK);
    eval 'sub MAD_DIMM_A_SIZE_SHIFT () {0;}' unless defined(&MAD_DIMM_A_SIZE_SHIFT);
    eval 'sub MAD_DIMM_A_SIZE_MASK () {(0xff <<  &MAD_DIMM_A_SIZE_SHIFT);}' unless defined(&MAD_DIMM_A_SIZE_MASK);
    eval 'sub CLKCFG () {0x10c00;}' unless defined(&CLKCFG);
    eval 'sub CLKCFG_FSB_400 () {(5<< 0);}' unless defined(&CLKCFG_FSB_400);
    eval 'sub CLKCFG_FSB_533 () {(1<< 0);}' unless defined(&CLKCFG_FSB_533);
    eval 'sub CLKCFG_FSB_667 () {(3<< 0);}' unless defined(&CLKCFG_FSB_667);
    eval 'sub CLKCFG_FSB_800 () {(2<< 0);}' unless defined(&CLKCFG_FSB_800);
    eval 'sub CLKCFG_FSB_1067 () {(6<< 0);}' unless defined(&CLKCFG_FSB_1067);
    eval 'sub CLKCFG_FSB_1333 () {(7<< 0);}' unless defined(&CLKCFG_FSB_1333);
    eval 'sub CLKCFG_FSB_1600 () {(4<< 0);}' unless defined(&CLKCFG_FSB_1600);
    eval 'sub CLKCFG_FSB_1600_ALT () {(0<< 0);}' unless defined(&CLKCFG_FSB_1600_ALT);
    eval 'sub CLKCFG_FSB_MASK () {(7<< 0);}' unless defined(&CLKCFG_FSB_MASK);
    eval 'sub CLKCFG_MEM_533 () {(1<< 4);}' unless defined(&CLKCFG_MEM_533);
    eval 'sub CLKCFG_MEM_667 () {(2<< 4);}' unless defined(&CLKCFG_MEM_667);
    eval 'sub CLKCFG_MEM_800 () {(3<< 4);}' unless defined(&CLKCFG_MEM_800);
    eval 'sub CLKCFG_MEM_MASK () {(7<< 4);}' unless defined(&CLKCFG_MEM_MASK);
    eval 'sub TSC1 () {0x11001;}' unless defined(&TSC1);
    eval 'sub TSE () {(1<<0);}' unless defined(&TSE);
    eval 'sub TR1 () {0x11006;}' unless defined(&TR1);
    eval 'sub TSFS () {0x11020;}' unless defined(&TSFS);
    eval 'sub TSFS_SLOPE_MASK () {0xff00;}' unless defined(&TSFS_SLOPE_MASK);
    eval 'sub TSFS_SLOPE_SHIFT () {8;}' unless defined(&TSFS_SLOPE_SHIFT);
    eval 'sub TSFS_INTR_MASK () {0xff;}' unless defined(&TSFS_INTR_MASK);
    eval 'sub CRSTANDVID () {0x11100;}' unless defined(&CRSTANDVID);
    eval 'sub PXVFREQ_BASE () {0x11110;}' unless defined(&PXVFREQ_BASE);
    eval 'sub PXVFREQ_PX_MASK () {0x7f000000;}' unless defined(&PXVFREQ_PX_MASK);
    eval 'sub PXVFREQ_PX_SHIFT () {24;}' unless defined(&PXVFREQ_PX_SHIFT);
    eval 'sub VIDFREQ_BASE () {0x11110;}' unless defined(&VIDFREQ_BASE);
    eval 'sub VIDFREQ1 () {0x11110;}' unless defined(&VIDFREQ1);
    eval 'sub VIDFREQ2 () {0x11114;}' unless defined(&VIDFREQ2);
    eval 'sub VIDFREQ3 () {0x11118;}' unless defined(&VIDFREQ3);
    eval 'sub VIDFREQ4 () {0x1111c;}' unless defined(&VIDFREQ4);
    eval 'sub VIDFREQ_P0_MASK () {0x1f000000;}' unless defined(&VIDFREQ_P0_MASK);
    eval 'sub VIDFREQ_P0_SHIFT () {24;}' unless defined(&VIDFREQ_P0_SHIFT);
    eval 'sub VIDFREQ_P0_CSCLK_MASK () {0xf00000;}' unless defined(&VIDFREQ_P0_CSCLK_MASK);
    eval 'sub VIDFREQ_P0_CSCLK_SHIFT () {20;}' unless defined(&VIDFREQ_P0_CSCLK_SHIFT);
    eval 'sub VIDFREQ_P0_CRCLK_MASK () {0xf0000;}' unless defined(&VIDFREQ_P0_CRCLK_MASK);
    eval 'sub VIDFREQ_P0_CRCLK_SHIFT () {16;}' unless defined(&VIDFREQ_P0_CRCLK_SHIFT);
    eval 'sub VIDFREQ_P1_MASK () {0x1f00;}' unless defined(&VIDFREQ_P1_MASK);
    eval 'sub VIDFREQ_P1_SHIFT () {8;}' unless defined(&VIDFREQ_P1_SHIFT);
    eval 'sub VIDFREQ_P1_CSCLK_MASK () {0xf0;}' unless defined(&VIDFREQ_P1_CSCLK_MASK);
    eval 'sub VIDFREQ_P1_CSCLK_SHIFT () {4;}' unless defined(&VIDFREQ_P1_CSCLK_SHIFT);
    eval 'sub VIDFREQ_P1_CRCLK_MASK () {0xf;}' unless defined(&VIDFREQ_P1_CRCLK_MASK);
    eval 'sub INTTOEXT_BASE_ILK () {0x11300;}' unless defined(&INTTOEXT_BASE_ILK);
    eval 'sub INTTOEXT_BASE () {0x11120;}' unless defined(&INTTOEXT_BASE);
    eval 'sub INTTOEXT_MAP3_SHIFT () {24;}' unless defined(&INTTOEXT_MAP3_SHIFT);
    eval 'sub INTTOEXT_MAP3_MASK () {(0x1f <<  &INTTOEXT_MAP3_SHIFT);}' unless defined(&INTTOEXT_MAP3_MASK);
    eval 'sub INTTOEXT_MAP2_SHIFT () {16;}' unless defined(&INTTOEXT_MAP2_SHIFT);
    eval 'sub INTTOEXT_MAP2_MASK () {(0x1f <<  &INTTOEXT_MAP2_SHIFT);}' unless defined(&INTTOEXT_MAP2_MASK);
    eval 'sub INTTOEXT_MAP1_SHIFT () {8;}' unless defined(&INTTOEXT_MAP1_SHIFT);
    eval 'sub INTTOEXT_MAP1_MASK () {(0x1f <<  &INTTOEXT_MAP1_SHIFT);}' unless defined(&INTTOEXT_MAP1_MASK);
    eval 'sub INTTOEXT_MAP0_SHIFT () {0;}' unless defined(&INTTOEXT_MAP0_SHIFT);
    eval 'sub INTTOEXT_MAP0_MASK () {(0x1f <<  &INTTOEXT_MAP0_SHIFT);}' unless defined(&INTTOEXT_MAP0_MASK);
    eval 'sub MEMSWCTL () {0x11170;}' unless defined(&MEMSWCTL);
    eval 'sub MEMCTL_CMD_MASK () {0xe000;}' unless defined(&MEMCTL_CMD_MASK);
    eval 'sub MEMCTL_CMD_SHIFT () {13;}' unless defined(&MEMCTL_CMD_SHIFT);
    eval 'sub MEMCTL_CMD_RCLK_OFF () {0;}' unless defined(&MEMCTL_CMD_RCLK_OFF);
    eval 'sub MEMCTL_CMD_RCLK_ON () {1;}' unless defined(&MEMCTL_CMD_RCLK_ON);
    eval 'sub MEMCTL_CMD_CHFREQ () {2;}' unless defined(&MEMCTL_CMD_CHFREQ);
    eval 'sub MEMCTL_CMD_CHVID () {3;}' unless defined(&MEMCTL_CMD_CHVID);
    eval 'sub MEMCTL_CMD_VMMOFF () {4;}' unless defined(&MEMCTL_CMD_VMMOFF);
    eval 'sub MEMCTL_CMD_VMMON () {5;}' unless defined(&MEMCTL_CMD_VMMON);
    eval 'sub MEMCTL_CMD_STS () {(1<<12);}' unless defined(&MEMCTL_CMD_STS);
    eval 'sub MEMCTL_FREQ_MASK () {0xf00;}' unless defined(&MEMCTL_FREQ_MASK);
    eval 'sub MEMCTL_FREQ_SHIFT () {8;}' unless defined(&MEMCTL_FREQ_SHIFT);
    eval 'sub MEMCTL_SFCAVM () {(1<<7);}' unless defined(&MEMCTL_SFCAVM);
    eval 'sub MEMCTL_TGT_VID_MASK () {0x7f;}' unless defined(&MEMCTL_TGT_VID_MASK);
    eval 'sub MEMIHYST () {0x1117c;}' unless defined(&MEMIHYST);
    eval 'sub MEMINTREN () {0x11180;}' unless defined(&MEMINTREN);
    eval 'sub MEMINT_RSEXIT_EN () {(1<<8);}' unless defined(&MEMINT_RSEXIT_EN);
    eval 'sub MEMINT_CX_SUPR_EN () {(1<<7);}' unless defined(&MEMINT_CX_SUPR_EN);
    eval 'sub MEMINT_CONT_BUSY_EN () {(1<<6);}' unless defined(&MEMINT_CONT_BUSY_EN);
    eval 'sub MEMINT_AVG_BUSY_EN () {(1<<5);}' unless defined(&MEMINT_AVG_BUSY_EN);
    eval 'sub MEMINT_EVAL_CHG_EN () {(1<<4);}' unless defined(&MEMINT_EVAL_CHG_EN);
    eval 'sub MEMINT_MON_IDLE_EN () {(1<<3);}' unless defined(&MEMINT_MON_IDLE_EN);
    eval 'sub MEMINT_UP_EVAL_EN () {(1<<2);}' unless defined(&MEMINT_UP_EVAL_EN);
    eval 'sub MEMINT_DOWN_EVAL_EN () {(1<<1);}' unless defined(&MEMINT_DOWN_EVAL_EN);
    eval 'sub MEMINT_SW_CMD_EN () {(1<<0);}' unless defined(&MEMINT_SW_CMD_EN);
    eval 'sub MEMINTRSTR () {0x11182;}' unless defined(&MEMINTRSTR);
    eval 'sub MEM_RSEXIT_MASK () {0xc000;}' unless defined(&MEM_RSEXIT_MASK);
    eval 'sub MEM_RSEXIT_SHIFT () {14;}' unless defined(&MEM_RSEXIT_SHIFT);
    eval 'sub MEM_CONT_BUSY_MASK () {0x3000;}' unless defined(&MEM_CONT_BUSY_MASK);
    eval 'sub MEM_CONT_BUSY_SHIFT () {12;}' unless defined(&MEM_CONT_BUSY_SHIFT);
    eval 'sub MEM_AVG_BUSY_MASK () {0xc00;}' unless defined(&MEM_AVG_BUSY_MASK);
    eval 'sub MEM_AVG_BUSY_SHIFT () {10;}' unless defined(&MEM_AVG_BUSY_SHIFT);
    eval 'sub MEM_EVAL_CHG_MASK () {0x300;}' unless defined(&MEM_EVAL_CHG_MASK);
    eval 'sub MEM_EVAL_BUSY_SHIFT () {8;}' unless defined(&MEM_EVAL_BUSY_SHIFT);
    eval 'sub MEM_MON_IDLE_MASK () {0xc0;}' unless defined(&MEM_MON_IDLE_MASK);
    eval 'sub MEM_MON_IDLE_SHIFT () {6;}' unless defined(&MEM_MON_IDLE_SHIFT);
    eval 'sub MEM_UP_EVAL_MASK () {0x30;}' unless defined(&MEM_UP_EVAL_MASK);
    eval 'sub MEM_UP_EVAL_SHIFT () {4;}' unless defined(&MEM_UP_EVAL_SHIFT);
    eval 'sub MEM_DOWN_EVAL_MASK () {0xc;}' unless defined(&MEM_DOWN_EVAL_MASK);
    eval 'sub MEM_DOWN_EVAL_SHIFT () {2;}' unless defined(&MEM_DOWN_EVAL_SHIFT);
    eval 'sub MEM_SW_CMD_MASK () {0x3;}' unless defined(&MEM_SW_CMD_MASK);
    eval 'sub MEM_INT_STEER_GFX () {0;}' unless defined(&MEM_INT_STEER_GFX);
    eval 'sub MEM_INT_STEER_CMR () {1;}' unless defined(&MEM_INT_STEER_CMR);
    eval 'sub MEM_INT_STEER_SMI () {2;}' unless defined(&MEM_INT_STEER_SMI);
    eval 'sub MEM_INT_STEER_SCI () {3;}' unless defined(&MEM_INT_STEER_SCI);
    eval 'sub MEMINTRSTS () {0x11184;}' unless defined(&MEMINTRSTS);
    eval 'sub MEMINT_RSEXIT () {(1<<7);}' unless defined(&MEMINT_RSEXIT);
    eval 'sub MEMINT_CONT_BUSY () {(1<<6);}' unless defined(&MEMINT_CONT_BUSY);
    eval 'sub MEMINT_AVG_BUSY () {(1<<5);}' unless defined(&MEMINT_AVG_BUSY);
    eval 'sub MEMINT_EVAL_CHG () {(1<<4);}' unless defined(&MEMINT_EVAL_CHG);
    eval 'sub MEMINT_MON_IDLE () {(1<<3);}' unless defined(&MEMINT_MON_IDLE);
    eval 'sub MEMINT_UP_EVAL () {(1<<2);}' unless defined(&MEMINT_UP_EVAL);
    eval 'sub MEMINT_DOWN_EVAL () {(1<<1);}' unless defined(&MEMINT_DOWN_EVAL);
    eval 'sub MEMINT_SW_CMD () {(1<<0);}' unless defined(&MEMINT_SW_CMD);
    eval 'sub MEMMODECTL () {0x11190;}' unless defined(&MEMMODECTL);
    eval 'sub MEMMODE_BOOST_EN () {(1<<31);}' unless defined(&MEMMODE_BOOST_EN);
    eval 'sub MEMMODE_BOOST_FREQ_MASK () {0xf000000;}' unless defined(&MEMMODE_BOOST_FREQ_MASK);
    eval 'sub MEMMODE_BOOST_FREQ_SHIFT () {24;}' unless defined(&MEMMODE_BOOST_FREQ_SHIFT);
    eval 'sub MEMMODE_IDLE_MODE_MASK () {0x30000;}' unless defined(&MEMMODE_IDLE_MODE_MASK);
    eval 'sub MEMMODE_IDLE_MODE_SHIFT () {16;}' unless defined(&MEMMODE_IDLE_MODE_SHIFT);
    eval 'sub MEMMODE_IDLE_MODE_EVAL () {0;}' unless defined(&MEMMODE_IDLE_MODE_EVAL);
    eval 'sub MEMMODE_IDLE_MODE_CONT () {1;}' unless defined(&MEMMODE_IDLE_MODE_CONT);
    eval 'sub MEMMODE_HWIDLE_EN () {(1<<15);}' unless defined(&MEMMODE_HWIDLE_EN);
    eval 'sub MEMMODE_SWMODE_EN () {(1<<14);}' unless defined(&MEMMODE_SWMODE_EN);
    eval 'sub MEMMODE_RCLK_GATE () {(1<<13);}' unless defined(&MEMMODE_RCLK_GATE);
    eval 'sub MEMMODE_HW_UPDATE () {(1<<12);}' unless defined(&MEMMODE_HW_UPDATE);
    eval 'sub MEMMODE_FSTART_MASK () {0xf00;}' unless defined(&MEMMODE_FSTART_MASK);
    eval 'sub MEMMODE_FSTART_SHIFT () {8;}' unless defined(&MEMMODE_FSTART_SHIFT);
    eval 'sub MEMMODE_FMAX_MASK () {0xf0;}' unless defined(&MEMMODE_FMAX_MASK);
    eval 'sub MEMMODE_FMAX_SHIFT () {4;}' unless defined(&MEMMODE_FMAX_SHIFT);
    eval 'sub MEMMODE_FMIN_MASK () {0xf;}' unless defined(&MEMMODE_FMIN_MASK);
    eval 'sub RCBMAXAVG () {0x1119c;}' unless defined(&RCBMAXAVG);
    eval 'sub MEMSWCTL2 () {0x1119e;}' unless defined(&MEMSWCTL2);
    eval 'sub SWMEMCMD_RENDER_OFF () {(0<< 13);}' unless defined(&SWMEMCMD_RENDER_OFF);
    eval 'sub SWMEMCMD_RENDER_ON () {(1<< 13);}' unless defined(&SWMEMCMD_RENDER_ON);
    eval 'sub SWMEMCMD_SWFREQ () {(2<< 13);}' unless defined(&SWMEMCMD_SWFREQ);
    eval 'sub SWMEMCMD_TARVID () {(3<< 13);}' unless defined(&SWMEMCMD_TARVID);
    eval 'sub SWMEMCMD_VRM_OFF () {(4<< 13);}' unless defined(&SWMEMCMD_VRM_OFF);
    eval 'sub SWMEMCMD_VRM_ON () {(5<< 13);}' unless defined(&SWMEMCMD_VRM_ON);
    eval 'sub CMDSTS () {(1<<12);}' unless defined(&CMDSTS);
    eval 'sub SFCAVM () {(1<<11);}' unless defined(&SFCAVM);
    eval 'sub SWFREQ_MASK () {0x380;}' unless defined(&SWFREQ_MASK);
    eval 'sub SWFREQ_SHIFT () {7;}' unless defined(&SWFREQ_SHIFT);
    eval 'sub TARVID_MASK () {0x1f;}' unless defined(&TARVID_MASK);
    eval 'sub MEMSTAT_CTG () {0x111a0;}' unless defined(&MEMSTAT_CTG);
    eval 'sub RCBMINAVG () {0x111a0;}' unless defined(&RCBMINAVG);
    eval 'sub RCUPEI () {0x111b0;}' unless defined(&RCUPEI);
    eval 'sub RCDNEI () {0x111b4;}' unless defined(&RCDNEI);
    eval 'sub RSTDBYCTL () {0x111b8;}' unless defined(&RSTDBYCTL);
    eval 'sub RS1EN () {(1<<31);}' unless defined(&RS1EN);
    eval 'sub RS2EN () {(1<<30);}' unless defined(&RS2EN);
    eval 'sub RS3EN () {(1<<29);}' unless defined(&RS3EN);
    eval 'sub D3RS3EN () {(1<<28);}' unless defined(&D3RS3EN);
    eval 'sub SWPROMORSX () {(1<<27);}' unless defined(&SWPROMORSX);
    eval 'sub RCWAKERW () {(1<<26);}' unless defined(&RCWAKERW);
    eval 'sub DPRSLPVREN () {(1<<25);}' unless defined(&DPRSLPVREN);
    eval 'sub GFXTGHYST () {(1<<24);}' unless defined(&GFXTGHYST);
    eval 'sub RCX_SW_EXIT () {(1<<23);}' unless defined(&RCX_SW_EXIT);
    eval 'sub RSX_STATUS_MASK () {(7<<20);}' unless defined(&RSX_STATUS_MASK);
    eval 'sub RSX_STATUS_ON () {(0<<20);}' unless defined(&RSX_STATUS_ON);
    eval 'sub RSX_STATUS_RC1 () {(1<<20);}' unless defined(&RSX_STATUS_RC1);
    eval 'sub RSX_STATUS_RC1E () {(2<<20);}' unless defined(&RSX_STATUS_RC1E);
    eval 'sub RSX_STATUS_RS1 () {(3<<20);}' unless defined(&RSX_STATUS_RS1);
    eval 'sub RSX_STATUS_RS2 () {(4<<20);}' unless defined(&RSX_STATUS_RS2);
    eval 'sub RSX_STATUS_RSVD () {(5<<20);}' unless defined(&RSX_STATUS_RSVD);
    eval 'sub RSX_STATUS_RS3 () {(6<<20);}' unless defined(&RSX_STATUS_RS3);
    eval 'sub RSX_STATUS_RSVD2 () {(7<<20);}' unless defined(&RSX_STATUS_RSVD2);
    eval 'sub UWRCRSXE () {(1<<19);}' unless defined(&UWRCRSXE);
    eval 'sub RSCRP () {(1<<18);}' unless defined(&RSCRP);
    eval 'sub JRSC () {(1<<17);}' unless defined(&JRSC);
    eval 'sub RS2INC0 () {(1<<16);}' unless defined(&RS2INC0);
    eval 'sub RS1CONTSAV_MASK () {(3<<14);}' unless defined(&RS1CONTSAV_MASK);
    eval 'sub RS1CONTSAV_NO_RS1 () {(0<<14);}' unless defined(&RS1CONTSAV_NO_RS1);
    eval 'sub RS1CONTSAV_RSVD () {(1<<14);}' unless defined(&RS1CONTSAV_RSVD);
    eval 'sub RS1CONTSAV_SAVE_RS1 () {(2<<14);}' unless defined(&RS1CONTSAV_SAVE_RS1);
    eval 'sub RS1CONTSAV_FULL_RS1 () {(3<<14);}' unless defined(&RS1CONTSAV_FULL_RS1);
    eval 'sub NORMSLEXLAT_MASK () {(3<<12);}' unless defined(&NORMSLEXLAT_MASK);
    eval 'sub SLOW_RS123 () {(0<<12);}' unless defined(&SLOW_RS123);
    eval 'sub SLOW_RS23 () {(1<<12);}' unless defined(&SLOW_RS23);
    eval 'sub SLOW_RS3 () {(2<<12);}' unless defined(&SLOW_RS3);
    eval 'sub NORMAL_RS123 () {(3<<12);}' unless defined(&NORMAL_RS123);
    eval 'sub RCMODE_TIMEOUT () {(1<<11);}' unless defined(&RCMODE_TIMEOUT);
    eval 'sub IMPROMOEN () {(1<<10);}' unless defined(&IMPROMOEN);
    eval 'sub RCENTSYNC () {(1<<9);}' unless defined(&RCENTSYNC);
    eval 'sub STATELOCK () {(1<<7);}' unless defined(&STATELOCK);
    eval 'sub RS_CSTATE_MASK () {(3<<4);}' unless defined(&RS_CSTATE_MASK);
    eval 'sub RS_CSTATE_C367_RS1 () {(0<<4);}' unless defined(&RS_CSTATE_C367_RS1);
    eval 'sub RS_CSTATE_C36_RS1_C7_RS2 () {(1<<4);}' unless defined(&RS_CSTATE_C36_RS1_C7_RS2);
    eval 'sub RS_CSTATE_RSVD () {(2<<4);}' unless defined(&RS_CSTATE_RSVD);
    eval 'sub RS_CSTATE_C367_RS2 () {(3<<4);}' unless defined(&RS_CSTATE_C367_RS2);
    eval 'sub REDSAVES () {(1<<3);}' unless defined(&REDSAVES);
    eval 'sub REDRESTORES () {(1<<2);}' unless defined(&REDRESTORES);
    eval 'sub VIDCTL () {0x111c0;}' unless defined(&VIDCTL);
    eval 'sub VIDSTS () {0x111c8;}' unless defined(&VIDSTS);
    eval 'sub VIDSTART () {0x111cc;}' unless defined(&VIDSTART);
    eval 'sub MEMSTAT_ILK () {0x111f8;}' unless defined(&MEMSTAT_ILK);
    eval 'sub MEMSTAT_VID_MASK () {0x7f00;}' unless defined(&MEMSTAT_VID_MASK);
    eval 'sub MEMSTAT_VID_SHIFT () {8;}' unless defined(&MEMSTAT_VID_SHIFT);
    eval 'sub MEMSTAT_PSTATE_MASK () {0xf8;}' unless defined(&MEMSTAT_PSTATE_MASK);
    eval 'sub MEMSTAT_PSTATE_SHIFT () {3;}' unless defined(&MEMSTAT_PSTATE_SHIFT);
    eval 'sub MEMSTAT_MON_ACTV () {(1<<2);}' unless defined(&MEMSTAT_MON_ACTV);
    eval 'sub MEMSTAT_SRC_CTL_MASK () {0x3;}' unless defined(&MEMSTAT_SRC_CTL_MASK);
    eval 'sub MEMSTAT_SRC_CTL_CORE () {0;}' unless defined(&MEMSTAT_SRC_CTL_CORE);
    eval 'sub MEMSTAT_SRC_CTL_TRB () {1;}' unless defined(&MEMSTAT_SRC_CTL_TRB);
    eval 'sub MEMSTAT_SRC_CTL_THM () {2;}' unless defined(&MEMSTAT_SRC_CTL_THM);
    eval 'sub MEMSTAT_SRC_CTL_STDBY () {3;}' unless defined(&MEMSTAT_SRC_CTL_STDBY);
    eval 'sub RCPREVBSYTUPAVG () {0x113b8;}' unless defined(&RCPREVBSYTUPAVG);
    eval 'sub RCPREVBSYTDNAVG () {0x113bc;}' unless defined(&RCPREVBSYTDNAVG);
    eval 'sub PMMISC () {0x11214;}' unless defined(&PMMISC);
    eval 'sub MCPPCE_EN () {(1<<0);}' unless defined(&MCPPCE_EN);
    eval 'sub SDEW () {0x1124c;}' unless defined(&SDEW);
    eval 'sub CSIEW0 () {0x11250;}' unless defined(&CSIEW0);
    eval 'sub CSIEW1 () {0x11254;}' unless defined(&CSIEW1);
    eval 'sub CSIEW2 () {0x11258;}' unless defined(&CSIEW2);
    eval 'sub PEW () {0x1125c;}' unless defined(&PEW);
    eval 'sub DEW () {0x11270;}' unless defined(&DEW);
    eval 'sub MCHAFE () {0x112c0;}' unless defined(&MCHAFE);
    eval 'sub CSIEC () {0x112e0;}' unless defined(&CSIEC);
    eval 'sub DMIEC () {0x112e4;}' unless defined(&DMIEC);
    eval 'sub DDREC () {0x112e8;}' unless defined(&DDREC);
    eval 'sub PEG0EC () {0x112ec;}' unless defined(&PEG0EC);
    eval 'sub PEG1EC () {0x112f0;}' unless defined(&PEG1EC);
    eval 'sub GFXEC () {0x112f4;}' unless defined(&GFXEC);
    eval 'sub RPPREVBSYTUPAVG () {0x113b8;}' unless defined(&RPPREVBSYTUPAVG);
    eval 'sub RPPREVBSYTDNAVG () {0x113bc;}' unless defined(&RPPREVBSYTDNAVG);
    eval 'sub ECR () {0x11600;}' unless defined(&ECR);
    eval 'sub ECR_GPFE () {(1<<31);}' unless defined(&ECR_GPFE);
    eval 'sub ECR_IMONE () {(1<<30);}' unless defined(&ECR_IMONE);
    eval 'sub ECR_CAP_MASK () {0x1f;}' unless defined(&ECR_CAP_MASK);
    eval 'sub OGW0 () {0x11608;}' unless defined(&OGW0);
    eval 'sub OGW1 () {0x1160c;}' unless defined(&OGW1);
    eval 'sub EG0 () {0x11610;}' unless defined(&EG0);
    eval 'sub EG1 () {0x11614;}' unless defined(&EG1);
    eval 'sub EG2 () {0x11618;}' unless defined(&EG2);
    eval 'sub EG3 () {0x1161c;}' unless defined(&EG3);
    eval 'sub EG4 () {0x11620;}' unless defined(&EG4);
    eval 'sub EG5 () {0x11624;}' unless defined(&EG5);
    eval 'sub EG6 () {0x11628;}' unless defined(&EG6);
    eval 'sub EG7 () {0x1162c;}' unless defined(&EG7);
    eval 'sub PXW () {0x11664;}' unless defined(&PXW);
    eval 'sub PXWL () {0x11680;}' unless defined(&PXWL);
    eval 'sub LCFUSE02 () {0x116c0;}' unless defined(&LCFUSE02);
    eval 'sub LCFUSE_HIV_MASK () {0xff;}' unless defined(&LCFUSE_HIV_MASK);
    eval 'sub CSIPLL0 () {0x12c10;}' unless defined(&CSIPLL0);
    eval 'sub DDRMPLL1 () {0x12c20;}' unless defined(&DDRMPLL1);
    eval 'sub PEG_BAND_GAP_DATA () {0x14d68;}' unless defined(&PEG_BAND_GAP_DATA);
    eval 'sub GEN6_GT_PERF_STATUS () {0x145948;}' unless defined(&GEN6_GT_PERF_STATUS);
    eval 'sub GEN6_RP_STATE_LIMITS () {0x145994;}' unless defined(&GEN6_RP_STATE_LIMITS);
    eval 'sub GEN6_RP_STATE_CAP () {0x145998;}' unless defined(&GEN6_RP_STATE_CAP);
    eval 'sub CCID () {0x2180;}' unless defined(&CCID);
    eval 'sub CCID_EN () {(1<<0);}' unless defined(&CCID_EN);
    eval 'sub OVADD () {0x30000;}' unless defined(&OVADD);
    eval 'sub DOVSTA () {0x30008;}' unless defined(&DOVSTA);
    eval 'sub OC_BUF () {(0x3<<20);}' unless defined(&OC_BUF);
    eval 'sub OGAMC5 () {0x30010;}' unless defined(&OGAMC5);
    eval 'sub OGAMC4 () {0x30014;}' unless defined(&OGAMC4);
    eval 'sub OGAMC3 () {0x30018;}' unless defined(&OGAMC3);
    eval 'sub OGAMC2 () {0x3001c;}' unless defined(&OGAMC2);
    eval 'sub OGAMC1 () {0x30020;}' unless defined(&OGAMC1);
    eval 'sub OGAMC0 () {0x30024;}' unless defined(&OGAMC0);
    eval 'sub _HTOTAL_A () {0x60000;}' unless defined(&_HTOTAL_A);
    eval 'sub _HBLANK_A () {0x60004;}' unless defined(&_HBLANK_A);
    eval 'sub _HSYNC_A () {0x60008;}' unless defined(&_HSYNC_A);
    eval 'sub _VTOTAL_A () {0x6000c;}' unless defined(&_VTOTAL_A);
    eval 'sub _VBLANK_A () {0x60010;}' unless defined(&_VBLANK_A);
    eval 'sub _VSYNC_A () {0x60014;}' unless defined(&_VSYNC_A);
    eval 'sub _PIPEASRC () {0x6001c;}' unless defined(&_PIPEASRC);
    eval 'sub _BCLRPAT_A () {0x60020;}' unless defined(&_BCLRPAT_A);
    eval 'sub _VSYNCSHIFT_A () {0x60028;}' unless defined(&_VSYNCSHIFT_A);
    eval 'sub _HTOTAL_B () {0x61000;}' unless defined(&_HTOTAL_B);
    eval 'sub _HBLANK_B () {0x61004;}' unless defined(&_HBLANK_B);
    eval 'sub _HSYNC_B () {0x61008;}' unless defined(&_HSYNC_B);
    eval 'sub _VTOTAL_B () {0x6100c;}' unless defined(&_VTOTAL_B);
    eval 'sub _VBLANK_B () {0x61010;}' unless defined(&_VBLANK_B);
    eval 'sub _VSYNC_B () {0x61014;}' unless defined(&_VSYNC_B);
    eval 'sub _PIPEBSRC () {0x6101c;}' unless defined(&_PIPEBSRC);
    eval 'sub _BCLRPAT_B () {0x61020;}' unless defined(&_BCLRPAT_B);
    eval 'sub _VSYNCSHIFT_B () {0x61028;}' unless defined(&_VSYNCSHIFT_B);
    eval 'sub HTOTAL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_HTOTAL_A,  &_HTOTAL_B));
    }' unless defined(&HTOTAL);
    eval 'sub HBLANK {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_HBLANK_A,  &_HBLANK_B));
    }' unless defined(&HBLANK);
    eval 'sub HSYNC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_HSYNC_A,  &_HSYNC_B));
    }' unless defined(&HSYNC);
    eval 'sub VTOTAL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VTOTAL_A,  &_VTOTAL_B));
    }' unless defined(&VTOTAL);
    eval 'sub VBLANK {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VBLANK_A,  &_VBLANK_B));
    }' unless defined(&VBLANK);
    eval 'sub VSYNC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VSYNC_A,  &_VSYNC_B));
    }' unless defined(&VSYNC);
    eval 'sub BCLRPAT {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_BCLRPAT_A,  &_BCLRPAT_B));
    }' unless defined(&BCLRPAT);
    eval 'sub VSYNCSHIFT {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VSYNCSHIFT_A,  &_VSYNCSHIFT_B));
    }' unless defined(&VSYNCSHIFT);
    eval 'sub ADPA () {0x61100;}' unless defined(&ADPA);
    eval 'sub ADPA_DAC_ENABLE () {(1<<31);}' unless defined(&ADPA_DAC_ENABLE);
    eval 'sub ADPA_DAC_DISABLE () {0;}' unless defined(&ADPA_DAC_DISABLE);
    eval 'sub ADPA_PIPE_SELECT_MASK () {(1<<30);}' unless defined(&ADPA_PIPE_SELECT_MASK);
    eval 'sub ADPA_PIPE_A_SELECT () {0;}' unless defined(&ADPA_PIPE_A_SELECT);
    eval 'sub ADPA_PIPE_B_SELECT () {(1<<30);}' unless defined(&ADPA_PIPE_B_SELECT);
    eval 'sub ADPA_PIPE_SELECT {
        my($pipe) = @_;
	    eval q((($pipe) << 30));
    }' unless defined(&ADPA_PIPE_SELECT);
    eval 'sub ADPA_USE_VGA_HVPOLARITY () {(1<<15);}' unless defined(&ADPA_USE_VGA_HVPOLARITY);
    eval 'sub ADPA_SETS_HVPOLARITY () {0;}' unless defined(&ADPA_SETS_HVPOLARITY);
    eval 'sub ADPA_VSYNC_CNTL_DISABLE () {(1<<11);}' unless defined(&ADPA_VSYNC_CNTL_DISABLE);
    eval 'sub ADPA_VSYNC_CNTL_ENABLE () {0;}' unless defined(&ADPA_VSYNC_CNTL_ENABLE);
    eval 'sub ADPA_HSYNC_CNTL_DISABLE () {(1<<10);}' unless defined(&ADPA_HSYNC_CNTL_DISABLE);
    eval 'sub ADPA_HSYNC_CNTL_ENABLE () {0;}' unless defined(&ADPA_HSYNC_CNTL_ENABLE);
    eval 'sub ADPA_VSYNC_ACTIVE_HIGH () {(1<<4);}' unless defined(&ADPA_VSYNC_ACTIVE_HIGH);
    eval 'sub ADPA_VSYNC_ACTIVE_LOW () {0;}' unless defined(&ADPA_VSYNC_ACTIVE_LOW);
    eval 'sub ADPA_HSYNC_ACTIVE_HIGH () {(1<<3);}' unless defined(&ADPA_HSYNC_ACTIVE_HIGH);
    eval 'sub ADPA_HSYNC_ACTIVE_LOW () {0;}' unless defined(&ADPA_HSYNC_ACTIVE_LOW);
    eval 'sub ADPA_DPMS_MASK () {(~(3<<10));}' unless defined(&ADPA_DPMS_MASK);
    eval 'sub ADPA_DPMS_ON () {(0<<10);}' unless defined(&ADPA_DPMS_ON);
    eval 'sub ADPA_DPMS_SUSPEND () {(1<<10);}' unless defined(&ADPA_DPMS_SUSPEND);
    eval 'sub ADPA_DPMS_STANDBY () {(2<<10);}' unless defined(&ADPA_DPMS_STANDBY);
    eval 'sub ADPA_DPMS_OFF () {(3<<10);}' unless defined(&ADPA_DPMS_OFF);
    eval 'sub PORT_HOTPLUG_EN () {0x61110;}' unless defined(&PORT_HOTPLUG_EN);
    eval 'sub HDMIB_HOTPLUG_INT_EN () {(1<< 29);}' unless defined(&HDMIB_HOTPLUG_INT_EN);
    eval 'sub DPB_HOTPLUG_INT_EN () {(1<< 29);}' unless defined(&DPB_HOTPLUG_INT_EN);
    eval 'sub HDMIC_HOTPLUG_INT_EN () {(1<< 28);}' unless defined(&HDMIC_HOTPLUG_INT_EN);
    eval 'sub DPC_HOTPLUG_INT_EN () {(1<< 28);}' unless defined(&DPC_HOTPLUG_INT_EN);
    eval 'sub HDMID_HOTPLUG_INT_EN () {(1<< 27);}' unless defined(&HDMID_HOTPLUG_INT_EN);
    eval 'sub DPD_HOTPLUG_INT_EN () {(1<< 27);}' unless defined(&DPD_HOTPLUG_INT_EN);
    eval 'sub SDVOB_HOTPLUG_INT_EN () {(1<< 26);}' unless defined(&SDVOB_HOTPLUG_INT_EN);
    eval 'sub SDVOC_HOTPLUG_INT_EN () {(1<< 25);}' unless defined(&SDVOC_HOTPLUG_INT_EN);
    eval 'sub TV_HOTPLUG_INT_EN () {(1<< 18);}' unless defined(&TV_HOTPLUG_INT_EN);
    eval 'sub CRT_HOTPLUG_INT_EN () {(1<< 9);}' unless defined(&CRT_HOTPLUG_INT_EN);
    eval 'sub CRT_HOTPLUG_FORCE_DETECT () {(1<< 3);}' unless defined(&CRT_HOTPLUG_FORCE_DETECT);
    eval 'sub CRT_HOTPLUG_ACTIVATION_PERIOD_32 () {(0<< 8);}' unless defined(&CRT_HOTPLUG_ACTIVATION_PERIOD_32);
    eval 'sub CRT_HOTPLUG_ACTIVATION_PERIOD_64 () {(1<< 8);}' unless defined(&CRT_HOTPLUG_ACTIVATION_PERIOD_64);
    eval 'sub CRT_HOTPLUG_DAC_ON_TIME_2M () {(0<< 7);}' unless defined(&CRT_HOTPLUG_DAC_ON_TIME_2M);
    eval 'sub CRT_HOTPLUG_DAC_ON_TIME_4M () {(1<< 7);}' unless defined(&CRT_HOTPLUG_DAC_ON_TIME_4M);
    eval 'sub CRT_HOTPLUG_VOLTAGE_COMPARE_40 () {(0<< 5);}' unless defined(&CRT_HOTPLUG_VOLTAGE_COMPARE_40);
    eval 'sub CRT_HOTPLUG_VOLTAGE_COMPARE_50 () {(1<< 5);}' unless defined(&CRT_HOTPLUG_VOLTAGE_COMPARE_50);
    eval 'sub CRT_HOTPLUG_VOLTAGE_COMPARE_60 () {(2<< 5);}' unless defined(&CRT_HOTPLUG_VOLTAGE_COMPARE_60);
    eval 'sub CRT_HOTPLUG_VOLTAGE_COMPARE_70 () {(3<< 5);}' unless defined(&CRT_HOTPLUG_VOLTAGE_COMPARE_70);
    eval 'sub CRT_HOTPLUG_VOLTAGE_COMPARE_MASK () {(3<< 5);}' unless defined(&CRT_HOTPLUG_VOLTAGE_COMPARE_MASK);
    eval 'sub CRT_HOTPLUG_DETECT_DELAY_1G () {(0<< 4);}' unless defined(&CRT_HOTPLUG_DETECT_DELAY_1G);
    eval 'sub CRT_HOTPLUG_DETECT_DELAY_2G () {(1<< 4);}' unless defined(&CRT_HOTPLUG_DETECT_DELAY_2G);
    eval 'sub CRT_HOTPLUG_DETECT_VOLTAGE_325MV () {(0<< 2);}' unless defined(&CRT_HOTPLUG_DETECT_VOLTAGE_325MV);
    eval 'sub CRT_HOTPLUG_DETECT_VOLTAGE_475MV () {(1<< 2);}' unless defined(&CRT_HOTPLUG_DETECT_VOLTAGE_475MV);
    eval 'sub PORT_HOTPLUG_STAT () {0x61114;}' unless defined(&PORT_HOTPLUG_STAT);
    eval 'sub HDMIB_HOTPLUG_INT_STATUS () {(1<< 29);}' unless defined(&HDMIB_HOTPLUG_INT_STATUS);
    eval 'sub DPB_HOTPLUG_INT_STATUS () {(1<< 29);}' unless defined(&DPB_HOTPLUG_INT_STATUS);
    eval 'sub HDMIC_HOTPLUG_INT_STATUS () {(1<< 28);}' unless defined(&HDMIC_HOTPLUG_INT_STATUS);
    eval 'sub DPC_HOTPLUG_INT_STATUS () {(1<< 28);}' unless defined(&DPC_HOTPLUG_INT_STATUS);
    eval 'sub HDMID_HOTPLUG_INT_STATUS () {(1<< 27);}' unless defined(&HDMID_HOTPLUG_INT_STATUS);
    eval 'sub DPD_HOTPLUG_INT_STATUS () {(1<< 27);}' unless defined(&DPD_HOTPLUG_INT_STATUS);
    eval 'sub CRT_HOTPLUG_INT_STATUS () {(1<< 11);}' unless defined(&CRT_HOTPLUG_INT_STATUS);
    eval 'sub TV_HOTPLUG_INT_STATUS () {(1<< 10);}' unless defined(&TV_HOTPLUG_INT_STATUS);
    eval 'sub CRT_HOTPLUG_MONITOR_MASK () {(3<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_MASK);
    eval 'sub CRT_HOTPLUG_MONITOR_COLOR () {(3<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_COLOR);
    eval 'sub CRT_HOTPLUG_MONITOR_MONO () {(2<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_MONO);
    eval 'sub CRT_HOTPLUG_MONITOR_NONE () {(0<< 8);}' unless defined(&CRT_HOTPLUG_MONITOR_NONE);
    eval 'sub SDVOC_HOTPLUG_INT_STATUS () {(1<< 7);}' unless defined(&SDVOC_HOTPLUG_INT_STATUS);
    eval 'sub SDVOB_HOTPLUG_INT_STATUS () {(1<< 6);}' unless defined(&SDVOB_HOTPLUG_INT_STATUS);
    eval 'sub SDVOB () {0x61140;}' unless defined(&SDVOB);
    eval 'sub SDVOC () {0x61160;}' unless defined(&SDVOC);
    eval 'sub SDVO_ENABLE () {(1<< 31);}' unless defined(&SDVO_ENABLE);
    eval 'sub SDVO_PIPE_B_SELECT () {(1<< 30);}' unless defined(&SDVO_PIPE_B_SELECT);
    eval 'sub SDVO_STALL_SELECT () {(1<< 29);}' unless defined(&SDVO_STALL_SELECT);
    eval 'sub SDVO_INTERRUPT_ENABLE () {(1<< 26);}' unless defined(&SDVO_INTERRUPT_ENABLE);
    eval 'sub SDVO_PORT_MULTIPLY_MASK () {(7<< 23);}' unless defined(&SDVO_PORT_MULTIPLY_MASK);
    eval 'sub SDVO_PORT_MULTIPLY_SHIFT () {23;}' unless defined(&SDVO_PORT_MULTIPLY_SHIFT);
    eval 'sub SDVO_PHASE_SELECT_MASK () {(15<< 19);}' unless defined(&SDVO_PHASE_SELECT_MASK);
    eval 'sub SDVO_PHASE_SELECT_DEFAULT () {(6<< 19);}' unless defined(&SDVO_PHASE_SELECT_DEFAULT);
    eval 'sub SDVO_CLOCK_OUTPUT_INVERT () {(1<< 18);}' unless defined(&SDVO_CLOCK_OUTPUT_INVERT);
    eval 'sub SDVOC_GANG_MODE () {(1<< 16);}' unless defined(&SDVOC_GANG_MODE);
    eval 'sub SDVO_ENCODING_SDVO () {(0x << 10);}' unless defined(&SDVO_ENCODING_SDVO);
    eval 'sub SDVO_ENCODING_HDMI () {(0x2 << 10);}' unless defined(&SDVO_ENCODING_HDMI);
    eval 'sub SDVO_NULL_PACKETS_DURING_VSYNC () {(1<< 9);}' unless defined(&SDVO_NULL_PACKETS_DURING_VSYNC);
    eval 'sub SDVO_COLOR_RANGE_16_235 () {(1<< 8);}' unless defined(&SDVO_COLOR_RANGE_16_235);
    eval 'sub SDVO_BORDER_ENABLE () {(1<< 7);}' unless defined(&SDVO_BORDER_ENABLE);
    eval 'sub SDVO_AUDIO_ENABLE () {(1<< 6);}' unless defined(&SDVO_AUDIO_ENABLE);
    eval 'sub SDVO_VSYNC_ACTIVE_HIGH () {(1<< 4);}' unless defined(&SDVO_VSYNC_ACTIVE_HIGH);
    eval 'sub SDVO_HSYNC_ACTIVE_HIGH () {(1<< 3);}' unless defined(&SDVO_HSYNC_ACTIVE_HIGH);
    eval 'sub SDVOB_PCIE_CONCURRENCY () {(1<< 3);}' unless defined(&SDVOB_PCIE_CONCURRENCY);
    eval 'sub SDVO_DETECTED () {(1<< 2);}' unless defined(&SDVO_DETECTED);
    eval 'sub SDVOB_PRESERVE_MASK () {((1<< 17) | (1<< 16) | (1<< 14) | (1<< 26));}' unless defined(&SDVOB_PRESERVE_MASK);
    eval 'sub SDVOC_PRESERVE_MASK () {((1<< 17) | (1<< 26));}' unless defined(&SDVOC_PRESERVE_MASK);
    eval 'sub DVOA () {0x61120;}' unless defined(&DVOA);
    eval 'sub DVOB () {0x61140;}' unless defined(&DVOB);
    eval 'sub DVOC () {0x61160;}' unless defined(&DVOC);
    eval 'sub DVO_ENABLE () {(1<< 31);}' unless defined(&DVO_ENABLE);
    eval 'sub DVO_PIPE_B_SELECT () {(1<< 30);}' unless defined(&DVO_PIPE_B_SELECT);
    eval 'sub DVO_PIPE_STALL_UNUSED () {(0<< 28);}' unless defined(&DVO_PIPE_STALL_UNUSED);
    eval 'sub DVO_PIPE_STALL () {(1<< 28);}' unless defined(&DVO_PIPE_STALL);
    eval 'sub DVO_PIPE_STALL_TV () {(2<< 28);}' unless defined(&DVO_PIPE_STALL_TV);
    eval 'sub DVO_PIPE_STALL_MASK () {(3<< 28);}' unless defined(&DVO_PIPE_STALL_MASK);
    eval 'sub DVO_USE_VGA_SYNC () {(1<< 15);}' unless defined(&DVO_USE_VGA_SYNC);
    eval 'sub DVO_DATA_ORDER_I740 () {(0<< 14);}' unless defined(&DVO_DATA_ORDER_I740);
    eval 'sub DVO_DATA_ORDER_FP () {(1<< 14);}' unless defined(&DVO_DATA_ORDER_FP);
    eval 'sub DVO_VSYNC_DISABLE () {(1<< 11);}' unless defined(&DVO_VSYNC_DISABLE);
    eval 'sub DVO_HSYNC_DISABLE () {(1<< 10);}' unless defined(&DVO_HSYNC_DISABLE);
    eval 'sub DVO_VSYNC_TRISTATE () {(1<< 9);}' unless defined(&DVO_VSYNC_TRISTATE);
    eval 'sub DVO_HSYNC_TRISTATE () {(1<< 8);}' unless defined(&DVO_HSYNC_TRISTATE);
    eval 'sub DVO_BORDER_ENABLE () {(1<< 7);}' unless defined(&DVO_BORDER_ENABLE);
    eval 'sub DVO_DATA_ORDER_GBRG () {(1<< 6);}' unless defined(&DVO_DATA_ORDER_GBRG);
    eval 'sub DVO_DATA_ORDER_RGGB () {(0<< 6);}' unless defined(&DVO_DATA_ORDER_RGGB);
    eval 'sub DVO_DATA_ORDER_GBRG_ERRATA () {(0<< 6);}' unless defined(&DVO_DATA_ORDER_GBRG_ERRATA);
    eval 'sub DVO_DATA_ORDER_RGGB_ERRATA () {(1<< 6);}' unless defined(&DVO_DATA_ORDER_RGGB_ERRATA);
    eval 'sub DVO_VSYNC_ACTIVE_HIGH () {(1<< 4);}' unless defined(&DVO_VSYNC_ACTIVE_HIGH);
    eval 'sub DVO_HSYNC_ACTIVE_HIGH () {(1<< 3);}' unless defined(&DVO_HSYNC_ACTIVE_HIGH);
    eval 'sub DVO_BLANK_ACTIVE_HIGH () {(1<< 2);}' unless defined(&DVO_BLANK_ACTIVE_HIGH);
    eval 'sub DVO_OUTPUT_CSTATE_PIXELS () {(1<< 1);}' unless defined(&DVO_OUTPUT_CSTATE_PIXELS);
    eval 'sub DVO_OUTPUT_SOURCE_SIZE_PIXELS () {(1<< 0);}' unless defined(&DVO_OUTPUT_SOURCE_SIZE_PIXELS);
    eval 'sub DVO_PRESERVE_MASK () {(0x7<<24);}' unless defined(&DVO_PRESERVE_MASK);
    eval 'sub DVOA_SRCDIM () {0x61124;}' unless defined(&DVOA_SRCDIM);
    eval 'sub DVOB_SRCDIM () {0x61144;}' unless defined(&DVOB_SRCDIM);
    eval 'sub DVOC_SRCDIM () {0x61164;}' unless defined(&DVOC_SRCDIM);
    eval 'sub DVO_SRCDIM_HORIZONTAL_SHIFT () {12;}' unless defined(&DVO_SRCDIM_HORIZONTAL_SHIFT);
    eval 'sub DVO_SRCDIM_VERTICAL_SHIFT () {0;}' unless defined(&DVO_SRCDIM_VERTICAL_SHIFT);
    eval 'sub LVDS () {0x61180;}' unless defined(&LVDS);
    eval 'sub LVDS_PORT_EN () {(1<< 31);}' unless defined(&LVDS_PORT_EN);
    eval 'sub LVDS_PIPEB_SELECT () {(1<< 30);}' unless defined(&LVDS_PIPEB_SELECT);
    eval 'sub LVDS_PIPE_MASK () {(1<< 30);}' unless defined(&LVDS_PIPE_MASK);
    eval 'sub LVDS_PIPE {
        my($pipe) = @_;
	    eval q((($pipe) << 30));
    }' unless defined(&LVDS_PIPE);
    eval 'sub LVDS_ENABLE_DITHER () {(1<< 25);}' unless defined(&LVDS_ENABLE_DITHER);
    eval 'sub LVDS_VSYNC_POLARITY () {(1<< 21);}' unless defined(&LVDS_VSYNC_POLARITY);
    eval 'sub LVDS_HSYNC_POLARITY () {(1<< 20);}' unless defined(&LVDS_HSYNC_POLARITY);
    eval 'sub LVDS_BORDER_ENABLE () {(1<< 15);}' unless defined(&LVDS_BORDER_ENABLE);
    eval 'sub LVDS_A0A2_CLKA_POWER_MASK () {(3<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_MASK);
    eval 'sub LVDS_A0A2_CLKA_POWER_DOWN () {(0<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_DOWN);
    eval 'sub LVDS_A0A2_CLKA_POWER_UP () {(3<< 8);}' unless defined(&LVDS_A0A2_CLKA_POWER_UP);
    eval 'sub LVDS_A3_POWER_MASK () {(3<< 6);}' unless defined(&LVDS_A3_POWER_MASK);
    eval 'sub LVDS_A3_POWER_DOWN () {(0<< 6);}' unless defined(&LVDS_A3_POWER_DOWN);
    eval 'sub LVDS_A3_POWER_UP () {(3<< 6);}' unless defined(&LVDS_A3_POWER_UP);
    eval 'sub LVDS_CLKB_POWER_MASK () {(3<< 4);}' unless defined(&LVDS_CLKB_POWER_MASK);
    eval 'sub LVDS_CLKB_POWER_DOWN () {(0<< 4);}' unless defined(&LVDS_CLKB_POWER_DOWN);
    eval 'sub LVDS_CLKB_POWER_UP () {(3<< 4);}' unless defined(&LVDS_CLKB_POWER_UP);
    eval 'sub LVDS_B0B3_POWER_MASK () {(3<< 2);}' unless defined(&LVDS_B0B3_POWER_MASK);
    eval 'sub LVDS_B0B3_POWER_DOWN () {(0<< 2);}' unless defined(&LVDS_B0B3_POWER_DOWN);
    eval 'sub LVDS_B0B3_POWER_UP () {(3<< 2);}' unless defined(&LVDS_B0B3_POWER_UP);
    eval 'sub VIDEO_DIP_DATA () {0x61178;}' unless defined(&VIDEO_DIP_DATA);
    eval 'sub VIDEO_DIP_CTL () {0x61170;}' unless defined(&VIDEO_DIP_CTL);
    eval 'sub VIDEO_DIP_ENABLE () {(1<< 31);}' unless defined(&VIDEO_DIP_ENABLE);
    eval 'sub VIDEO_DIP_PORT_B () {(1<< 29);}' unless defined(&VIDEO_DIP_PORT_B);
    eval 'sub VIDEO_DIP_PORT_C () {(2<< 29);}' unless defined(&VIDEO_DIP_PORT_C);
    eval 'sub VIDEO_DIP_ENABLE_AVI () {(1<< 21);}' unless defined(&VIDEO_DIP_ENABLE_AVI);
    eval 'sub VIDEO_DIP_ENABLE_VENDOR () {(2<< 21);}' unless defined(&VIDEO_DIP_ENABLE_VENDOR);
    eval 'sub VIDEO_DIP_ENABLE_SPD () {(8<< 21);}' unless defined(&VIDEO_DIP_ENABLE_SPD);
    eval 'sub VIDEO_DIP_SELECT_AVI () {(0<< 19);}' unless defined(&VIDEO_DIP_SELECT_AVI);
    eval 'sub VIDEO_DIP_SELECT_VENDOR () {(1<< 19);}' unless defined(&VIDEO_DIP_SELECT_VENDOR);
    eval 'sub VIDEO_DIP_SELECT_SPD () {(3<< 19);}' unless defined(&VIDEO_DIP_SELECT_SPD);
    eval 'sub VIDEO_DIP_SELECT_MASK () {(3<< 19);}' unless defined(&VIDEO_DIP_SELECT_MASK);
    eval 'sub VIDEO_DIP_FREQ_ONCE () {(0<< 16);}' unless defined(&VIDEO_DIP_FREQ_ONCE);
    eval 'sub VIDEO_DIP_FREQ_VSYNC () {(1<< 16);}' unless defined(&VIDEO_DIP_FREQ_VSYNC);
    eval 'sub VIDEO_DIP_FREQ_2VSYNC () {(2<< 16);}' unless defined(&VIDEO_DIP_FREQ_2VSYNC);
    eval 'sub PP_STATUS () {0x61200;}' unless defined(&PP_STATUS);
    eval 'sub PP_ON () {(1<< 31);}' unless defined(&PP_ON);
    eval 'sub PP_READY () {(1<< 30);}' unless defined(&PP_READY);
    eval 'sub PP_SEQUENCE_NONE () {(0<< 28);}' unless defined(&PP_SEQUENCE_NONE);
    eval 'sub PP_SEQUENCE_POWER_UP () {(1<< 28);}' unless defined(&PP_SEQUENCE_POWER_UP);
    eval 'sub PP_SEQUENCE_POWER_DOWN () {(2<< 28);}' unless defined(&PP_SEQUENCE_POWER_DOWN);
    eval 'sub PP_SEQUENCE_MASK () {(3<< 28);}' unless defined(&PP_SEQUENCE_MASK);
    eval 'sub PP_SEQUENCE_SHIFT () {28;}' unless defined(&PP_SEQUENCE_SHIFT);
    eval 'sub PP_CYCLE_DELAY_ACTIVE () {(1<< 27);}' unless defined(&PP_CYCLE_DELAY_ACTIVE);
    eval 'sub PP_SEQUENCE_STATE_MASK () {0xf;}' unless defined(&PP_SEQUENCE_STATE_MASK);
    eval 'sub PP_SEQUENCE_STATE_OFF_IDLE () {(0x << 0);}' unless defined(&PP_SEQUENCE_STATE_OFF_IDLE);
    eval 'sub PP_SEQUENCE_STATE_OFF_S0_1 () {(0x1 << 0);}' unless defined(&PP_SEQUENCE_STATE_OFF_S0_1);
    eval 'sub PP_SEQUENCE_STATE_OFF_S0_2 () {(0x2 << 0);}' unless defined(&PP_SEQUENCE_STATE_OFF_S0_2);
    eval 'sub PP_SEQUENCE_STATE_OFF_S0_3 () {(0x3 << 0);}' unless defined(&PP_SEQUENCE_STATE_OFF_S0_3);
    eval 'sub PP_SEQUENCE_STATE_ON_IDLE () {(0x8 << 0);}' unless defined(&PP_SEQUENCE_STATE_ON_IDLE);
    eval 'sub PP_SEQUENCE_STATE_ON_S1_0 () {(0x9 << 0);}' unless defined(&PP_SEQUENCE_STATE_ON_S1_0);
    eval 'sub PP_SEQUENCE_STATE_ON_S1_2 () {(0xa << 0);}' unless defined(&PP_SEQUENCE_STATE_ON_S1_2);
    eval 'sub PP_SEQUENCE_STATE_ON_S1_3 () {(0xb << 0);}' unless defined(&PP_SEQUENCE_STATE_ON_S1_3);
    eval 'sub PP_SEQUENCE_STATE_RESET () {(0xf << 0);}' unless defined(&PP_SEQUENCE_STATE_RESET);
    eval 'sub PP_CONTROL () {0x61204;}' unless defined(&PP_CONTROL);
    eval 'sub POWER_TARGET_ON () {(1<< 0);}' unless defined(&POWER_TARGET_ON);
    eval 'sub PP_ON_DELAYS () {0x61208;}' unless defined(&PP_ON_DELAYS);
    eval 'sub PP_OFF_DELAYS () {0x6120c;}' unless defined(&PP_OFF_DELAYS);
    eval 'sub PP_DIVISOR () {0x61210;}' unless defined(&PP_DIVISOR);
    eval 'sub PFIT_CONTROL () {0x61230;}' unless defined(&PFIT_CONTROL);
    eval 'sub PFIT_ENABLE () {(1<< 31);}' unless defined(&PFIT_ENABLE);
    eval 'sub PFIT_PIPE_MASK () {(3<< 29);}' unless defined(&PFIT_PIPE_MASK);
    eval 'sub PFIT_PIPE_SHIFT () {29;}' unless defined(&PFIT_PIPE_SHIFT);
    eval 'sub VERT_INTERP_DISABLE () {(0<< 10);}' unless defined(&VERT_INTERP_DISABLE);
    eval 'sub VERT_INTERP_BILINEAR () {(1<< 10);}' unless defined(&VERT_INTERP_BILINEAR);
    eval 'sub VERT_INTERP_MASK () {(3<< 10);}' unless defined(&VERT_INTERP_MASK);
    eval 'sub VERT_AUTO_SCALE () {(1<< 9);}' unless defined(&VERT_AUTO_SCALE);
    eval 'sub HORIZ_INTERP_DISABLE () {(0<< 6);}' unless defined(&HORIZ_INTERP_DISABLE);
    eval 'sub HORIZ_INTERP_BILINEAR () {(1<< 6);}' unless defined(&HORIZ_INTERP_BILINEAR);
    eval 'sub HORIZ_INTERP_MASK () {(3<< 6);}' unless defined(&HORIZ_INTERP_MASK);
    eval 'sub HORIZ_AUTO_SCALE () {(1<< 5);}' unless defined(&HORIZ_AUTO_SCALE);
    eval 'sub PANEL_8TO6_DITHER_ENABLE () {(1<< 3);}' unless defined(&PANEL_8TO6_DITHER_ENABLE);
    eval 'sub PFIT_FILTER_FUZZY () {(0<< 24);}' unless defined(&PFIT_FILTER_FUZZY);
    eval 'sub PFIT_SCALING_AUTO () {(0<< 26);}' unless defined(&PFIT_SCALING_AUTO);
    eval 'sub PFIT_SCALING_PROGRAMMED () {(1<< 26);}' unless defined(&PFIT_SCALING_PROGRAMMED);
    eval 'sub PFIT_SCALING_PILLAR () {(2<< 26);}' unless defined(&PFIT_SCALING_PILLAR);
    eval 'sub PFIT_SCALING_LETTER () {(3<< 26);}' unless defined(&PFIT_SCALING_LETTER);
    eval 'sub PFIT_PGM_RATIOS () {0x61234;}' unless defined(&PFIT_PGM_RATIOS);
    eval 'sub PFIT_VERT_SCALE_MASK () {0xfff00000;}' unless defined(&PFIT_VERT_SCALE_MASK);
    eval 'sub PFIT_HORIZ_SCALE_MASK () {0xfff0;}' unless defined(&PFIT_HORIZ_SCALE_MASK);
    eval 'sub PFIT_VERT_SCALE_SHIFT () {20;}' unless defined(&PFIT_VERT_SCALE_SHIFT);
    eval 'sub PFIT_VERT_SCALE_MASK () {0xfff00000;}' unless defined(&PFIT_VERT_SCALE_MASK);
    eval 'sub PFIT_HORIZ_SCALE_SHIFT () {4;}' unless defined(&PFIT_HORIZ_SCALE_SHIFT);
    eval 'sub PFIT_HORIZ_SCALE_MASK () {0xfff0;}' unless defined(&PFIT_HORIZ_SCALE_MASK);
    eval 'sub PFIT_VERT_SCALE_SHIFT_965 () {16;}' unless defined(&PFIT_VERT_SCALE_SHIFT_965);
    eval 'sub PFIT_VERT_SCALE_MASK_965 () {0x1fff0000;}' unless defined(&PFIT_VERT_SCALE_MASK_965);
    eval 'sub PFIT_HORIZ_SCALE_SHIFT_965 () {0;}' unless defined(&PFIT_HORIZ_SCALE_SHIFT_965);
    eval 'sub PFIT_HORIZ_SCALE_MASK_965 () {0x1fff;}' unless defined(&PFIT_HORIZ_SCALE_MASK_965);
    eval 'sub PFIT_AUTO_RATIOS () {0x61238;}' unless defined(&PFIT_AUTO_RATIOS);
    eval 'sub BLC_PWM_CTL () {0x61254;}' unless defined(&BLC_PWM_CTL);
    eval 'sub BACKLIGHT_MODULATION_FREQ_SHIFT () {(17);}' unless defined(&BACKLIGHT_MODULATION_FREQ_SHIFT);
    eval 'sub BLC_PWM_CTL2 () {0x61250;}' unless defined(&BLC_PWM_CTL2);
    eval 'sub BLM_COMBINATION_MODE () {(1<< 30);}' unless defined(&BLM_COMBINATION_MODE);
    eval 'sub BACKLIGHT_MODULATION_FREQ_MASK () {(0x7fff << 17);}' unless defined(&BACKLIGHT_MODULATION_FREQ_MASK);
    eval 'sub BLM_LEGACY_MODE () {(1<< 16);}' unless defined(&BLM_LEGACY_MODE);
    eval 'sub BACKLIGHT_DUTY_CYCLE_SHIFT () {(0);}' unless defined(&BACKLIGHT_DUTY_CYCLE_SHIFT);
    eval 'sub BACKLIGHT_DUTY_CYCLE_MASK () {(0xffff);}' unless defined(&BACKLIGHT_DUTY_CYCLE_MASK);
    eval 'sub BLC_HIST_CTL () {0x61260;}' unless defined(&BLC_HIST_CTL);
    eval 'sub TV_CTL () {0x68000;}' unless defined(&TV_CTL);
    eval 'sub TV_ENC_ENABLE () {(1<< 31);}' unless defined(&TV_ENC_ENABLE);
    eval 'sub TV_ENC_PIPEB_SELECT () {(1<< 30);}' unless defined(&TV_ENC_PIPEB_SELECT);
    eval 'sub TV_ENC_OUTPUT_COMPOSITE () {(0<< 28);}' unless defined(&TV_ENC_OUTPUT_COMPOSITE);
    eval 'sub TV_ENC_OUTPUT_SVIDEO () {(1<< 28);}' unless defined(&TV_ENC_OUTPUT_SVIDEO);
    eval 'sub TV_ENC_OUTPUT_COMPONENT () {(2<< 28);}' unless defined(&TV_ENC_OUTPUT_COMPONENT);
    eval 'sub TV_ENC_OUTPUT_SVIDEO_COMPOSITE () {(3<< 28);}' unless defined(&TV_ENC_OUTPUT_SVIDEO_COMPOSITE);
    eval 'sub TV_TRILEVEL_SYNC () {(1<< 21);}' unless defined(&TV_TRILEVEL_SYNC);
    eval 'sub TV_SLOW_SYNC () {(1<< 20);}' unless defined(&TV_SLOW_SYNC);
    eval 'sub TV_OVERSAMPLE_4X () {(0<< 18);}' unless defined(&TV_OVERSAMPLE_4X);
    eval 'sub TV_OVERSAMPLE_2X () {(1<< 18);}' unless defined(&TV_OVERSAMPLE_2X);
    eval 'sub TV_OVERSAMPLE_NONE () {(2<< 18);}' unless defined(&TV_OVERSAMPLE_NONE);
    eval 'sub TV_OVERSAMPLE_8X () {(3<< 18);}' unless defined(&TV_OVERSAMPLE_8X);
    eval 'sub TV_PROGRESSIVE () {(1<< 17);}' unless defined(&TV_PROGRESSIVE);
    eval 'sub TV_PAL_BURST () {(1<< 16);}' unless defined(&TV_PAL_BURST);
    eval 'sub TV_YC_SKEW_MASK () {(7<< 12);}' unless defined(&TV_YC_SKEW_MASK);
    eval 'sub TV_ENC_SDP_FIX () {(1<< 11);}' unless defined(&TV_ENC_SDP_FIX);
    eval 'sub TV_ENC_C0_FIX () {(1<< 10);}' unless defined(&TV_ENC_C0_FIX);
    eval 'sub TV_CTL_SAVE () {((1<< 11) | (3<< 9) | (7<< 6) | 0xf);}' unless defined(&TV_CTL_SAVE);
    eval 'sub TV_FUSE_STATE_MASK () {(3<< 4);}' unless defined(&TV_FUSE_STATE_MASK);
    eval 'sub TV_FUSE_STATE_ENABLED () {(0<< 4);}' unless defined(&TV_FUSE_STATE_ENABLED);
    eval 'sub TV_FUSE_STATE_NO_MACROVISION () {(1<< 4);}' unless defined(&TV_FUSE_STATE_NO_MACROVISION);
    eval 'sub TV_FUSE_STATE_DISABLED () {(2<< 4);}' unless defined(&TV_FUSE_STATE_DISABLED);
    eval 'sub TV_TEST_MODE_NORMAL () {(0<< 0);}' unless defined(&TV_TEST_MODE_NORMAL);
    eval 'sub TV_TEST_MODE_PATTERN_1 () {(1<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_1);
    eval 'sub TV_TEST_MODE_PATTERN_2 () {(2<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_2);
    eval 'sub TV_TEST_MODE_PATTERN_3 () {(3<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_3);
    eval 'sub TV_TEST_MODE_PATTERN_4 () {(4<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_4);
    eval 'sub TV_TEST_MODE_PATTERN_5 () {(5<< 0);}' unless defined(&TV_TEST_MODE_PATTERN_5);
    eval 'sub TV_TEST_MODE_MONITOR_DETECT () {(7<< 0);}' unless defined(&TV_TEST_MODE_MONITOR_DETECT);
    eval 'sub TV_TEST_MODE_MASK () {(7<< 0);}' unless defined(&TV_TEST_MODE_MASK);
    eval 'sub TV_DAC () {0x68004;}' unless defined(&TV_DAC);
    eval 'sub TV_DAC_SAVE () {0xffff00;}' unless defined(&TV_DAC_SAVE);
    eval 'sub TVDAC_STATE_CHG () {(1<< 31);}' unless defined(&TVDAC_STATE_CHG);
    eval 'sub TVDAC_SENSE_MASK () {(7<< 28);}' unless defined(&TVDAC_SENSE_MASK);
    eval 'sub TVDAC_A_SENSE () {(1<< 30);}' unless defined(&TVDAC_A_SENSE);
    eval 'sub TVDAC_B_SENSE () {(1<< 29);}' unless defined(&TVDAC_B_SENSE);
    eval 'sub TVDAC_C_SENSE () {(1<< 28);}' unless defined(&TVDAC_C_SENSE);
    eval 'sub TVDAC_STATE_CHG_EN () {(1<< 27);}' unless defined(&TVDAC_STATE_CHG_EN);
    eval 'sub TVDAC_A_SENSE_CTL () {(1<< 26);}' unless defined(&TVDAC_A_SENSE_CTL);
    eval 'sub TVDAC_B_SENSE_CTL () {(1<< 25);}' unless defined(&TVDAC_B_SENSE_CTL);
    eval 'sub TVDAC_C_SENSE_CTL () {(1<< 24);}' unless defined(&TVDAC_C_SENSE_CTL);
    eval 'sub DAC_CTL_OVERRIDE () {(1<< 7);}' unless defined(&DAC_CTL_OVERRIDE);
    eval 'sub ENC_TVDAC_SLEW_FAST () {(1<< 6);}' unless defined(&ENC_TVDAC_SLEW_FAST);
    eval 'sub DAC_A_1_3_V () {(0<< 4);}' unless defined(&DAC_A_1_3_V);
    eval 'sub DAC_A_1_1_V () {(1<< 4);}' unless defined(&DAC_A_1_1_V);
    eval 'sub DAC_A_0_7_V () {(2<< 4);}' unless defined(&DAC_A_0_7_V);
    eval 'sub DAC_A_MASK () {(3<< 4);}' unless defined(&DAC_A_MASK);
    eval 'sub DAC_B_1_3_V () {(0<< 2);}' unless defined(&DAC_B_1_3_V);
    eval 'sub DAC_B_1_1_V () {(1<< 2);}' unless defined(&DAC_B_1_1_V);
    eval 'sub DAC_B_0_7_V () {(2<< 2);}' unless defined(&DAC_B_0_7_V);
    eval 'sub DAC_B_MASK () {(3<< 2);}' unless defined(&DAC_B_MASK);
    eval 'sub DAC_C_1_3_V () {(0<< 0);}' unless defined(&DAC_C_1_3_V);
    eval 'sub DAC_C_1_1_V () {(1<< 0);}' unless defined(&DAC_C_1_1_V);
    eval 'sub DAC_C_0_7_V () {(2<< 0);}' unless defined(&DAC_C_0_7_V);
    eval 'sub DAC_C_MASK () {(3<< 0);}' unless defined(&DAC_C_MASK);
    eval 'sub TV_CSC_Y () {0x68010;}' unless defined(&TV_CSC_Y);
    eval 'sub TV_RY_MASK () {0x7ff0000;}' unless defined(&TV_RY_MASK);
    eval 'sub TV_RY_SHIFT () {16;}' unless defined(&TV_RY_SHIFT);
    eval 'sub TV_GY_MASK () {0xfff;}' unless defined(&TV_GY_MASK);
    eval 'sub TV_GY_SHIFT () {0;}' unless defined(&TV_GY_SHIFT);
    eval 'sub TV_CSC_Y2 () {0x68014;}' unless defined(&TV_CSC_Y2);
    eval 'sub TV_BY_MASK () {0x7ff0000;}' unless defined(&TV_BY_MASK);
    eval 'sub TV_BY_SHIFT () {16;}' unless defined(&TV_BY_SHIFT);
    eval 'sub TV_AY_MASK () {0x3ff;}' unless defined(&TV_AY_MASK);
    eval 'sub TV_AY_SHIFT () {0;}' unless defined(&TV_AY_SHIFT);
    eval 'sub TV_CSC_U () {0x68018;}' unless defined(&TV_CSC_U);
    eval 'sub TV_RU_MASK () {0x7ff0000;}' unless defined(&TV_RU_MASK);
    eval 'sub TV_RU_SHIFT () {16;}' unless defined(&TV_RU_SHIFT);
    eval 'sub TV_GU_MASK () {0x7ff;}' unless defined(&TV_GU_MASK);
    eval 'sub TV_GU_SHIFT () {0;}' unless defined(&TV_GU_SHIFT);
    eval 'sub TV_CSC_U2 () {0x6801c;}' unless defined(&TV_CSC_U2);
    eval 'sub TV_BU_MASK () {0x7ff0000;}' unless defined(&TV_BU_MASK);
    eval 'sub TV_BU_SHIFT () {16;}' unless defined(&TV_BU_SHIFT);
    eval 'sub TV_AU_MASK () {0x3ff;}' unless defined(&TV_AU_MASK);
    eval 'sub TV_AU_SHIFT () {0;}' unless defined(&TV_AU_SHIFT);
    eval 'sub TV_CSC_V () {0x68020;}' unless defined(&TV_CSC_V);
    eval 'sub TV_RV_MASK () {0xfff0000;}' unless defined(&TV_RV_MASK);
    eval 'sub TV_RV_SHIFT () {16;}' unless defined(&TV_RV_SHIFT);
    eval 'sub TV_GV_MASK () {0x7ff;}' unless defined(&TV_GV_MASK);
    eval 'sub TV_GV_SHIFT () {0;}' unless defined(&TV_GV_SHIFT);
    eval 'sub TV_CSC_V2 () {0x68024;}' unless defined(&TV_CSC_V2);
    eval 'sub TV_BV_MASK () {0x7ff0000;}' unless defined(&TV_BV_MASK);
    eval 'sub TV_BV_SHIFT () {16;}' unless defined(&TV_BV_SHIFT);
    eval 'sub TV_AV_MASK () {0x7ff;}' unless defined(&TV_AV_MASK);
    eval 'sub TV_AV_SHIFT () {0;}' unless defined(&TV_AV_SHIFT);
    eval 'sub TV_CLR_KNOBS () {0x68028;}' unless defined(&TV_CLR_KNOBS);
    eval 'sub TV_BRIGHTNESS_MASK () {0xff000000;}' unless defined(&TV_BRIGHTNESS_MASK);
    eval 'sub TV_BRIGHTNESS_SHIFT () {24;}' unless defined(&TV_BRIGHTNESS_SHIFT);
    eval 'sub TV_CONTRAST_MASK () {0xff0000;}' unless defined(&TV_CONTRAST_MASK);
    eval 'sub TV_CONTRAST_SHIFT () {16;}' unless defined(&TV_CONTRAST_SHIFT);
    eval 'sub TV_SATURATION_MASK () {0xff00;}' unless defined(&TV_SATURATION_MASK);
    eval 'sub TV_SATURATION_SHIFT () {8;}' unless defined(&TV_SATURATION_SHIFT);
    eval 'sub TV_HUE_MASK () {0xff;}' unless defined(&TV_HUE_MASK);
    eval 'sub TV_HUE_SHIFT () {0;}' unless defined(&TV_HUE_SHIFT);
    eval 'sub TV_CLR_LEVEL () {0x6802c;}' unless defined(&TV_CLR_LEVEL);
    eval 'sub TV_BLACK_LEVEL_MASK () {0x1ff0000;}' unless defined(&TV_BLACK_LEVEL_MASK);
    eval 'sub TV_BLACK_LEVEL_SHIFT () {16;}' unless defined(&TV_BLACK_LEVEL_SHIFT);
    eval 'sub TV_BLANK_LEVEL_MASK () {0x1ff;}' unless defined(&TV_BLANK_LEVEL_MASK);
    eval 'sub TV_BLANK_LEVEL_SHIFT () {0;}' unless defined(&TV_BLANK_LEVEL_SHIFT);
    eval 'sub TV_H_CTL_1 () {0x68030;}' unless defined(&TV_H_CTL_1);
    eval 'sub TV_HSYNC_END_MASK () {0x1fff0000;}' unless defined(&TV_HSYNC_END_MASK);
    eval 'sub TV_HSYNC_END_SHIFT () {16;}' unless defined(&TV_HSYNC_END_SHIFT);
    eval 'sub TV_HTOTAL_MASK () {0x1fff;}' unless defined(&TV_HTOTAL_MASK);
    eval 'sub TV_HTOTAL_SHIFT () {0;}' unless defined(&TV_HTOTAL_SHIFT);
    eval 'sub TV_H_CTL_2 () {0x68034;}' unless defined(&TV_H_CTL_2);
    eval 'sub TV_BURST_ENA () {(1<< 31);}' unless defined(&TV_BURST_ENA);
    eval 'sub TV_HBURST_START_SHIFT () {16;}' unless defined(&TV_HBURST_START_SHIFT);
    eval 'sub TV_HBURST_START_MASK () {0x1fff0000;}' unless defined(&TV_HBURST_START_MASK);
    eval 'sub TV_HBURST_LEN_SHIFT () {0;}' unless defined(&TV_HBURST_LEN_SHIFT);
    eval 'sub TV_HBURST_LEN_MASK () {0x1fff;}' unless defined(&TV_HBURST_LEN_MASK);
    eval 'sub TV_H_CTL_3 () {0x68038;}' unless defined(&TV_H_CTL_3);
    eval 'sub TV_HBLANK_END_SHIFT () {16;}' unless defined(&TV_HBLANK_END_SHIFT);
    eval 'sub TV_HBLANK_END_MASK () {0x1fff0000;}' unless defined(&TV_HBLANK_END_MASK);
    eval 'sub TV_HBLANK_START_SHIFT () {0;}' unless defined(&TV_HBLANK_START_SHIFT);
    eval 'sub TV_HBLANK_START_MASK () {0x1fff;}' unless defined(&TV_HBLANK_START_MASK);
    eval 'sub TV_V_CTL_1 () {0x6803c;}' unless defined(&TV_V_CTL_1);
    eval 'sub TV_NBR_END_SHIFT () {16;}' unless defined(&TV_NBR_END_SHIFT);
    eval 'sub TV_NBR_END_MASK () {0x7ff0000;}' unless defined(&TV_NBR_END_MASK);
    eval 'sub TV_VI_END_F1_SHIFT () {8;}' unless defined(&TV_VI_END_F1_SHIFT);
    eval 'sub TV_VI_END_F1_MASK () {0x3f00;}' unless defined(&TV_VI_END_F1_MASK);
    eval 'sub TV_VI_END_F2_SHIFT () {0;}' unless defined(&TV_VI_END_F2_SHIFT);
    eval 'sub TV_VI_END_F2_MASK () {0x3f;}' unless defined(&TV_VI_END_F2_MASK);
    eval 'sub TV_V_CTL_2 () {0x68040;}' unless defined(&TV_V_CTL_2);
    eval 'sub TV_VSYNC_LEN_MASK () {0x7ff0000;}' unless defined(&TV_VSYNC_LEN_MASK);
    eval 'sub TV_VSYNC_LEN_SHIFT () {16;}' unless defined(&TV_VSYNC_LEN_SHIFT);
    eval 'sub TV_VSYNC_START_F1_MASK () {0x7f00;}' unless defined(&TV_VSYNC_START_F1_MASK);
    eval 'sub TV_VSYNC_START_F1_SHIFT () {8;}' unless defined(&TV_VSYNC_START_F1_SHIFT);
    eval 'sub TV_VSYNC_START_F2_MASK () {0x7f;}' unless defined(&TV_VSYNC_START_F2_MASK);
    eval 'sub TV_VSYNC_START_F2_SHIFT () {0;}' unless defined(&TV_VSYNC_START_F2_SHIFT);
    eval 'sub TV_V_CTL_3 () {0x68044;}' unless defined(&TV_V_CTL_3);
    eval 'sub TV_EQUAL_ENA () {(1<< 31);}' unless defined(&TV_EQUAL_ENA);
    eval 'sub TV_VEQ_LEN_MASK () {0x7f0000;}' unless defined(&TV_VEQ_LEN_MASK);
    eval 'sub TV_VEQ_LEN_SHIFT () {16;}' unless defined(&TV_VEQ_LEN_SHIFT);
    eval 'sub TV_VEQ_START_F1_MASK () {0x7f00;}' unless defined(&TV_VEQ_START_F1_MASK);
    eval 'sub TV_VEQ_START_F1_SHIFT () {8;}' unless defined(&TV_VEQ_START_F1_SHIFT);
    eval 'sub TV_VEQ_START_F2_MASK () {0x7f;}' unless defined(&TV_VEQ_START_F2_MASK);
    eval 'sub TV_VEQ_START_F2_SHIFT () {0;}' unless defined(&TV_VEQ_START_F2_SHIFT);
    eval 'sub TV_V_CTL_4 () {0x68048;}' unless defined(&TV_V_CTL_4);
    eval 'sub TV_VBURST_START_F1_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F1_MASK);
    eval 'sub TV_VBURST_START_F1_SHIFT () {16;}' unless defined(&TV_VBURST_START_F1_SHIFT);
    eval 'sub TV_VBURST_END_F1_MASK () {0xff;}' unless defined(&TV_VBURST_END_F1_MASK);
    eval 'sub TV_VBURST_END_F1_SHIFT () {0;}' unless defined(&TV_VBURST_END_F1_SHIFT);
    eval 'sub TV_V_CTL_5 () {0x6804c;}' unless defined(&TV_V_CTL_5);
    eval 'sub TV_VBURST_START_F2_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F2_MASK);
    eval 'sub TV_VBURST_START_F2_SHIFT () {16;}' unless defined(&TV_VBURST_START_F2_SHIFT);
    eval 'sub TV_VBURST_END_F2_MASK () {0xff;}' unless defined(&TV_VBURST_END_F2_MASK);
    eval 'sub TV_VBURST_END_F2_SHIFT () {0;}' unless defined(&TV_VBURST_END_F2_SHIFT);
    eval 'sub TV_V_CTL_6 () {0x68050;}' unless defined(&TV_V_CTL_6);
    eval 'sub TV_VBURST_START_F3_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F3_MASK);
    eval 'sub TV_VBURST_START_F3_SHIFT () {16;}' unless defined(&TV_VBURST_START_F3_SHIFT);
    eval 'sub TV_VBURST_END_F3_MASK () {0xff;}' unless defined(&TV_VBURST_END_F3_MASK);
    eval 'sub TV_VBURST_END_F3_SHIFT () {0;}' unless defined(&TV_VBURST_END_F3_SHIFT);
    eval 'sub TV_V_CTL_7 () {0x68054;}' unless defined(&TV_V_CTL_7);
    eval 'sub TV_VBURST_START_F4_MASK () {0x3f0000;}' unless defined(&TV_VBURST_START_F4_MASK);
    eval 'sub TV_VBURST_START_F4_SHIFT () {16;}' unless defined(&TV_VBURST_START_F4_SHIFT);
    eval 'sub TV_VBURST_END_F4_MASK () {0xff;}' unless defined(&TV_VBURST_END_F4_MASK);
    eval 'sub TV_VBURST_END_F4_SHIFT () {0;}' unless defined(&TV_VBURST_END_F4_SHIFT);
    eval 'sub TV_SC_CTL_1 () {0x68060;}' unless defined(&TV_SC_CTL_1);
    eval 'sub TV_SC_DDA1_EN () {(1<< 31);}' unless defined(&TV_SC_DDA1_EN);
    eval 'sub TV_SC_DDA2_EN () {(1<< 30);}' unless defined(&TV_SC_DDA2_EN);
    eval 'sub TV_SC_DDA3_EN () {(1<< 29);}' unless defined(&TV_SC_DDA3_EN);
    eval 'sub TV_SC_RESET_EVERY_2 () {(0<< 24);}' unless defined(&TV_SC_RESET_EVERY_2);
    eval 'sub TV_SC_RESET_EVERY_4 () {(1<< 24);}' unless defined(&TV_SC_RESET_EVERY_4);
    eval 'sub TV_SC_RESET_EVERY_8 () {(2<< 24);}' unless defined(&TV_SC_RESET_EVERY_8);
    eval 'sub TV_SC_RESET_NEVER () {(3<< 24);}' unless defined(&TV_SC_RESET_NEVER);
    eval 'sub TV_BURST_LEVEL_MASK () {0xff0000;}' unless defined(&TV_BURST_LEVEL_MASK);
    eval 'sub TV_BURST_LEVEL_SHIFT () {16;}' unless defined(&TV_BURST_LEVEL_SHIFT);
    eval 'sub TV_SCDDA1_INC_MASK () {0xfff;}' unless defined(&TV_SCDDA1_INC_MASK);
    eval 'sub TV_SCDDA1_INC_SHIFT () {0;}' unless defined(&TV_SCDDA1_INC_SHIFT);
    eval 'sub TV_SC_CTL_2 () {0x68064;}' unless defined(&TV_SC_CTL_2);
    eval 'sub TV_SCDDA2_SIZE_MASK () {0x7fff0000;}' unless defined(&TV_SCDDA2_SIZE_MASK);
    eval 'sub TV_SCDDA2_SIZE_SHIFT () {16;}' unless defined(&TV_SCDDA2_SIZE_SHIFT);
    eval 'sub TV_SCDDA2_INC_MASK () {0x7fff;}' unless defined(&TV_SCDDA2_INC_MASK);
    eval 'sub TV_SCDDA2_INC_SHIFT () {0;}' unless defined(&TV_SCDDA2_INC_SHIFT);
    eval 'sub TV_SC_CTL_3 () {0x68068;}' unless defined(&TV_SC_CTL_3);
    eval 'sub TV_SCDDA3_SIZE_MASK () {0x7fff0000;}' unless defined(&TV_SCDDA3_SIZE_MASK);
    eval 'sub TV_SCDDA3_SIZE_SHIFT () {16;}' unless defined(&TV_SCDDA3_SIZE_SHIFT);
    eval 'sub TV_SCDDA3_INC_MASK () {0x7fff;}' unless defined(&TV_SCDDA3_INC_MASK);
    eval 'sub TV_SCDDA3_INC_SHIFT () {0;}' unless defined(&TV_SCDDA3_INC_SHIFT);
    eval 'sub TV_WIN_POS () {0x68070;}' unless defined(&TV_WIN_POS);
    eval 'sub TV_XPOS_MASK () {0x1fff0000;}' unless defined(&TV_XPOS_MASK);
    eval 'sub TV_XPOS_SHIFT () {16;}' unless defined(&TV_XPOS_SHIFT);
    eval 'sub TV_YPOS_MASK () {0xfff;}' unless defined(&TV_YPOS_MASK);
    eval 'sub TV_YPOS_SHIFT () {0;}' unless defined(&TV_YPOS_SHIFT);
    eval 'sub TV_WIN_SIZE () {0x68074;}' unless defined(&TV_WIN_SIZE);
    eval 'sub TV_XSIZE_MASK () {0x1fff0000;}' unless defined(&TV_XSIZE_MASK);
    eval 'sub TV_XSIZE_SHIFT () {16;}' unless defined(&TV_XSIZE_SHIFT);
    eval 'sub TV_YSIZE_MASK () {0xfff;}' unless defined(&TV_YSIZE_MASK);
    eval 'sub TV_YSIZE_SHIFT () {0;}' unless defined(&TV_YSIZE_SHIFT);
    eval 'sub TV_FILTER_CTL_1 () {0x68080;}' unless defined(&TV_FILTER_CTL_1);
    eval 'sub TV_AUTO_SCALE () {(1<< 31);}' unless defined(&TV_AUTO_SCALE);
    eval 'sub TV_V_FILTER_BYPASS () {(1<< 29);}' unless defined(&TV_V_FILTER_BYPASS);
    eval 'sub TV_VADAPT () {(1<< 28);}' unless defined(&TV_VADAPT);
    eval 'sub TV_VADAPT_MODE_MASK () {(3<< 26);}' unless defined(&TV_VADAPT_MODE_MASK);
    eval 'sub TV_VADAPT_MODE_LEAST () {(0<< 26);}' unless defined(&TV_VADAPT_MODE_LEAST);
    eval 'sub TV_VADAPT_MODE_MODERATE () {(1<< 26);}' unless defined(&TV_VADAPT_MODE_MODERATE);
    eval 'sub TV_VADAPT_MODE_MOST () {(3<< 26);}' unless defined(&TV_VADAPT_MODE_MOST);
    eval 'sub TV_HSCALE_FRAC_MASK () {0x3fff;}' unless defined(&TV_HSCALE_FRAC_MASK);
    eval 'sub TV_HSCALE_FRAC_SHIFT () {0;}' unless defined(&TV_HSCALE_FRAC_SHIFT);
    eval 'sub TV_FILTER_CTL_2 () {0x68084;}' unless defined(&TV_FILTER_CTL_2);
    eval 'sub TV_VSCALE_INT_MASK () {0x38000;}' unless defined(&TV_VSCALE_INT_MASK);
    eval 'sub TV_VSCALE_INT_SHIFT () {15;}' unless defined(&TV_VSCALE_INT_SHIFT);
    eval 'sub TV_VSCALE_FRAC_MASK () {0x7fff;}' unless defined(&TV_VSCALE_FRAC_MASK);
    eval 'sub TV_VSCALE_FRAC_SHIFT () {0;}' unless defined(&TV_VSCALE_FRAC_SHIFT);
    eval 'sub TV_FILTER_CTL_3 () {0x68088;}' unless defined(&TV_FILTER_CTL_3);
    eval 'sub TV_VSCALE_IP_INT_MASK () {0x38000;}' unless defined(&TV_VSCALE_IP_INT_MASK);
    eval 'sub TV_VSCALE_IP_INT_SHIFT () {15;}' unless defined(&TV_VSCALE_IP_INT_SHIFT);
    eval 'sub TV_VSCALE_IP_FRAC_MASK () {0x7fff;}' unless defined(&TV_VSCALE_IP_FRAC_MASK);
    eval 'sub TV_VSCALE_IP_FRAC_SHIFT () {0;}' unless defined(&TV_VSCALE_IP_FRAC_SHIFT);
    eval 'sub TV_CC_CONTROL () {0x68090;}' unless defined(&TV_CC_CONTROL);
    eval 'sub TV_CC_ENABLE () {(1<< 31);}' unless defined(&TV_CC_ENABLE);
    eval 'sub TV_CC_FID_MASK () {(1<< 27);}' unless defined(&TV_CC_FID_MASK);
    eval 'sub TV_CC_FID_SHIFT () {27;}' unless defined(&TV_CC_FID_SHIFT);
    eval 'sub TV_CC_HOFF_MASK () {0x3ff0000;}' unless defined(&TV_CC_HOFF_MASK);
    eval 'sub TV_CC_HOFF_SHIFT () {16;}' unless defined(&TV_CC_HOFF_SHIFT);
    eval 'sub TV_CC_LINE_MASK () {0x3f;}' unless defined(&TV_CC_LINE_MASK);
    eval 'sub TV_CC_LINE_SHIFT () {0;}' unless defined(&TV_CC_LINE_SHIFT);
    eval 'sub TV_CC_DATA () {0x68094;}' unless defined(&TV_CC_DATA);
    eval 'sub TV_CC_RDY () {(1<< 31);}' unless defined(&TV_CC_RDY);
    eval 'sub TV_CC_DATA_2_MASK () {0x7f0000;}' unless defined(&TV_CC_DATA_2_MASK);
    eval 'sub TV_CC_DATA_2_SHIFT () {16;}' unless defined(&TV_CC_DATA_2_SHIFT);
    eval 'sub TV_CC_DATA_1_MASK () {0x7f;}' unless defined(&TV_CC_DATA_1_MASK);
    eval 'sub TV_CC_DATA_1_SHIFT () {0;}' unless defined(&TV_CC_DATA_1_SHIFT);
    eval 'sub TV_H_LUMA_0 () {0x68100;}' unless defined(&TV_H_LUMA_0);
    eval 'sub TV_H_LUMA_59 () {0x681ec;}' unless defined(&TV_H_LUMA_59);
    eval 'sub TV_H_CHROMA_0 () {0x68200;}' unless defined(&TV_H_CHROMA_0);
    eval 'sub TV_H_CHROMA_59 () {0x682ec;}' unless defined(&TV_H_CHROMA_59);
    eval 'sub TV_V_LUMA_0 () {0x68300;}' unless defined(&TV_V_LUMA_0);
    eval 'sub TV_V_LUMA_42 () {0x683a8;}' unless defined(&TV_V_LUMA_42);
    eval 'sub TV_V_CHROMA_0 () {0x68400;}' unless defined(&TV_V_CHROMA_0);
    eval 'sub TV_V_CHROMA_42 () {0x684a8;}' unless defined(&TV_V_CHROMA_42);
    eval 'sub DP_A () {0x64000;}' unless defined(&DP_A);
    eval 'sub DP_B () {0x64100;}' unless defined(&DP_B);
    eval 'sub DP_C () {0x64200;}' unless defined(&DP_C);
    eval 'sub DP_D () {0x64300;}' unless defined(&DP_D);
    eval 'sub DP_PORT_EN () {(1<< 31);}' unless defined(&DP_PORT_EN);
    eval 'sub DP_PIPEB_SELECT () {(1<< 30);}' unless defined(&DP_PIPEB_SELECT);
    eval 'sub DP_PIPE_MASK () {(1<< 30);}' unless defined(&DP_PIPE_MASK);
    eval 'sub DP_LINK_TRAIN_PAT_1 () {(0<< 28);}' unless defined(&DP_LINK_TRAIN_PAT_1);
    eval 'sub DP_LINK_TRAIN_PAT_2 () {(1<< 28);}' unless defined(&DP_LINK_TRAIN_PAT_2);
    eval 'sub DP_LINK_TRAIN_PAT_IDLE () {(2<< 28);}' unless defined(&DP_LINK_TRAIN_PAT_IDLE);
    eval 'sub DP_LINK_TRAIN_OFF () {(3<< 28);}' unless defined(&DP_LINK_TRAIN_OFF);
    eval 'sub DP_LINK_TRAIN_MASK () {(3<< 28);}' unless defined(&DP_LINK_TRAIN_MASK);
    eval 'sub DP_LINK_TRAIN_SHIFT () {28;}' unless defined(&DP_LINK_TRAIN_SHIFT);
    eval 'sub DP_LINK_TRAIN_PAT_1_CPT () {(0<< 8);}' unless defined(&DP_LINK_TRAIN_PAT_1_CPT);
    eval 'sub DP_LINK_TRAIN_PAT_2_CPT () {(1<< 8);}' unless defined(&DP_LINK_TRAIN_PAT_2_CPT);
    eval 'sub DP_LINK_TRAIN_PAT_IDLE_CPT () {(2<< 8);}' unless defined(&DP_LINK_TRAIN_PAT_IDLE_CPT);
    eval 'sub DP_LINK_TRAIN_OFF_CPT () {(3<< 8);}' unless defined(&DP_LINK_TRAIN_OFF_CPT);
    eval 'sub DP_LINK_TRAIN_MASK_CPT () {(7<< 8);}' unless defined(&DP_LINK_TRAIN_MASK_CPT);
    eval 'sub DP_LINK_TRAIN_SHIFT_CPT () {8;}' unless defined(&DP_LINK_TRAIN_SHIFT_CPT);
    eval 'sub DP_VOLTAGE_0_4 () {(0<< 25);}' unless defined(&DP_VOLTAGE_0_4);
    eval 'sub DP_VOLTAGE_0_6 () {(1<< 25);}' unless defined(&DP_VOLTAGE_0_6);
    eval 'sub DP_VOLTAGE_0_8 () {(2<< 25);}' unless defined(&DP_VOLTAGE_0_8);
    eval 'sub DP_VOLTAGE_1_2 () {(3<< 25);}' unless defined(&DP_VOLTAGE_1_2);
    eval 'sub DP_VOLTAGE_MASK () {(7<< 25);}' unless defined(&DP_VOLTAGE_MASK);
    eval 'sub DP_VOLTAGE_SHIFT () {25;}' unless defined(&DP_VOLTAGE_SHIFT);
    eval 'sub DP_PRE_EMPHASIS_0 () {(0<< 22);}' unless defined(&DP_PRE_EMPHASIS_0);
    eval 'sub DP_PRE_EMPHASIS_3_5 () {(1<< 22);}' unless defined(&DP_PRE_EMPHASIS_3_5);
    eval 'sub DP_PRE_EMPHASIS_6 () {(2<< 22);}' unless defined(&DP_PRE_EMPHASIS_6);
    eval 'sub DP_PRE_EMPHASIS_9_5 () {(3<< 22);}' unless defined(&DP_PRE_EMPHASIS_9_5);
    eval 'sub DP_PRE_EMPHASIS_MASK () {(7<< 22);}' unless defined(&DP_PRE_EMPHASIS_MASK);
    eval 'sub DP_PRE_EMPHASIS_SHIFT () {22;}' unless defined(&DP_PRE_EMPHASIS_SHIFT);
    eval 'sub DP_PORT_WIDTH_1 () {(0<< 19);}' unless defined(&DP_PORT_WIDTH_1);
    eval 'sub DP_PORT_WIDTH_2 () {(1<< 19);}' unless defined(&DP_PORT_WIDTH_2);
    eval 'sub DP_PORT_WIDTH_4 () {(3<< 19);}' unless defined(&DP_PORT_WIDTH_4);
    eval 'sub DP_PORT_WIDTH_MASK () {(7<< 19);}' unless defined(&DP_PORT_WIDTH_MASK);
    eval 'sub DP_ENHANCED_FRAMING () {(1<< 18);}' unless defined(&DP_ENHANCED_FRAMING);
    eval 'sub DP_PLL_FREQ_270MHZ () {(0<< 16);}' unless defined(&DP_PLL_FREQ_270MHZ);
    eval 'sub DP_PLL_FREQ_160MHZ () {(1<< 16);}' unless defined(&DP_PLL_FREQ_160MHZ);
    eval 'sub DP_PLL_FREQ_MASK () {(3<< 16);}' unless defined(&DP_PLL_FREQ_MASK);
    eval 'sub DP_PORT_REVERSAL () {(1<< 15);}' unless defined(&DP_PORT_REVERSAL);
    eval 'sub DP_PLL_ENABLE () {(1<< 14);}' unless defined(&DP_PLL_ENABLE);
    eval 'sub DP_CLOCK_OUTPUT_ENABLE () {(1<< 13);}' unless defined(&DP_CLOCK_OUTPUT_ENABLE);
    eval 'sub DP_SCRAMBLING_DISABLE () {(1<< 12);}' unless defined(&DP_SCRAMBLING_DISABLE);
    eval 'sub DP_SCRAMBLING_DISABLE_IRONLAKE () {(1<< 7);}' unless defined(&DP_SCRAMBLING_DISABLE_IRONLAKE);
    eval 'sub DP_COLOR_RANGE_16_235 () {(1<< 8);}' unless defined(&DP_COLOR_RANGE_16_235);
    eval 'sub DP_AUDIO_OUTPUT_ENABLE () {(1<< 6);}' unless defined(&DP_AUDIO_OUTPUT_ENABLE);
    eval 'sub DP_SYNC_VS_HIGH () {(1<< 4);}' unless defined(&DP_SYNC_VS_HIGH);
    eval 'sub DP_SYNC_HS_HIGH () {(1<< 3);}' unless defined(&DP_SYNC_HS_HIGH);
    eval 'sub DP_DETECTED () {(1<< 2);}' unless defined(&DP_DETECTED);
    eval 'sub DPA_AUX_CH_CTL () {0x64010;}' unless defined(&DPA_AUX_CH_CTL);
    eval 'sub DPA_AUX_CH_DATA1 () {0x64014;}' unless defined(&DPA_AUX_CH_DATA1);
    eval 'sub DPA_AUX_CH_DATA2 () {0x64018;}' unless defined(&DPA_AUX_CH_DATA2);
    eval 'sub DPA_AUX_CH_DATA3 () {0x6401c;}' unless defined(&DPA_AUX_CH_DATA3);
    eval 'sub DPA_AUX_CH_DATA4 () {0x64020;}' unless defined(&DPA_AUX_CH_DATA4);
    eval 'sub DPA_AUX_CH_DATA5 () {0x64024;}' unless defined(&DPA_AUX_CH_DATA5);
    eval 'sub DPB_AUX_CH_CTL () {0x64110;}' unless defined(&DPB_AUX_CH_CTL);
    eval 'sub DPB_AUX_CH_DATA1 () {0x64114;}' unless defined(&DPB_AUX_CH_DATA1);
    eval 'sub DPB_AUX_CH_DATA2 () {0x64118;}' unless defined(&DPB_AUX_CH_DATA2);
    eval 'sub DPB_AUX_CH_DATA3 () {0x6411c;}' unless defined(&DPB_AUX_CH_DATA3);
    eval 'sub DPB_AUX_CH_DATA4 () {0x64120;}' unless defined(&DPB_AUX_CH_DATA4);
    eval 'sub DPB_AUX_CH_DATA5 () {0x64124;}' unless defined(&DPB_AUX_CH_DATA5);
    eval 'sub DPC_AUX_CH_CTL () {0x64210;}' unless defined(&DPC_AUX_CH_CTL);
    eval 'sub DPC_AUX_CH_DATA1 () {0x64214;}' unless defined(&DPC_AUX_CH_DATA1);
    eval 'sub DPC_AUX_CH_DATA2 () {0x64218;}' unless defined(&DPC_AUX_CH_DATA2);
    eval 'sub DPC_AUX_CH_DATA3 () {0x6421c;}' unless defined(&DPC_AUX_CH_DATA3);
    eval 'sub DPC_AUX_CH_DATA4 () {0x64220;}' unless defined(&DPC_AUX_CH_DATA4);
    eval 'sub DPC_AUX_CH_DATA5 () {0x64224;}' unless defined(&DPC_AUX_CH_DATA5);
    eval 'sub DPD_AUX_CH_CTL () {0x64310;}' unless defined(&DPD_AUX_CH_CTL);
    eval 'sub DPD_AUX_CH_DATA1 () {0x64314;}' unless defined(&DPD_AUX_CH_DATA1);
    eval 'sub DPD_AUX_CH_DATA2 () {0x64318;}' unless defined(&DPD_AUX_CH_DATA2);
    eval 'sub DPD_AUX_CH_DATA3 () {0x6431c;}' unless defined(&DPD_AUX_CH_DATA3);
    eval 'sub DPD_AUX_CH_DATA4 () {0x64320;}' unless defined(&DPD_AUX_CH_DATA4);
    eval 'sub DPD_AUX_CH_DATA5 () {0x64324;}' unless defined(&DPD_AUX_CH_DATA5);
    eval 'sub DP_AUX_CH_CTL_SEND_BUSY () {(1<< 31);}' unless defined(&DP_AUX_CH_CTL_SEND_BUSY);
    eval 'sub DP_AUX_CH_CTL_DONE () {(1<< 30);}' unless defined(&DP_AUX_CH_CTL_DONE);
    eval 'sub DP_AUX_CH_CTL_INTERRUPT () {(1<< 29);}' unless defined(&DP_AUX_CH_CTL_INTERRUPT);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_ERROR () {(1<< 28);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_ERROR);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_400us () {(0<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_400us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_600us () {(1<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_600us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_800us () {(2<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_800us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_1600us () {(3<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_1600us);
    eval 'sub DP_AUX_CH_CTL_TIME_OUT_MASK () {(3<< 26);}' unless defined(&DP_AUX_CH_CTL_TIME_OUT_MASK);
    eval 'sub DP_AUX_CH_CTL_RECEIVE_ERROR () {(1<< 25);}' unless defined(&DP_AUX_CH_CTL_RECEIVE_ERROR);
    eval 'sub DP_AUX_CH_CTL_MESSAGE_SIZE_MASK () {(0x1f << 20);}' unless defined(&DP_AUX_CH_CTL_MESSAGE_SIZE_MASK);
    eval 'sub DP_AUX_CH_CTL_MESSAGE_SIZE_SHIFT () {20;}' unless defined(&DP_AUX_CH_CTL_MESSAGE_SIZE_SHIFT);
    eval 'sub DP_AUX_CH_CTL_PRECHARGE_2US_MASK () {(0xf << 16);}' unless defined(&DP_AUX_CH_CTL_PRECHARGE_2US_MASK);
    eval 'sub DP_AUX_CH_CTL_PRECHARGE_2US_SHIFT () {16;}' unless defined(&DP_AUX_CH_CTL_PRECHARGE_2US_SHIFT);
    eval 'sub DP_AUX_CH_CTL_AUX_AKSV_SELECT () {(1<< 15);}' unless defined(&DP_AUX_CH_CTL_AUX_AKSV_SELECT);
    eval 'sub DP_AUX_CH_CTL_MANCHESTER_TEST () {(1<< 14);}' unless defined(&DP_AUX_CH_CTL_MANCHESTER_TEST);
    eval 'sub DP_AUX_CH_CTL_SYNC_TEST () {(1<< 13);}' unless defined(&DP_AUX_CH_CTL_SYNC_TEST);
    eval 'sub DP_AUX_CH_CTL_DEGLITCH_TEST () {(1<< 12);}' unless defined(&DP_AUX_CH_CTL_DEGLITCH_TEST);
    eval 'sub DP_AUX_CH_CTL_PRECHARGE_TEST () {(1<< 11);}' unless defined(&DP_AUX_CH_CTL_PRECHARGE_TEST);
    eval 'sub DP_AUX_CH_CTL_BIT_CLOCK_2X_MASK () {(0x7ff);}' unless defined(&DP_AUX_CH_CTL_BIT_CLOCK_2X_MASK);
    eval 'sub DP_AUX_CH_CTL_BIT_CLOCK_2X_SHIFT () {0;}' unless defined(&DP_AUX_CH_CTL_BIT_CLOCK_2X_SHIFT);
    eval 'sub _PIPEA_GMCH_DATA_M () {0x70050;}' unless defined(&_PIPEA_GMCH_DATA_M);
    eval 'sub _PIPEB_GMCH_DATA_M () {0x71050;}' unless defined(&_PIPEB_GMCH_DATA_M);
    eval 'sub PIPE_GMCH_DATA_M_TU_SIZE_MASK () {(0x3f << 25);}' unless defined(&PIPE_GMCH_DATA_M_TU_SIZE_MASK);
    eval 'sub PIPE_GMCH_DATA_M_TU_SIZE_SHIFT () {25;}' unless defined(&PIPE_GMCH_DATA_M_TU_SIZE_SHIFT);
    eval 'sub PIPE_GMCH_DATA_M_MASK () {(0xffffff);}' unless defined(&PIPE_GMCH_DATA_M_MASK);
    eval 'sub _PIPEA_GMCH_DATA_N () {0x70054;}' unless defined(&_PIPEA_GMCH_DATA_N);
    eval 'sub _PIPEB_GMCH_DATA_N () {0x71054;}' unless defined(&_PIPEB_GMCH_DATA_N);
    eval 'sub PIPE_GMCH_DATA_N_MASK () {(0xffffff);}' unless defined(&PIPE_GMCH_DATA_N_MASK);
    eval 'sub _PIPEA_DP_LINK_M () {0x70060;}' unless defined(&_PIPEA_DP_LINK_M);
    eval 'sub _PIPEB_DP_LINK_M () {0x71060;}' unless defined(&_PIPEB_DP_LINK_M);
    eval 'sub PIPEA_DP_LINK_M_MASK () {(0xffffff);}' unless defined(&PIPEA_DP_LINK_M_MASK);
    eval 'sub _PIPEA_DP_LINK_N () {0x70064;}' unless defined(&_PIPEA_DP_LINK_N);
    eval 'sub _PIPEB_DP_LINK_N () {0x71064;}' unless defined(&_PIPEB_DP_LINK_N);
    eval 'sub PIPEA_DP_LINK_N_MASK () {(0xffffff);}' unless defined(&PIPEA_DP_LINK_N_MASK);
    eval 'sub PIPE_GMCH_DATA_M {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_GMCH_DATA_M,  &_PIPEB_GMCH_DATA_M));
    }' unless defined(&PIPE_GMCH_DATA_M);
    eval 'sub PIPE_GMCH_DATA_N {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_GMCH_DATA_N,  &_PIPEB_GMCH_DATA_N));
    }' unless defined(&PIPE_GMCH_DATA_N);
    eval 'sub PIPE_DP_LINK_M {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_DP_LINK_M,  &_PIPEB_DP_LINK_M));
    }' unless defined(&PIPE_DP_LINK_M);
    eval 'sub PIPE_DP_LINK_N {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_DP_LINK_N,  &_PIPEB_DP_LINK_N));
    }' unless defined(&PIPE_DP_LINK_N);
    eval 'sub _PIPEADSL () {0x70000;}' unless defined(&_PIPEADSL);
    eval 'sub DSL_LINEMASK () {0xfff;}' unless defined(&DSL_LINEMASK);
    eval 'sub _PIPEACONF () {0x70008;}' unless defined(&_PIPEACONF);
    eval 'sub PIPECONF_ENABLE () {(1<<31);}' unless defined(&PIPECONF_ENABLE);
    eval 'sub PIPECONF_DISABLE () {0;}' unless defined(&PIPECONF_DISABLE);
    eval 'sub PIPECONF_DOUBLE_WIDE () {(1<<30);}' unless defined(&PIPECONF_DOUBLE_WIDE);
    eval 'sub I965_PIPECONF_ACTIVE () {(1<<30);}' unless defined(&I965_PIPECONF_ACTIVE);
    eval 'sub PIPECONF_FRAME_START_DELAY_MASK () {(3<<27);}' unless defined(&PIPECONF_FRAME_START_DELAY_MASK);
    eval 'sub PIPECONF_SINGLE_WIDE () {0;}' unless defined(&PIPECONF_SINGLE_WIDE);
    eval 'sub PIPECONF_PIPE_UNLOCKED () {0;}' unless defined(&PIPECONF_PIPE_UNLOCKED);
    eval 'sub PIPECONF_PIPE_LOCKED () {(1<<25);}' unless defined(&PIPECONF_PIPE_LOCKED);
    eval 'sub PIPECONF_PALETTE () {0;}' unless defined(&PIPECONF_PALETTE);
    eval 'sub PIPECONF_GAMMA () {(1<<24);}' unless defined(&PIPECONF_GAMMA);
    eval 'sub PIPECONF_FORCE_BORDER () {(1<<25);}' unless defined(&PIPECONF_FORCE_BORDER);
    eval 'sub PIPECONF_INTERLACE_MASK () {(7<< 21);}' unless defined(&PIPECONF_INTERLACE_MASK);
    eval 'sub PIPECONF_PROGRESSIVE () {(0<< 21);}' unless defined(&PIPECONF_PROGRESSIVE);
    eval 'sub PIPECONF_INTERLACE_W_SYNC_SHIFT_PANEL () {(4<< 21);}' unless defined(&PIPECONF_INTERLACE_W_SYNC_SHIFT_PANEL);
    eval 'sub PIPECONF_INTERLACE_W_SYNC_SHIFT () {(5<< 21);}' unless defined(&PIPECONF_INTERLACE_W_SYNC_SHIFT);
    eval 'sub PIPECONF_INTERLACE_W_FIELD_INDICATION () {(6<< 21);}' unless defined(&PIPECONF_INTERLACE_W_FIELD_INDICATION);
    eval 'sub PIPECONF_INTERLACE_FIELD_0_ONLY () {(7<< 21);}' unless defined(&PIPECONF_INTERLACE_FIELD_0_ONLY);
    eval 'sub PIPECONF_PFIT_PF_INTERLACED_ILK () {(1<< 21);}' unless defined(&PIPECONF_PFIT_PF_INTERLACED_ILK);
    eval 'sub PIPECONF_INTERLACED_ILK () {(3<< 21);}' unless defined(&PIPECONF_INTERLACED_ILK);
    eval 'sub PIPECONF_INTERLACED_DBL_ILK () {(4<< 21);}' unless defined(&PIPECONF_INTERLACED_DBL_ILK);
    eval 'sub PIPECONF_PFIT_PF_INTERLACED_DBL_ILK () {(5<< 21);}' unless defined(&PIPECONF_PFIT_PF_INTERLACED_DBL_ILK);
    eval 'sub PIPECONF_CXSR_DOWNCLOCK () {(1<<16);}' unless defined(&PIPECONF_CXSR_DOWNCLOCK);
    eval 'sub PIPECONF_BPP_MASK () {(0xe0);}' unless defined(&PIPECONF_BPP_MASK);
    eval 'sub PIPECONF_BPP_8 () {(0<<5);}' unless defined(&PIPECONF_BPP_8);
    eval 'sub PIPECONF_BPP_10 () {(1<<5);}' unless defined(&PIPECONF_BPP_10);
    eval 'sub PIPECONF_BPP_6 () {(2<<5);}' unless defined(&PIPECONF_BPP_6);
    eval 'sub PIPECONF_BPP_12 () {(3<<5);}' unless defined(&PIPECONF_BPP_12);
    eval 'sub PIPECONF_DITHER_EN () {(1<<4);}' unless defined(&PIPECONF_DITHER_EN);
    eval 'sub PIPECONF_DITHER_TYPE_MASK () {(0xc);}' unless defined(&PIPECONF_DITHER_TYPE_MASK);
    eval 'sub PIPECONF_DITHER_TYPE_SP () {(0<<2);}' unless defined(&PIPECONF_DITHER_TYPE_SP);
    eval 'sub PIPECONF_DITHER_TYPE_ST1 () {(1<<2);}' unless defined(&PIPECONF_DITHER_TYPE_ST1);
    eval 'sub PIPECONF_DITHER_TYPE_ST2 () {(2<<2);}' unless defined(&PIPECONF_DITHER_TYPE_ST2);
    eval 'sub PIPECONF_DITHER_TYPE_TEMP () {(3<<2);}' unless defined(&PIPECONF_DITHER_TYPE_TEMP);
    eval 'sub _PIPEASTAT () {0x70024;}' unless defined(&_PIPEASTAT);
    eval 'sub PIPE_FIFO_UNDERRUN_STATUS () {(1<<31);}' unless defined(&PIPE_FIFO_UNDERRUN_STATUS);
    eval 'sub PIPE_CRC_ERROR_ENABLE () {(1<<29);}' unless defined(&PIPE_CRC_ERROR_ENABLE);
    eval 'sub PIPE_CRC_DONE_ENABLE () {(1<<28);}' unless defined(&PIPE_CRC_DONE_ENABLE);
    eval 'sub PIPE_GMBUS_EVENT_ENABLE () {(1<<27);}' unless defined(&PIPE_GMBUS_EVENT_ENABLE);
    eval 'sub PIPE_HOTPLUG_INTERRUPT_ENABLE () {(1<<26);}' unless defined(&PIPE_HOTPLUG_INTERRUPT_ENABLE);
    eval 'sub PIPE_VSYNC_INTERRUPT_ENABLE () {(1<<25);}' unless defined(&PIPE_VSYNC_INTERRUPT_ENABLE);
    eval 'sub PIPE_DISPLAY_LINE_COMPARE_ENABLE () {(1<<24);}' unless defined(&PIPE_DISPLAY_LINE_COMPARE_ENABLE);
    eval 'sub PIPE_DPST_EVENT_ENABLE () {(1<<23);}' unless defined(&PIPE_DPST_EVENT_ENABLE);
    eval 'sub PIPE_LEGACY_BLC_EVENT_ENABLE () {(1<<22);}' unless defined(&PIPE_LEGACY_BLC_EVENT_ENABLE);
    eval 'sub PIPE_ODD_FIELD_INTERRUPT_ENABLE () {(1<<21);}' unless defined(&PIPE_ODD_FIELD_INTERRUPT_ENABLE);
    eval 'sub PIPE_EVEN_FIELD_INTERRUPT_ENABLE () {(1<<20);}' unless defined(&PIPE_EVEN_FIELD_INTERRUPT_ENABLE);
    eval 'sub PIPE_HOTPLUG_TV_INTERRUPT_ENABLE () {(1<<18);}' unless defined(&PIPE_HOTPLUG_TV_INTERRUPT_ENABLE);
    eval 'sub PIPE_START_VBLANK_INTERRUPT_ENABLE () {(1<<18);}' unless defined(&PIPE_START_VBLANK_INTERRUPT_ENABLE);
    eval 'sub PIPE_VBLANK_INTERRUPT_ENABLE () {(1<<17);}' unless defined(&PIPE_VBLANK_INTERRUPT_ENABLE);
    eval 'sub PIPE_OVERLAY_UPDATED_ENABLE () {(1<<16);}' unless defined(&PIPE_OVERLAY_UPDATED_ENABLE);
    eval 'sub PIPE_CRC_ERROR_INTERRUPT_STATUS () {(1<<13);}' unless defined(&PIPE_CRC_ERROR_INTERRUPT_STATUS);
    eval 'sub PIPE_CRC_DONE_INTERRUPT_STATUS () {(1<<12);}' unless defined(&PIPE_CRC_DONE_INTERRUPT_STATUS);
    eval 'sub PIPE_GMBUS_INTERRUPT_STATUS () {(1<<11);}' unless defined(&PIPE_GMBUS_INTERRUPT_STATUS);
    eval 'sub PIPE_HOTPLUG_INTERRUPT_STATUS () {(1<<10);}' unless defined(&PIPE_HOTPLUG_INTERRUPT_STATUS);
    eval 'sub PIPE_VSYNC_INTERRUPT_STATUS () {(1<<9);}' unless defined(&PIPE_VSYNC_INTERRUPT_STATUS);
    eval 'sub PIPE_DISPLAY_LINE_COMPARE_STATUS () {(1<<8);}' unless defined(&PIPE_DISPLAY_LINE_COMPARE_STATUS);
    eval 'sub PIPE_DPST_EVENT_STATUS () {(1<<7);}' unless defined(&PIPE_DPST_EVENT_STATUS);
    eval 'sub PIPE_LEGACY_BLC_EVENT_STATUS () {(1<<6);}' unless defined(&PIPE_LEGACY_BLC_EVENT_STATUS);
    eval 'sub PIPE_ODD_FIELD_INTERRUPT_STATUS () {(1<<5);}' unless defined(&PIPE_ODD_FIELD_INTERRUPT_STATUS);
    eval 'sub PIPE_EVEN_FIELD_INTERRUPT_STATUS () {(1<<4);}' unless defined(&PIPE_EVEN_FIELD_INTERRUPT_STATUS);
    eval 'sub PIPE_HOTPLUG_TV_INTERRUPT_STATUS () {(1<<2);}' unless defined(&PIPE_HOTPLUG_TV_INTERRUPT_STATUS);
    eval 'sub PIPE_START_VBLANK_INTERRUPT_STATUS () {(1<<2);}' unless defined(&PIPE_START_VBLANK_INTERRUPT_STATUS);
    eval 'sub PIPE_VBLANK_INTERRUPT_STATUS () {(1<<1);}' unless defined(&PIPE_VBLANK_INTERRUPT_STATUS);
    eval 'sub PIPE_OVERLAY_UPDATED_STATUS () {(1<<0);}' unless defined(&PIPE_OVERLAY_UPDATED_STATUS);
    eval 'sub PIPE_BPC_MASK () {(7<< 5);}' unless defined(&PIPE_BPC_MASK);
    eval 'sub PIPE_8BPC () {(0<< 5);}' unless defined(&PIPE_8BPC);
    eval 'sub PIPE_10BPC () {(1<< 5);}' unless defined(&PIPE_10BPC);
    eval 'sub PIPE_6BPC () {(2<< 5);}' unless defined(&PIPE_6BPC);
    eval 'sub PIPE_12BPC () {(3<< 5);}' unless defined(&PIPE_12BPC);
    eval 'sub PIPESRC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEASRC,  &_PIPEBSRC));
    }' unless defined(&PIPESRC);
    eval 'sub PIPECONF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEACONF,  &_PIPEBCONF));
    }' unless defined(&PIPECONF);
    eval 'sub PIPEDSL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEADSL,  &_PIPEBDSL));
    }' unless defined(&PIPEDSL);
    eval 'sub PIPEFRAME {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEAFRAMEHIGH,  &_PIPEBFRAMEHIGH));
    }' unless defined(&PIPEFRAME);
    eval 'sub PIPEFRAMEPIXEL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEAFRAMEPIXEL,  &_PIPEBFRAMEPIXEL));
    }' unless defined(&PIPEFRAMEPIXEL);
    eval 'sub PIPESTAT {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEASTAT,  &_PIPEBSTAT));
    }' unless defined(&PIPESTAT);
    eval 'sub DSPARB () {0x70030;}' unless defined(&DSPARB);
    eval 'sub DSPARB_CSTART_MASK () {(0x7f << 7);}' unless defined(&DSPARB_CSTART_MASK);
    eval 'sub DSPARB_CSTART_SHIFT () {7;}' unless defined(&DSPARB_CSTART_SHIFT);
    eval 'sub DSPARB_BSTART_MASK () {(0x7f);}' unless defined(&DSPARB_BSTART_MASK);
    eval 'sub DSPARB_BSTART_SHIFT () {0;}' unless defined(&DSPARB_BSTART_SHIFT);
    eval 'sub DSPARB_BEND_SHIFT () {9;}' unless defined(&DSPARB_BEND_SHIFT);
    eval 'sub DSPARB_AEND_SHIFT () {0;}' unless defined(&DSPARB_AEND_SHIFT);
    eval 'sub DSPFW1 () {0x70034;}' unless defined(&DSPFW1);
    eval 'sub DSPFW_SR_SHIFT () {23;}' unless defined(&DSPFW_SR_SHIFT);
    eval 'sub DSPFW_SR_MASK () {(0x1ff<<23);}' unless defined(&DSPFW_SR_MASK);
    eval 'sub DSPFW_CURSORB_SHIFT () {16;}' unless defined(&DSPFW_CURSORB_SHIFT);
    eval 'sub DSPFW_CURSORB_MASK () {(0x3f<<16);}' unless defined(&DSPFW_CURSORB_MASK);
    eval 'sub DSPFW_PLANEB_SHIFT () {8;}' unless defined(&DSPFW_PLANEB_SHIFT);
    eval 'sub DSPFW_PLANEB_MASK () {(0x7f<<8);}' unless defined(&DSPFW_PLANEB_MASK);
    eval 'sub DSPFW_PLANEA_MASK () {(0x7f);}' unless defined(&DSPFW_PLANEA_MASK);
    eval 'sub DSPFW2 () {0x70038;}' unless defined(&DSPFW2);
    eval 'sub DSPFW_CURSORA_MASK () {0x3f00;}' unless defined(&DSPFW_CURSORA_MASK);
    eval 'sub DSPFW_CURSORA_SHIFT () {8;}' unless defined(&DSPFW_CURSORA_SHIFT);
    eval 'sub DSPFW_PLANEC_MASK () {(0x7f);}' unless defined(&DSPFW_PLANEC_MASK);
    eval 'sub DSPFW3 () {0x7003c;}' unless defined(&DSPFW3);
    eval 'sub DSPFW_HPLL_SR_EN () {(1<<31);}' unless defined(&DSPFW_HPLL_SR_EN);
    eval 'sub DSPFW_CURSOR_SR_SHIFT () {24;}' unless defined(&DSPFW_CURSOR_SR_SHIFT);
    eval 'sub PINEVIEW_SELF_REFRESH_EN () {(1<<30);}' unless defined(&PINEVIEW_SELF_REFRESH_EN);
    eval 'sub DSPFW_CURSOR_SR_MASK () {(0x3f<<24);}' unless defined(&DSPFW_CURSOR_SR_MASK);
    eval 'sub DSPFW_HPLL_CURSOR_SHIFT () {16;}' unless defined(&DSPFW_HPLL_CURSOR_SHIFT);
    eval 'sub DSPFW_HPLL_CURSOR_MASK () {(0x3f<<16);}' unless defined(&DSPFW_HPLL_CURSOR_MASK);
    eval 'sub DSPFW_HPLL_SR_MASK () {(0x1ff);}' unless defined(&DSPFW_HPLL_SR_MASK);
    eval 'sub G4X_FIFO_LINE_SIZE () {64;}' unless defined(&G4X_FIFO_LINE_SIZE);
    eval 'sub I915_FIFO_LINE_SIZE () {64;}' unless defined(&I915_FIFO_LINE_SIZE);
    eval 'sub I830_FIFO_LINE_SIZE () {32;}' unless defined(&I830_FIFO_LINE_SIZE);
    eval 'sub G4X_FIFO_SIZE () {127;}' unless defined(&G4X_FIFO_SIZE);
    eval 'sub I965_FIFO_SIZE () {512;}' unless defined(&I965_FIFO_SIZE);
    eval 'sub I945_FIFO_SIZE () {127;}' unless defined(&I945_FIFO_SIZE);
    eval 'sub I915_FIFO_SIZE () {95;}' unless defined(&I915_FIFO_SIZE);
    eval 'sub I855GM_FIFO_SIZE () {127;}' unless defined(&I855GM_FIFO_SIZE);
    eval 'sub I830_FIFO_SIZE () {95;}' unless defined(&I830_FIFO_SIZE);
    eval 'sub G4X_MAX_WM () {0x3f;}' unless defined(&G4X_MAX_WM);
    eval 'sub I915_MAX_WM () {0x3f;}' unless defined(&I915_MAX_WM);
    eval 'sub PINEVIEW_DISPLAY_FIFO () {512;}' unless defined(&PINEVIEW_DISPLAY_FIFO);
    eval 'sub PINEVIEW_FIFO_LINE_SIZE () {64;}' unless defined(&PINEVIEW_FIFO_LINE_SIZE);
    eval 'sub PINEVIEW_MAX_WM () {0x1ff;}' unless defined(&PINEVIEW_MAX_WM);
    eval 'sub PINEVIEW_DFT_WM () {0x3f;}' unless defined(&PINEVIEW_DFT_WM);
    eval 'sub PINEVIEW_DFT_HPLLOFF_WM () {0;}' unless defined(&PINEVIEW_DFT_HPLLOFF_WM);
    eval 'sub PINEVIEW_GUARD_WM () {10;}' unless defined(&PINEVIEW_GUARD_WM);
    eval 'sub PINEVIEW_CURSOR_FIFO () {64;}' unless defined(&PINEVIEW_CURSOR_FIFO);
    eval 'sub PINEVIEW_CURSOR_MAX_WM () {0x3f;}' unless defined(&PINEVIEW_CURSOR_MAX_WM);
    eval 'sub PINEVIEW_CURSOR_DFT_WM () {0;}' unless defined(&PINEVIEW_CURSOR_DFT_WM);
    eval 'sub PINEVIEW_CURSOR_GUARD_WM () {5;}' unless defined(&PINEVIEW_CURSOR_GUARD_WM);
    eval 'sub I965_CURSOR_FIFO () {64;}' unless defined(&I965_CURSOR_FIFO);
    eval 'sub I965_CURSOR_MAX_WM () {32;}' unless defined(&I965_CURSOR_MAX_WM);
    eval 'sub I965_CURSOR_DFT_WM () {8;}' unless defined(&I965_CURSOR_DFT_WM);
    eval 'sub WM0_PIPEA_ILK () {0x45100;}' unless defined(&WM0_PIPEA_ILK);
    eval 'sub WM0_PIPE_PLANE_MASK () {(0x7f<<16);}' unless defined(&WM0_PIPE_PLANE_MASK);
    eval 'sub WM0_PIPE_PLANE_SHIFT () {16;}' unless defined(&WM0_PIPE_PLANE_SHIFT);
    eval 'sub WM0_PIPE_SPRITE_MASK () {(0x3f<<8);}' unless defined(&WM0_PIPE_SPRITE_MASK);
    eval 'sub WM0_PIPE_SPRITE_SHIFT () {8;}' unless defined(&WM0_PIPE_SPRITE_SHIFT);
    eval 'sub WM0_PIPE_CURSOR_MASK () {(0x1f);}' unless defined(&WM0_PIPE_CURSOR_MASK);
    eval 'sub WM0_PIPEB_ILK () {0x45104;}' unless defined(&WM0_PIPEB_ILK);
    eval 'sub WM0_PIPEC_IVB () {0x45200;}' unless defined(&WM0_PIPEC_IVB);
    eval 'sub WM1_LP_ILK () {0x45108;}' unless defined(&WM1_LP_ILK);
    eval 'sub WM1_LP_SR_EN () {(1<<31);}' unless defined(&WM1_LP_SR_EN);
    eval 'sub WM1_LP_LATENCY_SHIFT () {24;}' unless defined(&WM1_LP_LATENCY_SHIFT);
    eval 'sub WM1_LP_LATENCY_MASK () {(0x7f<<24);}' unless defined(&WM1_LP_LATENCY_MASK);
    eval 'sub WM1_LP_FBC_MASK () {(0xf<<20);}' unless defined(&WM1_LP_FBC_MASK);
    eval 'sub WM1_LP_FBC_SHIFT () {20;}' unless defined(&WM1_LP_FBC_SHIFT);
    eval 'sub WM1_LP_SR_MASK () {(0x1ff<<8);}' unless defined(&WM1_LP_SR_MASK);
    eval 'sub WM1_LP_SR_SHIFT () {8;}' unless defined(&WM1_LP_SR_SHIFT);
    eval 'sub WM1_LP_CURSOR_MASK () {(0x3f);}' unless defined(&WM1_LP_CURSOR_MASK);
    eval 'sub WM2_LP_ILK () {0x4510c;}' unless defined(&WM2_LP_ILK);
    eval 'sub WM2_LP_EN () {(1<<31);}' unless defined(&WM2_LP_EN);
    eval 'sub WM3_LP_ILK () {0x45110;}' unless defined(&WM3_LP_ILK);
    eval 'sub WM3_LP_EN () {(1<<31);}' unless defined(&WM3_LP_EN);
    eval 'sub WM1S_LP_ILK () {0x45120;}' unless defined(&WM1S_LP_ILK);
    eval 'sub WM2S_LP_IVB () {0x45124;}' unless defined(&WM2S_LP_IVB);
    eval 'sub WM3S_LP_IVB () {0x45128;}' unless defined(&WM3S_LP_IVB);
    eval 'sub WM1S_LP_EN () {(1<<31);}' unless defined(&WM1S_LP_EN);
    eval 'sub MLTR_ILK () {0x11222;}' unless defined(&MLTR_ILK);
    eval 'sub MLTR_WM1_SHIFT () {0;}' unless defined(&MLTR_WM1_SHIFT);
    eval 'sub MLTR_WM2_SHIFT () {8;}' unless defined(&MLTR_WM2_SHIFT);
    eval 'sub ILK_SRLT_MASK () {0x3f;}' unless defined(&ILK_SRLT_MASK);
    eval 'sub ILK_LATENCY {
        my($shift) = @_;
	    eval q(( &I915_READ( &MLTR_ILK) >> ($shift) &  &ILK_SRLT_MASK));
    }' unless defined(&ILK_LATENCY);
    eval 'sub ILK_READ_WM1_LATENCY () {
        eval q( &ILK_LATENCY( &MLTR_WM1_SHIFT));
    }' unless defined(&ILK_READ_WM1_LATENCY);
    eval 'sub ILK_READ_WM2_LATENCY () {
        eval q( &ILK_LATENCY( &MLTR_WM2_SHIFT));
    }' unless defined(&ILK_READ_WM2_LATENCY);
    eval 'sub ILK_DISPLAY_FIFO () {128;}' unless defined(&ILK_DISPLAY_FIFO);
    eval 'sub ILK_DISPLAY_MAXWM () {64;}' unless defined(&ILK_DISPLAY_MAXWM);
    eval 'sub ILK_DISPLAY_DFTWM () {8;}' unless defined(&ILK_DISPLAY_DFTWM);
    eval 'sub ILK_CURSOR_FIFO () {32;}' unless defined(&ILK_CURSOR_FIFO);
    eval 'sub ILK_CURSOR_MAXWM () {16;}' unless defined(&ILK_CURSOR_MAXWM);
    eval 'sub ILK_CURSOR_DFTWM () {8;}' unless defined(&ILK_CURSOR_DFTWM);
    eval 'sub ILK_DISPLAY_SR_FIFO () {512;}' unless defined(&ILK_DISPLAY_SR_FIFO);
    eval 'sub ILK_DISPLAY_MAX_SRWM () {0x1ff;}' unless defined(&ILK_DISPLAY_MAX_SRWM);
    eval 'sub ILK_DISPLAY_DFT_SRWM () {0x3f;}' unless defined(&ILK_DISPLAY_DFT_SRWM);
    eval 'sub ILK_CURSOR_SR_FIFO () {64;}' unless defined(&ILK_CURSOR_SR_FIFO);
    eval 'sub ILK_CURSOR_MAX_SRWM () {0x3f;}' unless defined(&ILK_CURSOR_MAX_SRWM);
    eval 'sub ILK_CURSOR_DFT_SRWM () {8;}' unless defined(&ILK_CURSOR_DFT_SRWM);
    eval 'sub ILK_FIFO_LINE_SIZE () {64;}' unless defined(&ILK_FIFO_LINE_SIZE);
    eval 'sub SNB_DISPLAY_FIFO () {128;}' unless defined(&SNB_DISPLAY_FIFO);
    eval 'sub SNB_DISPLAY_MAXWM () {0x7f;}' unless defined(&SNB_DISPLAY_MAXWM);
    eval 'sub SNB_DISPLAY_DFTWM () {8;}' unless defined(&SNB_DISPLAY_DFTWM);
    eval 'sub SNB_CURSOR_FIFO () {32;}' unless defined(&SNB_CURSOR_FIFO);
    eval 'sub SNB_CURSOR_MAXWM () {0x1f;}' unless defined(&SNB_CURSOR_MAXWM);
    eval 'sub SNB_CURSOR_DFTWM () {8;}' unless defined(&SNB_CURSOR_DFTWM);
    eval 'sub SNB_DISPLAY_SR_FIFO () {512;}' unless defined(&SNB_DISPLAY_SR_FIFO);
    eval 'sub SNB_DISPLAY_MAX_SRWM () {0x1ff;}' unless defined(&SNB_DISPLAY_MAX_SRWM);
    eval 'sub SNB_DISPLAY_DFT_SRWM () {0x3f;}' unless defined(&SNB_DISPLAY_DFT_SRWM);
    eval 'sub SNB_CURSOR_SR_FIFO () {64;}' unless defined(&SNB_CURSOR_SR_FIFO);
    eval 'sub SNB_CURSOR_MAX_SRWM () {0x3f;}' unless defined(&SNB_CURSOR_MAX_SRWM);
    eval 'sub SNB_CURSOR_DFT_SRWM () {8;}' unless defined(&SNB_CURSOR_DFT_SRWM);
    eval 'sub SNB_FBC_MAX_SRWM () {0xf;}' unless defined(&SNB_FBC_MAX_SRWM);
    eval 'sub SNB_FIFO_LINE_SIZE () {64;}' unless defined(&SNB_FIFO_LINE_SIZE);
    eval 'sub SSKPD () {0x5d10;}' unless defined(&SSKPD);
    eval 'sub SSKPD_WM_MASK () {0x3f;}' unless defined(&SSKPD_WM_MASK);
    eval 'sub SSKPD_WM0_SHIFT () {0;}' unless defined(&SSKPD_WM0_SHIFT);
    eval 'sub SSKPD_WM1_SHIFT () {8;}' unless defined(&SSKPD_WM1_SHIFT);
    eval 'sub SSKPD_WM2_SHIFT () {16;}' unless defined(&SSKPD_WM2_SHIFT);
    eval 'sub SSKPD_WM3_SHIFT () {24;}' unless defined(&SSKPD_WM3_SHIFT);
    eval 'sub SNB_LATENCY {
        my($shift) = @_;
	    eval q(( &I915_READ( &MCHBAR_MIRROR_BASE_SNB +  &SSKPD) >> ($shift) &  &SSKPD_WM_MASK));
    }' unless defined(&SNB_LATENCY);
    eval 'sub SNB_READ_WM0_LATENCY () {
        eval q( &SNB_LATENCY( &SSKPD_WM0_SHIFT));
    }' unless defined(&SNB_READ_WM0_LATENCY);
    eval 'sub SNB_READ_WM1_LATENCY () {
        eval q( &SNB_LATENCY( &SSKPD_WM1_SHIFT));
    }' unless defined(&SNB_READ_WM1_LATENCY);
    eval 'sub SNB_READ_WM2_LATENCY () {
        eval q( &SNB_LATENCY( &SSKPD_WM2_SHIFT));
    }' unless defined(&SNB_READ_WM2_LATENCY);
    eval 'sub SNB_READ_WM3_LATENCY () {
        eval q( &SNB_LATENCY( &SSKPD_WM3_SHIFT));
    }' unless defined(&SNB_READ_WM3_LATENCY);
    eval 'sub _PIPEAFRAMEHIGH () {0x70040;}' unless defined(&_PIPEAFRAMEHIGH);
    eval 'sub PIPE_FRAME_HIGH_MASK () {0xffff;}' unless defined(&PIPE_FRAME_HIGH_MASK);
    eval 'sub PIPE_FRAME_HIGH_SHIFT () {0;}' unless defined(&PIPE_FRAME_HIGH_SHIFT);
    eval 'sub _PIPEAFRAMEPIXEL () {0x70044;}' unless defined(&_PIPEAFRAMEPIXEL);
    eval 'sub PIPE_FRAME_LOW_MASK () {0xff000000;}' unless defined(&PIPE_FRAME_LOW_MASK);
    eval 'sub PIPE_FRAME_LOW_SHIFT () {24;}' unless defined(&PIPE_FRAME_LOW_SHIFT);
    eval 'sub PIPE_PIXEL_MASK () {0xffffff;}' unless defined(&PIPE_PIXEL_MASK);
    eval 'sub PIPE_PIXEL_SHIFT () {0;}' unless defined(&PIPE_PIXEL_SHIFT);
    eval 'sub _PIPEA_FRMCOUNT_GM45 () {0x70040;}' unless defined(&_PIPEA_FRMCOUNT_GM45);
    eval 'sub _PIPEA_FLIPCOUNT_GM45 () {0x70044;}' unless defined(&_PIPEA_FLIPCOUNT_GM45);
    eval 'sub PIPE_FRMCOUNT_GM45 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_FRMCOUNT_GM45,  &_PIPEB_FRMCOUNT_GM45));
    }' unless defined(&PIPE_FRMCOUNT_GM45);
    eval 'sub _CURACNTR () {0x70080;}' unless defined(&_CURACNTR);
    eval 'sub CURSOR_ENABLE () {0x80000000;}' unless defined(&CURSOR_ENABLE);
    eval 'sub CURSOR_GAMMA_ENABLE () {0x40000000;}' unless defined(&CURSOR_GAMMA_ENABLE);
    eval 'sub CURSOR_STRIDE_MASK () {0x30000000;}' unless defined(&CURSOR_STRIDE_MASK);
    eval 'sub CURSOR_FORMAT_SHIFT () {24;}' unless defined(&CURSOR_FORMAT_SHIFT);
    eval 'sub CURSOR_FORMAT_MASK () {(0x7 <<  &CURSOR_FORMAT_SHIFT);}' unless defined(&CURSOR_FORMAT_MASK);
    eval 'sub CURSOR_FORMAT_2C () {(0x <<  &CURSOR_FORMAT_SHIFT);}' unless defined(&CURSOR_FORMAT_2C);
    eval 'sub CURSOR_FORMAT_3C () {(0x1 <<  &CURSOR_FORMAT_SHIFT);}' unless defined(&CURSOR_FORMAT_3C);
    eval 'sub CURSOR_FORMAT_4C () {(0x2 <<  &CURSOR_FORMAT_SHIFT);}' unless defined(&CURSOR_FORMAT_4C);
    eval 'sub CURSOR_FORMAT_ARGB () {(0x4 <<  &CURSOR_FORMAT_SHIFT);}' unless defined(&CURSOR_FORMAT_ARGB);
    eval 'sub CURSOR_FORMAT_XRGB () {(0x5 <<  &CURSOR_FORMAT_SHIFT);}' unless defined(&CURSOR_FORMAT_XRGB);
    eval 'sub CURSOR_MODE () {0x27;}' unless defined(&CURSOR_MODE);
    eval 'sub CURSOR_MODE_DISABLE () {0x;}' unless defined(&CURSOR_MODE_DISABLE);
    eval 'sub CURSOR_MODE_64_32B_AX () {0x7;}' unless defined(&CURSOR_MODE_64_32B_AX);
    eval 'sub CURSOR_MODE_64_ARGB_AX () {((1<< 5) |  &CURSOR_MODE_64_32B_AX);}' unless defined(&CURSOR_MODE_64_ARGB_AX);
    eval 'sub MCURSOR_PIPE_SELECT () {(1<< 28);}' unless defined(&MCURSOR_PIPE_SELECT);
    eval 'sub MCURSOR_PIPE_A () {0x;}' unless defined(&MCURSOR_PIPE_A);
    eval 'sub MCURSOR_PIPE_B () {(1<< 28);}' unless defined(&MCURSOR_PIPE_B);
    eval 'sub MCURSOR_GAMMA_ENABLE () {(1<< 26);}' unless defined(&MCURSOR_GAMMA_ENABLE);
    eval 'sub _CURABASE () {0x70084;}' unless defined(&_CURABASE);
    eval 'sub _CURAPOS () {0x70088;}' unless defined(&_CURAPOS);
    eval 'sub CURSOR_POS_MASK () {0x7ff;}' unless defined(&CURSOR_POS_MASK);
    eval 'sub CURSOR_POS_SIGN () {0x8000;}' unless defined(&CURSOR_POS_SIGN);
    eval 'sub CURSOR_X_SHIFT () {0;}' unless defined(&CURSOR_X_SHIFT);
    eval 'sub CURSOR_Y_SHIFT () {16;}' unless defined(&CURSOR_Y_SHIFT);
    eval 'sub CURSIZE () {0x700a0;}' unless defined(&CURSIZE);
    eval 'sub _CURBCNTR () {0x700c0;}' unless defined(&_CURBCNTR);
    eval 'sub _CURBBASE () {0x700c4;}' unless defined(&_CURBBASE);
    eval 'sub _CURBPOS () {0x700c8;}' unless defined(&_CURBPOS);
    eval 'sub _CURBCNTR_IVB () {0x71080;}' unless defined(&_CURBCNTR_IVB);
    eval 'sub _CURBBASE_IVB () {0x71084;}' unless defined(&_CURBBASE_IVB);
    eval 'sub _CURBPOS_IVB () {0x71088;}' unless defined(&_CURBPOS_IVB);
    eval 'sub CURCNTR {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_CURACNTR,  &_CURBCNTR));
    }' unless defined(&CURCNTR);
    eval 'sub CURBASE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_CURABASE,  &_CURBBASE));
    }' unless defined(&CURBASE);
    eval 'sub CURPOS {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_CURAPOS,  &_CURBPOS));
    }' unless defined(&CURPOS);
    eval 'sub CURCNTR_IVB {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_CURACNTR,  &_CURBCNTR_IVB));
    }' unless defined(&CURCNTR_IVB);
    eval 'sub CURBASE_IVB {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_CURABASE,  &_CURBBASE_IVB));
    }' unless defined(&CURBASE_IVB);
    eval 'sub CURPOS_IVB {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_CURAPOS,  &_CURBPOS_IVB));
    }' unless defined(&CURPOS_IVB);
    eval 'sub _DSPACNTR () {0x70180;}' unless defined(&_DSPACNTR);
    eval 'sub DISPLAY_PLANE_ENABLE () {(1<<31);}' unless defined(&DISPLAY_PLANE_ENABLE);
    eval 'sub DISPLAY_PLANE_DISABLE () {0;}' unless defined(&DISPLAY_PLANE_DISABLE);
    eval 'sub DISPPLANE_GAMMA_ENABLE () {(1<<30);}' unless defined(&DISPPLANE_GAMMA_ENABLE);
    eval 'sub DISPPLANE_GAMMA_DISABLE () {0;}' unless defined(&DISPPLANE_GAMMA_DISABLE);
    eval 'sub DISPPLANE_PIXFORMAT_MASK () {(0xf<<26);}' unless defined(&DISPPLANE_PIXFORMAT_MASK);
    eval 'sub DISPPLANE_8BPP () {(0x2<<26);}' unless defined(&DISPPLANE_8BPP);
    eval 'sub DISPPLANE_15_16BPP () {(0x4<<26);}' unless defined(&DISPPLANE_15_16BPP);
    eval 'sub DISPPLANE_16BPP () {(0x5<<26);}' unless defined(&DISPPLANE_16BPP);
    eval 'sub DISPPLANE_32BPP_NO_ALPHA () {(0x6<<26);}' unless defined(&DISPPLANE_32BPP_NO_ALPHA);
    eval 'sub DISPPLANE_32BPP () {(0x7<<26);}' unless defined(&DISPPLANE_32BPP);
    eval 'sub DISPPLANE_32BPP_30BIT_NO_ALPHA () {(0xa<<26);}' unless defined(&DISPPLANE_32BPP_30BIT_NO_ALPHA);
    eval 'sub DISPPLANE_STEREO_ENABLE () {(1<<25);}' unless defined(&DISPPLANE_STEREO_ENABLE);
    eval 'sub DISPPLANE_STEREO_DISABLE () {0;}' unless defined(&DISPPLANE_STEREO_DISABLE);
    eval 'sub DISPPLANE_SEL_PIPE_SHIFT () {24;}' unless defined(&DISPPLANE_SEL_PIPE_SHIFT);
    eval 'sub DISPPLANE_SEL_PIPE_MASK () {(3<< &DISPPLANE_SEL_PIPE_SHIFT);}' unless defined(&DISPPLANE_SEL_PIPE_MASK);
    eval 'sub DISPPLANE_SEL_PIPE_A () {0;}' unless defined(&DISPPLANE_SEL_PIPE_A);
    eval 'sub DISPPLANE_SEL_PIPE_B () {(1<< &DISPPLANE_SEL_PIPE_SHIFT);}' unless defined(&DISPPLANE_SEL_PIPE_B);
    eval 'sub DISPPLANE_SRC_KEY_ENABLE () {(1<<22);}' unless defined(&DISPPLANE_SRC_KEY_ENABLE);
    eval 'sub DISPPLANE_SRC_KEY_DISABLE () {0;}' unless defined(&DISPPLANE_SRC_KEY_DISABLE);
    eval 'sub DISPPLANE_LINE_DOUBLE () {(1<<20);}' unless defined(&DISPPLANE_LINE_DOUBLE);
    eval 'sub DISPPLANE_NO_LINE_DOUBLE () {0;}' unless defined(&DISPPLANE_NO_LINE_DOUBLE);
    eval 'sub DISPPLANE_STEREO_POLARITY_FIRST () {0;}' unless defined(&DISPPLANE_STEREO_POLARITY_FIRST);
    eval 'sub DISPPLANE_STEREO_POLARITY_SECOND () {(1<<18);}' unless defined(&DISPPLANE_STEREO_POLARITY_SECOND);
    eval 'sub DISPPLANE_TRICKLE_FEED_DISABLE () {(1<<14);}' unless defined(&DISPPLANE_TRICKLE_FEED_DISABLE);
    eval 'sub DISPPLANE_TILED () {(1<<10);}' unless defined(&DISPPLANE_TILED);
    eval 'sub _DSPAADDR () {0x70184;}' unless defined(&_DSPAADDR);
    eval 'sub _DSPASTRIDE () {0x70188;}' unless defined(&_DSPASTRIDE);
    eval 'sub _DSPAPOS () {0x7018c;}' unless defined(&_DSPAPOS);
    eval 'sub _DSPASIZE () {0x70190;}' unless defined(&_DSPASIZE);
    eval 'sub _DSPASURF () {0x7019c;}' unless defined(&_DSPASURF);
    eval 'sub _DSPATILEOFF () {0x701a4;}' unless defined(&_DSPATILEOFF);
    eval 'sub DSPCNTR {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPACNTR,  &_DSPBCNTR));
    }' unless defined(&DSPCNTR);
    eval 'sub DSPADDR {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPAADDR,  &_DSPBADDR));
    }' unless defined(&DSPADDR);
    eval 'sub DSPSTRIDE {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPASTRIDE,  &_DSPBSTRIDE));
    }' unless defined(&DSPSTRIDE);
    eval 'sub DSPPOS {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPAPOS,  &_DSPBPOS));
    }' unless defined(&DSPPOS);
    eval 'sub DSPSIZE {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPASIZE,  &_DSPBSIZE));
    }' unless defined(&DSPSIZE);
    eval 'sub DSPSURF {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPASURF,  &_DSPBSURF));
    }' unless defined(&DSPSURF);
    eval 'sub DSPTILEOFF {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_DSPATILEOFF,  &_DSPBTILEOFF));
    }' unless defined(&DSPTILEOFF);
    eval 'sub SWF00 () {0x71410;}' unless defined(&SWF00);
    eval 'sub SWF01 () {0x71414;}' unless defined(&SWF01);
    eval 'sub SWF02 () {0x71418;}' unless defined(&SWF02);
    eval 'sub SWF03 () {0x7141c;}' unless defined(&SWF03);
    eval 'sub SWF04 () {0x71420;}' unless defined(&SWF04);
    eval 'sub SWF05 () {0x71424;}' unless defined(&SWF05);
    eval 'sub SWF06 () {0x71428;}' unless defined(&SWF06);
    eval 'sub SWF10 () {0x70410;}' unless defined(&SWF10);
    eval 'sub SWF11 () {0x70414;}' unless defined(&SWF11);
    eval 'sub SWF14 () {0x71420;}' unless defined(&SWF14);
    eval 'sub SWF30 () {0x72414;}' unless defined(&SWF30);
    eval 'sub SWF31 () {0x72418;}' unless defined(&SWF31);
    eval 'sub SWF32 () {0x7241c;}' unless defined(&SWF32);
    eval 'sub _PIPEBDSL () {0x71000;}' unless defined(&_PIPEBDSL);
    eval 'sub _PIPEBCONF () {0x71008;}' unless defined(&_PIPEBCONF);
    eval 'sub _PIPEBSTAT () {0x71024;}' unless defined(&_PIPEBSTAT);
    eval 'sub _PIPEBFRAMEHIGH () {0x71040;}' unless defined(&_PIPEBFRAMEHIGH);
    eval 'sub _PIPEBFRAMEPIXEL () {0x71044;}' unless defined(&_PIPEBFRAMEPIXEL);
    eval 'sub _PIPEB_FRMCOUNT_GM45 () {0x71040;}' unless defined(&_PIPEB_FRMCOUNT_GM45);
    eval 'sub _PIPEB_FLIPCOUNT_GM45 () {0x71044;}' unless defined(&_PIPEB_FLIPCOUNT_GM45);
    eval 'sub _DSPBCNTR () {0x71180;}' unless defined(&_DSPBCNTR);
    eval 'sub DISPPLANE_ALPHA_TRANS_ENABLE () {(1<<15);}' unless defined(&DISPPLANE_ALPHA_TRANS_ENABLE);
    eval 'sub DISPPLANE_ALPHA_TRANS_DISABLE () {0;}' unless defined(&DISPPLANE_ALPHA_TRANS_DISABLE);
    eval 'sub DISPPLANE_SPRITE_ABOVE_DISPLAY () {0;}' unless defined(&DISPPLANE_SPRITE_ABOVE_DISPLAY);
    eval 'sub DISPPLANE_SPRITE_ABOVE_OVERLAY () {(1);}' unless defined(&DISPPLANE_SPRITE_ABOVE_OVERLAY);
    eval 'sub _DSPBADDR () {0x71184;}' unless defined(&_DSPBADDR);
    eval 'sub _DSPBSTRIDE () {0x71188;}' unless defined(&_DSPBSTRIDE);
    eval 'sub _DSPBPOS () {0x7118c;}' unless defined(&_DSPBPOS);
    eval 'sub _DSPBSIZE () {0x71190;}' unless defined(&_DSPBSIZE);
    eval 'sub _DSPBSURF () {0x7119c;}' unless defined(&_DSPBSURF);
    eval 'sub _DSPBTILEOFF () {0x711a4;}' unless defined(&_DSPBTILEOFF);
    eval 'sub _DVSACNTR () {0x72180;}' unless defined(&_DVSACNTR);
    eval 'sub DVS_ENABLE () {(1<<31);}' unless defined(&DVS_ENABLE);
    eval 'sub DVS_GAMMA_ENABLE () {(1<<30);}' unless defined(&DVS_GAMMA_ENABLE);
    eval 'sub DVS_PIXFORMAT_MASK () {(3<<25);}' unless defined(&DVS_PIXFORMAT_MASK);
    eval 'sub DVS_FORMAT_YUV422 () {(0<<25);}' unless defined(&DVS_FORMAT_YUV422);
    eval 'sub DVS_FORMAT_RGBX101010 () {(1<<25);}' unless defined(&DVS_FORMAT_RGBX101010);
    eval 'sub DVS_FORMAT_RGBX888 () {(2<<25);}' unless defined(&DVS_FORMAT_RGBX888);
    eval 'sub DVS_FORMAT_RGBX161616 () {(3<<25);}' unless defined(&DVS_FORMAT_RGBX161616);
    eval 'sub DVS_SOURCE_KEY () {(1<<22);}' unless defined(&DVS_SOURCE_KEY);
    eval 'sub DVS_RGB_ORDER_XBGR () {(1<<20);}' unless defined(&DVS_RGB_ORDER_XBGR);
    eval 'sub DVS_YUV_BYTE_ORDER_MASK () {(3<<16);}' unless defined(&DVS_YUV_BYTE_ORDER_MASK);
    eval 'sub DVS_YUV_ORDER_YUYV () {(0<<16);}' unless defined(&DVS_YUV_ORDER_YUYV);
    eval 'sub DVS_YUV_ORDER_UYVY () {(1<<16);}' unless defined(&DVS_YUV_ORDER_UYVY);
    eval 'sub DVS_YUV_ORDER_YVYU () {(2<<16);}' unless defined(&DVS_YUV_ORDER_YVYU);
    eval 'sub DVS_YUV_ORDER_VYUY () {(3<<16);}' unless defined(&DVS_YUV_ORDER_VYUY);
    eval 'sub DVS_DEST_KEY () {(1<<2);}' unless defined(&DVS_DEST_KEY);
    eval 'sub DVS_TRICKLE_FEED_DISABLE () {(1<<14);}' unless defined(&DVS_TRICKLE_FEED_DISABLE);
    eval 'sub DVS_TILED () {(1<<10);}' unless defined(&DVS_TILED);
    eval 'sub _DVSALINOFF () {0x72184;}' unless defined(&_DVSALINOFF);
    eval 'sub _DVSASTRIDE () {0x72188;}' unless defined(&_DVSASTRIDE);
    eval 'sub _DVSAPOS () {0x7218c;}' unless defined(&_DVSAPOS);
    eval 'sub _DVSASIZE () {0x72190;}' unless defined(&_DVSASIZE);
    eval 'sub _DVSAKEYVAL () {0x72194;}' unless defined(&_DVSAKEYVAL);
    eval 'sub _DVSAKEYMSK () {0x72198;}' unless defined(&_DVSAKEYMSK);
    eval 'sub _DVSASURF () {0x7219c;}' unless defined(&_DVSASURF);
    eval 'sub _DVSAKEYMAXVAL () {0x721a0;}' unless defined(&_DVSAKEYMAXVAL);
    eval 'sub _DVSATILEOFF () {0x721a4;}' unless defined(&_DVSATILEOFF);
    eval 'sub _DVSASURFLIVE () {0x721ac;}' unless defined(&_DVSASURFLIVE);
    eval 'sub _DVSASCALE () {0x72204;}' unless defined(&_DVSASCALE);
    eval 'sub DVS_SCALE_ENABLE () {(1<<31);}' unless defined(&DVS_SCALE_ENABLE);
    eval 'sub DVS_FILTER_MASK () {(3<<29);}' unless defined(&DVS_FILTER_MASK);
    eval 'sub DVS_FILTER_MEDIUM () {(0<<29);}' unless defined(&DVS_FILTER_MEDIUM);
    eval 'sub DVS_FILTER_ENHANCING () {(1<<29);}' unless defined(&DVS_FILTER_ENHANCING);
    eval 'sub DVS_FILTER_SOFTENING () {(2<<29);}' unless defined(&DVS_FILTER_SOFTENING);
    eval 'sub DVS_VERTICAL_OFFSET_HALF () {(1<<28);}' unless defined(&DVS_VERTICAL_OFFSET_HALF);
    eval 'sub DVS_VERTICAL_OFFSET_ENABLE () {(1<<27);}' unless defined(&DVS_VERTICAL_OFFSET_ENABLE);
    eval 'sub _DVSAGAMC () {0x72300;}' unless defined(&_DVSAGAMC);
    eval 'sub _DVSBCNTR () {0x73180;}' unless defined(&_DVSBCNTR);
    eval 'sub _DVSBLINOFF () {0x73184;}' unless defined(&_DVSBLINOFF);
    eval 'sub _DVSBSTRIDE () {0x73188;}' unless defined(&_DVSBSTRIDE);
    eval 'sub _DVSBPOS () {0x7318c;}' unless defined(&_DVSBPOS);
    eval 'sub _DVSBSIZE () {0x73190;}' unless defined(&_DVSBSIZE);
    eval 'sub _DVSBKEYVAL () {0x73194;}' unless defined(&_DVSBKEYVAL);
    eval 'sub _DVSBKEYMSK () {0x73198;}' unless defined(&_DVSBKEYMSK);
    eval 'sub _DVSBSURF () {0x7319c;}' unless defined(&_DVSBSURF);
    eval 'sub _DVSBKEYMAXVAL () {0x731a0;}' unless defined(&_DVSBKEYMAXVAL);
    eval 'sub _DVSBTILEOFF () {0x731a4;}' unless defined(&_DVSBTILEOFF);
    eval 'sub _DVSBSURFLIVE () {0x731ac;}' unless defined(&_DVSBSURFLIVE);
    eval 'sub _DVSBSCALE () {0x73204;}' unless defined(&_DVSBSCALE);
    eval 'sub _DVSBGAMC () {0x73300;}' unless defined(&_DVSBGAMC);
    eval 'sub DVSCNTR {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSACNTR,  &_DVSBCNTR));
    }' unless defined(&DVSCNTR);
    eval 'sub DVSLINOFF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSALINOFF,  &_DVSBLINOFF));
    }' unless defined(&DVSLINOFF);
    eval 'sub DVSSTRIDE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSASTRIDE,  &_DVSBSTRIDE));
    }' unless defined(&DVSSTRIDE);
    eval 'sub DVSPOS {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSAPOS,  &_DVSBPOS));
    }' unless defined(&DVSPOS);
    eval 'sub DVSSURF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSASURF,  &_DVSBSURF));
    }' unless defined(&DVSSURF);
    eval 'sub DVSKEYMAX {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSAKEYMAXVAL,  &_DVSBKEYMAXVAL));
    }' unless defined(&DVSKEYMAX);
    eval 'sub DVSSIZE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSASIZE,  &_DVSBSIZE));
    }' unless defined(&DVSSIZE);
    eval 'sub DVSSCALE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSASCALE,  &_DVSBSCALE));
    }' unless defined(&DVSSCALE);
    eval 'sub DVSTILEOFF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSATILEOFF,  &_DVSBTILEOFF));
    }' unless defined(&DVSTILEOFF);
    eval 'sub DVSKEYVAL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSAKEYVAL,  &_DVSBKEYVAL));
    }' unless defined(&DVSKEYVAL);
    eval 'sub DVSKEYMSK {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_DVSAKEYMSK,  &_DVSBKEYMSK));
    }' unless defined(&DVSKEYMSK);
    eval 'sub _SPRA_CTL () {0x70280;}' unless defined(&_SPRA_CTL);
    eval 'sub SPRITE_ENABLE () {(1<<31);}' unless defined(&SPRITE_ENABLE);
    eval 'sub SPRITE_GAMMA_ENABLE () {(1<<30);}' unless defined(&SPRITE_GAMMA_ENABLE);
    eval 'sub SPRITE_PIXFORMAT_MASK () {(7<<25);}' unless defined(&SPRITE_PIXFORMAT_MASK);
    eval 'sub SPRITE_FORMAT_YUV422 () {(0<<25);}' unless defined(&SPRITE_FORMAT_YUV422);
    eval 'sub SPRITE_FORMAT_RGBX101010 () {(1<<25);}' unless defined(&SPRITE_FORMAT_RGBX101010);
    eval 'sub SPRITE_FORMAT_RGBX888 () {(2<<25);}' unless defined(&SPRITE_FORMAT_RGBX888);
    eval 'sub SPRITE_FORMAT_RGBX161616 () {(3<<25);}' unless defined(&SPRITE_FORMAT_RGBX161616);
    eval 'sub SPRITE_FORMAT_YUV444 () {(4<<25);}' unless defined(&SPRITE_FORMAT_YUV444);
    eval 'sub SPRITE_FORMAT_XR_BGR101010 () {(5<<25);}' unless defined(&SPRITE_FORMAT_XR_BGR101010);
    eval 'sub SPRITE_CSC_ENABLE () {(1<<24);}' unless defined(&SPRITE_CSC_ENABLE);
    eval 'sub SPRITE_SOURCE_KEY () {(1<<22);}' unless defined(&SPRITE_SOURCE_KEY);
    eval 'sub SPRITE_RGB_ORDER_RGBX () {(1<<20);}' unless defined(&SPRITE_RGB_ORDER_RGBX);
    eval 'sub SPRITE_YUV_TO_RGB_CSC_DISABLE () {(1<<19);}' unless defined(&SPRITE_YUV_TO_RGB_CSC_DISABLE);
    eval 'sub SPRITE_YUV_CSC_FORMAT_BT709 () {(1<<18);}' unless defined(&SPRITE_YUV_CSC_FORMAT_BT709);
    eval 'sub SPRITE_YUV_BYTE_ORDER_MASK () {(3<<16);}' unless defined(&SPRITE_YUV_BYTE_ORDER_MASK);
    eval 'sub SPRITE_YUV_ORDER_YUYV () {(0<<16);}' unless defined(&SPRITE_YUV_ORDER_YUYV);
    eval 'sub SPRITE_YUV_ORDER_UYVY () {(1<<16);}' unless defined(&SPRITE_YUV_ORDER_UYVY);
    eval 'sub SPRITE_YUV_ORDER_YVYU () {(2<<16);}' unless defined(&SPRITE_YUV_ORDER_YVYU);
    eval 'sub SPRITE_YUV_ORDER_VYUY () {(3<<16);}' unless defined(&SPRITE_YUV_ORDER_VYUY);
    eval 'sub SPRITE_TRICKLE_FEED_DISABLE () {(1<<14);}' unless defined(&SPRITE_TRICKLE_FEED_DISABLE);
    eval 'sub SPRITE_INT_GAMMA_ENABLE () {(1<<13);}' unless defined(&SPRITE_INT_GAMMA_ENABLE);
    eval 'sub SPRITE_TILED () {(1<<10);}' unless defined(&SPRITE_TILED);
    eval 'sub SPRITE_DEST_KEY () {(1<<2);}' unless defined(&SPRITE_DEST_KEY);
    eval 'sub _SPRA_LINOFF () {0x70284;}' unless defined(&_SPRA_LINOFF);
    eval 'sub _SPRA_STRIDE () {0x70288;}' unless defined(&_SPRA_STRIDE);
    eval 'sub _SPRA_POS () {0x7028c;}' unless defined(&_SPRA_POS);
    eval 'sub _SPRA_SIZE () {0x70290;}' unless defined(&_SPRA_SIZE);
    eval 'sub _SPRA_KEYVAL () {0x70294;}' unless defined(&_SPRA_KEYVAL);
    eval 'sub _SPRA_KEYMSK () {0x70298;}' unless defined(&_SPRA_KEYMSK);
    eval 'sub _SPRA_SURF () {0x7029c;}' unless defined(&_SPRA_SURF);
    eval 'sub _SPRA_KEYMAX () {0x702a0;}' unless defined(&_SPRA_KEYMAX);
    eval 'sub _SPRA_TILEOFF () {0x702a4;}' unless defined(&_SPRA_TILEOFF);
    eval 'sub _SPRA_SCALE () {0x70304;}' unless defined(&_SPRA_SCALE);
    eval 'sub SPRITE_SCALE_ENABLE () {(1<<31);}' unless defined(&SPRITE_SCALE_ENABLE);
    eval 'sub SPRITE_FILTER_MASK () {(3<<29);}' unless defined(&SPRITE_FILTER_MASK);
    eval 'sub SPRITE_FILTER_MEDIUM () {(0<<29);}' unless defined(&SPRITE_FILTER_MEDIUM);
    eval 'sub SPRITE_FILTER_ENHANCING () {(1<<29);}' unless defined(&SPRITE_FILTER_ENHANCING);
    eval 'sub SPRITE_FILTER_SOFTENING () {(2<<29);}' unless defined(&SPRITE_FILTER_SOFTENING);
    eval 'sub SPRITE_VERTICAL_OFFSET_HALF () {(1<<28);}' unless defined(&SPRITE_VERTICAL_OFFSET_HALF);
    eval 'sub SPRITE_VERTICAL_OFFSET_ENABLE () {(1<<27);}' unless defined(&SPRITE_VERTICAL_OFFSET_ENABLE);
    eval 'sub _SPRA_GAMC () {0x70400;}' unless defined(&_SPRA_GAMC);
    eval 'sub _SPRB_CTL () {0x71280;}' unless defined(&_SPRB_CTL);
    eval 'sub _SPRB_LINOFF () {0x71284;}' unless defined(&_SPRB_LINOFF);
    eval 'sub _SPRB_STRIDE () {0x71288;}' unless defined(&_SPRB_STRIDE);
    eval 'sub _SPRB_POS () {0x7128c;}' unless defined(&_SPRB_POS);
    eval 'sub _SPRB_SIZE () {0x71290;}' unless defined(&_SPRB_SIZE);
    eval 'sub _SPRB_KEYVAL () {0x71294;}' unless defined(&_SPRB_KEYVAL);
    eval 'sub _SPRB_KEYMSK () {0x71298;}' unless defined(&_SPRB_KEYMSK);
    eval 'sub _SPRB_SURF () {0x7129c;}' unless defined(&_SPRB_SURF);
    eval 'sub _SPRB_KEYMAX () {0x712a0;}' unless defined(&_SPRB_KEYMAX);
    eval 'sub _SPRB_TILEOFF () {0x712a4;}' unless defined(&_SPRB_TILEOFF);
    eval 'sub _SPRB_SCALE () {0x71304;}' unless defined(&_SPRB_SCALE);
    eval 'sub _SPRB_GAMC () {0x71400;}' unless defined(&_SPRB_GAMC);
    eval 'sub SPRCTL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_CTL,  &_SPRB_CTL));
    }' unless defined(&SPRCTL);
    eval 'sub SPRLINOFF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_LINOFF,  &_SPRB_LINOFF));
    }' unless defined(&SPRLINOFF);
    eval 'sub SPRSTRIDE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_STRIDE,  &_SPRB_STRIDE));
    }' unless defined(&SPRSTRIDE);
    eval 'sub SPRPOS {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_POS,  &_SPRB_POS));
    }' unless defined(&SPRPOS);
    eval 'sub SPRSIZE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_SIZE,  &_SPRB_SIZE));
    }' unless defined(&SPRSIZE);
    eval 'sub SPRKEYVAL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_KEYVAL,  &_SPRB_KEYVAL));
    }' unless defined(&SPRKEYVAL);
    eval 'sub SPRKEYMSK {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_KEYMSK,  &_SPRB_KEYMSK));
    }' unless defined(&SPRKEYMSK);
    eval 'sub SPRSURF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_SURF,  &_SPRB_SURF));
    }' unless defined(&SPRSURF);
    eval 'sub SPRKEYMAX {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_KEYMAX,  &_SPRB_KEYMAX));
    }' unless defined(&SPRKEYMAX);
    eval 'sub SPRTILEOFF {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_TILEOFF,  &_SPRB_TILEOFF));
    }' unless defined(&SPRTILEOFF);
    eval 'sub SPRSCALE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_SCALE,  &_SPRB_SCALE));
    }' unless defined(&SPRSCALE);
    eval 'sub SPRGAMC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_SPRA_GAMC,  &_SPRB_GAMC));
    }' unless defined(&SPRGAMC);
    eval 'sub VGACNTRL () {0x71400;}' unless defined(&VGACNTRL);
    eval 'sub VGA_DISP_DISABLE () {(1<< 31);}' unless defined(&VGA_DISP_DISABLE);
    eval 'sub VGA_2X_MODE () {(1<< 30);}' unless defined(&VGA_2X_MODE);
    eval 'sub VGA_PIPE_B_SELECT () {(1<< 29);}' unless defined(&VGA_PIPE_B_SELECT);
    eval 'sub CPU_VGACNTRL () {0x41000;}' unless defined(&CPU_VGACNTRL);
    eval 'sub DIGITAL_PORT_HOTPLUG_CNTRL () {0x44030;}' unless defined(&DIGITAL_PORT_HOTPLUG_CNTRL);
    eval 'sub DIGITAL_PORTA_HOTPLUG_ENABLE () {(1<< 4);}' unless defined(&DIGITAL_PORTA_HOTPLUG_ENABLE);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_2MS () {(0<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_2MS);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_4_5MS () {(1<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_4_5MS);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_6MS () {(2<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_6MS);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_100MS () {(3<< 2);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_100MS);
    eval 'sub DIGITAL_PORTA_NO_DETECT () {(0<< 0);}' unless defined(&DIGITAL_PORTA_NO_DETECT);
    eval 'sub DIGITAL_PORTA_LONG_PULSE_DETECT_MASK () {(1<< 1);}' unless defined(&DIGITAL_PORTA_LONG_PULSE_DETECT_MASK);
    eval 'sub DIGITAL_PORTA_SHORT_PULSE_DETECT_MASK () {(1<< 0);}' unless defined(&DIGITAL_PORTA_SHORT_PULSE_DETECT_MASK);
    eval 'sub RR_HW_CTL () {0x45300;}' unless defined(&RR_HW_CTL);
    eval 'sub RR_HW_LOW_POWER_FRAMES_MASK () {0xff;}' unless defined(&RR_HW_LOW_POWER_FRAMES_MASK);
    eval 'sub RR_HW_HIGH_POWER_FRAMES_MASK () {0xff00;}' unless defined(&RR_HW_HIGH_POWER_FRAMES_MASK);
    eval 'sub FDI_PLL_BIOS_0 () {0x46000;}' unless defined(&FDI_PLL_BIOS_0);
    eval 'sub FDI_PLL_FB_CLOCK_MASK () {0xff;}' unless defined(&FDI_PLL_FB_CLOCK_MASK);
    eval 'sub FDI_PLL_BIOS_1 () {0x46004;}' unless defined(&FDI_PLL_BIOS_1);
    eval 'sub FDI_PLL_BIOS_2 () {0x46008;}' unless defined(&FDI_PLL_BIOS_2);
    eval 'sub DISPLAY_PORT_PLL_BIOS_0 () {0x4600c;}' unless defined(&DISPLAY_PORT_PLL_BIOS_0);
    eval 'sub DISPLAY_PORT_PLL_BIOS_1 () {0x46010;}' unless defined(&DISPLAY_PORT_PLL_BIOS_1);
    eval 'sub DISPLAY_PORT_PLL_BIOS_2 () {0x46014;}' unless defined(&DISPLAY_PORT_PLL_BIOS_2);
    eval 'sub PCH_DSPCLK_GATE_D () {0x42020;}' unless defined(&PCH_DSPCLK_GATE_D);
    eval 'sub DPFCUNIT_CLOCK_GATE_DISABLE () {(1<< 9);}' unless defined(&DPFCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPFCRUNIT_CLOCK_GATE_DISABLE () {(1<< 8);}' unless defined(&DPFCRUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPFDUNIT_CLOCK_GATE_DISABLE () {(1<< 7);}' unless defined(&DPFDUNIT_CLOCK_GATE_DISABLE);
    eval 'sub DPARBUNIT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&DPARBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub PCH_3DCGDIS0 () {0x46020;}' unless defined(&PCH_3DCGDIS0);
    eval 'sub MARIUNIT_CLOCK_GATE_DISABLE () {(1<< 18);}' unless defined(&MARIUNIT_CLOCK_GATE_DISABLE);
    eval 'sub SVSMUNIT_CLOCK_GATE_DISABLE () {(1<< 1);}' unless defined(&SVSMUNIT_CLOCK_GATE_DISABLE);
    eval 'sub PCH_3DCGDIS1 () {0x46024;}' unless defined(&PCH_3DCGDIS1);
    eval 'sub VFMUNIT_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&VFMUNIT_CLOCK_GATE_DISABLE);
    eval 'sub FDI_PLL_FREQ_CTL () {0x46030;}' unless defined(&FDI_PLL_FREQ_CTL);
    eval 'sub FDI_PLL_FREQ_CHANGE_REQUEST () {(1<<24);}' unless defined(&FDI_PLL_FREQ_CHANGE_REQUEST);
    eval 'sub FDI_PLL_FREQ_LOCK_LIMIT_MASK () {0xfff00;}' unless defined(&FDI_PLL_FREQ_LOCK_LIMIT_MASK);
    eval 'sub FDI_PLL_FREQ_DISABLE_COUNT_LIMIT_MASK () {0xff;}' unless defined(&FDI_PLL_FREQ_DISABLE_COUNT_LIMIT_MASK);
    eval 'sub _PIPEA_DATA_M1 () {0x60030;}' unless defined(&_PIPEA_DATA_M1);
    eval 'sub TU_SIZE {
        my($x) = @_;
	    eval q(((($x)-1) << 25));
    }' unless defined(&TU_SIZE);
    eval 'sub TU_SIZE_MASK () {0x7e000000;}' unless defined(&TU_SIZE_MASK);
    eval 'sub PIPE_DATA_M1_OFFSET () {0;}' unless defined(&PIPE_DATA_M1_OFFSET);
    eval 'sub _PIPEA_DATA_N1 () {0x60034;}' unless defined(&_PIPEA_DATA_N1);
    eval 'sub PIPE_DATA_N1_OFFSET () {0;}' unless defined(&PIPE_DATA_N1_OFFSET);
    eval 'sub _PIPEA_DATA_M2 () {0x60038;}' unless defined(&_PIPEA_DATA_M2);
    eval 'sub PIPE_DATA_M2_OFFSET () {0;}' unless defined(&PIPE_DATA_M2_OFFSET);
    eval 'sub _PIPEA_DATA_N2 () {0x6003c;}' unless defined(&_PIPEA_DATA_N2);
    eval 'sub PIPE_DATA_N2_OFFSET () {0;}' unless defined(&PIPE_DATA_N2_OFFSET);
    eval 'sub _PIPEA_LINK_M1 () {0x60040;}' unless defined(&_PIPEA_LINK_M1);
    eval 'sub PIPE_LINK_M1_OFFSET () {0;}' unless defined(&PIPE_LINK_M1_OFFSET);
    eval 'sub _PIPEA_LINK_N1 () {0x60044;}' unless defined(&_PIPEA_LINK_N1);
    eval 'sub PIPE_LINK_N1_OFFSET () {0;}' unless defined(&PIPE_LINK_N1_OFFSET);
    eval 'sub _PIPEA_LINK_M2 () {0x60048;}' unless defined(&_PIPEA_LINK_M2);
    eval 'sub PIPE_LINK_M2_OFFSET () {0;}' unless defined(&PIPE_LINK_M2_OFFSET);
    eval 'sub _PIPEA_LINK_N2 () {0x6004c;}' unless defined(&_PIPEA_LINK_N2);
    eval 'sub PIPE_LINK_N2_OFFSET () {0;}' unless defined(&PIPE_LINK_N2_OFFSET);
    eval 'sub _PIPEB_DATA_M1 () {0x61030;}' unless defined(&_PIPEB_DATA_M1);
    eval 'sub _PIPEB_DATA_N1 () {0x61034;}' unless defined(&_PIPEB_DATA_N1);
    eval 'sub _PIPEB_DATA_M2 () {0x61038;}' unless defined(&_PIPEB_DATA_M2);
    eval 'sub _PIPEB_DATA_N2 () {0x6103c;}' unless defined(&_PIPEB_DATA_N2);
    eval 'sub _PIPEB_LINK_M1 () {0x61040;}' unless defined(&_PIPEB_LINK_M1);
    eval 'sub _PIPEB_LINK_N1 () {0x61044;}' unless defined(&_PIPEB_LINK_N1);
    eval 'sub _PIPEB_LINK_M2 () {0x61048;}' unless defined(&_PIPEB_LINK_M2);
    eval 'sub _PIPEB_LINK_N2 () {0x6104c;}' unless defined(&_PIPEB_LINK_N2);
    eval 'sub PIPE_DATA_M1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_DATA_M1,  &_PIPEB_DATA_M1));
    }' unless defined(&PIPE_DATA_M1);
    eval 'sub PIPE_DATA_N1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_DATA_N1,  &_PIPEB_DATA_N1));
    }' unless defined(&PIPE_DATA_N1);
    eval 'sub PIPE_DATA_M2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_DATA_M2,  &_PIPEB_DATA_M2));
    }' unless defined(&PIPE_DATA_M2);
    eval 'sub PIPE_DATA_N2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_DATA_N2,  &_PIPEB_DATA_N2));
    }' unless defined(&PIPE_DATA_N2);
    eval 'sub PIPE_LINK_M1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_LINK_M1,  &_PIPEB_LINK_M1));
    }' unless defined(&PIPE_LINK_M1);
    eval 'sub PIPE_LINK_N1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_LINK_N1,  &_PIPEB_LINK_N1));
    }' unless defined(&PIPE_LINK_N1);
    eval 'sub PIPE_LINK_M2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_LINK_M2,  &_PIPEB_LINK_M2));
    }' unless defined(&PIPE_LINK_M2);
    eval 'sub PIPE_LINK_N2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PIPEA_LINK_N2,  &_PIPEB_LINK_N2));
    }' unless defined(&PIPE_LINK_N2);
    eval 'sub _PFA_CTL_1 () {0x68080;}' unless defined(&_PFA_CTL_1);
    eval 'sub _PFB_CTL_1 () {0x68880;}' unless defined(&_PFB_CTL_1);
    eval 'sub PF_ENABLE () {(1<<31);}' unless defined(&PF_ENABLE);
    eval 'sub PF_FILTER_MASK () {(3<<23);}' unless defined(&PF_FILTER_MASK);
    eval 'sub PF_FILTER_PROGRAMMED () {(0<<23);}' unless defined(&PF_FILTER_PROGRAMMED);
    eval 'sub PF_FILTER_MED_3x3 () {(1<<23);}' unless defined(&PF_FILTER_MED_3x3);
    eval 'sub PF_FILTER_EDGE_ENHANCE () {(2<<23);}' unless defined(&PF_FILTER_EDGE_ENHANCE);
    eval 'sub PF_FILTER_EDGE_SOFTEN () {(3<<23);}' unless defined(&PF_FILTER_EDGE_SOFTEN);
    eval 'sub _PFA_WIN_SZ () {0x68074;}' unless defined(&_PFA_WIN_SZ);
    eval 'sub _PFB_WIN_SZ () {0x68874;}' unless defined(&_PFB_WIN_SZ);
    eval 'sub _PFA_WIN_POS () {0x68070;}' unless defined(&_PFA_WIN_POS);
    eval 'sub _PFB_WIN_POS () {0x68870;}' unless defined(&_PFB_WIN_POS);
    eval 'sub _PFA_VSCALE () {0x68084;}' unless defined(&_PFA_VSCALE);
    eval 'sub _PFB_VSCALE () {0x68884;}' unless defined(&_PFB_VSCALE);
    eval 'sub _PFA_HSCALE () {0x68090;}' unless defined(&_PFA_HSCALE);
    eval 'sub _PFB_HSCALE () {0x68890;}' unless defined(&_PFB_HSCALE);
    eval 'sub PF_CTL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PFA_CTL_1,  &_PFB_CTL_1));
    }' unless defined(&PF_CTL);
    eval 'sub PF_WIN_SZ {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PFA_WIN_SZ,  &_PFB_WIN_SZ));
    }' unless defined(&PF_WIN_SZ);
    eval 'sub PF_WIN_POS {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PFA_WIN_POS,  &_PFB_WIN_POS));
    }' unless defined(&PF_WIN_POS);
    eval 'sub PF_VSCALE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PFA_VSCALE,  &_PFB_VSCALE));
    }' unless defined(&PF_VSCALE);
    eval 'sub PF_HSCALE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_PFA_HSCALE,  &_PFB_HSCALE));
    }' unless defined(&PF_HSCALE);
    eval 'sub _LGC_PALETTE_A () {0x4a000;}' unless defined(&_LGC_PALETTE_A);
    eval 'sub _LGC_PALETTE_B () {0x4a800;}' unless defined(&_LGC_PALETTE_B);
    eval 'sub LGC_PALETTE {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_LGC_PALETTE_A,  &_LGC_PALETTE_B));
    }' unless defined(&LGC_PALETTE);
    eval 'sub DE_MASTER_IRQ_CONTROL () {(1<< 31);}' unless defined(&DE_MASTER_IRQ_CONTROL);
    eval 'sub DE_SPRITEB_FLIP_DONE () {(1<< 29);}' unless defined(&DE_SPRITEB_FLIP_DONE);
    eval 'sub DE_SPRITEA_FLIP_DONE () {(1<< 28);}' unless defined(&DE_SPRITEA_FLIP_DONE);
    eval 'sub DE_PLANEB_FLIP_DONE () {(1<< 27);}' unless defined(&DE_PLANEB_FLIP_DONE);
    eval 'sub DE_PLANEA_FLIP_DONE () {(1<< 26);}' unless defined(&DE_PLANEA_FLIP_DONE);
    eval 'sub DE_PCU_EVENT () {(1<< 25);}' unless defined(&DE_PCU_EVENT);
    eval 'sub DE_GTT_FAULT () {(1<< 24);}' unless defined(&DE_GTT_FAULT);
    eval 'sub DE_POISON () {(1<< 23);}' unless defined(&DE_POISON);
    eval 'sub DE_PERFORM_COUNTER () {(1<< 22);}' unless defined(&DE_PERFORM_COUNTER);
    eval 'sub DE_PCH_EVENT () {(1<< 21);}' unless defined(&DE_PCH_EVENT);
    eval 'sub DE_AUX_CHANNEL_A () {(1<< 20);}' unless defined(&DE_AUX_CHANNEL_A);
    eval 'sub DE_DP_A_HOTPLUG () {(1<< 19);}' unless defined(&DE_DP_A_HOTPLUG);
    eval 'sub DE_GSE () {(1<< 18);}' unless defined(&DE_GSE);
    eval 'sub DE_PIPEB_VBLANK () {(1<< 15);}' unless defined(&DE_PIPEB_VBLANK);
    eval 'sub DE_PIPEB_EVEN_FIELD () {(1<< 14);}' unless defined(&DE_PIPEB_EVEN_FIELD);
    eval 'sub DE_PIPEB_ODD_FIELD () {(1<< 13);}' unless defined(&DE_PIPEB_ODD_FIELD);
    eval 'sub DE_PIPEB_LINE_COMPARE () {(1<< 12);}' unless defined(&DE_PIPEB_LINE_COMPARE);
    eval 'sub DE_PIPEB_VSYNC () {(1<< 11);}' unless defined(&DE_PIPEB_VSYNC);
    eval 'sub DE_PIPEB_FIFO_UNDERRUN () {(1<< 8);}' unless defined(&DE_PIPEB_FIFO_UNDERRUN);
    eval 'sub DE_PIPEA_VBLANK () {(1<< 7);}' unless defined(&DE_PIPEA_VBLANK);
    eval 'sub DE_PIPEA_EVEN_FIELD () {(1<< 6);}' unless defined(&DE_PIPEA_EVEN_FIELD);
    eval 'sub DE_PIPEA_ODD_FIELD () {(1<< 5);}' unless defined(&DE_PIPEA_ODD_FIELD);
    eval 'sub DE_PIPEA_LINE_COMPARE () {(1<< 4);}' unless defined(&DE_PIPEA_LINE_COMPARE);
    eval 'sub DE_PIPEA_VSYNC () {(1<< 3);}' unless defined(&DE_PIPEA_VSYNC);
    eval 'sub DE_PIPEA_FIFO_UNDERRUN () {(1<< 0);}' unless defined(&DE_PIPEA_FIFO_UNDERRUN);
    eval 'sub DE_ERR_DEBUG_IVB () {(1<<30);}' unless defined(&DE_ERR_DEBUG_IVB);
    eval 'sub DE_GSE_IVB () {(1<<29);}' unless defined(&DE_GSE_IVB);
    eval 'sub DE_PCH_EVENT_IVB () {(1<<28);}' unless defined(&DE_PCH_EVENT_IVB);
    eval 'sub DE_DP_A_HOTPLUG_IVB () {(1<<27);}' unless defined(&DE_DP_A_HOTPLUG_IVB);
    eval 'sub DE_AUX_CHANNEL_A_IVB () {(1<<26);}' unless defined(&DE_AUX_CHANNEL_A_IVB);
    eval 'sub DE_SPRITEB_FLIP_DONE_IVB () {(1<<9);}' unless defined(&DE_SPRITEB_FLIP_DONE_IVB);
    eval 'sub DE_SPRITEA_FLIP_DONE_IVB () {(1<<4);}' unless defined(&DE_SPRITEA_FLIP_DONE_IVB);
    eval 'sub DE_PLANEB_FLIP_DONE_IVB () {(1<<8);}' unless defined(&DE_PLANEB_FLIP_DONE_IVB);
    eval 'sub DE_PLANEA_FLIP_DONE_IVB () {(1<<3);}' unless defined(&DE_PLANEA_FLIP_DONE_IVB);
    eval 'sub DE_PIPEB_VBLANK_IVB () {(1<<5);}' unless defined(&DE_PIPEB_VBLANK_IVB);
    eval 'sub DE_PIPEA_VBLANK_IVB () {(1<<0);}' unless defined(&DE_PIPEA_VBLANK_IVB);
    eval 'sub DEISR () {0x44000;}' unless defined(&DEISR);
    eval 'sub DEIMR () {0x44004;}' unless defined(&DEIMR);
    eval 'sub DEIIR () {0x44008;}' unless defined(&DEIIR);
    eval 'sub DEIER () {0x4400c;}' unless defined(&DEIER);
    eval 'sub GT_PIPE_NOTIFY () {(1<< 4);}' unless defined(&GT_PIPE_NOTIFY);
    eval 'sub GT_MASTER_ERROR () {(1<< 3);}' unless defined(&GT_MASTER_ERROR);
    eval 'sub GT_SYNC_STATUS () {(1<< 2);}' unless defined(&GT_SYNC_STATUS);
    eval 'sub GT_USER_INTERRUPT () {(1<< 0);}' unless defined(&GT_USER_INTERRUPT);
    eval 'sub GT_BSD_USER_INTERRUPT () {(1<< 5);}' unless defined(&GT_BSD_USER_INTERRUPT);
    eval 'sub GT_GEN6_BSD_USER_INTERRUPT () {(1<< 12);}' unless defined(&GT_GEN6_BSD_USER_INTERRUPT);
    eval 'sub GT_BLT_USER_INTERRUPT () {(1<< 22);}' unless defined(&GT_BLT_USER_INTERRUPT);
    eval 'sub GTISR () {0x44010;}' unless defined(&GTISR);
    eval 'sub GTIMR () {0x44014;}' unless defined(&GTIMR);
    eval 'sub GTIIR () {0x44018;}' unless defined(&GTIIR);
    eval 'sub GTIER () {0x4401c;}' unless defined(&GTIER);
    eval 'sub ILK_DISPLAY_CHICKEN2 () {0x42004;}' unless defined(&ILK_DISPLAY_CHICKEN2);
    eval 'sub ILK_ELPIN_409_SELECT () {(1<< 25);}' unless defined(&ILK_ELPIN_409_SELECT);
    eval 'sub ILK_DPARB_GATE () {(1<<22);}' unless defined(&ILK_DPARB_GATE);
    eval 'sub ILK_VSDPFD_FULL () {(1<<21);}' unless defined(&ILK_VSDPFD_FULL);
    eval 'sub ILK_DISPLAY_CHICKEN_FUSES () {0x42014;}' unless defined(&ILK_DISPLAY_CHICKEN_FUSES);
    eval 'sub ILK_INTERNAL_GRAPHICS_DISABLE () {(1<<31);}' unless defined(&ILK_INTERNAL_GRAPHICS_DISABLE);
    eval 'sub ILK_INTERNAL_DISPLAY_DISABLE () {(1<<30);}' unless defined(&ILK_INTERNAL_DISPLAY_DISABLE);
    eval 'sub ILK_DISPLAY_DEBUG_DISABLE () {(1<<29);}' unless defined(&ILK_DISPLAY_DEBUG_DISABLE);
    eval 'sub ILK_HDCP_DISABLE () {(1<<25);}' unless defined(&ILK_HDCP_DISABLE);
    eval 'sub ILK_eDP_A_DISABLE () {(1<<24);}' unless defined(&ILK_eDP_A_DISABLE);
    eval 'sub ILK_DESKTOP () {(1<<23);}' unless defined(&ILK_DESKTOP);
    eval 'sub ILK_DSPCLK_GATE () {0x42020;}' unless defined(&ILK_DSPCLK_GATE);
    eval 'sub IVB_VRHUNIT_CLK_GATE () {(1<<28);}' unless defined(&IVB_VRHUNIT_CLK_GATE);
    eval 'sub ILK_DPARB_CLK_GATE () {(1<<5);}' unless defined(&ILK_DPARB_CLK_GATE);
    eval 'sub ILK_DPFD_CLK_GATE () {(1<<7);}' unless defined(&ILK_DPFD_CLK_GATE);
    eval 'sub ILK_CLK_FBC () {(1<<7);}' unless defined(&ILK_CLK_FBC);
    eval 'sub ILK_DPFC_DIS1 () {(1<<8);}' unless defined(&ILK_DPFC_DIS1);
    eval 'sub ILK_DPFC_DIS2 () {(1<<9);}' unless defined(&ILK_DPFC_DIS2);
    eval 'sub IVB_CHICKEN3 () {0x4200c;}' unless defined(&IVB_CHICKEN3);
    eval 'sub CHICKEN3_DGMG_REQ_OUT_FIX_DISABLE () {(1<< 5);}' unless defined(&CHICKEN3_DGMG_REQ_OUT_FIX_DISABLE);
    eval 'sub CHICKEN3_DGMG_DONE_FIX_DISABLE () {(1<< 2);}' unless defined(&CHICKEN3_DGMG_DONE_FIX_DISABLE);
    eval 'sub DISP_ARB_CTL () {0x45000;}' unless defined(&DISP_ARB_CTL);
    eval 'sub DISP_TILE_SURFACE_SWIZZLING () {(1<<13);}' unless defined(&DISP_TILE_SURFACE_SWIZZLING);
    eval 'sub DISP_FBC_WM_DIS () {(1<<15);}' unless defined(&DISP_FBC_WM_DIS);
    eval 'sub GEN7_COMMON_SLICE_CHICKEN1 () {0x7010;}' unless defined(&GEN7_COMMON_SLICE_CHICKEN1);
    eval 'sub GEN7_CSC1_RHWO_OPT_DISABLE_IN_RCC () {((1<<10) | (1<<26));}' unless defined(&GEN7_CSC1_RHWO_OPT_DISABLE_IN_RCC);
    eval 'sub GEN7_L3CNTLREG1 () {0xb01c;}' unless defined(&GEN7_L3CNTLREG1);
    eval 'sub GEN7_WA_FOR_GEN7_L3_CONTROL () {0x3c4fff8c;}' unless defined(&GEN7_WA_FOR_GEN7_L3_CONTROL);
    eval 'sub GEN7_L3_CHICKEN_MODE_REGISTER () {0xb030;}' unless defined(&GEN7_L3_CHICKEN_MODE_REGISTER);
    eval 'sub GEN7_WA_L3_CHICKEN_MODE () {0x20000000;}' unless defined(&GEN7_WA_L3_CHICKEN_MODE);
    eval 'sub GEN7_SQ_CHICKEN_MBCUNIT_CONFIG () {0x9030;}' unless defined(&GEN7_SQ_CHICKEN_MBCUNIT_CONFIG);
    eval 'sub GEN7_SQ_CHICKEN_MBCUNIT_SQINTMOB () {(1<<11);}' unless defined(&GEN7_SQ_CHICKEN_MBCUNIT_SQINTMOB);
    eval 'sub SDE_AUDIO_POWER_D () {(1<< 27);}' unless defined(&SDE_AUDIO_POWER_D);
    eval 'sub SDE_AUDIO_POWER_C () {(1<< 26);}' unless defined(&SDE_AUDIO_POWER_C);
    eval 'sub SDE_AUDIO_POWER_B () {(1<< 25);}' unless defined(&SDE_AUDIO_POWER_B);
    eval 'sub SDE_AUDIO_POWER_SHIFT () {(25);}' unless defined(&SDE_AUDIO_POWER_SHIFT);
    eval 'sub SDE_AUDIO_POWER_MASK () {(7<<  &SDE_AUDIO_POWER_SHIFT);}' unless defined(&SDE_AUDIO_POWER_MASK);
    eval 'sub SDE_GMBUS () {(1<< 24);}' unless defined(&SDE_GMBUS);
    eval 'sub SDE_AUDIO_HDCP_TRANSB () {(1<< 23);}' unless defined(&SDE_AUDIO_HDCP_TRANSB);
    eval 'sub SDE_AUDIO_HDCP_TRANSA () {(1<< 22);}' unless defined(&SDE_AUDIO_HDCP_TRANSA);
    eval 'sub SDE_AUDIO_HDCP_MASK () {(3<< 22);}' unless defined(&SDE_AUDIO_HDCP_MASK);
    eval 'sub SDE_AUDIO_TRANSB () {(1<< 21);}' unless defined(&SDE_AUDIO_TRANSB);
    eval 'sub SDE_AUDIO_TRANSA () {(1<< 20);}' unless defined(&SDE_AUDIO_TRANSA);
    eval 'sub SDE_AUDIO_TRANS_MASK () {(3<< 20);}' unless defined(&SDE_AUDIO_TRANS_MASK);
    eval 'sub SDE_POISON () {(1<< 19);}' unless defined(&SDE_POISON);
    eval 'sub SDE_FDI_RXB () {(1<< 17);}' unless defined(&SDE_FDI_RXB);
    eval 'sub SDE_FDI_RXA () {(1<< 16);}' unless defined(&SDE_FDI_RXA);
    eval 'sub SDE_FDI_MASK () {(3<< 16);}' unless defined(&SDE_FDI_MASK);
    eval 'sub SDE_AUXD () {(1<< 15);}' unless defined(&SDE_AUXD);
    eval 'sub SDE_AUXC () {(1<< 14);}' unless defined(&SDE_AUXC);
    eval 'sub SDE_AUXB () {(1<< 13);}' unless defined(&SDE_AUXB);
    eval 'sub SDE_AUX_MASK () {(7<< 13);}' unless defined(&SDE_AUX_MASK);
    eval 'sub SDE_CRT_HOTPLUG () {(1<< 11);}' unless defined(&SDE_CRT_HOTPLUG);
    eval 'sub SDE_PORTD_HOTPLUG () {(1<< 10);}' unless defined(&SDE_PORTD_HOTPLUG);
    eval 'sub SDE_PORTC_HOTPLUG () {(1<< 9);}' unless defined(&SDE_PORTC_HOTPLUG);
    eval 'sub SDE_PORTB_HOTPLUG () {(1<< 8);}' unless defined(&SDE_PORTB_HOTPLUG);
    eval 'sub SDE_SDVOB_HOTPLUG () {(1<< 6);}' unless defined(&SDE_SDVOB_HOTPLUG);
    eval 'sub SDE_HOTPLUG_MASK () {(0xf << 8);}' unless defined(&SDE_HOTPLUG_MASK);
    eval 'sub SDE_TRANSB_CRC_DONE () {(1<< 5);}' unless defined(&SDE_TRANSB_CRC_DONE);
    eval 'sub SDE_TRANSB_CRC_ERR () {(1<< 4);}' unless defined(&SDE_TRANSB_CRC_ERR);
    eval 'sub SDE_TRANSB_FIFO_UNDER () {(1<< 3);}' unless defined(&SDE_TRANSB_FIFO_UNDER);
    eval 'sub SDE_TRANSA_CRC_DONE () {(1<< 2);}' unless defined(&SDE_TRANSA_CRC_DONE);
    eval 'sub SDE_TRANSA_CRC_ERR () {(1<< 1);}' unless defined(&SDE_TRANSA_CRC_ERR);
    eval 'sub SDE_TRANSA_FIFO_UNDER () {(1<< 0);}' unless defined(&SDE_TRANSA_FIFO_UNDER);
    eval 'sub SDE_TRANS_MASK () {(0x3f);}' unless defined(&SDE_TRANS_MASK);
    eval 'sub SDE_CRT_HOTPLUG_CPT () {(1<< 19);}' unless defined(&SDE_CRT_HOTPLUG_CPT);
    eval 'sub SDE_PORTD_HOTPLUG_CPT () {(1<< 23);}' unless defined(&SDE_PORTD_HOTPLUG_CPT);
    eval 'sub SDE_PORTC_HOTPLUG_CPT () {(1<< 22);}' unless defined(&SDE_PORTC_HOTPLUG_CPT);
    eval 'sub SDE_PORTB_HOTPLUG_CPT () {(1<< 21);}' unless defined(&SDE_PORTB_HOTPLUG_CPT);
    eval 'sub SDE_HOTPLUG_MASK_CPT () {( &SDE_CRT_HOTPLUG_CPT |  &SDE_PORTD_HOTPLUG_CPT |  &SDE_PORTC_HOTPLUG_CPT |  &SDE_PORTB_HOTPLUG_CPT);}' unless defined(&SDE_HOTPLUG_MASK_CPT);
    eval 'sub SDEISR () {0xc4000;}' unless defined(&SDEISR);
    eval 'sub SDEIMR () {0xc4004;}' unless defined(&SDEIMR);
    eval 'sub SDEIIR () {0xc4008;}' unless defined(&SDEIIR);
    eval 'sub SDEIER () {0xc400c;}' unless defined(&SDEIER);
    eval 'sub PCH_PORT_HOTPLUG () {0xc4030;}' unless defined(&PCH_PORT_HOTPLUG);
    eval 'sub PORTD_HOTPLUG_ENABLE () {(1<< 20);}' unless defined(&PORTD_HOTPLUG_ENABLE);
    eval 'sub PORTD_PULSE_DURATION_2ms () {(0);}' unless defined(&PORTD_PULSE_DURATION_2ms);
    eval 'sub PORTD_PULSE_DURATION_4_5ms () {(1<< 18);}' unless defined(&PORTD_PULSE_DURATION_4_5ms);
    eval 'sub PORTD_PULSE_DURATION_6ms () {(2<< 18);}' unless defined(&PORTD_PULSE_DURATION_6ms);
    eval 'sub PORTD_PULSE_DURATION_100ms () {(3<< 18);}' unless defined(&PORTD_PULSE_DURATION_100ms);
    eval 'sub PORTD_PULSE_DURATION_MASK () {(3<< 18);}' unless defined(&PORTD_PULSE_DURATION_MASK);
    eval 'sub PORTD_HOTPLUG_NO_DETECT () {(0);}' unless defined(&PORTD_HOTPLUG_NO_DETECT);
    eval 'sub PORTD_HOTPLUG_SHORT_DETECT () {(1<< 16);}' unless defined(&PORTD_HOTPLUG_SHORT_DETECT);
    eval 'sub PORTD_HOTPLUG_LONG_DETECT () {(1<< 17);}' unless defined(&PORTD_HOTPLUG_LONG_DETECT);
    eval 'sub PORTC_HOTPLUG_ENABLE () {(1<< 12);}' unless defined(&PORTC_HOTPLUG_ENABLE);
    eval 'sub PORTC_PULSE_DURATION_2ms () {(0);}' unless defined(&PORTC_PULSE_DURATION_2ms);
    eval 'sub PORTC_PULSE_DURATION_4_5ms () {(1<< 10);}' unless defined(&PORTC_PULSE_DURATION_4_5ms);
    eval 'sub PORTC_PULSE_DURATION_6ms () {(2<< 10);}' unless defined(&PORTC_PULSE_DURATION_6ms);
    eval 'sub PORTC_PULSE_DURATION_100ms () {(3<< 10);}' unless defined(&PORTC_PULSE_DURATION_100ms);
    eval 'sub PORTC_PULSE_DURATION_MASK () {(3<< 10);}' unless defined(&PORTC_PULSE_DURATION_MASK);
    eval 'sub PORTC_HOTPLUG_NO_DETECT () {(0);}' unless defined(&PORTC_HOTPLUG_NO_DETECT);
    eval 'sub PORTC_HOTPLUG_SHORT_DETECT () {(1<< 8);}' unless defined(&PORTC_HOTPLUG_SHORT_DETECT);
    eval 'sub PORTC_HOTPLUG_LONG_DETECT () {(1<< 9);}' unless defined(&PORTC_HOTPLUG_LONG_DETECT);
    eval 'sub PORTB_HOTPLUG_ENABLE () {(1<< 4);}' unless defined(&PORTB_HOTPLUG_ENABLE);
    eval 'sub PORTB_PULSE_DURATION_2ms () {(0);}' unless defined(&PORTB_PULSE_DURATION_2ms);
    eval 'sub PORTB_PULSE_DURATION_4_5ms () {(1<< 2);}' unless defined(&PORTB_PULSE_DURATION_4_5ms);
    eval 'sub PORTB_PULSE_DURATION_6ms () {(2<< 2);}' unless defined(&PORTB_PULSE_DURATION_6ms);
    eval 'sub PORTB_PULSE_DURATION_100ms () {(3<< 2);}' unless defined(&PORTB_PULSE_DURATION_100ms);
    eval 'sub PORTB_PULSE_DURATION_MASK () {(3<< 2);}' unless defined(&PORTB_PULSE_DURATION_MASK);
    eval 'sub PORTB_HOTPLUG_NO_DETECT () {(0);}' unless defined(&PORTB_HOTPLUG_NO_DETECT);
    eval 'sub PORTB_HOTPLUG_SHORT_DETECT () {(1<< 0);}' unless defined(&PORTB_HOTPLUG_SHORT_DETECT);
    eval 'sub PORTB_HOTPLUG_LONG_DETECT () {(1<< 1);}' unless defined(&PORTB_HOTPLUG_LONG_DETECT);
    eval 'sub PCH_GPIOA () {0xc5010;}' unless defined(&PCH_GPIOA);
    eval 'sub PCH_GPIOB () {0xc5014;}' unless defined(&PCH_GPIOB);
    eval 'sub PCH_GPIOC () {0xc5018;}' unless defined(&PCH_GPIOC);
    eval 'sub PCH_GPIOD () {0xc501c;}' unless defined(&PCH_GPIOD);
    eval 'sub PCH_GPIOE () {0xc5020;}' unless defined(&PCH_GPIOE);
    eval 'sub PCH_GPIOF () {0xc5024;}' unless defined(&PCH_GPIOF);
    eval 'sub PCH_GMBUS0 () {0xc5100;}' unless defined(&PCH_GMBUS0);
    eval 'sub PCH_GMBUS1 () {0xc5104;}' unless defined(&PCH_GMBUS1);
    eval 'sub PCH_GMBUS2 () {0xc5108;}' unless defined(&PCH_GMBUS2);
    eval 'sub PCH_GMBUS3 () {0xc510c;}' unless defined(&PCH_GMBUS3);
    eval 'sub PCH_GMBUS4 () {0xc5110;}' unless defined(&PCH_GMBUS4);
    eval 'sub PCH_GMBUS5 () {0xc5120;}' unless defined(&PCH_GMBUS5);
    eval 'sub _PCH_DPLL_A () {0xc6014;}' unless defined(&_PCH_DPLL_A);
    eval 'sub _PCH_DPLL_B () {0xc6018;}' unless defined(&_PCH_DPLL_B);
    eval 'sub PCH_DPLL {
        my($pipe) = @_;
	    eval q(($pipe == 0?  &_PCH_DPLL_A :  &_PCH_DPLL_B));
    }' unless defined(&PCH_DPLL);
    eval 'sub _PCH_FPA0 () {0xc6040;}' unless defined(&_PCH_FPA0);
    eval 'sub FP_CB_TUNE () {(0x3<<22);}' unless defined(&FP_CB_TUNE);
    eval 'sub _PCH_FPA1 () {0xc6044;}' unless defined(&_PCH_FPA1);
    eval 'sub _PCH_FPB0 () {0xc6048;}' unless defined(&_PCH_FPB0);
    eval 'sub _PCH_FPB1 () {0xc604c;}' unless defined(&_PCH_FPB1);
    eval 'sub PCH_FP0 {
        my($pipe) = @_;
	    eval q(($pipe == 0?  &_PCH_FPA0 :  &_PCH_FPB0));
    }' unless defined(&PCH_FP0);
    eval 'sub PCH_FP1 {
        my($pipe) = @_;
	    eval q(($pipe == 0?  &_PCH_FPA1 :  &_PCH_FPB1));
    }' unless defined(&PCH_FP1);
    eval 'sub PCH_DPLL_TEST () {0xc606c;}' unless defined(&PCH_DPLL_TEST);
    eval 'sub PCH_DREF_CONTROL () {0xc6200;}' unless defined(&PCH_DREF_CONTROL);
    eval 'sub DREF_CONTROL_MASK () {0x7fc3;}' unless defined(&DREF_CONTROL_MASK);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_DISABLE () {(0<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_DISABLE);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_DOWNSPREAD () {(2<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_DOWNSPREAD);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_NONSPREAD () {(3<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_NONSPREAD);
    eval 'sub DREF_CPU_SOURCE_OUTPUT_MASK () {(3<<13);}' unless defined(&DREF_CPU_SOURCE_OUTPUT_MASK);
    eval 'sub DREF_SSC_SOURCE_DISABLE () {(0<<11);}' unless defined(&DREF_SSC_SOURCE_DISABLE);
    eval 'sub DREF_SSC_SOURCE_ENABLE () {(2<<11);}' unless defined(&DREF_SSC_SOURCE_ENABLE);
    eval 'sub DREF_SSC_SOURCE_MASK () {(3<<11);}' unless defined(&DREF_SSC_SOURCE_MASK);
    eval 'sub DREF_NONSPREAD_SOURCE_DISABLE () {(0<<9);}' unless defined(&DREF_NONSPREAD_SOURCE_DISABLE);
    eval 'sub DREF_NONSPREAD_CK505_ENABLE () {(1<<9);}' unless defined(&DREF_NONSPREAD_CK505_ENABLE);
    eval 'sub DREF_NONSPREAD_SOURCE_ENABLE () {(2<<9);}' unless defined(&DREF_NONSPREAD_SOURCE_ENABLE);
    eval 'sub DREF_NONSPREAD_SOURCE_MASK () {(3<<9);}' unless defined(&DREF_NONSPREAD_SOURCE_MASK);
    eval 'sub DREF_SUPERSPREAD_SOURCE_DISABLE () {(0<<7);}' unless defined(&DREF_SUPERSPREAD_SOURCE_DISABLE);
    eval 'sub DREF_SUPERSPREAD_SOURCE_ENABLE () {(2<<7);}' unless defined(&DREF_SUPERSPREAD_SOURCE_ENABLE);
    eval 'sub DREF_SUPERSPREAD_SOURCE_MASK () {(3<<7);}' unless defined(&DREF_SUPERSPREAD_SOURCE_MASK);
    eval 'sub DREF_SSC4_DOWNSPREAD () {(0<<6);}' unless defined(&DREF_SSC4_DOWNSPREAD);
    eval 'sub DREF_SSC4_CENTERSPREAD () {(1<<6);}' unless defined(&DREF_SSC4_CENTERSPREAD);
    eval 'sub DREF_SSC1_DISABLE () {(0<<1);}' unless defined(&DREF_SSC1_DISABLE);
    eval 'sub DREF_SSC1_ENABLE () {(1<<1);}' unless defined(&DREF_SSC1_ENABLE);
    eval 'sub DREF_SSC4_DISABLE () {(0);}' unless defined(&DREF_SSC4_DISABLE);
    eval 'sub DREF_SSC4_ENABLE () {(1);}' unless defined(&DREF_SSC4_ENABLE);
    eval 'sub PCH_RAWCLK_FREQ () {0xc6204;}' unless defined(&PCH_RAWCLK_FREQ);
    eval 'sub FDL_TP1_TIMER_SHIFT () {12;}' unless defined(&FDL_TP1_TIMER_SHIFT);
    eval 'sub FDL_TP1_TIMER_MASK () {(3<<12);}' unless defined(&FDL_TP1_TIMER_MASK);
    eval 'sub FDL_TP2_TIMER_SHIFT () {10;}' unless defined(&FDL_TP2_TIMER_SHIFT);
    eval 'sub FDL_TP2_TIMER_MASK () {(3<<10);}' unless defined(&FDL_TP2_TIMER_MASK);
    eval 'sub RAWCLK_FREQ_MASK () {0x3ff;}' unless defined(&RAWCLK_FREQ_MASK);
    eval 'sub PCH_DPLL_TMR_CFG () {0xc6208;}' unless defined(&PCH_DPLL_TMR_CFG);
    eval 'sub PCH_SSC4_PARMS () {0xc6210;}' unless defined(&PCH_SSC4_PARMS);
    eval 'sub PCH_SSC4_AUX_PARMS () {0xc6214;}' unless defined(&PCH_SSC4_AUX_PARMS);
    eval 'sub PCH_DPLL_SEL () {0xc7000;}' unless defined(&PCH_DPLL_SEL);
    eval 'sub TRANSA_DPLL_ENABLE () {(1<<3);}' unless defined(&TRANSA_DPLL_ENABLE);
    eval 'sub TRANSA_DPLLB_SEL () {(1<<0);}' unless defined(&TRANSA_DPLLB_SEL);
    eval 'sub TRANSA_DPLLA_SEL () {0;}' unless defined(&TRANSA_DPLLA_SEL);
    eval 'sub TRANSB_DPLL_ENABLE () {(1<<7);}' unless defined(&TRANSB_DPLL_ENABLE);
    eval 'sub TRANSB_DPLLB_SEL () {(1<<4);}' unless defined(&TRANSB_DPLLB_SEL);
    eval 'sub TRANSB_DPLLA_SEL () {(0);}' unless defined(&TRANSB_DPLLA_SEL);
    eval 'sub TRANSC_DPLL_ENABLE () {(1<<11);}' unless defined(&TRANSC_DPLL_ENABLE);
    eval 'sub TRANSC_DPLLB_SEL () {(1<<8);}' unless defined(&TRANSC_DPLLB_SEL);
    eval 'sub TRANSC_DPLLA_SEL () {(0);}' unless defined(&TRANSC_DPLLA_SEL);
    eval 'sub _TRANS_HTOTAL_A () {0xe0000;}' unless defined(&_TRANS_HTOTAL_A);
    eval 'sub TRANS_HTOTAL_SHIFT () {16;}' unless defined(&TRANS_HTOTAL_SHIFT);
    eval 'sub TRANS_HACTIVE_SHIFT () {0;}' unless defined(&TRANS_HACTIVE_SHIFT);
    eval 'sub _TRANS_HBLANK_A () {0xe0004;}' unless defined(&_TRANS_HBLANK_A);
    eval 'sub TRANS_HBLANK_END_SHIFT () {16;}' unless defined(&TRANS_HBLANK_END_SHIFT);
    eval 'sub TRANS_HBLANK_START_SHIFT () {0;}' unless defined(&TRANS_HBLANK_START_SHIFT);
    eval 'sub _TRANS_HSYNC_A () {0xe0008;}' unless defined(&_TRANS_HSYNC_A);
    eval 'sub TRANS_HSYNC_END_SHIFT () {16;}' unless defined(&TRANS_HSYNC_END_SHIFT);
    eval 'sub TRANS_HSYNC_START_SHIFT () {0;}' unless defined(&TRANS_HSYNC_START_SHIFT);
    eval 'sub _TRANS_VTOTAL_A () {0xe000c;}' unless defined(&_TRANS_VTOTAL_A);
    eval 'sub TRANS_VTOTAL_SHIFT () {16;}' unless defined(&TRANS_VTOTAL_SHIFT);
    eval 'sub TRANS_VACTIVE_SHIFT () {0;}' unless defined(&TRANS_VACTIVE_SHIFT);
    eval 'sub _TRANS_VBLANK_A () {0xe0010;}' unless defined(&_TRANS_VBLANK_A);
    eval 'sub TRANS_VBLANK_END_SHIFT () {16;}' unless defined(&TRANS_VBLANK_END_SHIFT);
    eval 'sub TRANS_VBLANK_START_SHIFT () {0;}' unless defined(&TRANS_VBLANK_START_SHIFT);
    eval 'sub _TRANS_VSYNC_A () {0xe0014;}' unless defined(&_TRANS_VSYNC_A);
    eval 'sub TRANS_VSYNC_END_SHIFT () {16;}' unless defined(&TRANS_VSYNC_END_SHIFT);
    eval 'sub TRANS_VSYNC_START_SHIFT () {0;}' unless defined(&TRANS_VSYNC_START_SHIFT);
    eval 'sub _TRANS_VSYNCSHIFT_A () {0xe0028;}' unless defined(&_TRANS_VSYNCSHIFT_A);
    eval 'sub _TRANSA_DATA_M1 () {0xe0030;}' unless defined(&_TRANSA_DATA_M1);
    eval 'sub _TRANSA_DATA_N1 () {0xe0034;}' unless defined(&_TRANSA_DATA_N1);
    eval 'sub _TRANSA_DATA_M2 () {0xe0038;}' unless defined(&_TRANSA_DATA_M2);
    eval 'sub _TRANSA_DATA_N2 () {0xe003c;}' unless defined(&_TRANSA_DATA_N2);
    eval 'sub _TRANSA_DP_LINK_M1 () {0xe0040;}' unless defined(&_TRANSA_DP_LINK_M1);
    eval 'sub _TRANSA_DP_LINK_N1 () {0xe0044;}' unless defined(&_TRANSA_DP_LINK_N1);
    eval 'sub _TRANSA_DP_LINK_M2 () {0xe0048;}' unless defined(&_TRANSA_DP_LINK_M2);
    eval 'sub _TRANSA_DP_LINK_N2 () {0xe004c;}' unless defined(&_TRANSA_DP_LINK_N2);
    eval 'sub _VIDEO_DIP_CTL_A () {0xe0200;}' unless defined(&_VIDEO_DIP_CTL_A);
    eval 'sub _VIDEO_DIP_DATA_A () {0xe0208;}' unless defined(&_VIDEO_DIP_DATA_A);
    eval 'sub _VIDEO_DIP_GCP_A () {0xe0210;}' unless defined(&_VIDEO_DIP_GCP_A);
    eval 'sub _VIDEO_DIP_CTL_B () {0xe1200;}' unless defined(&_VIDEO_DIP_CTL_B);
    eval 'sub _VIDEO_DIP_DATA_B () {0xe1208;}' unless defined(&_VIDEO_DIP_DATA_B);
    eval 'sub _VIDEO_DIP_GCP_B () {0xe1210;}' unless defined(&_VIDEO_DIP_GCP_B);
    eval 'sub TVIDEO_DIP_CTL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VIDEO_DIP_CTL_A,  &_VIDEO_DIP_CTL_B));
    }' unless defined(&TVIDEO_DIP_CTL);
    eval 'sub TVIDEO_DIP_DATA {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VIDEO_DIP_DATA_A,  &_VIDEO_DIP_DATA_B));
    }' unless defined(&TVIDEO_DIP_DATA);
    eval 'sub TVIDEO_DIP_GCP {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_VIDEO_DIP_GCP_A,  &_VIDEO_DIP_GCP_B));
    }' unless defined(&TVIDEO_DIP_GCP);
    eval 'sub _TRANS_HTOTAL_B () {0xe1000;}' unless defined(&_TRANS_HTOTAL_B);
    eval 'sub _TRANS_HBLANK_B () {0xe1004;}' unless defined(&_TRANS_HBLANK_B);
    eval 'sub _TRANS_HSYNC_B () {0xe1008;}' unless defined(&_TRANS_HSYNC_B);
    eval 'sub _TRANS_VTOTAL_B () {0xe100c;}' unless defined(&_TRANS_VTOTAL_B);
    eval 'sub _TRANS_VBLANK_B () {0xe1010;}' unless defined(&_TRANS_VBLANK_B);
    eval 'sub _TRANS_VSYNC_B () {0xe1014;}' unless defined(&_TRANS_VSYNC_B);
    eval 'sub _TRANS_VSYNCSHIFT_B () {0xe1028;}' unless defined(&_TRANS_VSYNCSHIFT_B);
    eval 'sub TRANS_HTOTAL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_HTOTAL_A,  &_TRANS_HTOTAL_B));
    }' unless defined(&TRANS_HTOTAL);
    eval 'sub TRANS_HBLANK {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_HBLANK_A,  &_TRANS_HBLANK_B));
    }' unless defined(&TRANS_HBLANK);
    eval 'sub TRANS_HSYNC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_HSYNC_A,  &_TRANS_HSYNC_B));
    }' unless defined(&TRANS_HSYNC);
    eval 'sub TRANS_VTOTAL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_VTOTAL_A,  &_TRANS_VTOTAL_B));
    }' unless defined(&TRANS_VTOTAL);
    eval 'sub TRANS_VBLANK {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_VBLANK_A,  &_TRANS_VBLANK_B));
    }' unless defined(&TRANS_VBLANK);
    eval 'sub TRANS_VSYNC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_VSYNC_A,  &_TRANS_VSYNC_B));
    }' unless defined(&TRANS_VSYNC);
    eval 'sub TRANS_VSYNCSHIFT {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANS_VSYNCSHIFT_A,  &_TRANS_VSYNCSHIFT_B));
    }' unless defined(&TRANS_VSYNCSHIFT);
    eval 'sub _TRANSB_DATA_M1 () {0xe1030;}' unless defined(&_TRANSB_DATA_M1);
    eval 'sub _TRANSB_DATA_N1 () {0xe1034;}' unless defined(&_TRANSB_DATA_N1);
    eval 'sub _TRANSB_DATA_M2 () {0xe1038;}' unless defined(&_TRANSB_DATA_M2);
    eval 'sub _TRANSB_DATA_N2 () {0xe103c;}' unless defined(&_TRANSB_DATA_N2);
    eval 'sub _TRANSB_DP_LINK_M1 () {0xe1040;}' unless defined(&_TRANSB_DP_LINK_M1);
    eval 'sub _TRANSB_DP_LINK_N1 () {0xe1044;}' unless defined(&_TRANSB_DP_LINK_N1);
    eval 'sub _TRANSB_DP_LINK_M2 () {0xe1048;}' unless defined(&_TRANSB_DP_LINK_M2);
    eval 'sub _TRANSB_DP_LINK_N2 () {0xe104c;}' unless defined(&_TRANSB_DP_LINK_N2);
    eval 'sub TRANSDATA_M1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DATA_M1,  &_TRANSB_DATA_M1));
    }' unless defined(&TRANSDATA_M1);
    eval 'sub TRANSDATA_N1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DATA_N1,  &_TRANSB_DATA_N1));
    }' unless defined(&TRANSDATA_N1);
    eval 'sub TRANSDATA_M2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DATA_M2,  &_TRANSB_DATA_M2));
    }' unless defined(&TRANSDATA_M2);
    eval 'sub TRANSDATA_N2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DATA_N2,  &_TRANSB_DATA_N2));
    }' unless defined(&TRANSDATA_N2);
    eval 'sub TRANSDPLINK_M1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DP_LINK_M1,  &_TRANSB_DP_LINK_M1));
    }' unless defined(&TRANSDPLINK_M1);
    eval 'sub TRANSDPLINK_N1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DP_LINK_N1,  &_TRANSB_DP_LINK_N1));
    }' unless defined(&TRANSDPLINK_N1);
    eval 'sub TRANSDPLINK_M2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DP_LINK_M2,  &_TRANSB_DP_LINK_M2));
    }' unless defined(&TRANSDPLINK_M2);
    eval 'sub TRANSDPLINK_N2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_DP_LINK_N2,  &_TRANSB_DP_LINK_N2));
    }' unless defined(&TRANSDPLINK_N2);
    eval 'sub _TRANSACONF () {0xf0008;}' unless defined(&_TRANSACONF);
    eval 'sub _TRANSBCONF () {0xf1008;}' unless defined(&_TRANSBCONF);
    eval 'sub TRANSCONF {
        my($plane) = @_;
	    eval q( &_PIPE($plane,  &_TRANSACONF,  &_TRANSBCONF));
    }' unless defined(&TRANSCONF);
    eval 'sub TRANS_DISABLE () {(0<<31);}' unless defined(&TRANS_DISABLE);
    eval 'sub TRANS_ENABLE () {(1<<31);}' unless defined(&TRANS_ENABLE);
    eval 'sub TRANS_STATE_MASK () {(1<<30);}' unless defined(&TRANS_STATE_MASK);
    eval 'sub TRANS_STATE_DISABLE () {(0<<30);}' unless defined(&TRANS_STATE_DISABLE);
    eval 'sub TRANS_STATE_ENABLE () {(1<<30);}' unless defined(&TRANS_STATE_ENABLE);
    eval 'sub TRANS_FSYNC_DELAY_HB1 () {(0<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB1);
    eval 'sub TRANS_FSYNC_DELAY_HB2 () {(1<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB2);
    eval 'sub TRANS_FSYNC_DELAY_HB3 () {(2<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB3);
    eval 'sub TRANS_FSYNC_DELAY_HB4 () {(3<<27);}' unless defined(&TRANS_FSYNC_DELAY_HB4);
    eval 'sub TRANS_DP_AUDIO_ONLY () {(1<<26);}' unless defined(&TRANS_DP_AUDIO_ONLY);
    eval 'sub TRANS_DP_VIDEO_AUDIO () {(0<<26);}' unless defined(&TRANS_DP_VIDEO_AUDIO);
    eval 'sub TRANS_INTERLACE_MASK () {(7<<21);}' unless defined(&TRANS_INTERLACE_MASK);
    eval 'sub TRANS_PROGRESSIVE () {(0<<21);}' unless defined(&TRANS_PROGRESSIVE);
    eval 'sub TRANS_INTERLACED () {(3<<21);}' unless defined(&TRANS_INTERLACED);
    eval 'sub TRANS_LEGACY_INTERLACED_ILK () {(2<<21);}' unless defined(&TRANS_LEGACY_INTERLACED_ILK);
    eval 'sub TRANS_8BPC () {(0<<5);}' unless defined(&TRANS_8BPC);
    eval 'sub TRANS_10BPC () {(1<<5);}' unless defined(&TRANS_10BPC);
    eval 'sub TRANS_6BPC () {(2<<5);}' unless defined(&TRANS_6BPC);
    eval 'sub TRANS_12BPC () {(3<<5);}' unless defined(&TRANS_12BPC);
    eval 'sub _TRANSA_CHICKEN2 () {0xf0064;}' unless defined(&_TRANSA_CHICKEN2);
    eval 'sub _TRANSB_CHICKEN2 () {0xf1064;}' unless defined(&_TRANSB_CHICKEN2);
    eval 'sub TRANS_CHICKEN2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_TRANSA_CHICKEN2,  &_TRANSB_CHICKEN2));
    }' unless defined(&TRANS_CHICKEN2);
    eval 'sub TRANS_AUTOTRAIN_GEN_STALL_DIS () {(1<<31);}' unless defined(&TRANS_AUTOTRAIN_GEN_STALL_DIS);
    eval 'sub SOUTH_CHICKEN1 () {0xc2000;}' unless defined(&SOUTH_CHICKEN1);
    eval 'sub FDIA_PHASE_SYNC_SHIFT_OVR () {19;}' unless defined(&FDIA_PHASE_SYNC_SHIFT_OVR);
    eval 'sub FDIA_PHASE_SYNC_SHIFT_EN () {18;}' unless defined(&FDIA_PHASE_SYNC_SHIFT_EN);
    eval 'sub FDI_PHASE_SYNC_OVR {
        my($pipe) = @_;
	    eval q((1<<( &FDIA_PHASE_SYNC_SHIFT_OVR - (($pipe) * 2))));
    }' unless defined(&FDI_PHASE_SYNC_OVR);
    eval 'sub FDI_PHASE_SYNC_EN {
        my($pipe) = @_;
	    eval q((1<<( &FDIA_PHASE_SYNC_SHIFT_EN - (($pipe) * 2))));
    }' unless defined(&FDI_PHASE_SYNC_EN);
    eval 'sub SOUTH_CHICKEN2 () {0xc2004;}' unless defined(&SOUTH_CHICKEN2);
    eval 'sub DPLS_EDP_PPS_FIX_DIS () {(1<<0);}' unless defined(&DPLS_EDP_PPS_FIX_DIS);
    eval 'sub _FDI_RXA_CHICKEN () {0xc200c;}' unless defined(&_FDI_RXA_CHICKEN);
    eval 'sub _FDI_RXB_CHICKEN () {0xc2010;}' unless defined(&_FDI_RXB_CHICKEN);
    eval 'sub FDI_RX_PHASE_SYNC_POINTER_OVR () {(1<<1);}' unless defined(&FDI_RX_PHASE_SYNC_POINTER_OVR);
    eval 'sub FDI_RX_PHASE_SYNC_POINTER_EN () {(1<<0);}' unless defined(&FDI_RX_PHASE_SYNC_POINTER_EN);
    eval 'sub FDI_RX_CHICKEN {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_CHICKEN,  &_FDI_RXB_CHICKEN));
    }' unless defined(&FDI_RX_CHICKEN);
    eval 'sub SOUTH_DSPCLK_GATE_D () {0xc2020;}' unless defined(&SOUTH_DSPCLK_GATE_D);
    eval 'sub PCH_DPLSUNIT_CLOCK_GATE_DISABLE () {(1<<29);}' unless defined(&PCH_DPLSUNIT_CLOCK_GATE_DISABLE);
    eval 'sub _FDI_TXA_CTL () {0x60100;}' unless defined(&_FDI_TXA_CTL);
    eval 'sub _FDI_TXB_CTL () {0x61100;}' unless defined(&_FDI_TXB_CTL);
    eval 'sub FDI_TX_CTL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_TXA_CTL,  &_FDI_TXB_CTL));
    }' unless defined(&FDI_TX_CTL);
    eval 'sub FDI_TX_DISABLE () {(0<<31);}' unless defined(&FDI_TX_DISABLE);
    eval 'sub FDI_TX_ENABLE () {(1<<31);}' unless defined(&FDI_TX_ENABLE);
    eval 'sub FDI_LINK_TRAIN_PATTERN_1 () {(0<<28);}' unless defined(&FDI_LINK_TRAIN_PATTERN_1);
    eval 'sub FDI_LINK_TRAIN_PATTERN_2 () {(1<<28);}' unless defined(&FDI_LINK_TRAIN_PATTERN_2);
    eval 'sub FDI_LINK_TRAIN_PATTERN_IDLE () {(2<<28);}' unless defined(&FDI_LINK_TRAIN_PATTERN_IDLE);
    eval 'sub FDI_LINK_TRAIN_NONE () {(3<<28);}' unless defined(&FDI_LINK_TRAIN_NONE);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_0_4V () {(0<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_0_4V);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_0_6V () {(1<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_0_6V);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_0_8V () {(2<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_0_8V);
    eval 'sub FDI_LINK_TRAIN_VOLTAGE_1_2V () {(3<<25);}' unless defined(&FDI_LINK_TRAIN_VOLTAGE_1_2V);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_NONE () {(0<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_NONE);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_1_5X () {(1<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_1_5X);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_2X () {(2<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_2X);
    eval 'sub FDI_LINK_TRAIN_PRE_EMPHASIS_3X () {(3<<22);}' unless defined(&FDI_LINK_TRAIN_PRE_EMPHASIS_3X);
    eval 'sub FDI_LINK_TRAIN_400MV_0DB_SNB_A () {(0x38<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_0DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_400MV_6DB_SNB_A () {(0x2<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_6DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_600MV_3_5DB_SNB_A () {(0x1<<22);}' unless defined(&FDI_LINK_TRAIN_600MV_3_5DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_800MV_0DB_SNB_A () {(0x<<22);}' unless defined(&FDI_LINK_TRAIN_800MV_0DB_SNB_A);
    eval 'sub FDI_LINK_TRAIN_400MV_0DB_SNB_B () {(0x<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_0DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_400MV_6DB_SNB_B () {(0x3a<<22);}' unless defined(&FDI_LINK_TRAIN_400MV_6DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_600MV_3_5DB_SNB_B () {(0x39<<22);}' unless defined(&FDI_LINK_TRAIN_600MV_3_5DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_800MV_0DB_SNB_B () {(0x38<<22);}' unless defined(&FDI_LINK_TRAIN_800MV_0DB_SNB_B);
    eval 'sub FDI_LINK_TRAIN_VOL_EMP_MASK () {(0x3f<<22);}' unless defined(&FDI_LINK_TRAIN_VOL_EMP_MASK);
    eval 'sub FDI_DP_PORT_WIDTH_X1 () {(0<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X1);
    eval 'sub FDI_DP_PORT_WIDTH_X2 () {(1<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X2);
    eval 'sub FDI_DP_PORT_WIDTH_X3 () {(2<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X3);
    eval 'sub FDI_DP_PORT_WIDTH_X4 () {(3<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X4);
    eval 'sub FDI_TX_ENHANCE_FRAME_ENABLE () {(1<<18);}' unless defined(&FDI_TX_ENHANCE_FRAME_ENABLE);
    eval 'sub FDI_TX_PLL_ENABLE () {(1<<14);}' unless defined(&FDI_TX_PLL_ENABLE);
    eval 'sub FDI_LINK_TRAIN_PATTERN_1_IVB () {(0<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_1_IVB);
    eval 'sub FDI_LINK_TRAIN_PATTERN_2_IVB () {(1<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_2_IVB);
    eval 'sub FDI_LINK_TRAIN_PATTERN_IDLE_IVB () {(2<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_IDLE_IVB);
    eval 'sub FDI_LINK_TRAIN_NONE_IVB () {(3<<8);}' unless defined(&FDI_LINK_TRAIN_NONE_IVB);
    eval 'sub FDI_COMPOSITE_SYNC () {(1<<11);}' unless defined(&FDI_COMPOSITE_SYNC);
    eval 'sub FDI_LINK_TRAIN_AUTO () {(1<<10);}' unless defined(&FDI_LINK_TRAIN_AUTO);
    eval 'sub FDI_SCRAMBLING_ENABLE () {(0<<7);}' unless defined(&FDI_SCRAMBLING_ENABLE);
    eval 'sub FDI_SCRAMBLING_DISABLE () {(1<<7);}' unless defined(&FDI_SCRAMBLING_DISABLE);
    eval 'sub _FDI_RXA_CTL () {0xf000c;}' unless defined(&_FDI_RXA_CTL);
    eval 'sub _FDI_RXB_CTL () {0xf100c;}' unless defined(&_FDI_RXB_CTL);
    eval 'sub FDI_RX_CTL {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_CTL,  &_FDI_RXB_CTL));
    }' unless defined(&FDI_RX_CTL);
    eval 'sub FDI_RX_ENABLE () {(1<<31);}' unless defined(&FDI_RX_ENABLE);
    eval 'sub FDI_FS_ERRC_ENABLE () {(1<<27);}' unless defined(&FDI_FS_ERRC_ENABLE);
    eval 'sub FDI_FE_ERRC_ENABLE () {(1<<26);}' unless defined(&FDI_FE_ERRC_ENABLE);
    eval 'sub FDI_DP_PORT_WIDTH_X8 () {(7<<19);}' unless defined(&FDI_DP_PORT_WIDTH_X8);
    eval 'sub FDI_8BPC () {(0<<16);}' unless defined(&FDI_8BPC);
    eval 'sub FDI_10BPC () {(1<<16);}' unless defined(&FDI_10BPC);
    eval 'sub FDI_6BPC () {(2<<16);}' unless defined(&FDI_6BPC);
    eval 'sub FDI_12BPC () {(3<<16);}' unless defined(&FDI_12BPC);
    eval 'sub FDI_LINK_REVERSE_OVERWRITE () {(1<<15);}' unless defined(&FDI_LINK_REVERSE_OVERWRITE);
    eval 'sub FDI_DMI_LINK_REVERSE_MASK () {(1<<14);}' unless defined(&FDI_DMI_LINK_REVERSE_MASK);
    eval 'sub FDI_RX_PLL_ENABLE () {(1<<13);}' unless defined(&FDI_RX_PLL_ENABLE);
    eval 'sub FDI_FS_ERR_CORRECT_ENABLE () {(1<<11);}' unless defined(&FDI_FS_ERR_CORRECT_ENABLE);
    eval 'sub FDI_FE_ERR_CORRECT_ENABLE () {(1<<10);}' unless defined(&FDI_FE_ERR_CORRECT_ENABLE);
    eval 'sub FDI_FS_ERR_REPORT_ENABLE () {(1<<9);}' unless defined(&FDI_FS_ERR_REPORT_ENABLE);
    eval 'sub FDI_FE_ERR_REPORT_ENABLE () {(1<<8);}' unless defined(&FDI_FE_ERR_REPORT_ENABLE);
    eval 'sub FDI_RX_ENHANCE_FRAME_ENABLE () {(1<<6);}' unless defined(&FDI_RX_ENHANCE_FRAME_ENABLE);
    eval 'sub FDI_PCDCLK () {(1<<4);}' unless defined(&FDI_PCDCLK);
    eval 'sub FDI_AUTO_TRAINING () {(1<<10);}' unless defined(&FDI_AUTO_TRAINING);
    eval 'sub FDI_LINK_TRAIN_PATTERN_1_CPT () {(0<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_1_CPT);
    eval 'sub FDI_LINK_TRAIN_PATTERN_2_CPT () {(1<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_2_CPT);
    eval 'sub FDI_LINK_TRAIN_PATTERN_IDLE_CPT () {(2<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_IDLE_CPT);
    eval 'sub FDI_LINK_TRAIN_NORMAL_CPT () {(3<<8);}' unless defined(&FDI_LINK_TRAIN_NORMAL_CPT);
    eval 'sub FDI_LINK_TRAIN_PATTERN_MASK_CPT () {(3<<8);}' unless defined(&FDI_LINK_TRAIN_PATTERN_MASK_CPT);
    eval 'sub _FDI_RXA_MISC () {0xf0010;}' unless defined(&_FDI_RXA_MISC);
    eval 'sub _FDI_RXB_MISC () {0xf1010;}' unless defined(&_FDI_RXB_MISC);
    eval 'sub _FDI_RXA_TUSIZE1 () {0xf0030;}' unless defined(&_FDI_RXA_TUSIZE1);
    eval 'sub _FDI_RXA_TUSIZE2 () {0xf0038;}' unless defined(&_FDI_RXA_TUSIZE2);
    eval 'sub _FDI_RXB_TUSIZE1 () {0xf1030;}' unless defined(&_FDI_RXB_TUSIZE1);
    eval 'sub _FDI_RXB_TUSIZE2 () {0xf1038;}' unless defined(&_FDI_RXB_TUSIZE2);
    eval 'sub FDI_RX_MISC {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_MISC,  &_FDI_RXB_MISC));
    }' unless defined(&FDI_RX_MISC);
    eval 'sub FDI_RX_TUSIZE1 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_TUSIZE1,  &_FDI_RXB_TUSIZE1));
    }' unless defined(&FDI_RX_TUSIZE1);
    eval 'sub FDI_RX_TUSIZE2 {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_TUSIZE2,  &_FDI_RXB_TUSIZE2));
    }' unless defined(&FDI_RX_TUSIZE2);
    eval 'sub FDI_RX_INTER_LANE_ALIGN () {(1<<10);}' unless defined(&FDI_RX_INTER_LANE_ALIGN);
    eval 'sub FDI_RX_SYMBOL_LOCK () {(1<<9);}' unless defined(&FDI_RX_SYMBOL_LOCK);
    eval 'sub FDI_RX_BIT_LOCK () {(1<<8);}' unless defined(&FDI_RX_BIT_LOCK);
    eval 'sub FDI_RX_TRAIN_PATTERN_2_FAIL () {(1<<7);}' unless defined(&FDI_RX_TRAIN_PATTERN_2_FAIL);
    eval 'sub FDI_RX_FS_CODE_ERR () {(1<<6);}' unless defined(&FDI_RX_FS_CODE_ERR);
    eval 'sub FDI_RX_FE_CODE_ERR () {(1<<5);}' unless defined(&FDI_RX_FE_CODE_ERR);
    eval 'sub FDI_RX_SYMBOL_ERR_RATE_ABOVE () {(1<<4);}' unless defined(&FDI_RX_SYMBOL_ERR_RATE_ABOVE);
    eval 'sub FDI_RX_HDCP_LINK_FAIL () {(1<<3);}' unless defined(&FDI_RX_HDCP_LINK_FAIL);
    eval 'sub FDI_RX_PIXEL_FIFO_OVERFLOW () {(1<<2);}' unless defined(&FDI_RX_PIXEL_FIFO_OVERFLOW);
    eval 'sub FDI_RX_CROSS_CLOCK_OVERFLOW () {(1<<1);}' unless defined(&FDI_RX_CROSS_CLOCK_OVERFLOW);
    eval 'sub FDI_RX_SYMBOL_QUEUE_OVERFLOW () {(1<<0);}' unless defined(&FDI_RX_SYMBOL_QUEUE_OVERFLOW);
    eval 'sub _FDI_RXA_IIR () {0xf0014;}' unless defined(&_FDI_RXA_IIR);
    eval 'sub _FDI_RXA_IMR () {0xf0018;}' unless defined(&_FDI_RXA_IMR);
    eval 'sub _FDI_RXB_IIR () {0xf1014;}' unless defined(&_FDI_RXB_IIR);
    eval 'sub _FDI_RXB_IMR () {0xf1018;}' unless defined(&_FDI_RXB_IMR);
    eval 'sub FDI_RX_IIR {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_IIR,  &_FDI_RXB_IIR));
    }' unless defined(&FDI_RX_IIR);
    eval 'sub FDI_RX_IMR {
        my($pipe) = @_;
	    eval q( &_PIPE($pipe,  &_FDI_RXA_IMR,  &_FDI_RXB_IMR));
    }' unless defined(&FDI_RX_IMR);
    eval 'sub FDI_PLL_CTL_1 () {0xfe000;}' unless defined(&FDI_PLL_CTL_1);
    eval 'sub FDI_PLL_CTL_2 () {0xfe004;}' unless defined(&FDI_PLL_CTL_2);
    eval 'sub PCH_ADPA () {0xe1100;}' unless defined(&PCH_ADPA);
    eval 'sub ADPA_TRANS_SELECT_MASK () {(1<<30);}' unless defined(&ADPA_TRANS_SELECT_MASK);
    eval 'sub ADPA_TRANS_A_SELECT () {0;}' unless defined(&ADPA_TRANS_A_SELECT);
    eval 'sub ADPA_TRANS_B_SELECT () {(1<<30);}' unless defined(&ADPA_TRANS_B_SELECT);
    eval 'sub ADPA_CRT_HOTPLUG_MASK () {0x3ff0000;}' unless defined(&ADPA_CRT_HOTPLUG_MASK);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_NONE () {(0<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_NONE);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_MASK () {(3<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_MASK);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_COLOR () {(3<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_COLOR);
    eval 'sub ADPA_CRT_HOTPLUG_MONITOR_MONO () {(2<<24);}' unless defined(&ADPA_CRT_HOTPLUG_MONITOR_MONO);
    eval 'sub ADPA_CRT_HOTPLUG_ENABLE () {(1<<23);}' unless defined(&ADPA_CRT_HOTPLUG_ENABLE);
    eval 'sub ADPA_CRT_HOTPLUG_PERIOD_64 () {(0<<22);}' unless defined(&ADPA_CRT_HOTPLUG_PERIOD_64);
    eval 'sub ADPA_CRT_HOTPLUG_PERIOD_128 () {(1<<22);}' unless defined(&ADPA_CRT_HOTPLUG_PERIOD_128);
    eval 'sub ADPA_CRT_HOTPLUG_WARMUP_5MS () {(0<<21);}' unless defined(&ADPA_CRT_HOTPLUG_WARMUP_5MS);
    eval 'sub ADPA_CRT_HOTPLUG_WARMUP_10MS () {(1<<21);}' unless defined(&ADPA_CRT_HOTPLUG_WARMUP_10MS);
    eval 'sub ADPA_CRT_HOTPLUG_SAMPLE_2S () {(0<<20);}' unless defined(&ADPA_CRT_HOTPLUG_SAMPLE_2S);
    eval 'sub ADPA_CRT_HOTPLUG_SAMPLE_4S () {(1<<20);}' unless defined(&ADPA_CRT_HOTPLUG_SAMPLE_4S);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_40 () {(0<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_40);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_50 () {(1<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_50);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_60 () {(2<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_60);
    eval 'sub ADPA_CRT_HOTPLUG_VOLTAGE_70 () {(3<<18);}' unless defined(&ADPA_CRT_HOTPLUG_VOLTAGE_70);
    eval 'sub ADPA_CRT_HOTPLUG_VOLREF_325MV () {(0<<17);}' unless defined(&ADPA_CRT_HOTPLUG_VOLREF_325MV);
    eval 'sub ADPA_CRT_HOTPLUG_VOLREF_475MV () {(1<<17);}' unless defined(&ADPA_CRT_HOTPLUG_VOLREF_475MV);
    eval 'sub ADPA_CRT_HOTPLUG_FORCE_TRIGGER () {(1<<16);}' unless defined(&ADPA_CRT_HOTPLUG_FORCE_TRIGGER);
    eval 'sub HDMIB () {0xe1140;}' unless defined(&HDMIB);
    eval 'sub PORT_ENABLE () {(1<< 31);}' unless defined(&PORT_ENABLE);
    eval 'sub TRANSCODER {
        my($pipe) = @_;
	    eval q((($pipe) << 30));
    }' unless defined(&TRANSCODER);
    eval 'sub TRANSCODER_CPT {
        my($pipe) = @_;
	    eval q((($pipe) << 29));
    }' unless defined(&TRANSCODER_CPT);
    eval 'sub TRANSCODER_MASK () {(1<< 30);}' unless defined(&TRANSCODER_MASK);
    eval 'sub TRANSCODER_MASK_CPT () {(3<< 29);}' unless defined(&TRANSCODER_MASK_CPT);
    eval 'sub COLOR_FORMAT_8bpc () {(0);}' unless defined(&COLOR_FORMAT_8bpc);
    eval 'sub COLOR_FORMAT_12bpc () {(3<< 26);}' unless defined(&COLOR_FORMAT_12bpc);
    eval 'sub SDVOB_HOTPLUG_ENABLE () {(1<< 23);}' unless defined(&SDVOB_HOTPLUG_ENABLE);
    eval 'sub SDVO_ENCODING () {(0);}' unless defined(&SDVO_ENCODING);
    eval 'sub TMDS_ENCODING () {(2<< 10);}' unless defined(&TMDS_ENCODING);
    eval 'sub NULL_PACKET_VSYNC_ENABLE () {(1<< 9);}' unless defined(&NULL_PACKET_VSYNC_ENABLE);
    eval 'sub HDMI_MODE_SELECT () {(1<< 9);}' unless defined(&HDMI_MODE_SELECT);
    eval 'sub DVI_MODE_SELECT () {(0);}' unless defined(&DVI_MODE_SELECT);
    eval 'sub SDVOB_BORDER_ENABLE () {(1<< 7);}' unless defined(&SDVOB_BORDER_ENABLE);
    eval 'sub AUDIO_ENABLE () {(1<< 6);}' unless defined(&AUDIO_ENABLE);
    eval 'sub VSYNC_ACTIVE_HIGH () {(1<< 4);}' unless defined(&VSYNC_ACTIVE_HIGH);
    eval 'sub HSYNC_ACTIVE_HIGH () {(1<< 3);}' unless defined(&HSYNC_ACTIVE_HIGH);
    eval 'sub PORT_DETECTED () {(1<< 2);}' unless defined(&PORT_DETECTED);
    eval 'sub PCH_SDVOB () { &HDMIB;}' unless defined(&PCH_SDVOB);
    eval 'sub HDMIC () {0xe1150;}' unless defined(&HDMIC);
    eval 'sub HDMID () {0xe1160;}' unless defined(&HDMID);
    eval 'sub PCH_LVDS () {0xe1180;}' unless defined(&PCH_LVDS);
    eval 'sub LVDS_DETECTED () {(1<< 1);}' unless defined(&LVDS_DETECTED);
    eval 'sub BLC_PWM_CPU_CTL2 () {0x48250;}' unless defined(&BLC_PWM_CPU_CTL2);
    eval 'sub PWM_ENABLE () {(1<< 31);}' unless defined(&PWM_ENABLE);
    eval 'sub PWM_PIPE_A () {(0<< 29);}' unless defined(&PWM_PIPE_A);
    eval 'sub PWM_PIPE_B () {(1<< 29);}' unless defined(&PWM_PIPE_B);
    eval 'sub BLC_PWM_CPU_CTL () {0x48254;}' unless defined(&BLC_PWM_CPU_CTL);
    eval 'sub BLC_PWM_PCH_CTL1 () {0xc8250;}' unless defined(&BLC_PWM_PCH_CTL1);
    eval 'sub PWM_PCH_ENABLE () {(1<< 31);}' unless defined(&PWM_PCH_ENABLE);
    eval 'sub PWM_POLARITY_ACTIVE_LOW () {(1<< 29);}' unless defined(&PWM_POLARITY_ACTIVE_LOW);
    eval 'sub PWM_POLARITY_ACTIVE_HIGH () {(0<< 29);}' unless defined(&PWM_POLARITY_ACTIVE_HIGH);
    eval 'sub PWM_POLARITY_ACTIVE_LOW2 () {(1<< 28);}' unless defined(&PWM_POLARITY_ACTIVE_LOW2);
    eval 'sub PWM_POLARITY_ACTIVE_HIGH2 () {(0<< 28);}' unless defined(&PWM_POLARITY_ACTIVE_HIGH2);
    eval 'sub BLC_PWM_PCH_CTL2 () {0xc8254;}' unless defined(&BLC_PWM_PCH_CTL2);
    eval 'sub PCH_PP_STATUS () {0xc7200;}' unless defined(&PCH_PP_STATUS);
    eval 'sub PCH_PP_CONTROL () {0xc7204;}' unless defined(&PCH_PP_CONTROL);
    eval 'sub PANEL_UNLOCK_REGS () {(0xabcd << 16);}' unless defined(&PANEL_UNLOCK_REGS);
    eval 'sub PANEL_UNLOCK_MASK () {(0xffff << 16);}' unless defined(&PANEL_UNLOCK_MASK);
    eval 'sub EDP_FORCE_VDD () {(1<< 3);}' unless defined(&EDP_FORCE_VDD);
    eval 'sub EDP_BLC_ENABLE () {(1<< 2);}' unless defined(&EDP_BLC_ENABLE);
    eval 'sub PANEL_POWER_RESET () {(1<< 1);}' unless defined(&PANEL_POWER_RESET);
    eval 'sub PANEL_POWER_OFF () {(0<< 0);}' unless defined(&PANEL_POWER_OFF);
    eval 'sub PANEL_POWER_ON () {(1<< 0);}' unless defined(&PANEL_POWER_ON);
    eval 'sub PCH_PP_ON_DELAYS () {0xc7208;}' unless defined(&PCH_PP_ON_DELAYS);
    eval 'sub PANEL_PORT_SELECT_MASK () {(3<< 30);}' unless defined(&PANEL_PORT_SELECT_MASK);
    eval 'sub PANEL_PORT_SELECT_LVDS () {(0<< 30);}' unless defined(&PANEL_PORT_SELECT_LVDS);
    eval 'sub PANEL_PORT_SELECT_DPA () {(1<< 30);}' unless defined(&PANEL_PORT_SELECT_DPA);
    eval 'sub EDP_PANEL () {(1<< 30);}' unless defined(&EDP_PANEL);
    eval 'sub PANEL_PORT_SELECT_DPC () {(2<< 30);}' unless defined(&PANEL_PORT_SELECT_DPC);
    eval 'sub PANEL_PORT_SELECT_DPD () {(3<< 30);}' unless defined(&PANEL_PORT_SELECT_DPD);
    eval 'sub PANEL_POWER_UP_DELAY_MASK () {(0x1fff0000);}' unless defined(&PANEL_POWER_UP_DELAY_MASK);
    eval 'sub PANEL_POWER_UP_DELAY_SHIFT () {16;}' unless defined(&PANEL_POWER_UP_DELAY_SHIFT);
    eval 'sub PANEL_LIGHT_ON_DELAY_MASK () {(0x1fff);}' unless defined(&PANEL_LIGHT_ON_DELAY_MASK);
    eval 'sub PANEL_LIGHT_ON_DELAY_SHIFT () {0;}' unless defined(&PANEL_LIGHT_ON_DELAY_SHIFT);
    eval 'sub PCH_PP_OFF_DELAYS () {0xc720c;}' unless defined(&PCH_PP_OFF_DELAYS);
    eval 'sub PANEL_POWER_DOWN_DELAY_MASK () {(0x1fff0000);}' unless defined(&PANEL_POWER_DOWN_DELAY_MASK);
    eval 'sub PANEL_POWER_DOWN_DELAY_SHIFT () {16;}' unless defined(&PANEL_POWER_DOWN_DELAY_SHIFT);
    eval 'sub PANEL_LIGHT_OFF_DELAY_MASK () {(0x1fff);}' unless defined(&PANEL_LIGHT_OFF_DELAY_MASK);
    eval 'sub PANEL_LIGHT_OFF_DELAY_SHIFT () {0;}' unless defined(&PANEL_LIGHT_OFF_DELAY_SHIFT);
    eval 'sub PCH_PP_DIVISOR () {0xc7210;}' unless defined(&PCH_PP_DIVISOR);
    eval 'sub PP_REFERENCE_DIVIDER_MASK () {(0xffffff00);}' unless defined(&PP_REFERENCE_DIVIDER_MASK);
    eval 'sub PP_REFERENCE_DIVIDER_SHIFT () {8;}' unless defined(&PP_REFERENCE_DIVIDER_SHIFT);
    eval 'sub PANEL_POWER_CYCLE_DELAY_MASK () {(0x1f);}' unless defined(&PANEL_POWER_CYCLE_DELAY_MASK);
    eval 'sub PANEL_POWER_CYCLE_DELAY_SHIFT () {0;}' unless defined(&PANEL_POWER_CYCLE_DELAY_SHIFT);
    eval 'sub PCH_DP_B () {0xe4100;}' unless defined(&PCH_DP_B);
    eval 'sub PCH_DPB_AUX_CH_CTL () {0xe4110;}' unless defined(&PCH_DPB_AUX_CH_CTL);
    eval 'sub PCH_DPB_AUX_CH_DATA1 () {0xe4114;}' unless defined(&PCH_DPB_AUX_CH_DATA1);
    eval 'sub PCH_DPB_AUX_CH_DATA2 () {0xe4118;}' unless defined(&PCH_DPB_AUX_CH_DATA2);
    eval 'sub PCH_DPB_AUX_CH_DATA3 () {0xe411c;}' unless defined(&PCH_DPB_AUX_CH_DATA3);
    eval 'sub PCH_DPB_AUX_CH_DATA4 () {0xe4120;}' unless defined(&PCH_DPB_AUX_CH_DATA4);
    eval 'sub PCH_DPB_AUX_CH_DATA5 () {0xe4124;}' unless defined(&PCH_DPB_AUX_CH_DATA5);
    eval 'sub PCH_DP_C () {0xe4200;}' unless defined(&PCH_DP_C);
    eval 'sub PCH_DPC_AUX_CH_CTL () {0xe4210;}' unless defined(&PCH_DPC_AUX_CH_CTL);
    eval 'sub PCH_DPC_AUX_CH_DATA1 () {0xe4214;}' unless defined(&PCH_DPC_AUX_CH_DATA1);
    eval 'sub PCH_DPC_AUX_CH_DATA2 () {0xe4218;}' unless defined(&PCH_DPC_AUX_CH_DATA2);
    eval 'sub PCH_DPC_AUX_CH_DATA3 () {0xe421c;}' unless defined(&PCH_DPC_AUX_CH_DATA3);
    eval 'sub PCH_DPC_AUX_CH_DATA4 () {0xe4220;}' unless defined(&PCH_DPC_AUX_CH_DATA4);
    eval 'sub PCH_DPC_AUX_CH_DATA5 () {0xe4224;}' unless defined(&PCH_DPC_AUX_CH_DATA5);
    eval 'sub PCH_DP_D () {0xe4300;}' unless defined(&PCH_DP_D);
    eval 'sub PCH_DPD_AUX_CH_CTL () {0xe4310;}' unless defined(&PCH_DPD_AUX_CH_CTL);
    eval 'sub PCH_DPD_AUX_CH_DATA1 () {0xe4314;}' unless defined(&PCH_DPD_AUX_CH_DATA1);
    eval 'sub PCH_DPD_AUX_CH_DATA2 () {0xe4318;}' unless defined(&PCH_DPD_AUX_CH_DATA2);
    eval 'sub PCH_DPD_AUX_CH_DATA3 () {0xe431c;}' unless defined(&PCH_DPD_AUX_CH_DATA3);
    eval 'sub PCH_DPD_AUX_CH_DATA4 () {0xe4320;}' unless defined(&PCH_DPD_AUX_CH_DATA4);
    eval 'sub PCH_DPD_AUX_CH_DATA5 () {0xe4324;}' unless defined(&PCH_DPD_AUX_CH_DATA5);
    eval 'sub PORT_TRANS_A_SEL_CPT () {0;}' unless defined(&PORT_TRANS_A_SEL_CPT);
    eval 'sub PORT_TRANS_B_SEL_CPT () {(1<<29);}' unless defined(&PORT_TRANS_B_SEL_CPT);
    eval 'sub PORT_TRANS_C_SEL_CPT () {(2<<29);}' unless defined(&PORT_TRANS_C_SEL_CPT);
    eval 'sub PORT_TRANS_SEL_MASK () {(3<<29);}' unless defined(&PORT_TRANS_SEL_MASK);
    eval 'sub PORT_TRANS_SEL_CPT {
        my($pipe) = @_;
	    eval q((($pipe) << 29));
    }' unless defined(&PORT_TRANS_SEL_CPT);
    eval 'sub TRANS_DP_CTL_A () {0xe0300;}' unless defined(&TRANS_DP_CTL_A);
    eval 'sub TRANS_DP_CTL_B () {0xe1300;}' unless defined(&TRANS_DP_CTL_B);
    eval 'sub TRANS_DP_CTL_C () {0xe2300;}' unless defined(&TRANS_DP_CTL_C);
    eval 'sub TRANS_DP_CTL {
        my($pipe) = @_;
	    eval q(( &TRANS_DP_CTL_A + ($pipe) * 0x1000));
    }' unless defined(&TRANS_DP_CTL);
    eval 'sub TRANS_DP_OUTPUT_ENABLE () {(1<<31);}' unless defined(&TRANS_DP_OUTPUT_ENABLE);
    eval 'sub TRANS_DP_PORT_SEL_B () {(0<<29);}' unless defined(&TRANS_DP_PORT_SEL_B);
    eval 'sub TRANS_DP_PORT_SEL_C () {(1<<29);}' unless defined(&TRANS_DP_PORT_SEL_C);
    eval 'sub TRANS_DP_PORT_SEL_D () {(2<<29);}' unless defined(&TRANS_DP_PORT_SEL_D);
    eval 'sub TRANS_DP_PORT_SEL_NONE () {(3<<29);}' unless defined(&TRANS_DP_PORT_SEL_NONE);
    eval 'sub TRANS_DP_PORT_SEL_MASK () {(3<<29);}' unless defined(&TRANS_DP_PORT_SEL_MASK);
    eval 'sub TRANS_DP_AUDIO_ONLY () {(1<<26);}' unless defined(&TRANS_DP_AUDIO_ONLY);
    eval 'sub TRANS_DP_ENH_FRAMING () {(1<<18);}' unless defined(&TRANS_DP_ENH_FRAMING);
    eval 'sub TRANS_DP_8BPC () {(0<<9);}' unless defined(&TRANS_DP_8BPC);
    eval 'sub TRANS_DP_10BPC () {(1<<9);}' unless defined(&TRANS_DP_10BPC);
    eval 'sub TRANS_DP_6BPC () {(2<<9);}' unless defined(&TRANS_DP_6BPC);
    eval 'sub TRANS_DP_12BPC () {(3<<9);}' unless defined(&TRANS_DP_12BPC);
    eval 'sub TRANS_DP_BPC_MASK () {(3<<9);}' unless defined(&TRANS_DP_BPC_MASK);
    eval 'sub TRANS_DP_VSYNC_ACTIVE_HIGH () {(1<<4);}' unless defined(&TRANS_DP_VSYNC_ACTIVE_HIGH);
    eval 'sub TRANS_DP_VSYNC_ACTIVE_LOW () {0;}' unless defined(&TRANS_DP_VSYNC_ACTIVE_LOW);
    eval 'sub TRANS_DP_HSYNC_ACTIVE_HIGH () {(1<<3);}' unless defined(&TRANS_DP_HSYNC_ACTIVE_HIGH);
    eval 'sub TRANS_DP_HSYNC_ACTIVE_LOW () {0;}' unless defined(&TRANS_DP_HSYNC_ACTIVE_LOW);
    eval 'sub TRANS_DP_SYNC_MASK () {(3<<3);}' unless defined(&TRANS_DP_SYNC_MASK);
    eval 'sub EDP_LINK_TRAIN_400MV_0DB_SNB_A () {(0x38<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_0DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_400MV_6DB_SNB_A () {(0x2<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_6DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_600MV_3_5DB_SNB_A () {(0x1<<22);}' unless defined(&EDP_LINK_TRAIN_600MV_3_5DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_800MV_0DB_SNB_A () {(0x<<22);}' unless defined(&EDP_LINK_TRAIN_800MV_0DB_SNB_A);
    eval 'sub EDP_LINK_TRAIN_400_600MV_0DB_SNB_B () {(0x<<22);}' unless defined(&EDP_LINK_TRAIN_400_600MV_0DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_400MV_3_5DB_SNB_B () {(0x1<<22);}' unless defined(&EDP_LINK_TRAIN_400MV_3_5DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_400_600MV_6DB_SNB_B () {(0x3a<<22);}' unless defined(&EDP_LINK_TRAIN_400_600MV_6DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_600_800MV_3_5DB_SNB_B () {(0x39<<22);}' unless defined(&EDP_LINK_TRAIN_600_800MV_3_5DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_800_1200MV_0DB_SNB_B () {(0x38<<22);}' unless defined(&EDP_LINK_TRAIN_800_1200MV_0DB_SNB_B);
    eval 'sub EDP_LINK_TRAIN_VOL_EMP_MASK_SNB () {(0x3f<<22);}' unless defined(&EDP_LINK_TRAIN_VOL_EMP_MASK_SNB);
    eval 'sub EDP_LINK_TRAIN_400MV_0DB_IVB () {(0x24 <<22);}' unless defined(&EDP_LINK_TRAIN_400MV_0DB_IVB);
    eval 'sub EDP_LINK_TRAIN_400MV_3_5DB_IVB () {(0x2a <<22);}' unless defined(&EDP_LINK_TRAIN_400MV_3_5DB_IVB);
    eval 'sub EDP_LINK_TRAIN_400MV_6DB_IVB () {(0x2f <<22);}' unless defined(&EDP_LINK_TRAIN_400MV_6DB_IVB);
    eval 'sub EDP_LINK_TRAIN_600MV_0DB_IVB () {(0x30 <<22);}' unless defined(&EDP_LINK_TRAIN_600MV_0DB_IVB);
    eval 'sub EDP_LINK_TRAIN_600MV_3_5DB_IVB () {(0x36 <<22);}' unless defined(&EDP_LINK_TRAIN_600MV_3_5DB_IVB);
    eval 'sub EDP_LINK_TRAIN_800MV_0DB_IVB () {(0x38 <<22);}' unless defined(&EDP_LINK_TRAIN_800MV_0DB_IVB);
    eval 'sub EDP_LINK_TRAIN_800MV_3_5DB_IVB () {(0x33 <<22);}' unless defined(&EDP_LINK_TRAIN_800MV_3_5DB_IVB);
    eval 'sub EDP_LINK_TRAIN_500MV_0DB_IVB () {(0x <<22);}' unless defined(&EDP_LINK_TRAIN_500MV_0DB_IVB);
    eval 'sub EDP_LINK_TRAIN_1000MV_0DB_IVB () {(0x20 <<22);}' unless defined(&EDP_LINK_TRAIN_1000MV_0DB_IVB);
    eval 'sub EDP_LINK_TRAIN_500MV_3_5DB_IVB () {(0x2 <<22);}' unless defined(&EDP_LINK_TRAIN_500MV_3_5DB_IVB);
    eval 'sub EDP_LINK_TRAIN_1000MV_3_5DB_IVB () {(0x22 <<22);}' unless defined(&EDP_LINK_TRAIN_1000MV_3_5DB_IVB);
    eval 'sub EDP_LINK_TRAIN_1000MV_6DB_IVB () {(0x23 <<22);}' unless defined(&EDP_LINK_TRAIN_1000MV_6DB_IVB);
    eval 'sub EDP_LINK_TRAIN_VOL_EMP_MASK_IVB () {(0x3f<<22);}' unless defined(&EDP_LINK_TRAIN_VOL_EMP_MASK_IVB);
    eval 'sub FORCEWAKE () {0xa18c;}' unless defined(&FORCEWAKE);
    eval 'sub FORCEWAKE_ACK () {0x130090;}' unless defined(&FORCEWAKE_ACK);
    eval 'sub FORCEWAKE_MT () {0xa188;}' unless defined(&FORCEWAKE_MT);
    eval 'sub FORCEWAKE_MT_ACK () {0x130040;}' unless defined(&FORCEWAKE_MT_ACK);
    eval 'sub ECOBUS () {0xa180;}' unless defined(&ECOBUS);
    eval 'sub FORCEWAKE_MT_ENABLE () {(1<<5);}' unless defined(&FORCEWAKE_MT_ENABLE);
    eval 'sub GTFIFODBG () {0x120000;}' unless defined(&GTFIFODBG);
    eval 'sub GT_FIFO_CPU_ERROR_MASK () {7;}' unless defined(&GT_FIFO_CPU_ERROR_MASK);
    eval 'sub GT_FIFO_OVFERR () {(1<<2);}' unless defined(&GT_FIFO_OVFERR);
    eval 'sub GT_FIFO_IAWRERR () {(1<<1);}' unless defined(&GT_FIFO_IAWRERR);
    eval 'sub GT_FIFO_IARDERR () {(1<<0);}' unless defined(&GT_FIFO_IARDERR);
    eval 'sub GT_FIFO_FREE_ENTRIES () {0x120008;}' unless defined(&GT_FIFO_FREE_ENTRIES);
    eval 'sub GT_FIFO_NUM_RESERVED_ENTRIES () {20;}' unless defined(&GT_FIFO_NUM_RESERVED_ENTRIES);
    eval 'sub GEN6_UCGCTL1 () {0x9400;}' unless defined(&GEN6_UCGCTL1);
    eval 'sub GEN6_BLBUNIT_CLOCK_GATE_DISABLE () {(1<< 5);}' unless defined(&GEN6_BLBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub GEN6_UCGCTL2 () {0x9404;}' unless defined(&GEN6_UCGCTL2);
    eval 'sub GEN6_RCZUNIT_CLOCK_GATE_DISABLE () {(1<< 13);}' unless defined(&GEN6_RCZUNIT_CLOCK_GATE_DISABLE);
    eval 'sub GEN6_RCPBUNIT_CLOCK_GATE_DISABLE () {(1<< 12);}' unless defined(&GEN6_RCPBUNIT_CLOCK_GATE_DISABLE);
    eval 'sub GEN6_RCCUNIT_CLOCK_GATE_DISABLE () {(1<< 11);}' unless defined(&GEN6_RCCUNIT_CLOCK_GATE_DISABLE);
    eval 'sub GEN6_RPNSWREQ () {0xa008;}' unless defined(&GEN6_RPNSWREQ);
    eval 'sub GEN6_TURBO_DISABLE () {(1<<31);}' unless defined(&GEN6_TURBO_DISABLE);
    eval 'sub GEN6_FREQUENCY {
        my($x) = @_;
	    eval q((($x)<<25));
    }' unless defined(&GEN6_FREQUENCY);
    eval 'sub GEN6_OFFSET {
        my($x) = @_;
	    eval q((($x)<<19));
    }' unless defined(&GEN6_OFFSET);
    eval 'sub GEN6_AGGRESSIVE_TURBO () {(0<<15);}' unless defined(&GEN6_AGGRESSIVE_TURBO);
    eval 'sub GEN6_RC_VIDEO_FREQ () {0xa00c;}' unless defined(&GEN6_RC_VIDEO_FREQ);
    eval 'sub GEN6_RC_CONTROL () {0xa090;}' unless defined(&GEN6_RC_CONTROL);
    eval 'sub GEN6_RC_CTL_RC6pp_ENABLE () {(1<<16);}' unless defined(&GEN6_RC_CTL_RC6pp_ENABLE);
    eval 'sub GEN6_RC_CTL_RC6p_ENABLE () {(1<<17);}' unless defined(&GEN6_RC_CTL_RC6p_ENABLE);
    eval 'sub GEN6_RC_CTL_RC6_ENABLE () {(1<<18);}' unless defined(&GEN6_RC_CTL_RC6_ENABLE);
    eval 'sub GEN6_RC_CTL_RC1e_ENABLE () {(1<<20);}' unless defined(&GEN6_RC_CTL_RC1e_ENABLE);
    eval 'sub GEN6_RC_CTL_RC7_ENABLE () {(1<<22);}' unless defined(&GEN6_RC_CTL_RC7_ENABLE);
    eval 'sub GEN6_RC_CTL_EI_MODE {
        my($x) = @_;
	    eval q((($x)<<27));
    }' unless defined(&GEN6_RC_CTL_EI_MODE);
    eval 'sub GEN6_RC_CTL_HW_ENABLE () {(1<<31);}' unless defined(&GEN6_RC_CTL_HW_ENABLE);
    eval 'sub GEN6_RP_DOWN_TIMEOUT () {0xa010;}' unless defined(&GEN6_RP_DOWN_TIMEOUT);
    eval 'sub GEN6_RP_INTERRUPT_LIMITS () {0xa014;}' unless defined(&GEN6_RP_INTERRUPT_LIMITS);
    eval 'sub GEN6_RPSTAT1 () {0xa01c;}' unless defined(&GEN6_RPSTAT1);
    eval 'sub GEN6_CAGF_SHIFT () {8;}' unless defined(&GEN6_CAGF_SHIFT);
    eval 'sub GEN6_CAGF_MASK () {(0x7f <<  &GEN6_CAGF_SHIFT);}' unless defined(&GEN6_CAGF_MASK);
    eval 'sub GEN6_RP_CONTROL () {0xa024;}' unless defined(&GEN6_RP_CONTROL);
    eval 'sub GEN6_RP_MEDIA_TURBO () {(1<<11);}' unless defined(&GEN6_RP_MEDIA_TURBO);
    eval 'sub GEN6_RP_MEDIA_MODE_MASK () {(3<<9);}' unless defined(&GEN6_RP_MEDIA_MODE_MASK);
    eval 'sub GEN6_RP_MEDIA_HW_TURBO_MODE () {(3<<9);}' unless defined(&GEN6_RP_MEDIA_HW_TURBO_MODE);
    eval 'sub GEN6_RP_MEDIA_HW_NORMAL_MODE () {(2<<9);}' unless defined(&GEN6_RP_MEDIA_HW_NORMAL_MODE);
    eval 'sub GEN6_RP_MEDIA_HW_MODE () {(1<<9);}' unless defined(&GEN6_RP_MEDIA_HW_MODE);
    eval 'sub GEN6_RP_MEDIA_SW_MODE () {(0<<9);}' unless defined(&GEN6_RP_MEDIA_SW_MODE);
    eval 'sub GEN6_RP_MEDIA_IS_GFX () {(1<<8);}' unless defined(&GEN6_RP_MEDIA_IS_GFX);
    eval 'sub GEN6_RP_ENABLE () {(1<<7);}' unless defined(&GEN6_RP_ENABLE);
    eval 'sub GEN6_RP_UP_IDLE_MIN () {(0x1<<3);}' unless defined(&GEN6_RP_UP_IDLE_MIN);
    eval 'sub GEN6_RP_UP_BUSY_AVG () {(0x2<<3);}' unless defined(&GEN6_RP_UP_BUSY_AVG);
    eval 'sub GEN6_RP_UP_BUSY_CONT () {(0x4<<3);}' unless defined(&GEN6_RP_UP_BUSY_CONT);
    eval 'sub GEN6_RP_DOWN_IDLE_CONT () {(0x1<<0);}' unless defined(&GEN6_RP_DOWN_IDLE_CONT);
    eval 'sub GEN6_RP_UP_THRESHOLD () {0xa02c;}' unless defined(&GEN6_RP_UP_THRESHOLD);
    eval 'sub GEN6_RP_DOWN_THRESHOLD () {0xa030;}' unless defined(&GEN6_RP_DOWN_THRESHOLD);
    eval 'sub GEN6_RP_CUR_UP_EI () {0xa050;}' unless defined(&GEN6_RP_CUR_UP_EI);
    eval 'sub GEN6_CURICONT_MASK () {0xffffff;}' unless defined(&GEN6_CURICONT_MASK);
    eval 'sub GEN6_RP_CUR_UP () {0xa054;}' unless defined(&GEN6_RP_CUR_UP);
    eval 'sub GEN6_CURBSYTAVG_MASK () {0xffffff;}' unless defined(&GEN6_CURBSYTAVG_MASK);
    eval 'sub GEN6_RP_PREV_UP () {0xa058;}' unless defined(&GEN6_RP_PREV_UP);
    eval 'sub GEN6_RP_CUR_DOWN_EI () {0xa05c;}' unless defined(&GEN6_RP_CUR_DOWN_EI);
    eval 'sub GEN6_CURIAVG_MASK () {0xffffff;}' unless defined(&GEN6_CURIAVG_MASK);
    eval 'sub GEN6_RP_CUR_DOWN () {0xa060;}' unless defined(&GEN6_RP_CUR_DOWN);
    eval 'sub GEN6_RP_PREV_DOWN () {0xa064;}' unless defined(&GEN6_RP_PREV_DOWN);
    eval 'sub GEN6_RP_UP_EI () {0xa068;}' unless defined(&GEN6_RP_UP_EI);
    eval 'sub GEN6_RP_DOWN_EI () {0xa06c;}' unless defined(&GEN6_RP_DOWN_EI);
    eval 'sub GEN6_RP_IDLE_HYSTERSIS () {0xa070;}' unless defined(&GEN6_RP_IDLE_HYSTERSIS);
    eval 'sub GEN6_RC_STATE () {0xa094;}' unless defined(&GEN6_RC_STATE);
    eval 'sub GEN6_RC1_WAKE_RATE_LIMIT () {0xa098;}' unless defined(&GEN6_RC1_WAKE_RATE_LIMIT);
    eval 'sub GEN6_RC6_WAKE_RATE_LIMIT () {0xa09c;}' unless defined(&GEN6_RC6_WAKE_RATE_LIMIT);
    eval 'sub GEN6_RC6pp_WAKE_RATE_LIMIT () {0xa0a0;}' unless defined(&GEN6_RC6pp_WAKE_RATE_LIMIT);
    eval 'sub GEN6_RC_EVALUATION_INTERVAL () {0xa0a8;}' unless defined(&GEN6_RC_EVALUATION_INTERVAL);
    eval 'sub GEN6_RC_IDLE_HYSTERSIS () {0xa0ac;}' unless defined(&GEN6_RC_IDLE_HYSTERSIS);
    eval 'sub GEN6_RC_SLEEP () {0xa0b0;}' unless defined(&GEN6_RC_SLEEP);
    eval 'sub GEN6_RC1e_THRESHOLD () {0xa0b4;}' unless defined(&GEN6_RC1e_THRESHOLD);
    eval 'sub GEN6_RC6_THRESHOLD () {0xa0b8;}' unless defined(&GEN6_RC6_THRESHOLD);
    eval 'sub GEN6_RC6p_THRESHOLD () {0xa0bc;}' unless defined(&GEN6_RC6p_THRESHOLD);
    eval 'sub GEN6_RC6pp_THRESHOLD () {0xa0c0;}' unless defined(&GEN6_RC6pp_THRESHOLD);
    eval 'sub GEN6_PMINTRMSK () {0xa168;}' unless defined(&GEN6_PMINTRMSK);
    eval 'sub GEN6_PMISR () {0x44020;}' unless defined(&GEN6_PMISR);
    eval 'sub GEN6_PMIMR () {0x44024;}' unless defined(&GEN6_PMIMR);
    eval 'sub GEN6_PMIIR () {0x44028;}' unless defined(&GEN6_PMIIR);
    eval 'sub GEN6_PMIER () {0x4402c;}' unless defined(&GEN6_PMIER);
    eval 'sub GEN6_PM_MBOX_EVENT () {(1<<25);}' unless defined(&GEN6_PM_MBOX_EVENT);
    eval 'sub GEN6_PM_THERMAL_EVENT () {(1<<24);}' unless defined(&GEN6_PM_THERMAL_EVENT);
    eval 'sub GEN6_PM_RP_DOWN_TIMEOUT () {(1<<6);}' unless defined(&GEN6_PM_RP_DOWN_TIMEOUT);
    eval 'sub GEN6_PM_RP_UP_THRESHOLD () {(1<<5);}' unless defined(&GEN6_PM_RP_UP_THRESHOLD);
    eval 'sub GEN6_PM_RP_DOWN_THRESHOLD () {(1<<4);}' unless defined(&GEN6_PM_RP_DOWN_THRESHOLD);
    eval 'sub GEN6_PM_RP_UP_EI_EXPIRED () {(1<<2);}' unless defined(&GEN6_PM_RP_UP_EI_EXPIRED);
    eval 'sub GEN6_PM_RP_DOWN_EI_EXPIRED () {(1<<1);}' unless defined(&GEN6_PM_RP_DOWN_EI_EXPIRED);
    eval 'sub GEN6_PM_DEFERRED_EVENTS () {( &GEN6_PM_RP_UP_THRESHOLD |  &GEN6_PM_RP_DOWN_THRESHOLD |  &GEN6_PM_RP_DOWN_TIMEOUT);}' unless defined(&GEN6_PM_DEFERRED_EVENTS);
    eval 'sub GEN6_PCODE_MAILBOX () {0x138124;}' unless defined(&GEN6_PCODE_MAILBOX);
    eval 'sub GEN6_PCODE_READY () {(1<<31);}' unless defined(&GEN6_PCODE_READY);
    eval 'sub GEN6_READ_OC_PARAMS () {0xc;}' unless defined(&GEN6_READ_OC_PARAMS);
    eval 'sub GEN6_PCODE_WRITE_MIN_FREQ_TABLE () {0x8;}' unless defined(&GEN6_PCODE_WRITE_MIN_FREQ_TABLE);
    eval 'sub GEN6_PCODE_READ_MIN_FREQ_TABLE () {0x9;}' unless defined(&GEN6_PCODE_READ_MIN_FREQ_TABLE);
    eval 'sub GEN6_PCODE_DATA () {0x138128;}' unless defined(&GEN6_PCODE_DATA);
    eval 'sub GEN6_PCODE_FREQ_IA_RATIO_SHIFT () {8;}' unless defined(&GEN6_PCODE_FREQ_IA_RATIO_SHIFT);
    eval 'sub GEN6_GT_CORE_STATUS () {0x138060;}' unless defined(&GEN6_GT_CORE_STATUS);
    eval 'sub GEN6_CORE_CPD_STATE_MASK () {(7<<4);}' unless defined(&GEN6_CORE_CPD_STATE_MASK);
    eval 'sub GEN6_RCn_MASK () {7;}' unless defined(&GEN6_RCn_MASK);
    eval 'sub GEN6_RC0 () {0;}' unless defined(&GEN6_RC0);
    eval 'sub GEN6_RC3 () {2;}' unless defined(&GEN6_RC3);
    eval 'sub GEN6_RC6 () {3;}' unless defined(&GEN6_RC6);
    eval 'sub GEN6_RC7 () {4;}' unless defined(&GEN6_RC7);
    eval 'sub G4X_AUD_VID_DID () {0x62020;}' unless defined(&G4X_AUD_VID_DID);
    eval 'sub INTEL_AUDIO_DEVCL () {0x808629fb;}' unless defined(&INTEL_AUDIO_DEVCL);
    eval 'sub INTEL_AUDIO_DEVBLC () {0x80862801;}' unless defined(&INTEL_AUDIO_DEVBLC);
    eval 'sub INTEL_AUDIO_DEVCTG () {0x80862802;}' unless defined(&INTEL_AUDIO_DEVCTG);
    eval 'sub G4X_AUD_CNTL_ST () {0x620b4;}' unless defined(&G4X_AUD_CNTL_ST);
    eval 'sub G4X_ELDV_DEVCL_DEVBLC () {(1<< 13);}' unless defined(&G4X_ELDV_DEVCL_DEVBLC);
    eval 'sub G4X_ELDV_DEVCTG () {(1<< 14);}' unless defined(&G4X_ELDV_DEVCTG);
    eval 'sub G4X_ELD_ADDR () {(0xf << 5);}' unless defined(&G4X_ELD_ADDR);
    eval 'sub G4X_ELD_ACK () {(1<< 4);}' unless defined(&G4X_ELD_ACK);
    eval 'sub G4X_HDMIW_HDMIEDID () {0x6210c;}' unless defined(&G4X_HDMIW_HDMIEDID);
    eval 'sub IBX_HDMIW_HDMIEDID_A () {0xe2050;}' unless defined(&IBX_HDMIW_HDMIEDID_A);
    eval 'sub IBX_AUD_CNTL_ST_A () {0xe20b4;}' unless defined(&IBX_AUD_CNTL_ST_A);
    eval 'sub IBX_ELD_BUFFER_SIZE () {(0x1f << 10);}' unless defined(&IBX_ELD_BUFFER_SIZE);
    eval 'sub IBX_ELD_ADDRESS () {(0x1f << 5);}' unless defined(&IBX_ELD_ADDRESS);
    eval 'sub IBX_ELD_ACK () {(1<< 4);}' unless defined(&IBX_ELD_ACK);
    eval 'sub IBX_AUD_CNTL_ST2 () {0xe20c0;}' unless defined(&IBX_AUD_CNTL_ST2);
    eval 'sub IBX_ELD_VALIDB () {(1<< 0);}' unless defined(&IBX_ELD_VALIDB);
    eval 'sub IBX_CP_READYB () {(1<< 1);}' unless defined(&IBX_CP_READYB);
    eval 'sub CPT_HDMIW_HDMIEDID_A () {0xe5050;}' unless defined(&CPT_HDMIW_HDMIEDID_A);
    eval 'sub CPT_AUD_CNTL_ST_A () {0xe50b4;}' unless defined(&CPT_AUD_CNTL_ST_A);
    eval 'sub CPT_AUD_CNTRL_ST2 () {0xe50c0;}' unless defined(&CPT_AUD_CNTRL_ST2);
    eval 'sub GEN7_SO_WRITE_OFFSET {
        my($n) = @_;
	    eval q((0x5280 + ($n) * 4));
    }' unless defined(&GEN7_SO_WRITE_OFFSET);
    eval 'sub IBX_AUD_CONFIG_A () {0xe2000;}' unless defined(&IBX_AUD_CONFIG_A);
    eval 'sub CPT_AUD_CONFIG_A () {0xe5000;}' unless defined(&CPT_AUD_CONFIG_A);
    eval 'sub AUD_CONFIG_N_VALUE_INDEX () {(1<< 29);}' unless defined(&AUD_CONFIG_N_VALUE_INDEX);
    eval 'sub AUD_CONFIG_N_PROG_ENABLE () {(1<< 28);}' unless defined(&AUD_CONFIG_N_PROG_ENABLE);
    eval 'sub AUD_CONFIG_UPPER_N_SHIFT () {20;}' unless defined(&AUD_CONFIG_UPPER_N_SHIFT);
    eval 'sub AUD_CONFIG_UPPER_N_VALUE () {(0xff << 20);}' unless defined(&AUD_CONFIG_UPPER_N_VALUE);
    eval 'sub AUD_CONFIG_LOWER_N_SHIFT () {4;}' unless defined(&AUD_CONFIG_LOWER_N_SHIFT);
    eval 'sub AUD_CONFIG_LOWER_N_VALUE () {(0xfff << 4);}' unless defined(&AUD_CONFIG_LOWER_N_VALUE);
    eval 'sub AUD_CONFIG_PIXEL_CLOCK_HDMI_SHIFT () {16;}' unless defined(&AUD_CONFIG_PIXEL_CLOCK_HDMI_SHIFT);
    eval 'sub AUD_CONFIG_PIXEL_CLOCK_HDMI () {(0xf << 16);}' unless defined(&AUD_CONFIG_PIXEL_CLOCK_HDMI);
    eval 'sub AUD_CONFIG_DISABLE_NCTS () {(1<< 3);}' unless defined(&AUD_CONFIG_DISABLE_NCTS);
}
1;
