require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS64_PARAM_H_)) {
    eval 'sub _MIPS64_PARAM_H_ () {1;}' unless defined(&_MIPS64_PARAM_H_);
    if(defined(&_KERNEL)) {
	require 'machine/cpu.ph';
    }
    eval 'sub ALIGNBYTES () {7;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p, $t) = @_;
	    eval q((((($p)) & ($sizeof{$t} - 1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
    eval 'sub KERNBASE () {0xffffffff80000000;}' unless defined(&KERNBASE);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub USPACE () {(16384);}' unless defined(&USPACE);
    if(defined(&_KERNEL)) {
	eval 'sub UPAGES () {( &USPACE >>  &PAGE_SHIFT);}' unless defined(&UPAGES);
	if((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) > 12) {
	    eval 'sub USPACE_ALIGN () {0;}' unless defined(&USPACE_ALIGN);
	} else {
	    eval 'sub USPACE_ALIGN () {(2*  &PAGE_SIZE);}' unless defined(&USPACE_ALIGN);
	}
    }
    eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
    if(defined(&_KERNEL)) {
	if((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) > 12) {
	    eval 'sub MSGBUFSIZE () { &PAGE_SIZE;}' unless defined(&MSGBUFSIZE);
	} else {
	    eval 'sub MSGBUFSIZE () {8192;}' unless defined(&MSGBUFSIZE);
	}
	eval 'sub NKMEMPAGES_MIN_DEFAULT () {((8* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((128* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    }
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	}
    }
}
1;
