<?php
// $Id: node_updated.inc,v 1.1 2009/07/18 22:10:48 merlinofchaos Exp $

/**
 * Callback function to supply a list of content types.
 */
function ctools_node_updated_ctools_content_types() {
  return array(
    'single' => TRUE,
    'title' => t('Node last updated date'),
    'icon' => 'icon_node.png',
    'description' => t('The date the referenced node was last updated.'),
    'required context' => new ctools_context_required(t('Node'), 'node'),
    'category' => t('Node'),
    'defaults' => array(
      'format' => 'small',
    ),
  );
}

/**
 * Render the custom content type.
 */
function ctools_node_updated_content_type_render($subtype, $conf, $panel_args, $context) {
  if (empty($context) || empty($context->data)) {
    return;
  }

  // Get a shortcut to the node.
  $node = $context->data;

  // Build the content type block.
  $block = new stdClass();
  $block->module  = 'node_updated';
  $block->title   = t('Last updated date');
  $block->content = format_date(!empty($node->updated) ? $node->updated : $node->created, $conf['format']);
  $block->delta   = $node->nid;

  return $block;
}

/**
 * Returns an edit form for custom type settings.
 */
function ctools_node_updated_content_type_edit_form(&$form, &$form_state) {
  $conf = $form_state['conf'];

  $time = time();
  $form['format'] = array(
    '#title' => t('Date format'),
    '#type' => 'select',
    '#options' => array(
      'small' => format_date($time, 'small'),
      'medium' => format_date($time, 'medium'),
      'large' => format_date($time, 'large'),
    ),
    '#default_value' => $conf['format'],
  );
}

/**
 * Submit handler for the custom type settings form.
 */
function ctools_node_updated_content_type_edit_form_submit(&$form, &$form_state) {
  // Copy everything from our defaults.
  foreach (array_keys($form_state['plugin']['defaults']) as $key) {
    $form_state['conf'][$key] = $form_state['values'][$key];
  }
}

/**
 * Returns the administrative title for a type.
 */
function ctools_node_updated_content_type_admin_title($subtype, $conf, $context) {
  return t('"@s" last updated date', array('@s' => $context->identifier));
}
