/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.wizards.files.PythonAbstractPathPage;

public abstract class AbstractPythonWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected String description;
    protected PythonAbstractPathPage filePage;

    protected abstract PythonAbstractPathPage createPathPage();

    protected abstract IFile doCreateNew(IProgressMonitor var1) throws CoreException;

    public AbstractPythonWizard(String description) {
        this.description = description;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = PydevPlugin.imageDescriptorFromPlugin((String)PydevPlugin.getPluginID(), (String)"icons/python_logo.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void addPages() {
        this.filePage = this.createPathPage();
        this.filePage.setDescription(this.description);
        this.addPage((IWizardPage)this.filePage);
    }

    public boolean performFinish() {
        IFile file;
        block6: {
            try {
                file = this.doCreateNew((IProgressMonitor)new NullProgressMonitor());
                if (file != null) break block6;
                return true;
            }
            catch (Exception e) {
                PydevPlugin.log(e);
                return false;
            }
        }
        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                this.afterEditorCreated(openEditor);
            }
        }
        catch (PartInitException e) {
            PydevPlugin.log(e);
            return false;
        }
        return true;
    }

    protected void afterEditorCreated(IEditorPart openEditor) {
    }
}

