/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.codegenerator.generateproperties.GeneratePropertiesChangeProcessor;
import org.python.pydev.refactoring.codegenerator.generateproperties.GeneratePropertiesRequestProcessor;
import org.python.pydev.refactoring.core.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.model.generateproperties.PropertyTreeProvider;
import org.python.pydev.refactoring.ui.pages.GeneratePropertiesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePropertiesRefactoring
extends AbstractPythonRefactoring {
    private GeneratePropertiesRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;

    public GeneratePropertiesRefactoring(RefactoringInfo req) {
        super(req);
        try {
            this.initWizard();
        }
        catch (Throwable throwable) {
            this.status.addInfo(Messages.infoFixCode);
        }
    }

    private void initWizard() throws Throwable {
        PropertyTreeProvider provider = new PropertyTreeProvider(this.info.getClasses());
        this.requestProcessor = new GeneratePropertiesRequestProcessor(this.info.getNewLineDelim());
        this.changeProcessor = new GeneratePropertiesChangeProcessor(this.getName(), this.info, this.requestProcessor);
        this.pages.add(new GeneratePropertiesPage(this.getName(), provider, this.requestProcessor));
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        List<IClassDefAdapter> classes = this.info.getClasses();
        if (classes.size() > 0) {
            for (IClassDefAdapter adapter : classes) {
                if (adapter.getAttributes().size() <= 0) continue;
                return super.checkInitialConditions(pm);
            }
        }
        this.status.addFatalError(Messages.generatePropertiesUnavailable);
        return this.status;
    }

    public String getName() {
        return Messages.generatePropertiesLabel;
    }
}

