'\"
'\" Generated from file '/usr/ports/obj/tklib-0.5/tklib-0.5/modules/diagrams/draw_diagram.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "Diagrams" n 0.2 diagrams "Tk Diagrams"
.BS
.SH NAME
Diagrams \- User documentation of the Diagrams package
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBTk  8.4\fR
.sp
package require \fBDiagrams  0.2\fR
.sp
\fB::Diagrams::drawin\fR \fIcanvas\fR
.sp
\fB::Diagrams::saveps\fR \fIfilename\fR
.sp
\fB::Diagrams::direction\fR \fInewdir\fR
.sp
\fB::Diagrams::currentpos\fR \fIpos\fR
.sp
\fB::Diagrams::getpos\fR \fIanchor\fR \fIobj\fR
.sp
\fB::Diagrams::position\fR \fIxcoord\fR \fIycoord\fR
.sp
\fB::Diagrams::box\fR \fItext\fR \fIwidth\fR \fIheight\fR
.sp
\fB::Diagrams::plaintext\fR \fItext\fR \fIwidth\fR \fIheight\fR
.sp
\fB::Diagrams::circle\fR \fItext\fR \fIradius\fR
.sp
\fB::Diagrams::slanted\fR \fItext\fR \fIwidth\fR \fIheight\fR \fIangle\fR
.sp
\fB::Diagrams::diamond\fR \fItext\fR \fIwidth\fR \fIheight\fR
.sp
\fB::Diagrams::drum\fR \fItext\fR \fIwidth\fR \fIheight\fR
.sp
\fB::Diagrams::arrow\fR \fItext\fR \fIlength\fR \fIheads\fR
.sp
\fB::Diagrams::line\fR \fIargs\fR
.sp
\fB::Diagrams::attach\fR \fIanchor\fR
.sp
\fB::Diagrams::color\fR \fIname\fR
.sp
\fB::Diagrams::fillcolor\fR \fIname\fR
.sp
\fB::Diagrams::textcolor\fR \fIname\fR
.sp
\fB::Diagrams::usegap\fR \fIuse\fR
.sp
\fB::Diagrams::xgap\fR \fIvalue\fR
.sp
\fB::Diagrams::ygap\fR \fIvalue\fR
.sp
\fB::Diagrams::textfont\fR \fIname\fR
.sp
\fB::Diagrams::linewidth\fR \fIpixels\fR
.sp
\fB::Diagrams::linestyle\fR \fIstyle\fR
.sp
\fB::Diagrams::pushstate\fR
.sp
\fB::Diagrams::popstate\fR
.sp
\fB::Diagrams::computepos\fR
.sp
\fB::Diagrams::boxcoords\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
.sp
\fB::Diagrams::moveobject\fR \fIobj\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBDiagrams\fR package is meant to help drawing diagrams, like
flowcharts. The philosophy is that you should be concentrating on the
contents of the diagram, rather than the exact positioning and sizing
of all items within it. The Diagrams package uses a few simple rules
to layout the items:
.IP \(bu
Each item (or object) in the diagram has a number of "anchors" - places
where arrows and lines can be connected to.
.IP \(bu
You can draw an arrow or a line from an object in a preset direction
.IP \(bu
Sizing and positioning should be done as automatic as possible: this is
achieved for instance by drawing boxes and circles with text, rather
than first drawing a rectangle and then drawing the text inside it or
vice versa.
.PP
The commands within this package can be split up in several
categories. Each category is described in a separate section.
.SH "GENERAL COMMANDS FOR POSITIONING AND SETUP"
.TP
\fB::Diagrams::drawin\fR \fIcanvas\fR
Set the canvas widget in which to draw
.RS
.TP
widget \fIcanvas\fR
Widget to draw in
.RE
.sp
.TP
\fB::Diagrams::saveps\fR \fIfilename\fR
Save the drawing in a PostScript file
.RS
.TP
filename \fIstring\fR
Name of the file to save the drawing in
.RE
.sp
.TP
\fB::Diagrams::direction\fR \fInewdir\fR
Set the direction for moving the current position.
The direction is one of:
north  northeast  east southeast  south
southwest west northwest
N      NE         E    SE         S     SW        W    NW
up     up-right   left down-right down  down-left left up-left
centre center     C
.RS
.TP
newdir \fIstring\fR
New direction
.RE
.sp
.TP
\fB::Diagrams::currentpos\fR \fIpos\fR
Set the current position explicitly (argument must be
a position "object")
.RS
.TP
pos \fIlist\fR
New position (retrieve via \fIgetpos\fR for instance)
.RE
.sp
.TP
\fB::Diagrams::getpos\fR \fIanchor\fR \fIobj\fR
Get the position of a particular "anchor" point of an object
anchor should be one of the direction strings
.RS
.TP
anchor \fIstring\fR
Name of the anchor (one of the directions - see
the \fIdirection\fR command
.TP
obj \fIlist\fR
The object in question
.RE
.sp
.TP
\fB::Diagrams::position\fR \fIxcoord\fR \fIycoord\fR
Create a position "object"
.RS
.TP
xcoord \fIfloat\fR
X-coordinate of the position
.TP
ycoord \fIfloat\fR
Y-coordinate of the position
.RE
.PP
.SH "DRAWING OBJECTS"
.TP
\fB::Diagrams::box\fR \fItext\fR \fIwidth\fR \fIheight\fR
Draw a box from the current position
(width and height are both optional; if not given, the text
determines the width and height)
.RS
.TP
string \fItext\fR
Text to be shown inside the box
.TP
float \fIwidth\fR
Width (if any) of the box in pixels
.TP
float \fIheight\fR
Height (if any) of the box in pixels
.RE
.sp
.TP
\fB::Diagrams::plaintext\fR \fItext\fR \fIwidth\fR \fIheight\fR
Draw plain text from the current position
(width and height are both optional; if not given, the text
determines the width and height)
.RS
.TP
string \fItext\fR
Text to be shown
.TP
float \fIwidth\fR
Width (if any) of the (invisible) box in which to
position the text
.TP
float \fIheight\fR
Height (if any) of the box
.RE
.sp
.TP
\fB::Diagrams::circle\fR \fItext\fR \fIradius\fR
Draw a circle from the current position
(the radius is optional)
.RS
.TP
string \fItext\fR
Text to be shown inside the circle
.TP
float \fIradius\fR
Radius (if any) of the circle in pixels
.RE
.sp
.TP
\fB::Diagrams::slanted\fR \fItext\fR \fIwidth\fR \fIheight\fR \fIangle\fR
Draw a slanted box from the current position
(width, height and angle are optional)
.RS
.TP
string \fItext\fR
Text to be shown inside the box
.TP
float \fIwidth\fR
Width (if any) of the box in pixels
.TP
float \fIheight\fR
Height (if any) of the box in pixels
.TP
float \fIangle\fR
Angle of the slanted box
.RE
.sp
.TP
\fB::Diagrams::diamond\fR \fItext\fR \fIwidth\fR \fIheight\fR
Draw a diamond-shaped box from the current position
(width and height are both optional; if not given, the text
determines the width and height)
.RS
.TP
string \fItext\fR
Text to be shown inside the diamond
.TP
float \fIwidth\fR
Width (if any) of the diamond in pixels
.TP
float \fIheight\fR
Height (if any) of the diamond in pixels
.RE
.sp
.TP
\fB::Diagrams::drum\fR \fItext\fR \fIwidth\fR \fIheight\fR
Draw a drumshaped item from th ecurrent position
(width and height are both optional; if not given, the text
determines the width and height)
.RS
.TP
string \fItext\fR
Text to be shown inside the drum
.TP
float \fIwidth\fR
Width (if any) of the drum in pixels
.TP
float \fIheight\fR
Height (if any) of the drum in pixels
.RE
.sp
.TP
\fB::Diagrams::arrow\fR \fItext\fR \fIlength\fR \fIheads\fR
Draw an arrow from the current position to the next.
The text is drawn next to the arrow, the length (in pixels) is
optional. If not given the gap parameters are used.
.RS
.TP
string \fItext\fR
Text to be shown along the arrow
.TP
float \fIlength\fR
Length of the arrow in pixels
.TP
float \fIheads\fR
Which arrow heads to draw (first, last
or both - defaults to last)
.RE
.sp
.TP
\fB::Diagrams::line\fR \fIargs\fR
Draw a line specified via positions or via line segments
The arguments are either position or length-angle pairs
.RS
.TP
list \fIargs\fR
List of positions or of length-angle pairs
.RE
.sp
.PP
.SH ATTRIBUTES
(Note: attributes are persistent)
.TP
\fB::Diagrams::attach\fR \fIanchor\fR
Set the anchor point for attaching arrows to
.RS
.TP
string \fIanchor\fR
Any one of the valid anchor (e.g. N or North)
.RE
.sp
.TP
\fB::Diagrams::color\fR \fIname\fR
Set the color for the outline of a box etc.
.RS
.TP
color \fIname\fR
Name of the colour to be used
.RE
.sp
.TP
\fB::Diagrams::fillcolor\fR \fIname\fR
Set the color to fill the objects
.RS
.TP
color \fIname\fR
Name of the colour to be used
.RE
.sp
.TP
\fB::Diagrams::textcolor\fR \fIname\fR
Set the color to draw the text in
.RS
.TP
color \fIname\fR
Name of the colour to be used
.RE
.sp
.TP
\fB::Diagrams::usegap\fR \fIuse\fR
Turn the gap on (1) or off (0). Note: usually a small gap is used
when positioning objects.
.RS
.TP
boolean \fIuse\fR
Use the gap to compute the position of the next object or not
.RE
.sp
.TP
\fB::Diagrams::xgap\fR \fIvalue\fR
Size of the gap in horizontal direction (in pixels)
.RS
.TP
integer \fIvalue\fR
Gap width in pixels
.RE
.sp
.TP
\fB::Diagrams::ygap\fR \fIvalue\fR
Size of the gap in vertical direction (in pixels)
.RS
.TP
integer \fIvalue\fR
Gap height in pixels
.RE
.sp
.TP
\fB::Diagrams::textfont\fR \fIname\fR
Set the name of the font to use
.RS
.TP
string \fIname\fR
Name of a text font
.RE
.sp
.TP
\fB::Diagrams::linewidth\fR \fIpixels\fR
Set the width of the lines (in line objects and arrows and the outline
of boxes and other objects)
.RS
.TP
integer \fIpixels\fR
Number of pixels the lines are wide
.RE
.sp
.TP
\fB::Diagrams::linestyle\fR \fIstyle\fR
Set the style of the lines and arrows and of the outline of boxes and
other objects. The predefined line styles are: solid, dot, dash,
dash-dot, dash-dot-dot (these are the distinguishable line styles on
Windows). You can also use the style patterns from the canvas directly.
.RS
.TP
string \fIstyle\fR
Name of a valid line style
.RE
.sp
.PP
.SH "COMMANDS FOR IMPLEMENTING NEW OBJECTS"
Note: it is best to study how for instance box objects are implemented
first.
.TP
\fB::Diagrams::pushstate\fR
Save the current global settings
Used when defining an object that is composed of other objects
.TP
\fB::Diagrams::popstate\fR
Restore the previously saved global settings
.TP
\fB::Diagrams::computepos\fR
Compute the current position
.TP
\fB::Diagrams::boxcoords\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR
Compute the anchor coordinates for a box-like object
(this is merely a convenience routine. In general, you will
have to compute the list of coordinates yourself - see
for instance the diamond object)
.RS
.TP
float \fIx1\fR
X coordinate of upper-left corner
.TP
float \fIy1\fR
Y coordinate of upper-left corner
.TP
float \fIx2\fR
X coordinate of lower-right corner
.TP
float \fIy2\fR
Y coordinate of lower-right corner
.RE
.sp
.TP
\fB::Diagrams::moveobject\fR \fIobj\fR
Move the object to the right position and return the new
information
.RS
.TP
list \fIobj\fR
List of data representing the object
.RE
.sp
.PP
.SH KEYWORDS
diagrams, drawing