<?php
// $Id: imagecache.api.php,v 1.2 2009/02/17 21:36:18 drewish Exp $

/**
 * @file
 * Hooks provided by the ImageCache module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Inform ImageCache about actions that can be performed on an image.
 *
 * @return array
 *   An array of information on the actions implemented by a module. The array
 *   contains a sub-array for each action node type, with the machine-readable
 *   action name as the key. Each sub-array has up to 3 attributes. Possible
 *   attributes:
 *     "name": the human-readable name of the action. Required.
 *     "description": a brief description of the action. Required.
 *     "file": the name of the include file the action can be found
 *             in relative to the implementing module's path.
 */
function hook_imagecache_actions() {
  $actions = array(
    'imagecache_resize' => array(
      'name' => 'Resize',
      'description' => 'Resize an image to an exact set of dimensions, ignoring aspect ratio.',
    ),
  );
}

/**
 * Provides default ImageCache presets that can be overridden by site
 * administrators.
 *
 * @return array
 *   An array of imagecache preset definitions. Each definition can be
 *   generated by exporting a preset from the database. Each preset
 *   definition should be keyed on its presetname (for easier interaction
 *   with drupal_alter) and have the following attributes:
 *     "presetname": the imagecache preset name. Required.
 *     "actions": an array of action defintions for this preset. Required.
 */
function hook_imagecache_default_presets() {
  $presets = array();
  $presets['thumbnail'] = array (
    'presetname' => 'thumbnail',
    'actions' => array (
      0 => array (
        'weight' => '0',
        'module' => 'imagecache',
        'action' => 'imagecache_scale_and_crop',
        'data' => array (
          'width' => '60',
          'height' => '60',
        ),
      ),
    ),
  );
  return $presets;
}