/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionException;
import org.python.pydev.refactoring.coderefactoring.extractmethod.ExtractMethodChangeProcessor;
import org.python.pydev.refactoring.coderefactoring.extractmethod.ExtractMethodRequestProcessor;
import org.python.pydev.refactoring.core.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.pages.extractmethod.ExtractMethodPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMethodRefactoring
extends AbstractPythonRefactoring {
    private ExtractMethodRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;
    private ModuleAdapter parsedExtendedSelection = null;
    private ModuleAdapter parsedUserSelection;
    private ModuleAdapter module;

    public ExtractMethodRefactoring(RefactoringInfo req) {
        super(req);
        this.parsedUserSelection = req.getParsedUserSelection();
        this.parsedExtendedSelection = req.getParsedExtendedSelection();
        this.module = req.getModule();
        this.validateSelections();
        try {
            this.initWizard();
        }
        catch (Throwable throwable) {
            this.status.addInfo(Messages.infoFixCode);
        }
    }

    private void initWizard() throws Throwable {
        ITextSelection standardSelection = this.info.getUserSelection();
        ModuleAdapter standardModule = this.parsedUserSelection;
        if (standardModule == null) {
            standardSelection = this.info.getExtendedSelection();
            standardModule = this.parsedExtendedSelection;
        }
        this.requestProcessor = new ExtractMethodRequestProcessor(this.info.getScopeAdapter(), standardModule, this.getModule(), standardSelection);
        this.pages.add(new ExtractMethodPage(this.getName(), this.requestProcessor));
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        this.changeProcessor = new ExtractMethodChangeProcessor(this.getName(), this.info, this.requestProcessor);
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.requestProcessor.getScopeAdapter() == null || this.requestProcessor.getScopeAdapter() instanceof IClassDefAdapter) {
            this.status.addFatalError(Messages.extractMethodScopeInvalid);
            return this.status;
        }
        if (this.status.getEntries().length > 0) {
            return this.status;
        }
        if (this.parsedExtendedSelection == null && this.parsedUserSelection == null) {
            this.status.addFatalError(Messages.extractMethodIncompleteSelection);
            return this.status;
        }
        return this.status;
    }

    private void validateSelections() {
        block7: {
            block6: {
                try {
                    if (this.parsedUserSelection != null) {
                        VisitorFactory.validateSelection(this.parsedUserSelection);
                    }
                }
                catch (SelectionException e) {
                    this.parsedUserSelection = null;
                    if (this.parsedExtendedSelection != null) break block6;
                    this.status.addFatalError(e.getMessage());
                    return;
                }
            }
            try {
                if (this.parsedExtendedSelection != null) {
                    VisitorFactory.validateSelection(this.parsedExtendedSelection);
                }
            }
            catch (SelectionException e) {
                this.parsedExtendedSelection = null;
                if (this.parsedUserSelection != null) break block7;
                this.status.addFatalError(e.getMessage());
                return;
            }
        }
    }

    public void setModule(ModuleAdapter module) {
        this.module = module;
    }

    public ModuleAdapter getModule() {
        return this.module;
    }

    public String getName() {
        return Messages.extractMethodLabel;
    }
}

