/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.BugInstance;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class BugTreeView
extends ViewPart {
    private TabFolder theFolder;
    public static BugTreeView bugTreeView;
    public HashMap<String, Tree> projectTrees;
    private HashMap<String, HashMap<String, TreeItem>> patternMap;
    private HashMap<TreeItem, IMarker> instanceMap;

    public static BugTreeView getBugTreeView() {
        return bugTreeView;
    }

    public static IMarker getMarkerForTreeItem(TreeItem theItem) {
        if (bugTreeView != null && theItem != null) {
            return BugTreeView.bugTreeView.instanceMap.get(theItem);
        }
        return null;
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        IProject[] projectList;
        this.theFolder = new TabFolder(parent, 16384);
        this.projectTrees = new HashMap();
        this.patternMap = new HashMap();
        this.instanceMap = new HashMap();
        bugTreeView = this;
        IProject[] arr$ = projectList = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IProject proj = arr$[i$];
            if (!proj.isAccessible() || !FindbugsPlugin.isJavaProject(proj)) continue;
            try {
                IMarker[] arr$2 = proj.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    IMarker marker = arr$2[i$2];
                    this.addMarker(proj, marker);
                }
                continue;
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Core exception on tree initialization");
            }
        }
    }

    public void dispose() {
        this.projectTrees.clear();
        this.patternMap.clear();
        this.instanceMap.clear();
        this.theFolder.dispose();
        bugTreeView = null;
        super.dispose();
    }

    public void clearTree(final IProject currProject) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Tree treeToRemove = BugTreeView.this.projectTrees.get(currProject.getName());
                if (treeToRemove == null) {
                    return;
                }
                if (treeToRemove.isDisposed()) {
                    return;
                }
                TreeItem[] arr$ = treeToRemove.getItems();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    TreeItem x = arr$[i$];
                    BugTreeView.this.instanceMap.remove(x);
                }
                ((HashMap)BugTreeView.this.patternMap.get(currProject.getName())).clear();
                treeToRemove.removeAll();
            }
        });
    }

    public void addMarker(final IProject theProject, final IMarker theMarker) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    String pattern;
                    HashMap theMap;
                    BugInstance bug = MarkerUtil.findBugInstanceForMarker(theMarker);
                    if (bug == null) {
                        FindbugsPlugin.getDefault().logWarning("Couldn't find bug for " + theMarker);
                        return;
                    }
                    Tree theTree = BugTreeView.this.projectTrees.get(theProject.getName());
                    if (theTree == null || theTree.isDisposed()) {
                        TabItem newTab = new TabItem(BugTreeView.this.theFolder, 16384);
                        theTree = new Tree((Composite)BugTreeView.this.theFolder, 16384);
                        theTree.addSelectionListener((SelectionListener)new BugTreeSelectionListener(theTree));
                        newTab.setControl((Control)theTree);
                        newTab.setText(theProject.getName());
                        BugTreeView.this.projectTrees.put(theProject.getName(), theTree);
                        BugTreeView.this.patternMap.put(theProject.getName(), new HashMap());
                    }
                    if (!(theMap = (HashMap)BugTreeView.this.patternMap.get(theProject.getName())).containsKey(pattern = bug.getBugPattern().getShortDescription())) {
                        int i;
                        for (i = 0; i < theTree.getItemCount() && theTree.getItem(i).getText().compareTo(pattern) <= 0; ++i) {
                        }
                        TreeItem newItem = new TreeItem(theTree, 16384, i);
                        newItem.setText(pattern);
                        theMap.put(pattern, newItem);
                    }
                    TreeItem instanceItem = new TreeItem((TreeItem)theMap.get(pattern), 16384);
                    BugTreeView.this.instanceMap.put(instanceItem, theMarker);
                    instanceItem.setText(theMarker.getAttribute("message", "Error retrieving message"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private class BugTreeSelectionListener
    extends SelectionAdapter {
        private Tree theTree;

        public BugTreeSelectionListener(Tree theTree) {
            this.theTree = theTree;
        }

        public void widgetSelected(SelectionEvent e) {
            IMarker myMarker = (IMarker)BugTreeView.this.instanceMap.get(this.theTree.getSelection()[0]);
            if (myMarker == null) {
                return;
            }
            if (!myMarker.getResource().getProject().isOpen()) {
                System.out.println("Project not open");
                return;
            }
            FindbugsPlugin.showMarker(myMarker, false, false);
            try {
                IDE.openEditor((IWorkbenchPage)BugTreeView.this.getSite().getPage(), (IMarker)myMarker, (boolean)false);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TreeItem theItem = this.theTree.getSelection()[0];
            IMarker myMarker = (IMarker)BugTreeView.this.instanceMap.get(theItem);
            if (myMarker == null) {
                theItem.setExpanded(!theItem.getExpanded());
            } else {
                if (!myMarker.getResource().getProject().isOpen()) {
                    System.out.println("Project not open");
                    return;
                }
                FindbugsPlugin.showMarker(myMarker, false, false);
                try {
                    IDE.openEditor((IWorkbenchPage)BugTreeView.this.getSite().getPage(), (IMarker)myMarker, (boolean)false);
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

