/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.visitclass;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;

public class Util {
    @CheckForNull
    public static JavaClass getOuterClass(JavaClass obj) throws ClassNotFoundException {
        Attribute[] arr$ = obj.getAttributes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Attribute a = arr$[i$];
            if (!(a instanceof InnerClasses)) continue;
            InnerClass[] arr$2 = ((InnerClasses)a).getInnerClasses();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                InnerClass ic = arr$2[i$2];
                if (obj.getClassNameIndex() != ic.getInnerClassIndex()) continue;
                ConstantClass oc = (ConstantClass)obj.getConstantPool().getConstant(ic.getOuterClassIndex());
                String ocName = oc.getBytes(obj.getConstantPool());
                return Repository.lookupClass(ocName);
            }
        }
        return null;
    }

    public static int getSizeOfSurroundingTryBlock(ConstantPool constantPool, Code code, String vmNameOfExceptionClass, int pc) {
        LineNumber line;
        int size = Integer.MAX_VALUE;
        int tightStartPC = 0;
        int tightEndPC = Integer.MAX_VALUE;
        if (code.getExceptionTable() == null) {
            return size;
        }
        CodeException[] arr$ = code.getExceptionTable();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int thisSize;
            Constant catchType;
            CodeException catchBlock = arr$[i$];
            if (vmNameOfExceptionClass != null && ((catchType = constantPool.getConstant(catchBlock.getCatchType())) == null || catchType instanceof ConstantClass && !((ConstantClass)catchType).getBytes(constantPool).equals(vmNameOfExceptionClass))) continue;
            int startPC = catchBlock.getStartPC();
            int endPC = catchBlock.getEndPC();
            if (pc < startPC || pc > endPC || size <= (thisSize = endPC - startPC)) continue;
            size = thisSize;
            tightStartPC = startPC;
            tightEndPC = endPC;
        }
        if (size == Integer.MAX_VALUE) {
            return size;
        }
        size = (size + 7) / 8;
        LineNumberTable lineNumberTable = code.getLineNumberTable();
        if (lineNumberTable == null) {
            return size;
        }
        int count = 0;
        LineNumber[] arr$2 = lineNumberTable.getLineNumberTable();
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2 && (line = arr$2[i$]).getStartPC() <= tightEndPC; ++i$) {
            if (line.getStartPC() < tightStartPC) continue;
            ++count;
        }
        return count;
    }
}

