/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.config;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.SortedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPreferences
implements Cloneable {
    private static final String PREF_FILE_NAME = ".Findbugs_prefs";
    private static final int MAX_RECENT_FILES = 9;
    private static final String DETECTOR_THRESHOLD_KEY = "detector_threshold";
    private static final String FILTER_SETTINGS_KEY = "filter_settings";
    private static final String FILTER_SETTINGS2_KEY = "filter_settings_neg";
    private LinkedList<String> recentProjectsList = new LinkedList();
    private Map<String, Boolean> detectorEnablementMap = new HashMap<String, Boolean>();
    private ProjectFilterSettings filterSettings = ProjectFilterSettings.createDefault();
    private static UserPreferences preferencesSingleton = new UserPreferences();

    private UserPreferences() {
    }

    public static UserPreferences createDefaultUserPreferences() {
        return new UserPreferences();
    }

    public static UserPreferences getUserPreferences() {
        return preferencesSingleton;
    }

    public void read() {
        File prefFile = new File(SystemProperties.getProperty("user.home"), PREF_FILE_NAME);
        if (!prefFile.exists() || !prefFile.isFile()) {
            return;
        }
        try {
            this.read(new FileInputStream(prefFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream in) throws IOException {
        BufferedInputStream prefStream = null;
        Properties props = new Properties();
        try {
            prefStream = new BufferedInputStream(in);
            props.load(prefStream);
        }
        finally {
            try {
                if (prefStream != null) {
                    prefStream.close();
                }
            }
            catch (IOException ioe) {}
        }
        if (props.size() == 0) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            String key = new StringBuffer().append("recent").append(i).toString();
            String projectName = (String)props.get(key);
            if (projectName == null) continue;
            this.recentProjectsList.add(projectName);
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String detectorState;
            int pipePos;
            String key = (String)e.getKey();
            if (!key.startsWith("detector") || key.startsWith("detector_") || (pipePos = (detectorState = (String)e.getValue()).indexOf("|")) < 0) continue;
            String name = detectorState.substring(0, pipePos);
            String enabled = detectorState.substring(pipePos + 1);
            this.detectorEnablementMap.put(name, Boolean.valueOf(enabled));
        }
        if (props.get(FILTER_SETTINGS_KEY) != null) {
            this.filterSettings = ProjectFilterSettings.fromEncodedString(props.getProperty(FILTER_SETTINGS_KEY));
        } else {
            String threshold = (String)props.get(DETECTOR_THRESHOLD_KEY);
            if (threshold != null) {
                try {
                    int detectorThreshold = Integer.parseInt(threshold);
                    this.setUserDetectorThreshold(detectorThreshold);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (props.get(FILTER_SETTINGS2_KEY) != null) {
            ProjectFilterSettings.hiddenFromEncodedString(this.filterSettings, props.getProperty(FILTER_SETTINGS2_KEY));
        }
    }

    public void write() {
        block2: {
            try {
                File prefFile = new File(SystemProperties.getProperty("user.home"), PREF_FILE_NAME);
                this.write(new FileOutputStream(prefFile));
            }
            catch (IOException e) {
                if (!FindBugs.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        SortedProperties props = new SortedProperties();
        for (int i = 0; i < this.recentProjectsList.size(); ++i) {
            String projectName = this.recentProjectsList.get(i);
            String key = new StringBuffer().append("recent").append(i).toString();
            props.put(key, projectName);
        }
        for (Map.Entry<String, Boolean> entry : this.detectorEnablementMap.entrySet()) {
            props.put(new StringBuffer().append("detector").append(entry.getKey()).toString(), new StringBuffer().append(entry.getKey()).append("|").append(String.valueOf(entry.getValue())).toString());
        }
        props.put(FILTER_SETTINGS_KEY, this.filterSettings.toEncodedString());
        props.put(FILTER_SETTINGS2_KEY, this.filterSettings.hiddenToEncodedString());
        props.put(DETECTOR_THRESHOLD_KEY, String.valueOf(this.filterSettings.getMinPriorityAsInt()));
        BufferedOutputStream prefStream = null;
        try {
            prefStream = new BufferedOutputStream(out);
            props.store(prefStream, "FindBugs User Preferences");
            ((OutputStream)prefStream).flush();
        }
        finally {
            try {
                if (prefStream != null) {
                    ((OutputStream)prefStream).close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public List<String> getRecentProjects() {
        return this.recentProjectsList;
    }

    public void useProject(String projectName) {
        this.removeProject(projectName);
        this.recentProjectsList.addFirst(projectName);
        while (this.recentProjectsList.size() > 9) {
            this.recentProjectsList.removeLast();
        }
    }

    public void removeProject(String projectName) {
        Iterator it = this.recentProjectsList.iterator();
        while (it.hasNext()) {
            if (!projectName.equals(it.next())) continue;
            it.remove();
        }
    }

    public void enableDetector(DetectorFactory factory, boolean enable) {
        this.detectorEnablementMap.put(factory.getShortName(), new Boolean(enable));
    }

    public boolean isDetectorEnabled(DetectorFactory factory) {
        String detectorName = factory.getShortName();
        Boolean enabled = this.detectorEnablementMap.get(detectorName);
        if (enabled == null) {
            enabled = new Boolean(factory.isDefaultEnabled());
            this.detectorEnablementMap.put(detectorName, enabled);
        }
        return enabled;
    }

    public void enableAllDetectors(boolean enable) {
        this.detectorEnablementMap.clear();
        DetectorFactoryCollection factoryCollection = DetectorFactoryCollection.instance();
        Iterator<DetectorFactory> i = factoryCollection.factoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = i.next();
            this.detectorEnablementMap.put(factory.getShortName(), new Boolean(enable));
        }
    }

    public void setProjectFilterSettings(ProjectFilterSettings filterSettings) {
        this.filterSettings = filterSettings;
    }

    public ProjectFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public int getUserDetectorThreshold() {
        return this.filterSettings.getMinPriorityAsInt();
    }

    public void setUserDetectorThreshold(int threshold) {
        String minPriority = ProjectFilterSettings.getIntPriorityAsString(threshold);
        this.filterSettings.setMinPriority(minPriority);
    }

    public void setUserDetectorThreshold(String threshold) {
        this.filterSettings.setMinPriority(threshold);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UserPreferences other = (UserPreferences)obj;
        return this.recentProjectsList.equals(other.recentProjectsList) && ((Object)this.detectorEnablementMap).equals(other.detectorEnablementMap) && this.filterSettings.equals(other.filterSettings);
    }

    public int hashCode() {
        return this.recentProjectsList.hashCode() + ((Object)this.detectorEnablementMap).hashCode() + this.filterSettings.hashCode();
    }

    public Object clone() {
        try {
            UserPreferences dup = (UserPreferences)super.clone();
            dup.recentProjectsList = new LinkedList();
            dup.recentProjectsList.addAll(this.recentProjectsList);
            dup.detectorEnablementMap = new HashMap<String, Boolean>();
            dup.detectorEnablementMap.putAll(this.detectorEnablementMap);
            dup.filterSettings = (ProjectFilterSettings)this.filterSettings.clone();
            return dup;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

