/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilder;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.CFGPrinter;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.ExceptionHandlerMap;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.Target;
import edu.umd.cs.findbugs.ba.TargetEnumeratingVisitor;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.ReturnInstruction;

public class BetterCFGBuilder2
implements CFGBuilder,
EdgeTypes,
Debug {
    private static final boolean DEBUG = SystemProperties.getBoolean("cfgbuilder.debug");
    private static final LinkedList<EscapeTarget> emptyEscapeTargetList = new LinkedList();
    private MethodGen methodGen;
    private ConstantPoolGen cpg;
    private ExceptionHandlerMap exceptionHandlerMap;
    private BitSet usedInstructionSet;
    private LinkedList<Subroutine> subroutineWorkList;
    private IdentityHashMap<InstructionHandle, Subroutine> jsrSubroutineMap;
    private Subroutine topLevelSubroutine;
    private CFG cfg;

    public BetterCFGBuilder2(@NonNull MethodGen methodGen) {
        this.methodGen = methodGen;
        this.cpg = methodGen.getConstantPool();
        this.exceptionHandlerMap = new ExceptionHandlerMap(methodGen);
        this.usedInstructionSet = new BitSet();
        this.jsrSubroutineMap = new IdentityHashMap();
        this.subroutineWorkList = new LinkedList();
    }

    public void build() throws CFGBuilderException {
        this.topLevelSubroutine = new Subroutine(this.methodGen.getInstructionList().getStart());
        this.subroutineWorkList.add(this.topLevelSubroutine);
        while (!this.subroutineWorkList.isEmpty()) {
            Subroutine subroutine = this.subroutineWorkList.removeFirst();
            if (DEBUG) {
                System.out.println("Starting subroutine " + subroutine.getStartInstruction());
            }
            this.build(subroutine);
        }
        this.cfg = this.inlineAll();
        BasicBlock entryBlock = this.cfg.getEntry();
        InstructionList il = new InstructionList();
        entryBlock.addInstruction(il.append(new NOP()));
        if (VERIFY_INTEGRITY) {
            this.cfg.checkIntegrity();
        }
    }

    public CFG getCFG() {
        return this.cfg;
    }

    private void build(Subroutine subroutine) throws CFGBuilderException {
        subroutine.addEdgeAndExplore(subroutine.getEntry(), subroutine.getStartInstruction(), 10);
        while (subroutine.hasMoreWork()) {
            WorkListItem item = subroutine.nextItem();
            InstructionHandle handle = item.getStartInstruction();
            BasicBlock basicBlock = item.getBasicBlock();
            if (this.isPEI(handle)) {
                if (DEBUG) {
                    System.out.println("ETB block " + basicBlock.getId() + " for " + handle);
                }
                this.handleExceptions(subroutine, handle, basicBlock);
                BasicBlock body = subroutine.allocateBasicBlock();
                subroutine.addEdge(basicBlock, body, 0);
                basicBlock = body;
            }
            if (DEBUG) {
                System.out.println("BODY block " + basicBlock.getId() + " for " + handle);
            }
            if (!basicBlock.isEmpty()) {
                throw new IllegalStateException("Block isn't empty!");
            }
            boolean endOfBasicBlock = false;
            do {
                Instruction ins = handle.getInstruction();
                if (DEBUG) {
                    System.out.println("BB " + basicBlock.getId() + ": adding" + handle);
                }
                basicBlock.addInstruction(handle);
                subroutine.addInstruction(handle);
                short opcode = ins.getOpcode();
                if (opcode == 168 || opcode == 201) {
                    JsrInstruction jsr = (JsrInstruction)ins;
                    InstructionHandle jsrTarget = jsr.getTarget();
                    Subroutine jsrSubroutine = this.jsrSubroutineMap.get(jsrTarget);
                    if (jsrSubroutine == null) {
                        jsrSubroutine = new Subroutine(jsrTarget);
                        this.jsrSubroutineMap.put(jsrTarget, jsrSubroutine);
                        this.subroutineWorkList.add(jsrSubroutine);
                    }
                    subroutine.addEdgeAndExplore(basicBlock, handle.getNext(), 4);
                    endOfBasicBlock = true;
                } else if (opcode == 169) {
                    subroutine.addEdge(basicBlock, subroutine.getExit(), 5);
                    endOfBasicBlock = true;
                } else {
                    TargetEnumeratingVisitor visitor = new TargetEnumeratingVisitor(handle, this.cpg);
                    if (visitor.isEndOfBasicBlock()) {
                        endOfBasicBlock = true;
                        if (visitor.instructionIsThrow()) {
                            this.handleExceptions(subroutine, handle, basicBlock);
                        } else if (visitor.instructionIsExit()) {
                            subroutine.setExitBlock(basicBlock);
                        } else if (visitor.instructionIsReturn()) {
                            subroutine.setReturnBlock(basicBlock);
                        } else {
                            Iterator<Target> i = visitor.targetIterator();
                            while (i.hasNext()) {
                                Target target = i.next();
                                subroutine.addEdgeAndExplore(basicBlock, target.getTargetInstruction(), target.getEdgeType());
                            }
                        }
                    }
                }
                if (endOfBasicBlock) continue;
                InstructionHandle next = handle.getNext();
                if (next == null) {
                    throw new CFGBuilderException("Control falls off end of method: " + handle);
                }
                if (BetterCFGBuilder2.isMerge(next) || this.isPEI(next)) {
                    subroutine.addEdgeAndExplore(basicBlock, next, 0);
                    endOfBasicBlock = true;
                    continue;
                }
                handle = next;
            } while (!endOfBasicBlock);
        }
    }

    private void handleExceptions(Subroutine subroutine, InstructionHandle pei, BasicBlock etb) {
        etb.setExceptionThrower(pei);
        boolean sawUniversalExceptionHandler = false;
        List<CodeExceptionGen> exceptionHandlerList = this.exceptionHandlerMap.getHandlerList(pei);
        if (exceptionHandlerList != null) {
            Iterator<CodeExceptionGen> i$ = exceptionHandlerList.iterator();
            while (i$.hasNext()) {
                CodeExceptionGen exceptionHandler = i$.next();
                InstructionHandle handlerStart = exceptionHandler.getHandlerPC();
                subroutine.addEdgeAndExplore(etb, handlerStart, 9);
                if (!Hierarchy.isUniversalExceptionHandler(exceptionHandler.getCatchType())) continue;
                sawUniversalExceptionHandler = true;
            }
        }
        if (!sawUniversalExceptionHandler) {
            if (DEBUG) {
                System.out.println("Adding unhandled exception edge from " + pei);
            }
            subroutine.setUnhandledExceptionBlock(etb);
        }
    }

    private boolean isPEI(InstructionHandle handle) {
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof ExceptionThrower)) {
            return false;
        }
        if (ins instanceof NEW) {
            return false;
        }
        if (ins instanceof GETSTATIC) {
            return false;
        }
        if (ins instanceof PUTSTATIC) {
            return false;
        }
        if (ins instanceof ReturnInstruction) {
            return false;
        }
        if (ins instanceof INSTANCEOF) {
            return false;
        }
        if (ins instanceof MONITORENTER) {
            return false;
        }
        return !(ins instanceof MONITOREXIT);
    }

    private static boolean isMerge(InstructionHandle handle) {
        if (handle.hasTargeters()) {
            InstructionTargeter[] targeterList;
            InstructionTargeter[] arr$ = targeterList = handle.getTargeters();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                InstructionTargeter targeter = arr$[i$];
                if (!(targeter instanceof BranchInstruction)) continue;
                return true;
            }
        }
        return false;
    }

    private CFG inlineAll() throws CFGBuilderException {
        CFG result = new CFG();
        Context rootContext = new Context(null, this.topLevelSubroutine, result);
        rootContext.mapBlock(this.topLevelSubroutine.getEntry(), result.getEntry());
        rootContext.mapBlock(this.topLevelSubroutine.getExit(), result.getExit());
        BasicBlock resultStartBlock = rootContext.getBlock(this.topLevelSubroutine.getStartBlock());
        result.createEdge(result.getEntry(), resultStartBlock, 10);
        this.inline(rootContext);
        return result;
    }

    public void inline(Context context) throws CFGBuilderException {
        CFG result = context.getResult();
        context.checkForRecursion();
        Subroutine subroutine = context.getSubroutine();
        CFG subCFG = subroutine.getCFG();
        while (context.hasMoreWork()) {
            BasicBlock subBlock = context.nextItem();
            BasicBlock resultBlock = context.getBlock(subBlock);
            resultBlock.setInJSRSubroutine(context.getCaller() != null);
            BasicBlock.InstructionIterator insIter = subBlock.instructionIterator();
            while (insIter.hasNext()) {
                InstructionHandle handle = insIter.next();
                resultBlock.addInstruction(handle);
            }
            if (subBlock.isExceptionThrower()) {
                resultBlock.setExceptionThrower(subBlock.getExceptionThrower());
            }
            if (subBlock.isExceptionHandler()) {
                resultBlock.setExceptionGen(subBlock.getExceptionGen());
            }
            Iterator edgeIter = subCFG.outgoingEdgeIterator(subBlock);
            while (edgeIter.hasNext()) {
                Edge edge = (Edge)edgeIter.next();
                int edgeType = edge.getType();
                if (edgeType == 4) {
                    InstructionHandle jsrHandle = subBlock.getLastInstruction();
                    JsrInstruction jsr = (JsrInstruction)jsrHandle.getInstruction();
                    Subroutine jsrSub = this.jsrSubroutineMap.get(jsr.getTarget());
                    Context jsrContext = new Context(context, jsrSub, context.getResult());
                    BasicBlock resultJSRStartBlock = jsrContext.getBlock(jsrSub.getStartBlock());
                    result.createEdge(resultBlock, resultJSRStartBlock, 6);
                    BasicBlock subJSRSuccessorBlock = subroutine.getBlock(jsrHandle.getNext());
                    BasicBlock resultJSRSuccessorBlock = context.getBlock(subJSRSuccessorBlock);
                    jsrContext.mapBlock(jsrSub.getExit(), resultJSRSuccessorBlock);
                    this.inline(jsrContext);
                    continue;
                }
                BasicBlock resultTarget = context.getBlock((BasicBlock)edge.getTarget());
                result.createEdge(resultBlock, resultTarget, edge.getType());
            }
            Iterator<EscapeTarget> escapeTargetIter = subroutine.escapeTargetIterator(subBlock);
            while (escapeTargetIter.hasNext()) {
                Context caller;
                EscapeTarget escapeTarget = escapeTargetIter.next();
                InstructionHandle targetInstruction = escapeTarget.getTarget();
                for (caller = context.getCaller(); caller != null && !caller.getSubroutine().containsInstruction(targetInstruction); caller = caller.getCaller()) {
                }
                if (caller == null) {
                    throw new CFGBuilderException("Unknown caller for escape target " + targetInstruction + " referenced by " + context.getSubroutine().getStartInstruction());
                }
                BasicBlock subCallerTargetBlock = caller.getSubroutine().getBlock(targetInstruction);
                BasicBlock resultCallerTargetBlock = caller.getBlock(subCallerTargetBlock);
                result.createEdge(resultBlock, resultCallerTargetBlock, escapeTarget.getEdgeType());
            }
            if (subroutine.isReturnBlock(subBlock)) {
                result.createEdge(resultBlock, result.getExit(), 7);
            }
            if (subroutine.isExitBlock(subBlock)) {
                result.createEdge(resultBlock, result.getExit(), 13);
            }
            if (!subroutine.isUnhandledExceptionBlock(subBlock)) continue;
            result.createEdge(resultBlock, result.getExit(), 8);
        }
    }

    public static void main(String[] argv) throws Exception {
        Method[] methodList;
        if (argv.length != 1) {
            System.err.println("Usage: " + BetterCFGBuilder2.class.getName() + " <class file>");
            System.exit(1);
        }
        String methodName = SystemProperties.getProperty("cfgbuilder.method");
        JavaClass jclass = new ClassParser(argv[0]).parse();
        ClassGen classGen = new ClassGen(jclass);
        Method[] arr$ = methodList = jclass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            if (method.isAbstract() || method.isNative() || methodName != null && !method.getName().equals(methodName)) continue;
            MethodGen methodGen = new MethodGen(method, jclass.getClassName(), classGen.getConstantPool());
            BetterCFGBuilder2 cfgBuilder = new BetterCFGBuilder2(methodGen);
            cfgBuilder.build();
            CFG cfg = cfgBuilder.getCFG();
            CFGPrinter cfgPrinter = new CFGPrinter(cfg);
            System.out.println("---------------------------------------------------------------------");
            System.out.println("Method: " + SignatureConverter.convertMethodSignature(methodGen));
            System.out.println("---------------------------------------------------------------------");
            cfgPrinter.print(System.out);
        }
    }

    private static class Context {
        private final Context caller;
        private final Subroutine subroutine;
        private final CFG result;
        private final IdentityHashMap<BasicBlock, BasicBlock> blockMap;
        private final LinkedList<BasicBlock> workList;

        public Context(@Nullable Context caller, Subroutine subroutine, CFG result) {
            this.caller = caller;
            this.subroutine = subroutine;
            this.result = result;
            this.blockMap = new IdentityHashMap();
            this.workList = new LinkedList();
        }

        public Context getCaller() {
            return this.caller;
        }

        public Subroutine getSubroutine() {
            return this.subroutine;
        }

        public CFG getResult() {
            return this.result;
        }

        public void addItem(BasicBlock item) {
            this.workList.add(item);
        }

        public boolean hasMoreWork() {
            return !this.workList.isEmpty();
        }

        public BasicBlock nextItem() {
            return this.workList.removeFirst();
        }

        public void mapBlock(BasicBlock subBlock, BasicBlock resultBlock) {
            this.blockMap.put(subBlock, resultBlock);
        }

        public BasicBlock getBlock(BasicBlock subBlock) {
            BasicBlock resultBlock = this.blockMap.get(subBlock);
            if (resultBlock == null) {
                resultBlock = this.result.allocate();
                this.blockMap.put(subBlock, resultBlock);
                this.workList.add(subBlock);
            }
            return resultBlock;
        }

        public void checkForRecursion() throws CFGBuilderException {
            Context callerContext = this.caller;
            while (callerContext != null) {
                if (callerContext.subroutine == this.subroutine) {
                    throw new CFGBuilderException("JSR recursion detected!");
                }
                callerContext = callerContext.caller;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Subroutine {
        private final InstructionHandle start;
        private final BitSet instructionSet;
        private final CFG cfg;
        private IdentityHashMap<InstructionHandle, BasicBlock> blockMap;
        private IdentityHashMap<BasicBlock, List<EscapeTarget>> escapeTargetListMap;
        private BitSet returnBlockSet;
        private BitSet exitBlockSet;
        private BitSet unhandledExceptionBlockSet;
        private LinkedList<WorkListItem> workList;

        public Subroutine(InstructionHandle start) {
            this.start = start;
            this.instructionSet = new BitSet();
            this.cfg = new CFG();
            this.blockMap = new IdentityHashMap();
            this.escapeTargetListMap = new IdentityHashMap();
            this.returnBlockSet = new BitSet();
            this.exitBlockSet = new BitSet();
            this.unhandledExceptionBlockSet = new BitSet();
            this.workList = new LinkedList();
        }

        public InstructionHandle getStartInstruction() {
            return this.start;
        }

        public BasicBlock allocateBasicBlock() {
            return this.cfg.allocate();
        }

        public void addItem(WorkListItem item) {
            this.workList.add(item);
        }

        public boolean hasMoreWork() {
            return !this.workList.isEmpty();
        }

        public WorkListItem nextItem() {
            return this.workList.removeFirst();
        }

        public BasicBlock getEntry() {
            return this.cfg.getEntry();
        }

        public BasicBlock getExit() {
            return this.cfg.getExit();
        }

        public BasicBlock getStartBlock() {
            return this.getBlock(this.start);
        }

        public CFG getCFG() {
            return this.cfg;
        }

        public void addInstruction(InstructionHandle handle) throws CFGBuilderException {
            int position = handle.getPosition();
            if (BetterCFGBuilder2.this.usedInstructionSet.get(position)) {
                throw new CFGBuilderException(new StringBuffer().append("Instruction ").append(handle).append(" visited in multiple subroutines").toString());
            }
            this.instructionSet.set(position);
            BetterCFGBuilder2.this.usedInstructionSet.set(position);
        }

        public boolean containsInstruction(InstructionHandle handle) {
            return this.instructionSet.get(handle.getPosition());
        }

        public BasicBlock getBlock(InstructionHandle start) {
            BasicBlock block = this.blockMap.get(start);
            if (block == null) {
                block = this.allocateBasicBlock();
                this.blockMap.put(start, block);
                CodeExceptionGen exceptionGen = BetterCFGBuilder2.this.exceptionHandlerMap.getHandlerForStartInstruction(start);
                if (exceptionGen != null) {
                    block.setExceptionGen(exceptionGen);
                }
                this.addItem(new WorkListItem(start, block));
            }
            return block;
        }

        public void setReturnBlock(BasicBlock block) {
            this.returnBlockSet.set(block.getId());
        }

        public boolean isReturnBlock(BasicBlock block) {
            return this.returnBlockSet.get(block.getId());
        }

        public void setExitBlock(BasicBlock block) {
            this.exitBlockSet.set(block.getId());
        }

        public boolean isExitBlock(BasicBlock block) {
            return this.exitBlockSet.get(block.getId());
        }

        public void setUnhandledExceptionBlock(BasicBlock block) {
            this.unhandledExceptionBlockSet.set(block.getId());
        }

        public boolean isUnhandledExceptionBlock(BasicBlock block) {
            return this.unhandledExceptionBlockSet.get(block.getId());
        }

        public void addEdgeAndExplore(BasicBlock sourceBlock, InstructionHandle target, int edgeType) {
            if (BetterCFGBuilder2.this.usedInstructionSet.get(target.getPosition()) && !this.containsInstruction(target)) {
                List<EscapeTarget> escapeTargetList = this.escapeTargetListMap.get(sourceBlock);
                if (escapeTargetList == null) {
                    escapeTargetList = new LinkedList<EscapeTarget>();
                    this.escapeTargetListMap.put(sourceBlock, escapeTargetList);
                }
                escapeTargetList.add(new EscapeTarget(target, edgeType));
            } else {
                BasicBlock targetBlock = this.getBlock(target);
                this.addEdge(sourceBlock, targetBlock, edgeType);
            }
        }

        public void addEdge(BasicBlock sourceBlock, BasicBlock destBlock, int edgeType) {
            if (Debug.VERIFY_INTEGRITY && destBlock.isExceptionHandler() && edgeType != 9) {
                throw new IllegalStateException(new StringBuffer().append("In method ").append(SignatureConverter.convertMethodSignature(BetterCFGBuilder2.this.methodGen)).append(": exception handler ").append(destBlock.getFirstInstruction()).append(" reachable by non exception edge type ").append(edgeType).toString());
            }
            this.cfg.createEdge(sourceBlock, destBlock, edgeType);
        }

        public Iterator<EscapeTarget> escapeTargetIterator(BasicBlock sourceBlock) {
            LinkedList escapeTargetList = this.escapeTargetListMap.get(sourceBlock);
            if (escapeTargetList == null) {
                escapeTargetList = emptyEscapeTargetList;
            }
            return escapeTargetList.iterator();
        }
    }

    private static class EscapeTarget {
        private final InstructionHandle target;
        private final int edgeType;

        public EscapeTarget(InstructionHandle target, int edgeType) {
            this.target = target;
            this.edgeType = edgeType;
        }

        public InstructionHandle getTarget() {
            return this.target;
        }

        public int getEdgeType() {
            return this.edgeType;
        }
    }

    private static class WorkListItem {
        private final InstructionHandle start;
        private final BasicBlock basicBlock;

        public WorkListItem(InstructionHandle start, BasicBlock basicBlock) {
            this.start = start;
            this.basicBlock = basicBlock;
        }

        public InstructionHandle getStartInstruction() {
            return this.start;
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }
    }
}

