/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeChooser;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDominatorsAnalysis
extends BasicAbstractDataflowAnalysis<BitSet> {
    private final CFG cfg;
    private EdgeChooser edgeChooser;

    public AbstractDominatorsAnalysis(CFG cfg, final boolean ignoreExceptionEdges) {
        this(cfg, new EdgeChooser(){

            public boolean choose(Edge edge) {
                return !ignoreExceptionEdges || !edge.isExceptionEdge();
            }
        });
    }

    public AbstractDominatorsAnalysis(CFG cfg, EdgeChooser edgeChooser) {
        this.cfg = cfg;
        this.edgeChooser = edgeChooser;
    }

    @Override
    public BitSet createFact() {
        return new BitSet();
    }

    @Override
    public void copy(BitSet source, BitSet dest) {
        dest.clear();
        dest.or(source);
    }

    @Override
    public void initEntryFact(BitSet result) {
        result.clear();
    }

    @Override
    public void initResultFact(BitSet result) {
        this.makeFactTop(result);
    }

    @Override
    public boolean isTop(BitSet fact) {
        return fact.get(this.cfg.getNumBasicBlocks());
    }

    @Override
    public void makeFactTop(BitSet fact) {
        fact.set(this.cfg.getNumBasicBlocks());
    }

    @Override
    public boolean same(BitSet fact1, BitSet fact2) {
        return fact1.equals(fact2);
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, BitSet start, BitSet result) throws DataflowAnalysisException {
        this.copy(start, result);
        if (!this.isTop(result)) {
            result.set(basicBlock.getId());
        }
    }

    @Override
    public void meetInto(BitSet fact, Edge edge, BitSet result) throws DataflowAnalysisException {
        if (!this.edgeChooser.choose(edge)) {
            return;
        }
        if (this.isTop(fact)) {
            return;
        }
        if (this.isTop(result)) {
            this.copy(fact, result);
        } else {
            result.and(fact);
        }
    }

    public BitSet getAllDominatorsOf(BasicBlock block) {
        return (BitSet)this.getResultFact(block);
    }

    public BitSet getAllDominatedBy(BasicBlock dominator) {
        BitSet allDominated = new BitSet();
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            BitSet dominators = (BitSet)this.getResultFact(block);
            if (!dominators.get(dominator.getId())) continue;
            allDominated.set(block.getId());
        }
        return allDominated;
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((BitSet)x0, x1, (BitSet)x2);
    }

    @Override
    public /* synthetic */ void transfer(BasicBlock x0, InstructionHandle x1, Object x2, Object x3) throws DataflowAnalysisException {
        this.transfer(x0, x1, (BitSet)x2, (BitSet)x3);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((BitSet)x0, (BitSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((BitSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((BitSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((BitSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((BitSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((BitSet)x0, (BitSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }
}

