/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Location;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;

public class CallSite {
    private final Method method;
    private final Location location;

    public CallSite(Method method, BasicBlock basicBlock, InstructionHandle handle) {
        this.method = method;
        this.location = new Location(handle, basicBlock);
    }

    public Method getMethod() {
        return this.method;
    }

    public Location getLocation() {
        return this.location;
    }

    public BasicBlock getBasicBlock() {
        return this.location.getBasicBlock();
    }

    public InstructionHandle getHandle() {
        return this.location.getHandle();
    }

    public int hashCode() {
        return System.identityHashCode(this.method) ^ this.getBasicBlock().getId() ^ System.identityHashCode(this.location.getHandle());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CallSite)) {
            return false;
        }
        CallSite other = (CallSite)o;
        return this.method == other.method && this.getBasicBlock() == other.getBasicBlock() && this.getHandle() == other.getHandle();
    }
}

