/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class AnalysisCacheToRepositoryAdapter
implements Repository {
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public JavaClass findClass(String className) {
        className = ClassName.toSlashedClassName(className);
        ClassDescriptor classDescriptor = new ClassDescriptor(className);
        return (JavaClass)Global.getAnalysisCache().probeClassAnalysis(JavaClass.class, classDescriptor);
    }

    public ClassPath getClassPath() {
        throw new UnsupportedOperationException();
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        className = ClassName.toSlashedClassName(className);
        ClassDescriptor classDescriptor = new ClassDescriptor(className);
        try {
            return (JavaClass)Global.getAnalysisCache().getClassAnalysis(JavaClass.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className, e);
        }
    }

    public JavaClass loadClass(Class cls) throws ClassNotFoundException {
        return this.loadClass(cls.getName());
    }

    public void removeClass(JavaClass arg0) {
        throw new UnsupportedOperationException();
    }

    public void storeClass(JavaClass cls) {
        throw new UnsupportedOperationException();
    }
}

