/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class BooleanBinding
extends TupleBinding {
    private static final int BOOLEAN_SIZE = 1;

    public Object entryToObject(TupleInput tupleInput) {
        return tupleInput.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeBoolean((Boolean)object);
    }

    protected TupleOutput getTupleOutput(Object object) {
        return BooleanBinding.sizedOutput();
    }

    public static boolean entryToBoolean(DatabaseEntry databaseEntry) {
        return BooleanBinding.entryToInput(databaseEntry).readBoolean();
    }

    public static void booleanToEntry(boolean bl, DatabaseEntry databaseEntry) {
        BooleanBinding.outputToEntry(BooleanBinding.sizedOutput().writeBoolean(bl), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[1]);
    }
}

