<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
	/**
	 * RestoreItemsList Module
	 */
	class RestoreItemsListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function RestoreItemsListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getMailProperties();
			parent::ListModule($id, $data);// array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));
			$this->start = 0;
		}
		
		
		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			$result = false;
			
			foreach($this->data as $action)
			{
				if(isset($action["attributes"]) && isset($action["attributes"]["type"])) {
					$store = $this->getActionStore($action);
					$parententryid = $this->getActionParentEntryID($action);
					$folderentryid = $this->getActionEntryID($action);
					if(isset($action["attributes"]) && $action["attributes"]["type"] != "list"){
						$entrylist = $action["entrylist"];
					}

					switch($action["attributes"]["type"])
					{
						case "list":
							$result = $this->messageList($store, $folderentryid, $action);
							break;
						
						case "deleteall":
							$result = $this->deleteAll($store, $folderentryid, $action);
							break;
						case "restoreall":
							$result = $this->restoreAll($store, $folderentryid, $action);
							break;
						
						case "delete":
							$result = $this->deleteItems($store, $folderentryid, $entrylist, $action);
							break;
						case "restore":
							$result = $this->restoreItems($store, $folderentryid, $entrylist, $action);
							break;
					}
				}
			}

			//check if $action["attributes"] is set and type is not list and return of action is true
			// then call the new list of items to be sent to the client back.
			if(isset($action["attributes"]) && $action["attributes"]["type"] != "list" && $result){
				$result = $this->messageList($store, $folderentryid, $action);
			}
			return $result;
		}
		
		/**
		 * Function to retrieve the list of items of particular folder's entry id
		 * @param object $store store object.
		 * @param binary $entryid entry id of that particular folder.
		 * @param object $action request data.
		 * return - true if result is successful.
		 */
		function messageList($store, $entryid, $action){
			
			//set the this->$sort variable.
			$this->parseSortOrder($action);

			$data = array();
			$data["attributes"] = array("type" => "list");
			$data["column"] = $this->tablecolumns;

			$folder = mapi_msgstore_openentry($store, $entryid);
			$table = mapi_folder_getcontentstable($folder, SHOW_SOFT_DELETES);
			
			//sort the table according to sort data
			if (is_array($this->sort) && count($this->sort)>0){
				mapi_table_sort($table, $this->sort);
			}
			$restoreitems = mapi_table_queryallrows($table, Array(PR_ENTRYID, PR_MESSAGE_CLASS, PR_SUBJECT, PR_SENDER_NAME, PR_DELETED_ON, PR_MESSAGE_SIZE ));
			$items = Array();
			foreach($restoreitems as $restoreitem)
			{
				$item = null;
				$item = Conversion::mapMAPI2XML($this->properties, $restoreitem);
				array_push($items,$item);
			} 
			$data["item"] = $items;

			array_push($this->responseData["action"], $data);
			$GLOBALS["bus"]->addData($this->responseData);

			return true;
		}
		
		/**
		 * Function to delete all items of particular folder's entry id
		 * @param object $store store object.
		 * @param binary $folderentryid entry id of that particular folder.
		 * @param object $action request data.
		 * return - true if result is successful.
		 */

		function deleteAll($store, $folderentryid, $action){
			$entrylist = Array();
			$folder = mapi_msgstore_openentry($store, $folderentryid);
			$table = mapi_folder_getcontentstable($folder, SHOW_SOFT_DELETES);
			$rows = mapi_table_queryallrows($table, array(PR_ENTRYID));
			for($i=0;$i<count($rows);$i++){
				array_push($entrylist, $rows[$i][PR_ENTRYID]);
			}
			mapi_folder_deletemessages($folder, $entrylist, DELETE_HARD_DELETE);
			$result = (mapi_last_hresult()==NOERROR);

			return $result;
		}

		/**
		 * Function to restore all items of particular folder's entry id
		 * @param object $store store object.
		 * @param binary $folderentryid entry id of that particular folder.
		 * @param object $action request data.
		 * return - true if result is successful.
		 */
		function restoreAll($store, $folderentryid, $action){
			$entryidlist = Array();
			$sfolder = mapi_msgstore_openentry($store, $folderentryid);
			$table = mapi_folder_getcontentstable($sfolder, SHOW_SOFT_DELETES);
			$rows = mapi_table_queryallrows($table, array(PR_ENTRYID));
			for($i=0;$i<count($rows);$i++){
				array_push($entryidlist, $rows[$i][PR_ENTRYID]);
			}
			mapi_folder_copymessages($sfolder, $entryidlist, $sfolder, MESSAGE_MOVE);
			$result = (mapi_last_hresult()==NOERROR);

			// as after moving the message/s the entryid gets changed, so need to notify about the folder
			// so that we can update the folder on parent page.
			$folderProps = mapi_getprops($sfolder, array(PR_ENTRYID, PR_STORE_ENTRYID, PR_PARENT_ENTRYID));
			$GLOBALS["bus"]->notify(bin2hex($folderentryid), TABLE_SAVE, $folderProps);
			
			return $result;
		}

		/**
		 * Function to delete selected items of particular folder
		 * @param object $store store object.
		 * @param binary $folderentryid entry id of that particular folder.
		 * @param array $entryidlist array of entry ids of messages to be deleted permanently
		 * @param object $action request data.
		 * return - true if result is successful.
		 */
		function deleteItems($store, $folderentryid, $entryidlist, $action){
			$binEntryIdList = Array();
			if(isset($entryidlist) && !is_array($entryidlist)){
				$binEntryIdList[] = hex2bin($entryidlist);
			}else{
				foreach($entryidlist as $key => $value){
					$binEntryIdList[] = hex2bin($value);
				}
			}
			$sfolder = mapi_msgstore_openentry($store, $folderentryid);
			mapi_folder_deletemessages($sfolder, $binEntryIdList, DELETE_HARD_DELETE);
			$result = (mapi_last_hresult()==NOERROR);

			return $result;
		}
		
		/**
		 * Function to restore selected items of particular folder
		 * @param object $store store object.
		 * @param binary $folderentryid entry id of that particular folder.
		 * @param array $entryidlist array of entry ids of messages to be deleted permanently
		 * @param object $action request data.
		 * return - true if result is successful.
		 */
		function restoreItems($store, $folderentryid, $entryidlist, $action){
			$binEntryIdList = Array();
			if(isset($entryidlist) && !is_array($entryidlist)){
				$binEntryIdList[] = hex2bin($entryidlist);
			}else{
				foreach($entryidlist as $key => $value){
					$binEntryIdList[] = hex2bin($value);
				}
			}
			$sfolder = mapi_msgstore_openentry($store, $folderentryid);
			mapi_folder_copymessages($sfolder, $binEntryIdList, $sfolder, MESSAGE_MOVE);
			$result = (mapi_last_hresult()==NOERROR);
			
			// as after moving the message/s the entryid gets changed, so need to notify about the folder
			// so that we can update the folder on parent page.
			$folderProps = mapi_getprops($sfolder, array(PR_ENTRYID, PR_STORE_ENTRYID, PR_PARENT_ENTRYID));
			$GLOBALS["bus"]->notify(bin2hex($folderentryid), TABLE_SAVE, $folderProps);

			return $result;
		}
	}
?>
