/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
* Generates Print Preview for Calendar Week View
*/
PrintCalendarWeekView.prototype = new PrintView;
PrintCalendarWeekView.prototype.constructor = PrintCalendarWeekView;
PrintCalendarWeekView.superclass = PrintView.prototype;

/**
 * @constructor This view can be used to print a list of appointments in week view
 * @param Int moduleID The PrintListModule ID
 * @param HtmlElement The html element where all elements will be appended
 * @param Object The Events object
 * @param Object The Data Passed from the main window
 */
function PrintCalendarWeekView(moduleID, element, events, data, uniqueid) {
	if(arguments.length > 0) {
		this.init(moduleID, element, events, data, uniqueid);
	}
}

/**
 * Function which intializes the view
 */
PrintCalendarWeekView.prototype.initView = function() {
	// add day elments
	this.dayElements = new Array();
	this.dayElements[0] = dhtml.addElement(this.element, "div", "week_view day_monday");
	this.dayElements[3] = dhtml.addElement(this.element, "div", "week_view day_thursday");
	this.dayElements[1] = dhtml.addElement(this.element, "div", "week_view day_tuesday");
	this.dayElements[4] = dhtml.addElement(this.element, "div", "week_view day_friday");
	this.dayElements[2] = dhtml.addElement(this.element, "div", "week_view day_wednesday");
	this.dayElements[5] = dhtml.addElement(this.element, "div", "week_view day_saturday");
	this.dayElements[6] = dhtml.addElement(this.element, "div", "week_view day_sunday");

	// add header info
	var tmpStart = new Date(this.selecteddate).getStartDateOfWeek();
	
	for(var i = 0;i < this.dayElements.length; i++) {
		this.dayElements[i].id = "day_" + this.moduleID + "_" + (tmpStart.getTime() / 1000);
		var dayTitle = dhtml.addElement(this.dayElements[i], "span", "day_header", "", 
											tmpStart.strftime( _("%A %d %B") ));
		tmpStart.addDays(1);
	}
}

/**
 * Function will resize all elements in the view
 */
PrintCalendarWeekView.prototype.resizeView = function() {
	var menubarHeight = dhtml.getElementById("menubar").offsetHeight + dhtml.getElementById("menubar").offsetTop;
	var titleHeight = dhtml.getElementsByClassName("title")[0].offsetHeight;
	var bodyHeight = document.getElementsByTagName("body")[0].offsetHeight;

	var dialogContentHeight = bodyHeight - (menubarHeight + titleHeight) + 12;
	dhtml.getElementById("dialog_content").style.height = dialogContentHeight + "px";

	var printFooterHeight = dhtml.getElementById("print_footer").offsetHeight;
	var printHeaderHeight = dhtml.getElementById("print_header").offsetHeight;

	this.element.style.height = dialogContentHeight - (printHeaderHeight + printFooterHeight) + "px";

	for(var i in this.dayElements) {
		if(i == "5" || i == "6") {
			this.dayElements[i].style.height = (this.element.offsetHeight/3) / 2 + "px";
		} else {
			this.dayElements[i].style.height = (this.element.offsetHeight/3) + "px";	
		}
		this.dayElements[i].style.width = (this.element.offsetWidth/2) - 2 + "px";
	}

	// width of "print_calendar","print_header" and "print_footer" is in percentage 
	// so before printing need to convert it into pixels
	this.element.style.width = (this.dayElements[0].offsetWidth * 2) + 2 + "px";
	dhtml.getElementById("print_header").style.width = this.element.style.width;
	dhtml.getElementById("print_footer").style.width = this.element.style.width;
	
	this.hideOverlappingItems();
}

/**
 * Function will add items to the view
 * @param Object items Object with items
 * @param Array properties property list
 * @param Object action the action tag
 * @return Array list of entryids
 */
PrintCalendarWeekView.prototype.execute = function(items, properties, action) {
	var entryids = false;

	for(var i=0;i<items.length;i++){
		if (!entryids) {
			entryids = new Object();
		}
		// there is not much difference in createItem function 
		// of PrintView and PrintCalendarWeekView class
		// so it is not redeclared here used common function
		var item = this.createItem(items[i]);
		entryids[item["id"]]= item["entryid"];
	}

	this.resizeView();

	this.createIFrame();

	return entryids;
}

/**
 * Function will check if there are items outside the view that
 * have to be hidden
 */
PrintCalendarWeekView.prototype.hideOverlappingItems = function() {
	for(var i in this.dayElements) {
		var items = dhtml.getElementsByClassNameInElement(this.dayElements[i], "event", "div");
		var dayHeight = this.dayElements[i].offsetHeight;
		var	dayCurrentHeight = (items.length * 14) + 14;
		var maxItems = Math.floor((dayHeight - 18) / 14) - 1;

		// remove more_items label
		var moreItem = dhtml.getElementsByClassNameInElement(this.dayElements[i], "more_items", "div")[0];
		if(moreItem) {
			dhtml.deleteElement(moreItem);
		}

		// hide/show items
		var moreItemCount = 0;
		for(var j = 0; j < items.length; j++) {
			if(j < maxItems) {
				items[j].style.display = "block";
			} else {
				items[j].style.display = "none";
				moreItemCount++;
			}

			var item_back = dhtml.getElementById(items[j].id + "_back", "div", this.dayElements[i]);
			if(item_back != null) {
				if(j < maxItems) {
					item_back.style.display = "block";
				} else {
					item_back.style.display = "none";
				}
			}
		}

		// show more_items label
		if(items.length > maxItems && items.length > 0) {
			var moreItem = dhtml.addElement(this.dayElements[i], "div", "more_items");
			var unixTime = this.dayElements[i].getAttribute("id").split("_")[2];
			moreItem.setAttribute("unixtime", unixTime);
			moreItem.innerHTML = _("More items...");
		}
	}
}